/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image.compression.tile;

import java.nio.Buffer;
import java.util.logging.Logger;
import nom.tam.image.compression.tile.TileCompressionOperation;
import nom.tam.image.compression.tile.TileCompressionType;
import nom.tam.image.compression.tile.TiledImageCompressionOperation;
import nom.tam.image.compression.tile.mask.ImageNullPixelMask;
import nom.tam.image.compression.tile.mask.NullPixelMaskRestorer;
import nom.tam.image.tile.operation.TileArea;

public class TileDecompressor
extends TileCompressionOperation {
    private static final Logger LOG = Logger.getLogger(TileDecompressor.class.getName());
    private NullPixelMaskRestorer nullPixelMaskRestorer;

    protected TileDecompressor(TiledImageCompressionOperation array, int tileIndex, TileArea area) {
        super(array, tileIndex, area);
    }

    @Override
    public void run() {
        this.decompress();
        this.getTileBuffer().finish();
    }

    private void decompress() {
        this.initTileOptions();
        this.tileOptions.getCompressionParameters().getValuesFromColumn(this.getTileIndex());
        if (this.compressionType == TileCompressionType.COMPRESSED) {
            this.getCompressorControl().decompress(this.compressedData, this.getTileBuffer().getBuffer(), this.tileOptions);
            if (this.nullPixelMaskRestorer != null) {
                this.nullPixelMaskRestorer.restoreNulls();
            }
        } else if (this.compressionType == TileCompressionType.GZIP_COMPRESSED) {
            this.getGzipCompressorControl().decompress(this.compressedData, this.getTileBuffer().getBuffer(), null);
        } else if (this.compressionType == TileCompressionType.UNCOMPRESSED) {
            Buffer typedBuffer = this.getBaseType().asTypedBuffer(this.compressedData);
            this.getBaseType().appendBuffer(this.getTileBuffer().getBuffer(), typedBuffer);
        } else {
            LOG.severe("Unknown compression column");
            throw new IllegalStateException("Unknown compression column");
        }
    }

    @Override
    protected NullPixelMaskRestorer createImageNullPixelMask(ImageNullPixelMask imageNullPixelMask) {
        if (imageNullPixelMask != null) {
            this.nullPixelMaskRestorer = imageNullPixelMask.createTileRestorer(this.getTileBuffer(), this.getTileIndex());
        }
        return this.nullPixelMaskRestorer;
    }
}

