/*
 * Decompiled with CFR 0.152.
 */
package aigis.model.loader;

import aigis.model.loader.FastReader;
import java.io.IOException;

public class LatLonLoader {
    public static float[][] load(String filename) throws IOException {
        FastReader scan = new FastReader(filename);
        int nLatlon = scan.nextInt();
        float[][] latlonLine = new float[nLatlon][3];
        int i = 0;
        while (i < nLatlon) {
            scan.nextInt();
            latlonLine[i][0] = scan.nextFloat();
            latlonLine[i][1] = scan.nextFloat();
            latlonLine[i][2] = scan.nextFloat();
            ++i;
        }
        scan.close();
        return latlonLine;
    }

    public static Float[] loadColor(String filename) throws IOException {
        Float[] color = new Float[4];
        FastReader scan = new FastReader(filename);
        color[0] = Float.valueOf(scan.nextFloat());
        color[1] = Float.valueOf(scan.nextFloat());
        color[2] = Float.valueOf(scan.nextFloat());
        color[3] = Float.valueOf(scan.nextFloat());
        return color;
    }

    public static float loadLineSize(String filename) throws IOException {
        FastReader scan = new FastReader(filename);
        scan.skipLine(1);
        float lineSize = scan.nextFloat();
        return lineSize;
    }

    public static Float[][][] loadGeneral(String filename) throws IOException {
        FastReader scan = new FastReader(filename);
        scan.skipLine(2);
        int nLatlon = scan.nextInt();
        int lineCount = scan.getCommentLineCount(nLatlon);
        Float[][][] latlonLine = new Float[lineCount][nLatlon][3];
        int counter = 0;
        int h = 0;
        while (h < lineCount) {
            int i = counter;
            while (i < nLatlon) {
                if (scan.isComment()) {
                    counter = i + 1;
                    break;
                }
                scan.nextInt();
                latlonLine[h][i][0] = Float.valueOf(scan.nextFloat());
                latlonLine[h][i][1] = Float.valueOf(scan.nextFloat());
                latlonLine[h][i][2] = Float.valueOf(scan.nextFloat());
                ++i;
            }
            ++h;
        }
        scan.close();
        return latlonLine;
    }
}

