/*
 * Decompiled with CFR 0.152.
 */
package aigis.model.loader;

import aigis.model.LatLon;
import aigis.model.Model;
import aigis.model.loader.FastReader;
import java.io.IOException;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class ModelLoader {
    public static void load(String filename, Model model) throws IOException {
        int nFace;
        int nVertex;
        FastReader scan = new FastReader(filename);
        model.nVertex = nVertex = scan.nextInt();
        model.vertices = new float[nVertex][3];
        float maxX = 0.0f;
        float minX = Float.MAX_VALUE;
        int i = 0;
        while (i < nVertex) {
            scan.nextInt();
            int j = 0;
            while (j < 3) {
                model.vertices[i][j] = scan.nextFloat();
                if (j == 0) {
                    if (maxX < model.vertices[i][j]) {
                        maxX = model.vertices[i][j];
                    }
                    if (minX > model.vertices[i][j]) {
                        minX = model.vertices[i][j];
                    }
                }
                ++j;
            }
            ++i;
        }
        float max = 0.56f;
        float width = Math.abs(maxX) + Math.abs(minX);
        System.out.println("---");
        System.out.println(maxX);
        System.out.println(minX);
        model.width = width;
        model.nFace = nFace = scan.nextInt();
        model.faces = new int[nFace][3];
        int i2 = 0;
        while (i2 < nFace) {
            scan.nextInt();
            model.faces[i2][0] = scan.nextInt();
            model.faces[i2][1] = scan.nextInt();
            model.faces[i2][2] = scan.nextInt();
            ++i2;
        }
        scan.close();
        ModelLoader.makeNormal(model, nFace);
    }

    public static void makeNormal(Model model, int nFace) {
        model.nNormal = nFace;
        model.normals = new float[nFace][3];
        model.normalIndex = new int[3 * nFace];
        model.point = new float[nFace][3];
        model.info = new LatLon[nFace];
        int i = 0;
        while (i < nFace) {
            Point3f p0 = new Point3f(model.vertices[model.faces[i][0] - 1][0], model.vertices[model.faces[i][0] - 1][1], model.vertices[model.faces[i][0] - 1][2]);
            Point3f p1 = new Point3f(model.vertices[model.faces[i][1] - 1][0], model.vertices[model.faces[i][1] - 1][1], model.vertices[model.faces[i][1] - 1][2]);
            Point3f p2 = new Point3f(model.vertices[model.faces[i][2] - 1][0], model.vertices[model.faces[i][2] - 1][1], model.vertices[model.faces[i][2] - 1][2]);
            model.point[i][0] = (p0.x + p1.x + p2.x) / 3.0f;
            model.point[i][1] = (p0.y + p1.y + p2.y) / 3.0f;
            model.point[i][2] = (p1.z + p1.z + p2.z) / 3.0f;
            model.info[i] = new LatLon(model.point[i][0], model.point[i][1], model.point[i][2]);
            Vector3f v1 = new Vector3f(p1.x - p0.x, p1.y - p0.y, p1.z - p0.z);
            Vector3f v2 = new Vector3f(p2.x - p0.x, p2.y - p0.y, p2.z - p0.z);
            Vector3f normal = new Vector3f();
            normal.cross(v1, v2);
            normal.normalize();
            model.normals[i][0] = normal.x;
            model.normals[i][1] = normal.y;
            model.normals[i][2] = normal.z;
            model.normalIndex[i * 3 + 0] = i;
            model.normalIndex[i * 3 + 1] = i;
            model.normalIndex[i * 3 + 2] = i;
            ++i;
        }
    }
}

