/*
 * Decompiled with CFR 0.152.
 */
package aigis.model;

import aigis.model.Model;
import com.jogamp.opengl.GL2;
import java.awt.geom.Point2D;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

public class Models {
    private TreeMap<String, Model> models = new TreeMap();

    public void addModel(String key, Model model) {
        this.models.put(key, model);
    }

    public void removeModel(String key) {
        this.models.remove(key);
    }

    public boolean rewriteColor(String key, ByteBuffer ptr) {
        boolean ret = this.models.get(key).rewriteColor(ptr);
        ptr.limit(ptr.position());
        ptr.position(0);
        return ret;
    }

    public void emphasizePolygon(String key, Integer polygonID) {
        this.models.get(key).emphasizePolygon(polygonID);
    }

    public void compile(GL2 gl) {
        for (Map.Entry<String, Model> entry : this.models.entrySet()) {
            entry.getValue().compile(gl);
        }
    }

    public int getID(String key, Point2D.Double mousePos, double[] modelview, double[] projection, int[] viewport) {
        if (this.models.get(key) == null) {
            return -1;
        }
        return this.models.get(key).getID(mousePos, modelview, projection, viewport);
    }

    public int getSize() {
        return this.models.size();
    }

    public Model getModel(String key) {
        return this.models.get(key);
    }

    public int getNVertex(String key) {
        return this.models.get(key).getNVertex();
    }

    public int getNFace(String key) {
        return this.models.get(key).getNFace();
    }

    public int getNLatlonW(String key) {
        return this.models.get(key).getNLatlonW();
    }

    public int getNLatlonR(String key) {
        return this.models.get(key).getNLatlonR();
    }

    public int getNLatlon(String key) {
        return this.models.get(key).getNLatlon();
    }

    public ArrayList<Float[]> getColorlist(String key) {
        return this.models.get(key).getColorlist();
    }

    public ArrayList<Float> getSizelist(String key) {
        return this.models.get(key).getSizelist();
    }

    public ArrayList<Float[][][]> getLinelist(String key) {
        return this.models.get(key).getlinelist();
    }

    public int getVboId(String key, int type) {
        return this.models.get(key).getVboId(type);
    }

    public float[] getSurfaceSpecular(String key) {
        return this.models.get(key).getSpecular();
    }

    public float[] getSurfaceDiffuse(String key) {
        return this.models.get(key).getDiffuse();
    }

    public float[] getSurfaceAmbient(String key) {
        return this.models.get(key).getAmbient();
    }

    public float getSurfaceShiness(String key) {
        return this.models.get(key).getShiness();
    }
}

