/*
 * Decompiled with CFR 0.152.
 */
package aigis.model;

public class Rotate {
    private float[] axis = new float[]{0.0f, 0.0f, 0.0f};
    private float[] nowquat = new float[]{1.0f, 0.0f, 0.0f, 0.0f};
    private float[] RMatrix = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};

    public float[] getRMatrix() {
        return this.RMatrix;
    }

    public float[] translate(float[] u) {
        float[] ret = new float[4];
        int i = 0;
        while (i < 4) {
            ret[i] = this.RMatrix[4 * i + 0] * u[0] + this.RMatrix[4 * i + 1] * u[1] + this.RMatrix[4 * i + 2] * u[2] + this.RMatrix[4 * i + 3] * u[3];
            ++i;
        }
        return ret;
    }

    public void CreateRMfromLatLon(float lat, float lon) {
        double p = lat;
        double b = lon;
        this.nowquat[0] = (float)(Math.cos(p / 2.0) * Math.cos(b / 2.0));
        this.nowquat[1] = (float)(Math.sin(p / 2.0) * Math.cos(b / 2.0));
        this.nowquat[2] = (float)(-Math.sin(p / 2.0) * Math.sin(b / 2.0));
        this.nowquat[3] = (float)(Math.cos(p / 2.0) * Math.sin(b / 2.0));
        this.CopyCalculatedRM();
    }

    public void CreateRM() {
        double sum = 0.0;
        int i = 0;
        while (i < 3) {
            sum += (double)(this.axis[i] * this.axis[i]);
            ++i;
        }
        double leng = (float)Math.sqrt(sum);
        if (Math.abs(leng) < 1.0E-9) {
            return;
        }
        this.axis[0] = (float)((double)this.axis[0] / leng);
        this.axis[1] = (float)((double)this.axis[1] / leng);
        this.axis[2] = (float)((double)this.axis[2] / leng);
        float hrad = (float)(0.01 * leng);
        float s = (float)Math.sin(hrad);
        float wt = (float)Math.cos(hrad);
        float xt = s * this.axis[0];
        float yt = s * this.axis[1];
        float zt = s * this.axis[2];
        float w = wt * this.nowquat[0] - xt * this.nowquat[1] - yt * this.nowquat[2] - zt * this.nowquat[3];
        float x = wt * this.nowquat[1] + xt * this.nowquat[0] + yt * this.nowquat[3] - zt * this.nowquat[2];
        float y = wt * this.nowquat[2] - xt * this.nowquat[3] + yt * this.nowquat[0] + zt * this.nowquat[1];
        float z = wt * this.nowquat[3] + xt * this.nowquat[2] - yt * this.nowquat[1] + zt * this.nowquat[0];
        this.nowquat[0] = w;
        this.nowquat[1] = x;
        this.nowquat[2] = y;
        this.nowquat[3] = z;
        this.CopyCalculatedRM();
    }

    public void CreateInvRM() {
        double sum = 0.0;
        int i = 0;
        while (i < 3) {
            sum += (double)(this.axis[i] * this.axis[i]);
            ++i;
        }
        double leng = (float)Math.sqrt(sum);
        if (Math.abs(leng) < 1.0E-9) {
            return;
        }
        this.axis[0] = (float)((double)this.axis[0] / leng);
        this.axis[1] = (float)((double)this.axis[1] / leng);
        this.axis[2] = (float)((double)this.axis[2] / leng);
        float hrad = -((float)(0.01 * leng));
        float s = (float)Math.sin(hrad);
        float wt = (float)Math.cos(hrad);
        float xt = s * this.axis[0];
        float yt = s * this.axis[1];
        float zt = s * this.axis[2];
        float w = wt * this.nowquat[0] - xt * this.nowquat[1] - yt * this.nowquat[2] - zt * this.nowquat[3];
        float x = wt * this.nowquat[1] + xt * this.nowquat[0] + yt * this.nowquat[3] - zt * this.nowquat[2];
        float y = wt * this.nowquat[2] - xt * this.nowquat[3] + yt * this.nowquat[0] + zt * this.nowquat[1];
        float z = wt * this.nowquat[3] + xt * this.nowquat[2] - yt * this.nowquat[1] + zt * this.nowquat[0];
        this.nowquat[0] = w;
        this.nowquat[1] = x;
        this.nowquat[2] = y;
        this.nowquat[3] = z;
        this.CopyCalculatedRM();
    }

    public void setAxis(float x, float y, float z) {
        this.axis[0] = x;
        this.axis[1] = y;
        this.axis[2] = z;
    }

    public float[] getAxis() {
        return this.axis;
    }

    public float getAxisLength() {
        return (float)Math.sqrt(this.axis[0] * this.axis[0] + this.axis[1] * this.axis[1] + this.axis[2] * this.axis[2]);
    }

    private void CopyCalculatedRM() {
        float w = this.nowquat[0];
        float x = this.nowquat[1];
        float y = this.nowquat[2];
        float z = this.nowquat[3];
        float leng = (float)Math.sqrt(w * w + x * x + y * y + z * z);
        if ((double)Math.abs(leng) < 1.0E-9) {
            return;
        }
        this.nowquat[0] = w /= leng;
        this.nowquat[1] = x /= leng;
        this.nowquat[2] = y /= leng;
        this.nowquat[3] = z /= leng;
        float[] RMatrixt = new float[]{1.0f - 2.0f * y * y - 2.0f * z * z, 2.0f * x * y + 2.0f * w * z, 2.0f * x * z - 2.0f * w * y, 0.0f, 2.0f * x * y - 2.0f * w * z, 1.0f - 2.0f * x * x - 2.0f * z * z, 2.0f * y * z + 2.0f * w * x, 0.0f, 2.0f * x * z + 2.0f * w * y, 2.0f * y * z - 2.0f * w * x, 1.0f - 2.0f * x * x - 2.0f * y * y, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        int i = 0;
        while (i < 16) {
            this.RMatrix[i] = RMatrixt[i];
            ++i;
        }
    }
}

