/*
 * Decompiled with CFR 0.152.
 */
package aigis.model;

import java.awt.geom.Point2D;

public class Geometry {
    public static double cross(Point2D.Double a, Point2D.Double b) {
        return a.getX() * b.getY() - a.getY() * b.getX();
    }

    public static double dot(Point2D.Double a, Point2D.Double b) {
        return a.getX() * b.getX() + a.getY() * b.getY();
    }

    public static double norm(Point2D.Double a) {
        return a.distance(0.0, 0.0);
    }

    public static int ccw(Point2D.Double a, Point2D.Double b, Point2D.Double c) {
        Point2D.Double C;
        Point2D.Double B = new Point2D.Double(b.getX() - a.getX(), b.getY() - a.getY());
        if (Geometry.cross(B, C = new Point2D.Double(c.getX() - a.getX(), c.getY() - a.getY())) > 1.0E-11) {
            return 1;
        }
        if (Geometry.cross(B, C) < -1.0E-11) {
            return -1;
        }
        if (Geometry.dot(B, C) < -1.0E-11) {
            return 2;
        }
        if (Geometry.norm(B) < Geometry.norm(C) - 1.0E-11) {
            return -2;
        }
        return 0;
    }

    public static boolean intersectedSS(Point2D.Double a, Point2D.Double b, Point2D.Double c, Point2D.Double d) {
        return Geometry.ccw(a, b, c) * Geometry.ccw(a, b, d) <= 0 && Geometry.ccw(c, d, a) * Geometry.ccw(c, d, b) <= 0;
    }

    public static boolean triangleInside2(double[] tri, Point2D.Double mp) {
        Point2D.Double[] triangle = new Point2D.Double[]{new Point2D.Double(tri[0], tri[1]), new Point2D.Double(tri[3], tri[4]), new Point2D.Double(tri[6], tri[7])};
        int cw = Geometry.ccw(triangle[0], triangle[1], mp);
        int i = 1;
        while (i < 3) {
            int tmp = Geometry.ccw(triangle[i], triangle[(i + 1) % 3], mp);
            if (cw != tmp && tmp != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Deprecated
    public static boolean triangleInside(double[] _3DTriangle, Point2D.Double mp) {
        Point2D.Double gravityCenter = new Point2D.Double((_3DTriangle[0] + _3DTriangle[3] + _3DTriangle[6]) / 3.0, (_3DTriangle[1] + _3DTriangle[4] + _3DTriangle[7]) / 3.0);
        Point2D.Double[] triangle = new Point2D.Double[]{new Point2D.Double(_3DTriangle[0], _3DTriangle[1]), new Point2D.Double(_3DTriangle[3], _3DTriangle[4]), new Point2D.Double(_3DTriangle[6], _3DTriangle[7])};
        if (Geometry.intersectedSS(triangle[0], triangle[1], gravityCenter, mp)) {
            return false;
        }
        if (Geometry.intersectedSS(triangle[1], triangle[2], gravityCenter, mp)) {
            return false;
        }
        return !Geometry.intersectedSS(triangle[2], triangle[0], gravityCenter, mp);
    }
}

