/*
 * Decompiled with CFR 0.152.
 */
package aigis.model;

import aigis.model.Rotate;

public class Light {
    private float[] currentPosition = new float[4];
    private float[] defaultPosition = new float[]{0.0f, 0.0f, 5000.0f, 0.0f};
    private float[] lightSpecular = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    private float[] lightDiffuseDefault = new float[]{0.65f, 0.65f, 0.65f, 1.0f};
    private float[] lightAmbientDefault = new float[]{0.3f, 0.3f, 0.3f, 1.0f};
    private float[] lightDiffuseMin = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    private float[] lightAmbientMax = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private float[] lightDiffuse = this.lightDiffuseDefault;
    private float[] lightAmbient = this.lightAmbientDefault;
    private Model lightModel = new Model();

    public float[] getCurrentPosition() {
        return this.currentPosition;
    }

    public float[] getDefaultPosition() {
        return this.defaultPosition;
    }

    public float[] getSpecular() {
        return this.lightSpecular;
    }

    public float[] getAmbient() {
        return this.lightAmbient;
    }

    public float[] getDiffuse() {
        return this.lightDiffuse;
    }

    public Model getLightModel() {
        return this.lightModel;
    }

    public void resetCurrentPosition() {
        int i = 0;
        while (i < this.currentPosition.length) {
            this.currentPosition[i] = this.defaultPosition[i];
            ++i;
        }
    }

    public void setCurrentPosition(Rotate r) {
        this.currentPosition = r.translate(this.defaultPosition);
        this.lightModel.translate(r);
    }

    public void setCurrentPosition(float[] newCurrentLightPosition) {
        int i = 0;
        while (i < this.currentPosition.length) {
            this.currentPosition[i] = newCurrentLightPosition[i];
            ++i;
        }
    }

    public void changeDiffuse(boolean off) {
        if (off) {
            this.lightDiffuse = this.lightDiffuseMin;
            this.lightAmbient = this.lightAmbientMax;
        } else {
            this.lightDiffuse = this.lightDiffuseDefault;
            this.lightAmbient = this.lightAmbientDefault;
        }
    }

    class Model {
        private float[][] defaultVertices = new float[][]{{0.0f, 0.0f, 3.0f, 0.0f}, {0.0f, 0.0f, 0.35f, 0.0f}, {0.0f, 0.05f, 0.45f, 0.0f}, {0.05f, 0.0f, 0.45f, 0.0f}, {0.0f, -0.05f, 0.45f, 0.0f}, {-0.05f, 0.0f, 0.45f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f}};
        private float[][] vertices;
        private int[][] edges;

        Model() {
            int[][] nArrayArray = new int[11][];
            int[] nArray = new int[2];
            nArray[1] = 6;
            nArrayArray[0] = nArray;
            nArrayArray[1] = new int[]{6, 1};
            nArrayArray[2] = new int[]{1, 2};
            nArrayArray[3] = new int[]{2, 3};
            nArrayArray[4] = new int[]{3, 4};
            nArrayArray[5] = new int[]{4, 5};
            nArrayArray[6] = new int[]{5, 2};
            nArrayArray[7] = new int[]{1, 2};
            nArrayArray[8] = new int[]{1, 3};
            nArrayArray[9] = new int[]{1, 4};
            nArrayArray[10] = new int[]{1, 5};
            this.edges = nArrayArray;
            this.vertices = new float[this.defaultVertices.length][4];
        }

        public void translate(Rotate r) {
            int i = 0;
            while (i < this.defaultVertices.length) {
                this.vertices[i] = r.translate(this.defaultVertices[i]);
                ++i;
            }
        }

        public float[][] getVertices() {
            return this.vertices;
        }

        public int[][] getEdges() {
            return this.edges;
        }
    }
}

