/*
 * Decompiled with CFR 0.152.
 */
package aigis.model;

import aigis.model.Geometry;
import aigis.model.LatLon;
import aigis.model.loader.ModelLoader;
import aigis.model.loader.ObjLoader;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLBufferStorage;
import com.jogamp.opengl.glu.GLU;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class Model {
    public static final int BUFFERTYPE_VERTEX = 0;
    public static final int BUFFERTYPE_NORMAL = 1;
    public static final int BUFFERTYPE_COLOR = 2;
    public int nVertex;
    public int nFace;
    public int nNormal;
    public float[][] vertices;
    public int[][] faces;
    public float[][] normals;
    public int[] normalIndex;
    public float[][] point;
    public float[][] rgba;
    int nMap;
    int nLatlonW;
    int nLatlonR;
    int nLatlon;
    float[][] latlonLineW;
    float[][] latlonLineR;
    Float[][][] latlonLine;
    private int vboIdVertex;
    private int vboIdNormal;
    private int vboIdColor;
    static float r;
    static float g;
    static float b;
    static float a;
    Float[] lineColor;
    static float lineSize;
    ArrayList<Float[]> colorlist = new ArrayList();
    ArrayList<Float> sizelist = new ArrayList();
    ArrayList<Float[][][]> linelist = new ArrayList();
    public LatLon[] info;
    private float[] specular = new float[]{0.5f, 0.5f, 0.5f, 1.0f};
    private float[] diffuse = new float[]{0.5f, 0.5f, 0.5f, 1.0f};
    private float[] ambient = new float[]{0.4f, 0.4f, 0.4f, 1.0f};
    private float shiness = 5.0f;
    public float width = 0.0f;

    public int getNVertex() {
        return this.nVertex;
    }

    public int getNFace() {
        return this.nFace;
    }

    public int getNNormal() {
        return this.nNormal;
    }

    public float getVertex(int i, int j) {
        return this.vertices[i][j];
    }

    public int getFace(int i, int j) {
        return this.faces[i][j];
    }

    public float getNormal(int i, int j) {
        return this.normals[i][j];
    }

    public int getNormalIndex(int i) {
        return this.normalIndex[i];
    }

    public int getTotalMapping() {
        return this.nMap;
    }

    public int getNLatlonW() {
        return this.nLatlonW;
    }

    public int getNLatlonR() {
        return this.nLatlonR;
    }

    public int getNLatlon() {
        return this.nLatlon;
    }

    public ArrayList<Float[]> getColorlist() {
        return this.colorlist;
    }

    public ArrayList<Float> getSizelist() {
        return this.sizelist;
    }

    public ArrayList<Float[][][]> getlinelist() {
        return this.linelist;
    }

    public float[][] getPoint() {
        return this.point;
    }

    public LatLon[] getLatLon() {
        return this.info;
    }

    public float[][] getNormal() {
        return this.normals;
    }

    public float[] getSpecular() {
        return this.specular;
    }

    public float[] getDiffuse() {
        return this.diffuse;
    }

    public float[] getAmbient() {
        return this.ambient;
    }

    public float getShiness() {
        return this.shiness;
    }

    public Model(String filename) throws IOException {
        if (filename.endsWith(".obj")) {
            ObjLoader.load(filename, this);
        } else {
            ModelLoader.load(filename, this);
        }
        this.nMap = this.nFace;
        this.rgba = new float[this.nMap][4];
    }

    public Integer getID(Point2D.Double mousePos, double[] modelview, double[] projection, int[] viewport) {
        GLU gll = new GLU();
        int[] internalIndecies = new int[64];
        double[] zDepth = new double[64];
        int count = 0;
        double[] result = new double[9];
        int i = 0;
        while (i < this.nFace) {
            int j = 0;
            while (j < 3) {
                gll.gluProject((double)this.vertices[this.faces[i][j] - 1][0], (double)this.vertices[this.faces[i][j] - 1][1], (double)this.vertices[this.faces[i][j] - 1][2], modelview, 0, projection, 0, viewport, 0, result, 3 * j);
                ++j;
            }
            if (Geometry.triangleInside2(result, mousePos)) {
                internalIndecies[count] = i;
                zDepth[count] = (result[2] + result[5] + result[8]) / 3.0;
                ++count;
            }
            ++i;
        }
        if (count > 0) {
            double min = 1.0E80;
            int minIndex = 0;
            int d = 0;
            while (d < count) {
                if (min > zDepth[d]) {
                    min = zDepth[d];
                    minIndex = d;
                }
                ++d;
            }
            return new Integer(internalIndecies[minIndex]);
        }
        return new Integer(-1);
    }

    private int calcRequiredBufferSize(int type) {
        int ret = 0;
        if (type == 1 || type == 0) {
            ret = 9 * this.nFace + 3 * (this.nLatlonW + this.nLatlonR + this.nLatlon);
        } else if (type == 2) {
            ret = 12 * this.nFace + 4 * (this.nLatlonW + this.nLatlonR + this.nLatlon);
        }
        return ret;
    }

    private void buildBuffer(int type, GLBufferStorage storage) {
        block18: {
            int j;
            int i;
            ByteBuffer buff;
            block17: {
                buff = storage.getMappedBuffer();
                if (type == 0) {
                    i = 0;
                    while (i < this.nFace) {
                        j = 0;
                        while (j < 3) {
                            buff.putFloat(this.vertices[this.faces[i][j] - 1][0]);
                            buff.putFloat(this.vertices[this.faces[i][j] - 1][1]);
                            buff.putFloat(this.vertices[this.faces[i][j] - 1][2]);
                            ++j;
                        }
                        ++i;
                    }
                } else if (type == 1) {
                    i = 0;
                    while (i < 3 * this.nNormal) {
                        j = 0;
                        while (j < 3) {
                            buff.putFloat(this.normals[this.normalIndex[i]][j]);
                            ++j;
                        }
                        ++i;
                    }
                } else if (type == 2) {
                    i = 0;
                    while (i < this.nMap) {
                        j = 0;
                        while (j < 3) {
                            int k = 0;
                            while (k < 4) {
                                buff.putFloat(this.rgba[i][k]);
                                ++k;
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
                if (type != 0 && type != 1) break block17;
                i = 0;
                while (i < this.nLatlonW) {
                    buff.putFloat(this.latlonLineW[i][0]);
                    buff.putFloat(this.latlonLineW[i][1]);
                    buff.putFloat(this.latlonLineW[i][2]);
                    ++i;
                }
                i = 0;
                while (i < this.nLatlonR) {
                    buff.putFloat(this.latlonLineR[i][0]);
                    buff.putFloat(this.latlonLineR[i][1]);
                    buff.putFloat(this.latlonLineR[i][2]);
                    ++i;
                }
                break block18;
            }
            if (type != 2) break block18;
            i = 0;
            while (i < this.nLatlonW) {
                j = 0;
                while (j < 4) {
                    buff.putFloat(1.0f);
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < this.nLatlonR) {
                buff.putFloat(1.0f);
                buff.putFloat(0.0f);
                buff.putFloat(0.0f);
                buff.putFloat(1.0f);
                ++i;
            }
        }
    }

    public boolean rewriteColor(ByteBuffer ptr) {
        if (ptr != null) {
            int i = 0;
            while (i < this.nMap) {
                ptr.putFloat(this.rgba[i][0]);
                ptr.putFloat(this.rgba[i][1]);
                ptr.putFloat(this.rgba[i][2]);
                ptr.putFloat(this.rgba[i][3]);
                ptr.putFloat(this.rgba[i][0]);
                ptr.putFloat(this.rgba[i][1]);
                ptr.putFloat(this.rgba[i][2]);
                ptr.putFloat(this.rgba[i][3]);
                ptr.putFloat(this.rgba[i][0]);
                ptr.putFloat(this.rgba[i][1]);
                ptr.putFloat(this.rgba[i][2]);
                ptr.putFloat(this.rgba[i][3]);
                ++i;
            }
            i = 0;
            while (i < this.nLatlonW) {
                ptr.putFloat(1.0f);
                ptr.putFloat(1.0f);
                ptr.putFloat(1.0f);
                ptr.putFloat(1.0f);
                ++i;
            }
            i = 0;
            while (i < this.nLatlonR) {
                ptr.putFloat(1.0f);
                ptr.putFloat(0.0f);
                ptr.putFloat(0.0f);
                ptr.putFloat(1.0f);
                ++i;
            }
            i = 0;
            while (i < this.nLatlon) {
                ptr.putFloat((float)((double)r / 255.0));
                ptr.putFloat((float)((double)g / 255.0));
                ptr.putFloat((float)((double)b / 255.0));
                ptr.putFloat(a);
                ++i;
            }
            return true;
        }
        return false;
    }

    public void compile(GL2 gl) {
        this.vboIdVertex = 0;
        this.vboIdNormal = 0;
        this.vboIdColor = 0;
        int[] vboIdBuff = new int[3];
        gl.glGenBuffers(3, vboIdBuff, 0);
        gl.glBindBuffer(34962, vboIdBuff[0]);
        int totalSize = this.calcRequiredBufferSize(0);
        gl.glBufferData(34962, totalSize * 4, null, 35044);
        GLBufferStorage storage = gl.mapBuffer(34962, 35001);
        this.buildBuffer(0, storage);
        gl.glUnmapBuffer(34962);
        gl.glBindBuffer(34962, vboIdBuff[1]);
        totalSize = this.calcRequiredBufferSize(1);
        gl.glBufferData(34962, totalSize * 4, null, 35044);
        storage = gl.mapBuffer(34962, 35001);
        this.buildBuffer(1, storage);
        gl.glUnmapBuffer(34962);
        gl.glBindBuffer(34962, vboIdBuff[2]);
        totalSize = this.calcRequiredBufferSize(2);
        gl.glBufferData(34962, totalSize * 4, null, 35048);
        storage = gl.mapBuffer(34962, 35001);
        this.buildBuffer(2, storage);
        gl.glUnmapBuffer(34962);
        this.vboIdVertex = vboIdBuff[0];
        this.vboIdNormal = vboIdBuff[1];
        this.vboIdColor = vboIdBuff[2];
    }

    public void emphasizePolygon(Integer polygonID) {
        int pid = polygonID;
        this.rgba[pid][0] = 1.0f;
        this.rgba[pid][1] = 0.0f;
        this.rgba[pid][2] = 0.0f;
        this.rgba[pid][3] = 1.0f;
    }

    public float getWidth() {
        return this.width;
    }

    public int getVboId(int type) {
        if (type == 0) {
            return this.vboIdVertex;
        }
        if (type == 1) {
            return this.vboIdNormal;
        }
        if (type == 2) {
            return this.vboIdColor;
        }
        return -1;
    }
}

