

//HARMONICS 2.0.0
//(c) 2018 The University of Aizu
//This software is released under the GNU General Public License.


#ifndef CKSETFILEDIALOG_H
#define CKSETFILEDIALOG_H

#include <QDialog>
#include <QFile>
#include <QTextStream>
#include <iostream>
#include "SpiceUsr.h"

using namespace std;

namespace Ui {
class CKSetFileDialog;
}

class CKSetFileDialog : public QDialog
{
    Q_OBJECT

public:
    explicit CKSetFileDialog(QWidget *parent = 0);
    ~CKSetFileDialog();
    void setCKParam(QString, SpiceInt);
    void setLSKFile(QString);
    void setSCLKFile(QString);
    void setFKFile(QString);

public slots:
    void setCKParam_slot(QString, SpiceInt);
    void createCKSettingFile_slot();
    void CKTextSettingFile_slot();
    void setLSKFile_slot(QString);
    void setSCLKFile_slot(QString);
    void setFKFile_slot(QString);
    
    

private slots:
    void on_OKButton_clicked();
    void on_CancelButton_clicked();

private:
    Ui::CKSetFileDialog *ui;
    SpiceBoolean initSetFile;
    SpiceBoolean overWrite;
    const QString BEGINDATA="\\begindata";
    const QString plainLSK_FILE_NAME="LSK_FILE_NAME          = ";
    const QString plainSCLK_FILE_NAME="SCLK_FILE_NAME         = ";
    const QString plainFRAMES_FILE_NAME="FRAMES_FILE_NAME       = ";
    const QString plainCK_TYPE="CK_TYPE                = 3";
    const QString plainINSTRUMENT_ID="INSTRUMENT_ID          = ";
    const QString plainREFERENCE_FRAME_NAME="REFERENCE_FRAME_NAME   = ";
    const QString plainANGULAR_RATE_PRESENT="ANGULAR_RATE_PRESENT   = 'MAKE UP/NO AVERAGING'";
    const QString plainQUATERNION_NORM_ERROR="QUATERNION_NORM_ERROR  = 0.5";
    const QString plainINPUT_TIME_TYPE="INPUT_TIME_TYPE        = 'UTC'";
    const QString plainINPUT_DATA_TYPE="INPUT_DATA_TYPE        = 'SPICE QUATERNIONS'";
    const QString plainPRODUCER_ID="PRODUCER_ID            = 'HARMONICS2'";

    
    QString LSK_FILE_NAME;
    QString SCLK_FILE_NAME;
    QString FRAMES_FILE_NAME;
    QString CK_TYPE;
    QString INSTRUMENT_ID;
    QString REFERENCE_FRAME_NAME;
    QString ANGULAR_RATE_PRESENT;
    QString QUATERNION_NORM_ERROR;
    QString INPUT_TIME_TYPE;
    QString INPUT_DATA_TYPE;
    QString PRODUCER_ID;
    QString targetName, frame, SCName;
    SpiceInt instId;
    QString lskFile, sclkFile, fkFile;
    
    QString preData;
    
    
};

#endif 
