

//HARMONICS 2.0.0
//(c) 2018 The University of Aizu
//This software is released under the GNU General Public License.


#ifndef OBSERVATIONDATAMANAGEMENTDBMAINWINDOW_H
#define OBSERVATIONDATAMANAGEMENTDBMAINWINDOW_H

#include <QMainWindow>
#include <QSqlDatabase>
#include <QSqlDriver>
#include <QSqlQuery>
#include <QSqlError>
#include <QDebug>
#include <QDir>
#include <QFileDialog>
#include <QStandardItemModel>
#include <QAbstractItemModel>
#include <QSqlDatabase>
#include <QSqlQuery>
#include <QSql>
#include <QVector>
#include <QVector2D>
#include "SpiceUsr.h"
#include "SpiceDLA.h"
#include "SpiceDSK.h"
#include "dsk_proto.h"
#include <QMenu>
#include <QMessageBox>
#include <QtGui>
#include <fitsio.h>
#include <CCfits/CCfits>
#include <QVector4D>
#include "databasedrawgl.h"
#include "drawSpacecraftModel.h"
#include "drawTargetModel.h"
#include "computeelements.h"
#include <QTableWidgetItem>
#include <QProgressBar>

#ifdef __APPLE__
  #include <OpenCL/opencl.h>
  #include <OpenCL/cl.h>
  #include <cl.hpp>
#else
  #include <CL/cl.h>
#endif

using namespace std;
using namespace CCfits;

namespace Ui {
class ObservationDataManagementDBMainWindow;
}

class ObservationDataManagementDBMainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit ObservationDataManagementDBMainWindow(QWidget *parent = 0);
    ~ObservationDataManagementDBMainWindow();

    DatabaseDrawGL *databasedrawgl;
    DrawTargetModel *target;

    QStringList observedTimes;
    QString SCName, SCFrame, targetName, bodyFixed;
    SpiceInt SCID, targetID, instID;
    QString projectDSK;

    QString PLID; 

    int DBRowCount(QString);
    void listUpReadFilesWidget(QStringList);
    SpiceBoolean getImageUTC(QString);
    bool searchPolygonID(QString, SpiceInt, SpiceDLADescr, QString);
    SpiceInt getInstID(QString);
    QString projectName;

signals:
    DrawTargetModel* getTargetModel_signal();
    void sendTargetModel_signal(DrawTargetModel *);
    void setTargetModel_signal();
    void setSearchRegionMode_signal(bool);
    QString getSCName_signal();
    SpiceInt getSCID_singal();
    QString getSCFrame_signal();
    QString getTargetName_signal();
    SpiceInt getTargetID_signal();
    QString getBodyFixed_signal();
    void sendObservedAreas_signal(QStringList);
    void resetRegion_signal();

private slots:
    void on_ReadShapeModel_clicked();

    void on_searchRegionPushButton_clicked(bool checked);

    void setReadFileToDBWindow_slot(QStringList);

    void on_UnloadpushButton_clicked();

    void on_LoadpushButton_clicked();

    void on_MakepushButton_clicked();

    void openDBWindow_slot(QString);

    void on_AddImagesPushButton_clicked();

    void on_projectsTableWidget_clicked(const QModelIndex &index);

    void on_imagesListWidget_clicked(const QModelIndex &index);

    QMap<int, QString> getPLAndImageMap_slot();

    void sendResultSearchImage_slot(QStringList);

    void on_resetRegionButton_clicked();

    void sendLoadKernels_slot(QStringList);

    void on_readFIleListWidget_clicked(const QModelIndex &index);

private:
    Ui::ObservationDataManagementDBMainWindow *ui;

    QSqlQuery query;
    QSqlDatabase DB;

    QStringList readFilesList;

};

int get_cam_info(SpiceInt instid,
                 SpiceDouble center[2],
                 SpiceDouble pixels[2],
                 SpiceDouble *pixel_size,
                 SpiceDouble *focal_length);

#endif 
