


//HARMONICS 2.0.0
//(c) 2018 The University of Aizu
//This software is released under the GNU General Public License.




#define EPSILON 0.000001f
#define DELTA 1/1024
#define M_PI 3.14159f

__kernel void compShadowing(__global const float4* vertex, __global const int* vertexN, __global const float4* spheres, __global const float4* lightPos, __global float4* detectionPolygonColor){
    //printf("comp Shadowing\n");
    float t, tmin, tmax, det, inv_det, angle, u, v, an, bn, a, b, c;
    float4 t0, t1, pvec, qvec, tvec, vec0, vec1, vec2, normalVec, shadowVec0, shadowVec1, shadowVec2;
    const unsigned int n=get_global_id(0)*3;
    bool crossingDec;
    float sphere_sq, ray_sq;
    float4 xc;
    float xc2, vxc, distance;
    int polygonID, ra;
    bool mn;
    bool isHitNodeSphere[512];
    tmax=10000000;
    tmin=1E+20;
    unsigned int i;
    float distanceLightToHitPolygon, distanceLightToShadowPolygon;
    const float nodeSphereR=spheres[1].w;
    float tn, tp;
    float4 shadowStart, shadowRay;
    float3 pvec3D, qvec3D, LightToShadowPolygonVec;
    //printf("VertexN:%d\n", *vertexN);

    vec0=vertex[n];
    vec1=vertex[n+1];
    vec2=vertex[n+2];

    t0=vec1-vec0;
    t1=vec2-vec0;

    shadowStart.x=(*lightPos).x;
    shadowStart.y=(*lightPos).y;
    shadowStart.z=(*lightPos).z;
    shadowStart.w=1.0f;

    shadowRay.x=((vec0.x+vec1.x+vec2.x)/3.0f)-shadowStart.x;
    shadowRay.y=((vec0.y+vec1.y+vec2.y)/3.0f)-shadowStart.y;
    shadowRay.z=((vec0.z+vec1.z+vec2.z)/3.0f)-shadowStart.z;
    shadowRay.w=1.0f;

    //printf("shadowRay x:%f y:%f z:%f\n", shadowRay.x, shadowRay.y, shadowRay.z);
    sphere_sq=spheres[0].w*spheres[0].w;

    distanceLightToHitPolygon=shadowRay.x*shadowRay.x+shadowRay.y*shadowRay.y+shadowRay.z*shadowRay.z;
    shadowRay=normalize(shadowRay);

    pvec3D.x=(shadowRay.y*t1.z-shadowRay.z*t1.y);
    pvec3D.y=(shadowRay.z*t1.x-shadowRay.x*t1.z);
    pvec3D.z=(shadowRay.x*t1.y-shadowRay.y*t1.x);
    tvec=shadowStart-vec0;
    qvec3D.x=(tvec.y*t0.z-tvec.z*t0.y);
    qvec3D.y=(tvec.z*t0.x-tvec.x*t0.z);
    qvec3D.z=(tvec.x*t0.y-tvec.y*t0.x);
    det=t0.x*pvec3D.x+t0.y*pvec3D.y+t0.z*pvec3D.z;
    inv_det=round(1.0f/det);
    if(det<EPSILON){
        //printf("Culling det:%f\n", i, det);

        if(detectionPolygonColor[n].w==0.0){
            detectionPolygonColor[n].x=0.1f;
            detectionPolygonColor[n].y=0.1f;
            detectionPolygonColor[n].z=0.1f;

            detectionPolygonColor[n+1].x=0.1f;
            detectionPolygonColor[n+1].y=0.1f;
            detectionPolygonColor[n+1].z=0.1f;

            detectionPolygonColor[n+2].x=0.1f;
            detectionPolygonColor[n+2].y=0.1f;
            detectionPolygonColor[n+2].z=0.1f;
        }
        if(detectionPolygonColor[n].w==0.0){
            detectionPolygonColor[n].w=100.0f;
            detectionPolygonColor[n+1].w=100.0f;
            detectionPolygonColor[n+2].w=100.0f;
        }
        else{

            if(0<detectionPolygonColor[n].w && detectionPolygonColor[n].w<100){
                detectionPolygonColor[n].w+=200.0f;
                detectionPolygonColor[n+1].w+=200.0f;
                detectionPolygonColor[n+2].w+=200.0f;
            }

            else if(-100<detectionPolygonColor[n].w && detectionPolygonColor[n].w<0){
                detectionPolygonColor[n].w-=200.0f;
                detectionPolygonColor[n+1].w-=200.0f;
                detectionPolygonColor[n+2].w-=200.0f;
            }
        }
        return;
    }
    t=t1.x*qvec3D.x+t1.y*qvec3D.y+t1.z*qvec3D.z;
    t*=inv_det;
    //printf("origin t:%f\n", t);
    tmin=t;

    xc=convert_float4(shadowStart-spheres[0]);
    xc2=xc.x*xc.x+xc.y*xc.y+xc.z*xc.z;//C+r^2
    vxc=xc.x*shadowRay.x+xc.y*shadowRay.y+xc.z*shadowRay.z;//B
    ray_sq=shadowRay.x*shadowRay.x+shadowRay.y*shadowRay.y+shadowRay.z*shadowRay.z;
    distance=vxc*vxc-(ray_sq*(xc2-sphere_sq));



    if(distance<-0.001f){
         //printf("Not hit Root bounding sphere\n");
         return;
     }
     tn=-vxc-sqrt(distance);
     tp=-vxc+sqrt(distance);

    //printf("openCL tn: %f tp:%f\n", tn, tp);
    if(tn<0.0f && tp<0.0f){
        //printf("ray back\n");
        return;
    }

    else if(tn>0.0f && tp>0.0f){
         //printf("hit root bounding shpere\n");
    }

    for(i=1; i<513; i++){
        if(spheres[i].w>0){
            sphere_sq=spheres[i].w*spheres[i].w;
            break;
        }
    }

    for(i=1; i<513; i++){
        if(spheres[i].w<=0){
            isHitNodeSphere[i-1]=false;
            continue;
       }

       xc=convert_float4(shadowStart-spheres[i]);

       xc2=xc.x*xc.x+xc.y*xc.y+xc.z*xc.z;//C+r^2
       vxc=xc.x*shadowRay.x+xc.y*shadowRay.y+xc.z*shadowRay.z;//B
       ray_sq=shadowRay.x*shadowRay.x+shadowRay.y*shadowRay.y+shadowRay.z*shadowRay.z;
       distance=vxc*vxc-(ray_sq*(xc2-sphere_sq));

       if(distance<0.0f){
            //printf("i%d: bounding shpere not hit\n", (i-1));
            isHitNodeSphere[i-1]=false;
            continue;
        }

        tn=-vxc-sqrt(distance);
        tp=-vxc+sqrt(distance);

        if(tn<0.0f && tp<0.0f){
            //printf("ray back\n");
            isHitNodeSphere[i-1]=false;
            continue;
        }

        else if(tn>0.0f && tp>0.0f){
            //printf("OpenCL Shadow Ray Number:%d bounding sphere hit\n", (i-1));
            isHitNodeSphere[i-1]=true;
        }
    }

    polygonID=-1;

    unsigned int vertexMemberId;
    for(i=0; i< *vertexN; i+=3){
        if(n==i){
            continue;
        }
        vertexMemberId=round(vertex[i].w);
        //printf("vertexMemberID:%d\n", vertexMemberId);
        if(!isHitNodeSphere[vertexMemberId]){
            //printf("i:%d nodesphere:%d not hit\n", i, vertexMemberId);
            continue;
        }

        vec0=vertex[i];
        vec1=vertex[i+1];
        vec2=vertex[i+2];
        t0=vec1-vec0;
        t1=vec2-vec0;

        //printf("vertexId vec0:%d vec1:%d vec2:%d\n", vertexIndex[i], vertexIndex[i+1], vertexIndex[i+2]);

        //printf("OpenCL vec0 x:%.9f y:%.9f z:%.9f\n", vec0.x, vec0.y, vec0.z);
        //printf("OpenCL vec1 x:%f y:%f z:%f\n", vec1.x, vec1.y, vec1.z);

        //printf("OpenCL i:%d vec0 x:%f y:%f z:%f\n", i, vec0.x, vec0.y, vec0.z);
         //printf("OpenCL RayDirection x:%f y:%f z:%f\n ", rayDirection[n].x, rayDirection[n].y, rayDirection[n].z);
        // printf("OpenCL t0 x:%.9f y:%.9f z:%.9f\n", t0.x, t0.y, t0.z);
         //printf("OpenCL t1 x:%.9f y:%.9f z:%.9f\n", t1.x, t1.y, t1.z);

        pvec3D=float3(0, 0, 0);
        pvec3D.x=(shadowRay.y*t1.z-shadowRay.z*t1.y);
        pvec3D.y=(shadowRay.z*t1.x-shadowRay.x*t1.z);
        pvec3D.z=(shadowRay.x*t1.y-shadowRay.y*t1.x);

        det=t0.x*pvec3D.x+t0.y*pvec3D.y+t0.z*pvec3D.z;
        //printf("det:%f\n", det);

        if(det>-EPSILON && det<EPSILON){
            //printf("not collision\n");
            continue;
        }

        if(det<EPSILON){
            //if(i==n)
            //printf("i:%d Culling\n", i);
            continue;
        }

        inv_det=round(1.0f/det);
        //printf("OpenCL inv_det:%f\n", inv_det);

        tvec=shadowStart-vec0;
        //tvec.z=round(tvec.z);
        //printf("OpenCL tvec x:%.9f y:%.9f z:%.9f\n", tvec.x, tvec.y, tvec.z);

        //printf("OpenCL pvec3D x:%.9f y:%.9f z:%.9f\n", pvec3D.x, pvec3D.y, pvec3D.z);

        u=tvec.x*pvec3D.x+tvec.y*pvec3D.y+tvec.z*pvec3D.z;

        u*=inv_det;

        if(u<0.0f || u>1.0f){
            //printf("2\n");
            continue;
        }

        qvec3D=float3(0.0f, 0.0f, 0.0f);
        qvec3D.x=(tvec.y*t0.z-tvec.z*t0.y);
        qvec3D.y=(tvec.z*t0.x-tvec.x*t0.z);
        qvec3D.z=(tvec.x*t0.y-tvec.y*t0.x);

        v=shadowRay.x*qvec3D.x+shadowRay.y*qvec3D.y+shadowRay.z*qvec3D.z;

        v*=inv_det;
        if(v<0.0f || u+v>1.0f){
            //printf("u:%f\n", u);
            //printf("OpenCL v:%f\n", v);
            //printf("3\n");
            continue;
         }
         //printf("OpenCL v:%f\n", v);

         t=t1.x*qvec3D.x+t1.y*qvec3D.y+t1.z*qvec3D.z;
         t*=inv_det;
         //printf("i:%d t:%f\n", i, t);
         if(0<t&&t<tmin){
            /*LightToShadowPolygonVec.x=(vec0.x+vec1.x+vec2.x)/3.0f-shadowStart.x;
            LightToShadowPolygonVec.y=(vec0.y+vec1.y+vec2.y)/3.0f-shadowStart.y;
            LightToShadowPolygonVec.z=(vec0.z+vec1.z+vec2.z)/3.0f-shadowStart.z;
            LightToShadowPolygonVec.x=(round((LightToShadowPolygonVec.x)));
            LightToShadowPolygonVec.y=(round((LightToShadowPolygonVec.y)));
            LightToShadowPolygonVec.z=(round((LightToShadowPolygonVec.z)));
            //break;
            distanceLightToShadowPolygon=LightToShadowPolygonVec.x*LightToShadowPolygonVec.x+LightToShadowPolygonVec.y*LightToShadowPolygonVec.y+LightToShadowPolygonVec.z*LightToShadowPolygonVec.z;

            /*if(distanceLightToShadowPolygon>=distanceLightToHitPolygon){
                //printf("longer distance polygonID:%d\n", i);
                //printf("LightToShadow:%f LightToHit:%f\n", distanceLightToShadowPolygon, distanceLightToHitPolygon);
                break;
            }
            /*else{
                //printf("shoter distance polygonID:%d\n", i);
                //printf("LightToShadow:%f LightToHit:%f\n", distanceLightToShadowPolygon, distanceLightToHitPolygon);
                //printf("LightToShadow:%f LightToHit:%f\n", sqrt(distanceLightToShadowPolygon), sqrt(distanceLightToHitPolygon));
                //printf("LightToShadowPolygonVec x:%f y:%f z:%f\n", LightToShadowPolygonVec.x, LightToShadowPolygonVec.y, LightToShadowPolygonVec.z);
              }*/
            polygonID=i;
            break;
            //tmin=t;
         }

         //printf("i:%d ray hit\n", i);
        //break;
       }

       if(polygonID>0 && polygonID!=n){
           //printf("shadow polygonID:%d\n", polygonID);

           detectionPolygonColor[n].x=0.1f;
           detectionPolygonColor[n].y=0.1f;
           detectionPolygonColor[n].z=0.1f;

           detectionPolygonColor[n+1].x=0.1f;
           detectionPolygonColor[n+1].y=0.1f;
           detectionPolygonColor[n+1].z=0.1f;

           detectionPolygonColor[n+2].x=0.1f;
           detectionPolygonColor[n+2].y=0.1f;
           detectionPolygonColor[n+2].z=0.1f;

            if(detectionPolygonColor[n].w==0.0){
                detectionPolygonColor[n].w=100.0f;
                detectionPolygonColor[n+1].w=100.0f;
                detectionPolygonColor[n+2].w=100.0f;
            }
            else{
                if(0<detectionPolygonColor[n].w && detectionPolygonColor[n].w<100){
                    detectionPolygonColor[n].w+=100.0f;
                    detectionPolygonColor[n+1].w+=100.0f;
                    detectionPolygonColor[n+2].w+=100.0f;
                }
                else if(-100<detectionPolygonColor[n].w && detectionPolygonColor[n].w<0){
                    detectionPolygonColor[n].w-=100.0f;
                    detectionPolygonColor[n+1].w-=100.0f;
                    detectionPolygonColor[n+2].w-=100.0f;
                }
            }
/**/
        }
}
