

//HARMONICS 2.0.0
//(c) 2018 The University of Aizu
//This software is released under the GNU General Public License.


#include "createspkdialog.h"
#include "ui_createspkdialog.h"

createSPKDialog::createSPKDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::createSPKDialog)
{
    ui->setupUi(this);
    firstLine=true;
    ui->SPKtextEdit->setFont(QFont("Times", 17, QFont::Bold));
    
}

createSPKDialog::~createSPKDialog()
{
    delete ui;
}

void createSPKDialog::saveSPKData_slot(){

}

void createSPKDialog::sendSPKData_slot(SpiceDouble et, SpiceDouble x, SpiceDouble y, SpiceDouble z){
    QString spkUTC;
    SpiceChar time[LENOUT];
    
    timout_c(et, timeFormat, LENOUT, time);
    char chr[] = "日本語";
    QString qStr = QString(chr);

    et2utc_c(et, "ISOC", 0, LENOUT, time);
    QString timeStr=QString(time);
    QString spkData;
    

    spkData=timeStr+" "+QString(QString::number(x))+" "+QString(QString::number(y))+" "+QString(QString::number(z));

    ui->SPKtextEdit->append(spkData);

}

void createSPKDialog::on_WriteDateButton_clicked(){
    firstLine=false;
    emit getSPKData_signal();
}

void createSPKDialog::on_saveSPKDataButton_clicked(){
    SPKDataFileName = QFileDialog::getSaveFileName(this,tr("Save SPK data file"),".",tr("Text File(*.txt)"));
    if(SPKDataFileName.isEmpty()){
       spkDataFileInput=false;
        return ;
    }

    
        
        QFile spkfile(SPKDataFileName);
        spkfile.open(QIODevice::WriteOnly);
        QTextStream saveSPKStream(&spkfile);
        saveSPKStream <<ui->SPKtextEdit->toPlainText();
        saveSPKStream.flush();
        spkfile.close();

        emit sendSPKDataName_signal(SPKDataFileName);
    
}





void createSPKDialog::on_clearButton_clicked(){

}
