

//HARMONICS 2.0.0
//(c) 2018 The University of Aizu
//This software is released under the GNU General Public License.


#include "inputandmakeckkernelwindow.h"
#include "ui_inputandmakeckkernelwindow.h"
#include <QFileInfo>

InputAndMakeCKKernelWindow::InputAndMakeCKKernelWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::InputAndMakeCKKernelWindow)
{
    ui->setupUi(this);

    isCreateCKKernel=false;
    ckSettingFile=new CKSetFileDialog();

    connect(this, SIGNAL(CKTextSettingFile_signal()), ckSettingFile, SLOT(CKTextSettingFile_slot()));
    connect(this, SIGNAL(createCKSettingFile_signal()), ckSettingFile, SLOT(createCKSettingFile_slot()));

    connect(&MSOPCKprocess, SIGNAL(finished(int, QProcess::ExitStatus)), this, SLOT(MSOPCKfinished(int, QProcess::ExitStatus)));
    connect(&MSOPCKprocess, SIGNAL(error(QProcess::ProcessError)), this, SLOT(MSOPCKError(QProcess::ProcessError)));
    connect(&MSOPCKprocess, SIGNAL(readyReadStandardOutput()), this, SLOT(MSOPCKreadyReadStandardOutput()));
    connect(&MSOPCKprocess, SIGNAL(readyReadStandardError()), this, SLOT(MSOPCKreadyReadStandardError()));

    connect(&RemoveFileprocess, SIGNAL(finished(int, QProcess::ExitStatus)), this, SLOT(RemoveFilefinished(int, QProcess::ExitStatus)));
    connect(&RemoveFileprocess, SIGNAL(error(QProcess::ProcessError)), this, SLOT(RemoveFileError(QProcess::ProcessError)));
    connect(&RemoveFileprocess, SIGNAL(readyReadStandardOutput()), this, SLOT(RemoveFilereadyReadStandardOutput()));
    connect(&RemoveFileprocess, SIGNAL(readyReadStandardError()), this, SLOT(RemoveFilereadyReadStandardError()));

}

InputAndMakeCKKernelWindow::~InputAndMakeCKKernelWindow()
{
    delete ui;
    if(MSOPCKprocess.state()==QProcess::Running){
         MSOPCKprocess.kill();
        MSOPCKprocess.waitForFinished();
    }
    
}

void InputAndMakeCKKernelWindow::sendCKData_slot(SpiceDouble et, SpiceDouble roll, SpiceDouble pitch, SpiceDouble yaw){
    QString spkUTC;
    SpiceChar time[LENOUT];
    cout<<"call sendData"<<endl;
    timout_c(et, timeFormat, LENOUT, time);

    et2utc_c(et, "ISOC", 0, LENOUT, time);
    QString timeStr=QString(time);

    QString ckData=timeStr+" "+QString(QString::number(roll))+" "+QString(QString::number(pitch))+" "+QString(QString::number(yaw));
    QString str=ui->CKtextEdit->toPlainText();

    dataHash.clear();
    SpiceDouble dataET;
    QStringList strList=str.split("\n");

    for(int i=0; i<strList.length(); i++){
        QString is=strList.at(i).simplified();
        is=is.trimmed();
        if(is.isEmpty()){
            continue;
        }
        QStringList list=is.split(" ");
        QString s=list.at(0);
        utc2et_c(s.toStdString().c_str(), &dataET);

        dataHash.insert(dataET, strList.at(i));
  }
    dataHash.insert(et, ckData);

    QList<SpiceDouble> dataList=dataHash.keys();
    qSort(dataList);

    ui->CKtextEdit->clear();
    for(int i=0; i<dataList.length(); i++){
        ui->CKtextEdit->append(dataHash.value(dataList.at(i)));
    }
}

void InputAndMakeCKKernelWindow::on_WriteDateButton_clicked(){
    firstLine=false;
    emit getCKData_signal();
}

void InputAndMakeCKKernelWindow::on_saveCKDataButton_clicked(){
 
    CKFileName = QFileDialog::getSaveFileName(this,tr("Save CK data file"),".",tr("bc File(*.bc)"));

    if(CKFileName.isEmpty()){
         ckDataFileInput=false;
        return ;
    }

 
     
    QStringList ckfileName=CKFileName.split("/");
    QString CKDataFileName="./"+ckfileName.at(ckfileName.length()-1);
    

    CKDataFileName.replace(CKDataFileName.length()-2, 2, "txt");

    
    emit CKTextSettingFile_signal();
    emit createCKSettingFile_signal();

    QFile ckfile(CKDataFileName);

    ckfile.open(QIODevice::WriteOnly);
    QTextStream saveCKStream(&ckfile);
    

    QString str=ui->CKtextEdit->toPlainText();

    QStringList strList=str.split("\n");
     
     

    for(int i=0; i<strList.length(); i++){
        QString is=strList.at(i).simplified();
        is=is.trimmed();
        if(is.isEmpty()){
            continue;
             
        }

        
        QStringList segment=strList.at(i).split(" ");
        SpiceDouble roll, pitch, yaw;

        SpiceDouble q[4];
        SpiceDouble Rmatrix[3][3];
        roll=segment.at(1).toDouble()*rpd_c();
        
        pitch=-segment.at(2).toDouble()*rpd_c();
        yaw=segment.at(3).toDouble()*rpd_c();

        if(roll<0){
            roll=(-(180+roll));
        }
        else{
            roll=180-roll;
        }

        yaw=yaw+90;

        roll=(-roll);
        pitch=(-pitch);
        yaw=(-yaw);

        
        eul2m_c(roll, pitch, yaw, 1, 2, 3, Rmatrix);

        m2q_c(Rmatrix, q);
        
        QString ckInputSegment=segment.at(0)+" "+QString::number(q[0])+" "+QString::number(q[1])+" "+QString::number(q[2])+" "+QString::number(q[3]);
        
        ckInputSegment=ckInputSegment.trimmed();
        ckInputSegment=ckInputSegment.simplified();
        saveCKStream<<ckInputSegment<<endl;
    }

    saveCKStream.flush();
    ckfile.close();

    

    
    
    emit sendCKDataName_signal(CKFileName);
    makeCKCommand=makeCKComFormat+" "+CKSettingFileName+" "+CKDataFileName+" "+CKFileName;
    
    MSOPCKprocess.start(makeCKCommand);
    RemoveSettingfile=rmfile+CKSettingFileName;
    RemoveDataFile=rmfile+CKDataFileName;
    
    
}

void InputAndMakeCKKernelWindow::on_actionShow_Setting_FIle_triggered()
{
    emit CKTextSettingFile_signal();
    ckSettingFile->show();
}

void InputAndMakeCKKernelWindow::setCKParam_slot(QString frame, SpiceInt instId){
    ckSettingFile->setCKParam(frame, instId);
}

void InputAndMakeCKKernelWindow::setLSKFile_slot(QString lskName){
    ckSettingFile->setLSKFile(lskName);
}

void InputAndMakeCKKernelWindow::setSCLKFile_slot(QString sclkName){
    ckSettingFile->setSCLKFile(sclkName);
}

void InputAndMakeCKKernelWindow::setFKFile_slot(QString fkName){
    ckSettingFile->setFKFile(fkName);
}
void InputAndMakeCKKernelWindow::on_closeButton_clicked()
{
    this->close();
}

void InputAndMakeCKKernelWindow::on_actionAuto_Record_attidutes_from_MainWindow_triggered()
{
    emit isAutoRecordCK_signal(ui->actionAuto_Record_attidutes_from_MainWindow->isChecked());
}

void InputAndMakeCKKernelWindow::MSOPCKfinished(int exitCode, QProcess::ExitStatus exitStatus){   
    qDebug("exitCode=%d, exitStatus=%d", exitCode, exitStatus);
}

void InputAndMakeCKKernelWindow::MSOPCKError(QProcess::ProcessError error){   
    qDebug("MSOPCK error=%d", error);
    isCreateCKKernel=error;
}

void InputAndMakeCKKernelWindow::MSOPCKreadyReadStandardOutput(){   
    QByteArray ab = MSOPCKprocess.readAllStandardOutput();
    QTextBrowser *textbroser= new QTextBrowser;
    textbroser->setGeometry(200,100,620,450);
    textbroser->setFont(QFont("Times", 15, QFont::Bold));
    textbroser->insertPlainText(ab.data());
    textbroser->show();

    
}

void InputAndMakeCKKernelWindow::MSOPCKreadyReadStandardError()
{   
    QByteArray ab = MSOPCKprocess.readAllStandardError();
    
}

void InputAndMakeCKKernelWindow::RemoveFilefinished(int exitCode, QProcess::ExitStatus exitStatus){
    qDebug("Cannot Re CKData exitCode=%d, exitStatus=%d", exitCode, exitStatus);
}

void InputAndMakeCKKernelWindow::RemoveFileError(QProcess::ProcessError error){
    qDebug("error=%d", error);
}

void InputAndMakeCKKernelWindow::RemoveFilereadyReadStandardOutput(){

}

void InputAndMakeCKKernelWindow::RemoveFilereadyReadStandardError(){

}
