

//HARMONICS 2.0.0
//(c) 2018 The University of Aizu
//This software is released under the GNU General Public License.


#ifndef INPUTANDMAKESPKKERNELWINDOW_H
#define INPUTANDMAKESPKKERNELWINDOW_H

#include <QMainWindow>
#include <QtGui>
#include <QApplication>
#include <iostream>
#include <QFile>
#include <QFileDialog>
#include <QTextStream>
#include <QMessageBox>
#include <QTextBrowser>
#include "SpiceUsr.h"
#include "spksetfiledialog.h"

#define LENOUT 32
using namespace std;

namespace Ui {
class InputAndMakeSPKKernelWindow;
}

class InputAndMakeSPKKernelWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit InputAndMakeSPKKernelWindow(QWidget *parent = 0);
    ~InputAndMakeSPKKernelWindow();

private:
    Ui::InputAndMakeSPKKernelWindow *ui;
    SpiceBoolean firstLine;
    SpiceDouble preX, preY, preZ;
    QString SPKDataFileName;
    QString SPKFileName;
    QHash<SpiceDouble, QString> dataHash;
    SpiceBoolean spkDataFileInput;
    SpiceChar timeFormat[27]="YYYY Mon DD HR:MN:SC ::UTC";
    
    SPKSetFileDialog *spkSettingFile;
    const QString SPKSettingFileName="./SPKsetFile.txt";
    QProcess MKSPKprocess;
    const QString makeSPKComFormat="/usr/local/bin/mkspk -setup";
    

    QString makeSPKCommand;
    SpiceBoolean isCreateSPKKernel;
    const QString rmfile="rm /Users/s1190244/Desktop/";
    QString RemoveSettingfile;
    QString RemoveDataFile;
    QProcess RemoveFileprocess;

signals:
    void getSPKData_signal();
    void setInputDataFileName_signal(QString);
    void SPKTextSettingFile_signal();
    void createSPKSettingFile_signal();
    void isAutoRecordSPK_signal(SpiceBoolean);

public slots:
    void sendSPKData_slot(SpiceDouble, SpiceDouble, SpiceDouble, SpiceDouble);
    void on_WriteDateButton_clicked();
    void on_saveSPKDataButton_clicked();
    void setSPKParam_slot(QString, QString, QString);
    void setLSKFile_slot(QString);
    void setFKFile_slot(QString);

    void MKSPKfinished(int exitCode, QProcess::ExitStatus exitStatus);
    void MKSPKError(QProcess::ProcessError error);
    void MKSPKreadyReadStandardOutput();
    void MKSPKreadyReadStandardError();

    void RemoveFilefinished(int exitCode, QProcess::ExitStatus exitStatus);
    void RemoveFileError(QProcess::ProcessError error);
    void RemoveFilereadyReadStandardOutput();
    void RemoveFilereadyReadStandardError();
    void on_actionShow_Setting_File_triggered();
    void on_closeButton_clicked();
    void on_actionAuto_Record_positions_from_MainWindow_triggered();
};

#endif 
