#include "operatedatabase.h"
#include <QDebug>

OperateDatabase::OperateDatabase(QObject *parent) : QObject(parent)
{

}

OperateDatabase::~OperateDatabase(){
    DB.close();
}

void OperateDatabase::initDB_slot(){
    this->tableNames.clear();
    this->DSKs.clear();

    query.exec("select * from TargetModel");
    while (this->query.next()){ 
        this->tableNames.append(this->query.value(0).toString());
        this->DSKs.append(this->query.value(1).toString());
    }
}

void OperateDatabase::openDB_slot(QString DBPath){
    this->DB = QSqlDatabase::addDatabase("QSQLITE");
    this->DB.setDatabaseName(DBPath);

    this->DB.open();

    this->query = QSqlQuery(this->DB);
}

QStringList OperateDatabase::getTableNames_slot(){
    return this->tableNames;
}

QStringList OperateDatabase::getDSKs_slot(){
    return this->DSKs;
}

bool OperateDatabase::exectuteQuery_slot(QString sql){
    if(!query.exec(sql)) return false;
    return true;
}

QStringList OperateDatabase::get_DBImages_slot(QString tableName){
    QStringList images;
    images.clear();

    query.exec(QString("select * from %1FileInfo").arg(tableName));
    while (query.next()){ 
        images.append(query.value(0).toString());
    }

    return images;
}
