

//HARMONICS 2.0.0
//(c) 2018 The University of Aizu
//This software is released under the GNU General Public License.


__kernel void compRayDirection(__global const float4* WandH, const __global float* modelviewInvXProjInv, const __global int* viewport, __global float4* rayDirection, __global float4* screenNear){
    int i;
    float4 worldPos, pos;
    float4 nearPos, farPos;
    const unsigned int n=get_global_id(0);

    //printf("w:%f h:%f colorcode:%f\n", WandH[n].x, WandH[n].y, WandH[n].z);

    //near
    pos.x=(WandH[n].x)*2/viewport[0]-1;
    pos.y=(WandH[n].y)*2/viewport[1]-1;
    pos.z=-1;
    pos.w=1;

    worldPos.x=pos.x*modelviewInvXProjInv[0]+pos.y*modelviewInvXProjInv[4]+pos.z*modelviewInvXProjInv[8]+pos.w*modelviewInvXProjInv[12];
    worldPos.y=pos.x*modelviewInvXProjInv[1]+pos.y*modelviewInvXProjInv[5]+pos.z*modelviewInvXProjInv[9]+pos.w*modelviewInvXProjInv[13];
    worldPos.z=pos.x*modelviewInvXProjInv[2]+pos.y*modelviewInvXProjInv[6]+pos.z*modelviewInvXProjInv[10]+pos.w*modelviewInvXProjInv[14];
    worldPos.w=pos.x*modelviewInvXProjInv[3]+pos.y*modelviewInvXProjInv[7]+pos.z*modelviewInvXProjInv[11]+pos.w*modelviewInvXProjInv[15];

    float value;
    value=worldPos.w;
    if(value==0){
        printf("near Zero dev\n");
    }

    nearPos.x=worldPos.x/value;
    nearPos.y=worldPos.y/value;
    nearPos.z=worldPos.z/value;
    nearPos.w=worldPos.w/value;
/*
    printf("nearPos.x:%f\n", nearPos.x);
    printf("nearPos.y:%f\n", nearPos.y);
    printf("nearPos.z:%f\n", nearPos.z);
    printf("nearPos.w:%f\n", nearPos.w);
*/
    //far
    pos.z=1;

    worldPos.x=pos.x*modelviewInvXProjInv[0]+pos.y*modelviewInvXProjInv[4]+pos.z*modelviewInvXProjInv[8]+pos.w*modelviewInvXProjInv[12];
    worldPos.y=pos.x*modelviewInvXProjInv[1]+pos.y*modelviewInvXProjInv[5]+pos.z*modelviewInvXProjInv[9]+pos.w*modelviewInvXProjInv[13];
    worldPos.z=pos.x*modelviewInvXProjInv[2]+pos.y*modelviewInvXProjInv[6]+pos.z*modelviewInvXProjInv[10]+pos.w*modelviewInvXProjInv[14];
    worldPos.w=pos.x*modelviewInvXProjInv[3]+pos.y*modelviewInvXProjInv[7]+pos.z*modelviewInvXProjInv[11]+pos.w*modelviewInvXProjInv[15];

    value=worldPos.w;
    if(value==0){
        printf("far Zero dev\n");
    }

    farPos.x=worldPos.x/value;
    farPos.y=worldPos.y/value;
    farPos.z=worldPos.z/value;
    farPos.w=worldPos.w/value;

    screenNear[n]=convert_float4(nearPos);
    //screenNear[n].x=nearPos.x;
    //screenNear[n].y=nearPos.y;
/*
    printf("screenNear.x:%f\n", screenNear[n].x);
    printf("screenNear.y:%f\n", screenNear[n].y);
    printf("screenNear.z:%f\n", screenNear[n].z);
    printf("screenNear.w:%f\n", screenNear[n].w);
/**/

    rayDirection[n]=convert_float4(farPos-nearPos);

    rayDirection[n]=normalize(rayDirection[n]);


    rayDirection[n].w=0;
    //rayDirection[n].w=round(WandH[n].z);

    //rayDirection[n].w=WandH[n].w;
    //printf("WandH[%d].z:%f\n", n, WandH[n].z);
 //   printf("rayUnit\n");
    /*printf("rayDirection[%d].x:%f\n", n, rayDirection[n].x);
    printf("rayDirection[%d].y:%f\n", n, rayDirection[n].y);
    printf("rayDirection[%d].z:%f\n", n, rayDirection[n].z);
    printf("rayDirection[%d].w:%f\n", n, rayDirection[n].w);
/**/
}
