

//HARMONICS 2.0.0
//(c) 2018 The University of Aizu
//This software is released under the GNU General Public License.


#include "kerneldialog.h"
#include "ui_kerneldialog.h"


map<QString, SpiceBoolean> KernelDialog::kernelMap;

KernelDialog::KernelDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::KernelDialog)
{
    ui->setupUi(this);
    ui->kerneltableWidget->setColumnWidth(0, 260);
    ui->kerneltableWidget->setEditTriggers(QAbstractItemView::NoEditTriggers);
    checkBoxMapper=new QSignalMapper(ui->kerneltableWidget);
}

KernelDialog::~KernelDialog()
{
    delete ui;
}

void KernelDialog::setKernel(QStringList kernellist){
    QTableWidgetItem *item[3];
    SpiceChar arch_name[32], filetype[32];
    QString type;
    loadedKernelList=kernellist;

    ui->kerneltableWidget->setRowCount(kernellist.size());
    for(int i=0; i<kernellist.length(); i++){
        getfat_c(kernellist.at(i).toStdString().c_str(), 32, 32, arch_name, filetype);

        QStringList filenamelist=kernellist.at(i).split("/");
                QString ommisionName="..."+filenamelist.at(filenamelist.length()-2)+"/"+filenamelist.at(filenamelist.length()-1);
        item[0]=new QTableWidgetItem(ommisionName);
        item[1]=new QTableWidgetItem(filetype);
        QCheckBox *loadCheckBox=new QCheckBox();

        
        int n=kernelMap.size();
        if(i<n){
            SpiceBoolean loadCheck=kernelMap[kernellist.at(i)];
            loadCheckBox->setChecked(loadCheck);
        }
        else
            loadCheckBox->setChecked(true);

        ui->kerneltableWidget->setItem(i, 0, item[0]);
        ui->kerneltableWidget->setItem(i, 1, item[1]);
        ui->kerneltableWidget->setCellWidget(i, 2, loadCheckBox);

        

        connect(loadCheckBox, SIGNAL(toggled(bool)), checkBoxMapper, SLOT(map()));
        checkBoxMapper->setMapping(loadCheckBox, i);

        type=QString(filetype);
        
        if(type=="IK"){
            

        }

        if(type=="FK"){
            emit setFKFile_signal(kernellist.at(i));
        }

        if(type=="LSK"){
            emit setLSKFile_signal(kernellist.at(i));
        }

        if(type=="SCLK"){
            emit setSCLKFile_signal(kernellist.at(i));
        }
        
    }
    
    

    connect(checkBoxMapper, SIGNAL(mapped(int)), this, SLOT(kernelLoad(int)));
}

void KernelDialog::kernelLoad(int i){
    QCheckBox *checkBox=static_cast<QCheckBox *>(ui->kerneltableWidget->cellWidget(i, 2));

    if(checkBox->checkState()==Qt::Checked){
        
         furnsh_c(loadedKernelList[i].toStdString().c_str());
         cout<<"Kernel "+loadedKernelList[i].toStdString()+" is loaded"<<endl;
    }
    else{
        
       unload_c(loadedKernelList[i].toStdString().c_str());
       cout<<"Kernel "+loadedKernelList[i].toStdString()+" is unloaded"<<endl;
    }
}

void KernelDialog::on_OKButton_clicked()
{
    int n=ui->kerneltableWidget->rowCount();
    

    
    kernelMap.clear();

    for(int i=0; i<n; i++){
        
        QString str=loadedKernelList[i];
        QCheckBox *checkBox=static_cast<QCheckBox *>(ui->kerneltableWidget->cellWidget(i, 2));

        SpiceBoolean isCheck;
        if(checkBox->checkState()==Qt::Checked){
            isCheck=true;
        }
        else{
            isCheck=false;
        }

        kernelMap.insert(map<QString, SpiceBoolean>::value_type(loadedKernelList[i], isCheck));
    }

    ui->kerneltableWidget->clear();
}
