

//HARMONICS 2.0.0
//(c) 2018 The University of Aizu
//This software is released under the GNU General Public License.


#ifndef KERNELDIALOG_H
#define KERNELDIALOG_H

#include <iostream>
#include <QWidget>
#include <QtGui>
#include <QDialog>

#include <QCheckBox>

#include "SpiceUsr.h"
#include <string.h>
#include <map>

using namespace std;

namespace Ui {
class KernelDialog;
}

class KernelDialog : public QDialog
{
    Q_OBJECT

public:
    explicit KernelDialog(QWidget *parent = 0);
    ~KernelDialog();
    void setKernel(QStringList);

private:
    Ui::KernelDialog *ui;
    QSignalMapper *checkBoxMapper;
    
    QStringList loadedKernelList;
    static map<QString, SpiceBoolean> kernelMap; 

    
    

signals:
    void setLSKFile_signal(QString);
    void setSCLKFile_signal(QString);
    void setFKFile_signal(QString);

private slots:
    
    void kernelLoad(int);
    
    void on_OKButton_clicked();
};

#endif 


