

//HARMONICS 2.0.0
//(c) 2018 The University of Aizu
//This software is released under the GNU General Public License.


#include "observationdatamanagementdbmainwindow.h"
#include "ui_observationdatamanagementdbmainwindow.h"

ObservationDataManagementDBMainWindow::ObservationDataManagementDBMainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::ObservationDataManagementDBMainWindow)
{
    ui->setupUi(this);

    databasedrawgl = new DatabaseDrawGL();


    readFilesList.clear();

    ui->projectsTableWidget->setColumnCount(3);
    

    ui->projectsTableWidget->setHorizontalHeaderLabels( QStringList()<< tr("Project")
                                                       << tr("Instrument")
                                                       << tr("Version"));

    target = NULL;

    connect(this, SIGNAL(sendTargetModel_signal(DrawTargetModel*)), ui->targetOpenGLWidget, SLOT(sendTargetModel_slot(DrawTargetModel*)));
    connect(this, SIGNAL(setSearchRegionMode_signal(bool)), ui->targetOpenGLWidget, SLOT(setSearchRegionMode_slot(bool)));
    connect(this, SIGNAL(sendObservedAreas_signal(QStringList)), ui->targetOpenGLWidget, SLOT(sendObservedAreas_slot(QStringList)));
    connect(ui->targetOpenGLWidget, SIGNAL(getPLAndImageMap_signal()), this, SLOT(getPLAndImageMap_slot()));
    connect(ui->targetOpenGLWidget, SIGNAL(sendResultSearchImage_signal(QStringList)), this, SLOT(sendResultSearchImage_slot(QStringList)));
    connect(this, SIGNAL(resetRegion_signal()), ui->targetOpenGLWidget, SLOT(resetRegion_slot()));
}

ObservationDataManagementDBMainWindow::~ObservationDataManagementDBMainWindow()
{
    delete ui;
}

void ObservationDataManagementDBMainWindow::setReadFileToDBWindow_slot(QStringList readFiles){
    readFilesList << readFiles;

    listUpReadFilesWidget(readFilesList);
}

void ObservationDataManagementDBMainWindow::on_ReadShapeModel_clicked()
{
    target = getTargetModel_signal();
    sendTargetModel_signal(target);
}

void ObservationDataManagementDBMainWindow::on_searchRegionPushButton_clicked(bool checked)
{
    
    if(projectName == ""){
        return;
    }

    if(target == NULL) return;

    if(!checked){
        ui->searchRegionPushButton->setCheckable(true);
        setSearchRegionMode_signal(false);
    }

    else {
        ui->searchRegionPushButton->setCheckable(false);
        setSearchRegionMode_signal(true);
    }
}

void ObservationDataManagementDBMainWindow::on_UnloadpushButton_clicked()
{
    readFilesList.removeAt(ui->readFIleListWidget->currentIndex().row());

    listUpReadFilesWidget(readFilesList);
}

void ObservationDataManagementDBMainWindow::listUpReadFilesWidget(QStringList files){
    ui->readFIleListWidget->clear();

    for(int i = 0; i < files.length(); i++){
        QFileInfo fileInfo(files.at(i));
        ui->readFIleListWidget->addItem(fileInfo.fileName());
    }
}

void ObservationDataManagementDBMainWindow::on_LoadpushButton_clicked()
{
    QStringList files=QFileDialog::getOpenFileNames(this, tr("Open Kernels or Kernel List Files"), QDir::homePath(), tr("Spice Kernel Files(*.bc *.bsp *.tpc *.bpm *.ti *.TF *.tsc *.tls *.tpc *.txt *.obj *.mtl *.bds)"));

    if(files.empty()) return;

    for(int i = 0; i < files.length(); i++){
        if(readFilesList.contains(files.at(i))){
            files.removeAt(i);
            i--;
        }
    }

    readFilesList << files;
    listUpReadFilesWidget(readFilesList);
}

int ObservationDataManagementDBMainWindow::DBRowCount(QString table){
    query.exec(QString("select * from '%1'").arg(table));

    int row = 0;
    while (query.next()) row++;

    return row;
}

void ObservationDataManagementDBMainWindow::openDBWindow_slot(QString path){
    DB = QSqlDatabase::addDatabase("QSQLITE");
    DB.setDatabaseName(path);
    DB.open();

    query = QSqlQuery(DB);

    int row = DBRowCount("Projects"); 

    ui->projectsTableWidget->setRowCount(row);

    query.exec(QString("select * from Projects"));

    row = 0;
    while (query.next()){ 
        QString name, instrument, version;
        QTableWidgetItem *item;

        name = query.value(0).toString();
        item = new QTableWidgetItem(name);
        ui->projectsTableWidget->setItem(row, 0, item);

        instrument = query.value(1).toString();
        QFileInfo fileInfo(instrument);
        item = new QTableWidgetItem(fileInfo.fileName());
        ui->projectsTableWidget->setItem(row, 1, item);

        version = query.value(3).toString();
        item = new QTableWidgetItem(version);
        ui->projectsTableWidget->setItem(row, 2, item);

        row++;
    }

    this->show();
}

void ObservationDataManagementDBMainWindow::on_MakepushButton_clicked()
{
    QString instrument, DSK, kernels;
    QStringList files;
    bool isInst = false;
    bool isDSK = false;
    for(int i = 0; i < readFilesList.length(); i++){
        QFileInfo fileInfo(readFilesList.at(i));

        QString ext = fileInfo.suffix().toUpper();



        if(ext == "TI"){
            QString inst = ui->Instrumentlabel->text();

            instrument = readFilesList.at(i);

            
            if(instrument.contains(inst)){

                
                QString projectName = ui->projectLineEdit->text();
                if(projectName == "") projectName = inst;

                isInst = true;
            }
        }
        else if(ext == "BDS"){
            DSK = readFilesList.at(i);
            isDSK = true;
        }
        else kernels.append(readFilesList.at(i) + ",");
    }

    
    if(!isInst && !isDSK){
        return;
    }

    query.exec(QString("insert into Projects values ('%1', '%2', '%3', '%4', '%5');").arg(projectName, instrument, DSK, "1.00", kernels));

    query.exec(QString("create table %1 (PolygonID int primary key, ImageList text default 'NULL', NormalVectorX text, NormalVectorY text, NormalVectorZ text)").arg(projectName));

    query.exec(QString("create table %1Images (Image int primary key, PolygonID text, ObservedTime text)").arg(projectName));

    
    SpiceInt handle, vectorNum, polygonNum;
    SpiceDLADescr dladsc;
    SpiceBoolean found;

    dasopr_c(DSK.toStdString().c_str(), &handle);
    dlabfs_c(handle, &dladsc, &found);
    dskz02_c(handle, &dladsc, &vectorNum, &polygonNum);


    
    QProgressBar bar;
    
    bar.setRange(0, polygonNum);

    SpiceDouble plNorm[3];
    
    for(int i = 0; i < polygonNum; i++){
        dskn02_c(handle, &dladsc, i+1, plNorm);
        query.exec(QString("insert into '%1'(PolygonID, NormalVectorX, NormalVectorY, NormalVectorZ) values ('%2', '%3', '%4', '%5');").arg(projectName, QString::number(i+1), QString::number(plNorm[0]), QString::number(plNorm[1]), QString::number(plNorm[2])));
        bar.setValue(i);
        bar.show();
    }

    int row = DBRowCount("Projects"); 

    ui->projectsTableWidget->setRowCount(row);

    query.exec(QString("select * from Projects"));

    row = 0;
    while (query.next()){ 
        QString name, instrument, version;
        QTableWidgetItem *item;

        name = query.value(0).toString();
        item = new QTableWidgetItem(name);
        ui->projectsTableWidget->setItem(row, 0, item);

        instrument = query.value(1).toString();
        QFileInfo fileInfo(instrument);
        item = new QTableWidgetItem(fileInfo.fileName());
        ui->projectsTableWidget->setItem(row, 1, item);

        version = query.value(3).toString();
        item = new QTableWidgetItem(version);
        ui->projectsTableWidget->setItem(row, 2, item);

        row++;
    }
}

void ObservationDataManagementDBMainWindow::on_AddImagesPushButton_clicked()
{
    query.exec(QString("select * from Projects"));

    QString ikFile, kernel;
    int row = 0;
    while (query.next()){
        if(ui->projectsTableWidget->currentRow() == row){
            ikFile = query.value(1).toString();
            projectDSK = query.value(2).toString();
            kernel = query.value(4).toString();
        }
        row++;
    }

    QStringList kernels;
    kernels = kernel.split(",");
    
    

    

    QStringList imageList;
    QString str;
    while (query.next()) str = query.value(0).toString();
    imageList.append(str);

    QStringList images = QFileDialog::getOpenFileNames(this, tr("Open Kernels or Kernel List Files"), QDir::homePath(), tr("Spice Kernel Files(*.fit *.fits)"));
    if(images.empty()) return;

    SCName = getSCName_signal();
    SCFrame = getSCFrame_signal();
    targetName = getTargetName_signal();
    bodyFixed = getBodyFixed_signal();

    
    instID = getInstID(ikFile);

    
    


    
    SpiceInt handle, vectorNum, polygonNum;
    SpiceDLADescr dladsc;
    SpiceBoolean found;

    dasopr_c(projectDSK.toStdString().c_str(), &handle);
    dlabfs_c(handle, &dladsc, &found);

    observedTimes.clear();
    for(int i = 0; i < images.length(); i++){
        if(getImageUTC(images.at(i))){
            searchPolygonID(observedTimes.at(i), handle, dladsc, images.at(i));
        }
    }

    
}


SpiceInt ObservationDataManagementDBMainWindow::getInstID(QString file){
    QFile IKFile(file);
    QString instCode, scNameOfInst, instNameOfSC;
    SpiceBoolean found,isInst;
    found=isInst=SPICEFALSE;

    if(!IKFile.open(QIODevice::ReadOnly)) return SPICEFALSE;

    QTextStream IKkernelTextStream(&IKFile);

    while(!IKkernelTextStream.atEnd()){
        QString str=IKkernelTextStream.readLine();
        if(str.contains("SPACECRAFT_NAME")){
            str=str.trimmed();
            QStringList strList=str.split("=");
            str=strList.at(1).trimmed();
        }
        if(str.contains("NAIF_INSTRUMENT_ID")){
            str=str.trimmed();
            QStringList strList=str.split("=");
            QString str = strList.at(1);
            return str.toInt();
        }
    }
}

SpiceBoolean ObservationDataManagementDBMainWindow::getImageUTC(QString image){
    QFileInfo fileInfo;
    fileInfo.setFile(image);

    if(fileInfo.suffix().toLower() == "fit" || fileInfo.suffix().toLower() == "fits"|| fileInfo.suffix().toLower() == "fts"){
        auto_ptr<FITS> pInfile(0);

        try{
            pInfile.reset(new CCfits::FITS(image.toStdString().c_str(), CCfits::Read, true));
            PHDU& fitsImage=pInfile->pHDU();
            string UTC_0;
            fitsImage.readKey("UTC_0", UTC_0);
            observedTimes.append(QString(UTC_0.c_str()));
            return SPICETRUE;
        }
        catch(FitsException& issue){
            return  SPICEFALSE;
        }
    }
    else return SPICEFALSE;
}

bool ObservationDataManagementDBMainWindow::searchPolygonID(QString UTC, SpiceInt handle, SpiceDLADescr dladsc, QString fileName){
    SpiceDouble et, pixel_size;
    SpiceDouble pixel_dbl[2], image_size[2], image_center[2], bsight[3], bsight_bd[3], origin_bd[3];
    SpiceDouble solar_pos_bd[3], SC_pos_bd[3], plnorm[3], plate_center[3], plcenter2SC_bd[3], surface_point_tmp[3];
    SpiceDouble image_coord_bd[3], image_coord[3];
    SpiceDouble focal_length, lt;
    SpiceDouble bounds[BCVLEN][3], rotate[3][3], rotate_inv[3][3], verts[3][3];
    SpiceChar shape[STRLEN], frame[STRLEN];
    SpiceInt n_bcv;
    SpicePlane image_plane_bd;
    SpiceInt plates[1][3];
    SpiceInt num, nvtx, plid_tmp;
    SpiceBoolean found;
    SpiceInt numOfPolygon, numOfVertices;
    QVector<int> PLList;

    PLID.clear();

    if(!get_cam_info(instID, image_center, image_size, &pixel_size, &focal_length)) false;

    getfov_c(instID, BCVLEN, STRLEN, STRLEN, shape, frame,  bsight, &n_bcv, bounds); 

    str2et_c(UTC.toStdString().c_str(), &et); 

    

    
    spkpos_c(QString(targetName).toStdString().c_str(), et, bodyFixed.toStdString().c_str(), "LT+S", QString(QString::number(SCID)).toStdString().c_str(), SC_pos_bd, &lt);
    vminus_c(SC_pos_bd,SC_pos_bd); 

    
    pxform_c(frame, bodyFixed.toStdString().c_str(), et, rotate);

    
    

    vhat_c(bsight, bsight); 
    vscl_c(focal_length, bsight, bsight); 
    mxv_c (rotate, bsight, bsight_bd); 

    vadd_c(SC_pos_bd,bsight_bd,origin_bd); 
    nvp2pl_c(bsight_bd, origin_bd, &image_plane_bd); 
    pxform_c(bodyFixed.toStdString().c_str(), frame, et, rotate_inv); 

    dskz02_c(handle, &dladsc, &numOfVertices, &numOfPolygon); 

    for(int plid = 1; plid <= numOfPolygon; plid++){
        dskp02_c(handle, &dladsc, plid, 1, &num, plates);
        dskn02_c(handle, &dladsc, plid, plnorm ); 

        for(int i=0; i<3; i++){
            dskv02_c(handle, &dladsc, plates[0][i], 1, &nvtx, (SpiceDouble(*)[3])(verts[i])); 
        }

        for(int i=0; i<3; i++){
            plate_center[i] = (verts[0][i] + verts[1][i] + verts[2][i])/3; 
        }

        vsub_c (SC_pos_bd,plate_center,plcenter2SC_bd);

        dskx02_c (handle, &dladsc, plate_center, plcenter2SC_bd, &plid_tmp, surface_point_tmp, &found); 

        double imgCenterTmp[2], imgVertices[3][2];

        
        if(!found && vsep_c(plnorm, SC_pos_bd) < halfpi_c()) {
            int j;
            inrypl_c(plate_center, plcenter2SC_bd, &image_plane_bd, &j, image_coord_bd); 
            vsub_c(image_coord_bd, SC_pos_bd, image_coord); 
            mxv_c(rotate_inv,image_coord,image_coord); 

            
            imgCenterTmp[0]=image_coord[0]/pixel_size+image_center[0];
            imgCenterTmp[1]=image_coord[1]/pixel_size+image_center[1];

            PLList.append(plid);
            if(PLID==""){
                PLID=QString::number(plid);
            }
            else{
                PLID+=","+QString::number(plid);
            }

            
        }
    }
    QString projectName = ui->projectsTableWidget->currentItem()->text();
    query.exec(QString("insert into '%1Images' values ('%2', '%3', '%4');").arg(projectName, fileName, PLID, UTC));


    
    for(int i = 0; i < PLList.length(); i++){

        query.exec(QString("select * from %1 where PolygonID = '%2';").arg(projectName, QString::number(PLList.at(i))));

        QString str;
        str = query.value(1).toString();
        str += QString(fileName) + ",";

        query.exec(QString("update %1 set ImageList = '%2' where polygonID = %3;").arg(projectName, str, QString::number(PLList.at(i))));
    }
}


void ObservationDataManagementDBMainWindow::on_projectsTableWidget_clicked(const QModelIndex &index)
{
    if(index.column() == 0){
        projectName = ui->projectsTableWidget->currentItem()->text();

        ui->imagesListWidget->clear();

        
        query.exec(QString("select * from '%1Images'").arg(ui->projectsTableWidget->currentItem()->text()));

        
        QStringList images;
        while (query.next()){
            QString str;
            str = query.value(0).toString();
            QFileInfo fileInfo(str);
            images.append(fileInfo.fileName());
        }
        ui->imagesListWidget->addItems(images);
    }
}

void ObservationDataManagementDBMainWindow::on_imagesListWidget_clicked(const QModelIndex &index)
{
    query.exec(QString("select * from '%1Images'").arg(ui->projectsTableWidget->currentItem()->text()));

    QStringList polygons;
    int row = 0;
    while (query.next()){
        if(index.row() == row){
            QString str;
            str = query.value(1).toString();
            polygons = str.split(",");
        }
        row++;
    }

    emit sendObservedAreas_signal(polygons);
}

QMap<int, QString> ObservationDataManagementDBMainWindow::getPLAndImageMap_slot(){
    QMap<int, QString> map;
    query.exec(QString("select * from '%1'").arg(ui->projectsTableWidget->currentItem()->text()));

    while (query.next()){
        QString PL, images;
        PL = query.value(0).toString();
        images = query.value(1).toString();
        map.insert(PL.toInt(), images);
    }

    return map;
}

void ObservationDataManagementDBMainWindow::sendResultSearchImage_slot(QStringList list){
    ui->imagesListWidget->clear();

    
    if(list.at(0) == "none"){
        ui->imagesListWidget->clear();
    }
    else{
        ui->imagesListWidget->addItems(list);
    }
}

void ObservationDataManagementDBMainWindow::on_resetRegionButton_clicked()
{
    emit resetRegion_signal();

    ui->imagesListWidget->clear();
}

void ObservationDataManagementDBMainWindow::sendLoadKernels_slot(QStringList kernellist){
    ui->readFIleListWidget->clear();


    for(int i = 0; i < kernellist.length(); i++){
        QFileInfo fileInfo(kernellist.at(i));
        ui->readFIleListWidget->addItem(fileInfo.fileName());
    }
}

void ObservationDataManagementDBMainWindow::on_readFIleListWidget_clicked(const QModelIndex &index)
{
    ui->Instrumentlabel->setText(ui->readFIleListWidget->currentItem()->text());
}
