

//HARMONICS 2.0.0
//(c) 2018 The University of Aizu
//This software is released under the GNU General Public License.


#include "cksetfiledialog.h"
#include "ui_cksetfiledialog.h"

CKSetFileDialog::CKSetFileDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::CKSetFileDialog)
{
    ui->setupUi(this);
    initSetFile=false;
    overWrite=false;
    
    
    
    
    
    
    
    CK_TYPE="CK_TYPE                = 3";
    
    
    
    
    ANGULAR_RATE_PRESENT="ANGULAR_RATE_PRESENT   = 'MAKE UP/NO AVERAGING'";
    QUATERNION_NORM_ERROR="QUATERNION_NORM_ERROR  = 0.5";
    INPUT_TIME_TYPE="INPUT_TIME_TYPE        = 'UTC'";
    INPUT_DATA_TYPE="INPUT_DATA_TYPE        = 'SPICE QUATERNIONS'";
    PRODUCER_ID="PRODUCER_ID            = 'HARMONICS2'";
}

CKSetFileDialog::~CKSetFileDialog()
{
    delete ui;
}

void CKSetFileDialog::createCKSettingFile_slot(){
    
    
    QFile ckSetfile("./CKsetFile.txt");

    
    

    ckSetfile.open(QIODevice::WriteOnly);
    QTextStream CKSetStream(&ckSetfile);
    CKSetStream <<ui->CKSetTextEdit->toPlainText();
    CKSetStream.flush();
    ckSetfile.close();

    
}

void CKSetFileDialog::setCKParam_slot(QString frame, SpiceInt instId){
    this->frame=frame;
    this->instId=instId;
    
    
    

}
void CKSetFileDialog::setCKParam(QString frame, SpiceInt instId){
    this->frame=frame;
    this->instId=instId;
}

void CKSetFileDialog::setLSKFile_slot(QString lsk){
    lskFile=lsk;
}

void CKSetFileDialog::setSCLKFile_slot(QString sclk){
    sclkFile=sclk;
}

void CKSetFileDialog::setFKFile_slot(QString fk){
    fkFile=fk;
}

void CKSetFileDialog::setLSKFile(QString lsk){
    lskFile=lsk;
}

void CKSetFileDialog::setSCLKFile(QString sclk){
    sclkFile=sclk;
}

void CKSetFileDialog::setFKFile(QString fk){
    fkFile=fk;
}

void CKSetFileDialog::CKTextSettingFile_slot(){
    if(initSetFile==false&&overWrite==false){
        INSTRUMENT_ID=plainINSTRUMENT_ID+QString::number(instId);
        REFERENCE_FRAME_NAME=plainREFERENCE_FRAME_NAME+"'"+frame+"'";
        LSK_FILE_NAME=plainLSK_FILE_NAME+"'"+lskFile+"'";
        SCLK_FILE_NAME=plainSCLK_FILE_NAME+"'"+sclkFile+"'";
        FRAMES_FILE_NAME=plainFRAMES_FILE_NAME+"'"+fkFile+"'";
        INSTRUMENT_ID=plainINSTRUMENT_ID+QString::number(instId);

        ui->CKSetTextEdit->append(BEGINDATA);
        ui->CKSetTextEdit->append(LSK_FILE_NAME);
        ui->CKSetTextEdit->append(SCLK_FILE_NAME);
        ui->CKSetTextEdit->append(FRAMES_FILE_NAME);
        ui->CKSetTextEdit->append(CK_TYPE);
        ui->CKSetTextEdit->append(INSTRUMENT_ID);
        ui->CKSetTextEdit->append(REFERENCE_FRAME_NAME);
        ui->CKSetTextEdit->append(ANGULAR_RATE_PRESENT);
        ui->CKSetTextEdit->append(QUATERNION_NORM_ERROR);
        ui->CKSetTextEdit->append(INPUT_TIME_TYPE);
        ui->CKSetTextEdit->append(INPUT_DATA_TYPE);
        ui->CKSetTextEdit->append(PRODUCER_ID);
        ui->CKSetTextEdit->append("\n");

        initSetFile=true;

        preData=ui->CKSetTextEdit->toPlainText();
    }
}

void CKSetFileDialog::on_OKButton_clicked()
{
    overWrite=true;
    preData=ui->CKSetTextEdit->toPlainText();
    accept();
    
    
    

}

void CKSetFileDialog::on_CancelButton_clicked()
{
    overWrite=false;
    ui->CKSetTextEdit->clear();
    ui->CKSetTextEdit->setText(preData);
    reject();
}
