

//HARMONICS 2.0.0
//(c) 2018 The University of Aizu
//This software is released under the GNU General Public License.


#include "computeelements.h"
#include <QDebug>

const SpiceDouble computeElements::initRotate[4][4] = {
  { 1.0, 0.0, 0.0, 0.0 },
  { 0.0, 1.0, 0.0, 0.0 },
  { 0.0, 0.0, 1.0, 0.0 },
  { 0.0, 0.0, 0.0, 1.0 },
  };

computeElements::computeElements()
{
}


const int significantDigits = 100000;

void computeElements::computePos(const QString SCName, const QString targetName, const SpiceDouble et, SpiceDouble sun_pos[], SpiceDouble earth_pos[], SpiceDouble sc_pos[], SpiceDouble target_pos[])
{
    
    

    
    
    spkpos_c(targetName.toStdString().c_str(), et, "HAYABUSA_HP", "NONE", targetName.toStdString().c_str(), target_pos, &lt);
    
    spkpos_c(SCName.toStdString().c_str(), et, "HAYABUSA_HP", "NONE", targetName.toStdString().c_str(), sc_pos, &lt);
    
    spkpos_c("SUN", et, "HAYABUSA_HP", "NONE", targetName.toStdString().c_str(), sun_pos, &lt);
    
    
    spkpos_c("EARTH", et, "HAYABUSA_HP", "NONE", targetName.toStdString().c_str(), earth_pos, &lt);
    

    
    sun_pos[1]=round(sun_pos[1]);
    earth_pos[0]=round(earth_pos[0]);
    earth_pos[1]=round(earth_pos[1]);

    
    sun_pos[0]=-sun_pos[0];
    sun_pos[1]=-sun_pos[1];
    sc_pos[0]=-sc_pos[0];
    sc_pos[1]=-sc_pos[1];




    for(int i=0; i<3; i++){
        sc_pos[i]=round(sc_pos[i]*1000)/1000;
        target_pos[i]=round(target_pos[i]*1000)/1000;
    }
}

void computeElements::computeAttitude(const SpiceInt instId, const QString targetframe, const SpiceDouble et, SpiceDouble boresight[], SpiceDouble up_inst[], SpiceDouble *roll, SpiceDouble* pitch, SpiceDouble* yaw){
    QString upInstString="INS"+QString::number(instId)+"_UPVECTOR";
    
    SpiceBoolean found_val;
    SpiceInt n;

    
    getfov_c(instId, BCVLEN, STRLEN, STRLEN, shape, cameraframe, bsight_inst, &n_bcv, bounds);
    
    

    gdpool_c(upInstString.toStdString().c_str(), 0, 3, &n, up_inst, &found_val);
    pxform_c(cameraframe, targetframe.toStdString().c_str(), et, rotate);
    mxv_c(rotate, bsight_inst, boresight);
    
    mxv_c(rotate, up_inst, up_inst);
    

    SpiceDouble convx;
    SpiceDouble convy;
    SpiceDouble radian=90*M_PI/180;

    convx=up_inst[0]*cos(radian)+up_inst[1]*sin(radian);
    convy=(-up_inst[0])*sin(radian)+up_inst[1]*cos(radian);
    
    up_inst[0]=convx;
    up_inst[1]=convy;
    boresight[0]=-boresight[0];
    boresight[1]=-boresight[1];

    SpiceDouble rotation[4][4] = {
        { 1.0, 0.0, 0.0, 0.0 },
        { 0.0, 1.0, 0.0, 0.0 },
        { 0.0, 0.0, 1.0, 0.0 },
        { 0.0, 0.0, 0.0, 1.0 },
    };

    
    
    for(int i=0; i<3; i++){
        for(int j=0; j<3; j++){
            rotation[i][j]=rotate[i][j];
        }
    }

    for(int i=0; i<4; i++){
        for(int j=0; j<4; j++){
            obRotate[i*4+j]=rotation[i][j];
        }
    }


    
    
    
    m2eul_c(rotate, 1, 2, 3, roll, pitch, yaw);

    *roll*=(-RadToDeg);
    *pitch*=(-RadToDeg);
    *yaw*=(-RadToDeg);
    

    if(*roll<0){
        *roll=-(180+(*roll));
    }
    else{
        *roll=180-(*roll);
    }
    *yaw-=90;

    


    


    
    

    
    
    
    

    
    for(int i=0; i<3; i++){
        boresight[i]=round(boresight[i]*significantDigits)/significantDigits;
        up_inst[i]=round(up_inst[i]*significantDigits)/significantDigits;
    }
    

}

SpiceDouble computeElements::computeDistance(SpiceDouble pos1[], SpiceDouble pos2[]){
    SpiceDouble distance;
    SpiceDouble a=pos1[0]-pos2[0];
    SpiceDouble b=pos1[1]-pos2[1];
    SpiceDouble c=pos1[2]-pos2[2];
    distance=sqrt(a*a+b*b+c*c);
    
    return distance;
}

void computeElements::computeIllum(const QString SCName, const SpiceInt instId, const SpiceDouble et, const QString scTarget, SpiceDouble *phase, SpiceDouble *incidence, SpiceDouble *emission, SpiceBoolean *foundIll){ 
    SpiceDouble xpoint[3];
    SpiceDouble xsrvec[3];
    SpiceDouble trgepc;


    
    QString fixref="IAU_"+scTarget;
    
    sincpt_c("Ellipsoid", scTarget.toStdString().c_str(), et ,fixref.toStdString().c_str(), "LT+S",SCName.toStdString().c_str(), cameraframe, bsight_inst, xpoint, &trgepc, xsrvec, foundIll);

    if(*foundIll){
        ilumin_c("Ellipsoid", scTarget.toStdString().c_str(), et, fixref.toStdString().c_str(), "LT+S", SCName.toStdString().c_str(), xpoint, &trgepc, xsrvec, phase, incidence, emission);
        
        *phase*=RadToDeg;
        *incidence*=RadToDeg;
        *emission*=RadToDeg;
    }
    else{
        
        *phase=0.0;
        *incidence=0.0;
        *emission=0.0;
    }
}

void computeElements::computeRotateX(const SpiceDouble rotate, const SpiceDouble x[], const SpiceDouble y[], const SpiceDouble z[], SpiceDouble rotateX[], SpiceDouble rotateY[], SpiceDouble rotateZ[]){
    
    
    
    SpiceDouble radian=rotate*rpd_c();
    for(int i=0; i<3; i++){
        rotateX[i]=x[i];
        rotateY[i]=y[i]*cos(radian)+z[i]*sin(radian);
        rotateZ[i]=(-y[i]*sin(radian))+z[i]*cos(radian);

        
        rotateX[i]=round(rotateX[i]*pow(10, 10.0))/pow(10, 10.0);
        rotateY[i]=round(rotateY[i]*pow(10, 10.0))/pow(10, 10.0);
        rotateZ[i]=round(rotateZ[i]*pow(10, 10.0))/pow(10, 10.0);
    }

}

void computeElements::computeRotateY(const SpiceDouble rotate, const SpiceDouble x[], const SpiceDouble y[], const SpiceDouble z[], SpiceDouble rotateX[], SpiceDouble rotateY[], SpiceDouble rotateZ[]){
   
    
    
    SpiceDouble radian=rotate*rpd_c();
    for(int i=0; i<3; i++){
        rotateX[i]=x[i]*cos(radian)-z[i]*sin(radian);
        rotateY[i]=y[i];
        rotateZ[i]=(x[i]*sin(radian))+z[i]*cos(radian);

        
        rotateX[i]=round(rotateX[i]*pow(10, 10.0))/pow(10, 10.0);
        rotateY[i]=round(rotateY[i]*pow(10, 10.0))/pow(10, 10.0);
        rotateZ[i]=round(rotateZ[i]*pow(10, 10.0))/pow(10, 10.0);
    }

}

void computeElements::computeRotateZ(const SpiceDouble rotate, const SpiceDouble x[], const SpiceDouble y[], const SpiceDouble z[], SpiceDouble rotateX[], SpiceDouble rotateY[], SpiceDouble rotateZ[]){
    
    
    

    SpiceDouble radian=rotate*rpd_c();
    for(int i=0; i<3; i++){
        rotateX[i]=x[i]*cos(radian)+y[i]*sin(radian);
        rotateY[i]=(-x[i]*sin(radian))+y[i]*cos(radian);
        rotateZ[i]=z[i];

        
        rotateX[i]=round(rotateX[i]*pow(10, 10.0))/pow(10, 10.0);
        rotateY[i]=round(rotateY[i]*pow(10, 10.0))/pow(10, 10.0);
        rotateZ[i]=round(rotateZ[i]*pow(10, 10.0))/pow(10, 10.0);
    }

}

void computeElements::compTargetRotateMatrix(const QString targetName, const QString targetFrame, const SpiceDouble et, SpiceFloat targetRotate[]){
    QString bodyFixed=targetName+"_FIXED";
    
    pxform_c(bodyFixed.toStdString().c_str(), targetFrame.toStdString().c_str(), et, rotate);

    SpiceDouble rotation[4][4] = {
      { 1.0, 0.0, 0.0, 0.0 },
      { 0.0, 1.0, 0.0, 0.0 },
      { 0.0, 0.0, 1.0, 0.0 },
      { 0.0, 0.0, 0.0, 1.0 },
      };

    xpose_c(rotate, rotate);

    for(int i=0; i<3; i++){
        for(int j=0; j<3; j++){
           rotation[i][j]=rotate[i][j];
        }
    }

    
    

    for(int i=0; i<4; i++){
        for(int j=0; j<4; j++){
            targetRotate[i*4+j]=rotation[i][j];
        }
    }
}


 void computeElements::computeBoresightAndUpInstfromInput(const QString frame, const SpiceInt instID, const SpiceDouble roll, const SpiceDouble pitch, const SpiceDouble yaw, SpiceDouble bsight[], SpiceDouble up[], SpiceDouble bounds[4][3]){
     QString upInstString="INS"+QString::number(instID)+"_UPVECTOR";
     SpiceBoolean found_val;
     SpiceInt n;
     SpiceDouble up_inst[3];
     SpiceDouble boresight[3];
     SpiceDouble Rmatrix[3][3];
     SpiceDouble convx;
     SpiceDouble convy;
     SpiceDouble radian=90.0*M_PI/180.0;
     SpiceDouble r, p, y;
     gdpool_c(upInstString.toStdString().c_str(), 0, 3, &n, up_inst, &found_val);

     if(roll<0){
         r=(-(180+roll));
     }
     else{
         r=180-roll;
     }

     y=yaw+90;

     r=(-r);
     p=(-pitch);
     y=(-y);

     eul2m_c(r*rpd_c(), p*rpd_c(), y*rpd_c(), 1, 2, 3, Rmatrix);
     getfov_c(instID, BCVLEN, STRLEN, STRLEN, shape, cameraframe, boresight, &n_bcv, bounds);
     
     mxv_c(Rmatrix, boresight, bsight);

     
     for(int i = 0; i < n_bcv; i++)
         mxv_c(Rmatrix, bounds[i], bounds[i]);

     
     mxv_c(Rmatrix, up_inst, up);
     
     

     convx=(up[0]*cos(radian)+up[1]*sin(radian));
     convy=((-up[0])*sin(radian)+up[1]*cos(radian));

     up[0]=convx;
     up[1]=convy;
     up[2]=-up[2];

     for(int i=0; i<3; i++){
         bsight[i]=round(bsight[i]*significantDigits)/significantDigits;
         up[i]=round(up[i]*significantDigits)/significantDigits;
     }
     bsight[0]=-bsight[0];
     bsight[1]=-bsight[1];



     for(int i = 0; i < n_bcv; i++){
         bounds[i][0] = -bounds[i][0];
         bounds[i][1] = -bounds[i][1];
     }

     
     
}

