

//mainwindow.cpp
//(c) 2018 The University of Aizu
//This software is released under the GNU General Public License.


#include "mainwindow.h"
#include "ui_mainwindow.h"




const int spiceDoubleCellSize = 2048;
const int spiceIntCellSize = 1024;

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    kernelWindow=new KernelMainWindow();
    observationDBWindow=new ObservationDataManagementDBMainWindow();
    spkSettingFile=new SPKSetFileDialog();
    ckSettingFile=new CKSetFileDialog();
    instAndSCMainWindow=new instrumentonSCMainWindow();
    inputMakeSPKWindow=new InputAndMakeSPKKernelWindow();
    inputMakeCKWindow=new InputAndMakeCKKernelWindow();

    ui->setupUi(this);
    ui->drawImageWidget->hide();
    this->setFixedSize(840, 745);

    ui->SCPosXdoubleSpinBox->setReadOnly(true);
    ui->SCPosYdoubleSpinBox->setReadOnly(true);
    ui->SCPosZdoubleSpinBox->setReadOnly(true);
    ui->SCRolldoubleSpinBox->setReadOnly(true);
    ui->SCPitchdoubleSpinBox->setReadOnly(true);
    ui->SCYawdoubleSpinBox->setReadOnly(true);










    ui->label->setFocus();
    SpiceInt lenout=0;
    SpiceChar action[] = "IGNORE";
    erract_c("SET", lenout, action);
    instId=-130102;
    instName="HAYABUSA_AMICA";
    scName="HAYABUSA";
    frame="HAYABUSA_HP";
    HARMONICS2Mode="ReadingKernel";
    codec=QTextCodec::codecForName("ShiftJIS");
    instIDReg.setPattern("NAIF_INSTRUMENT_ID");
    spacecraftNameReg.setPattern("SPACECRAFT_NAME");
    animation=isShowInputPosAtt=GL_FALSE;
    isAutoRecordSPKData=isAutoRecordCKData=isChangeVal=GL_FALSE;
    isOpenImageFile=GL_TRUE;
    SPKDataName="";
    CKDataName="";
    startEttime=endEttime=0;
    SPKCovertMinEt=10E300;
    SPKCovertMaxEt=0;
    
    QTextCodec::setCodecForLocale(QTextCodec::codecForName("UTF-8"));

    
    connect(&MKSPKprocess, SIGNAL(finished(int, QProcess::ExitStatus)), this, SLOT(MKSPKfinished(int, QProcess::ExitStatus)));
    connect(&MKSPKprocess, SIGNAL(error(QProcess::ProcessError)), this, SLOT(MKSPKerror(QProcess::ProcessError)));
    connect(&MKSPKprocess, SIGNAL(readyReadStandardOutput()), this, SLOT(MKSPKreadyReadStandardOutput()));
    connect(&MKSPKprocess, SIGNAL(readyReadStandardError()), this, SLOT(MKSPKreadyReadStandardError()));

    connect(&MSOPCKprocess, SIGNAL(finished(int, QProcess::ExitStatus)), this, SLOT(MSOPCKfinished(int, QProcess::ExitStatus)));
    connect(&MSOPCKprocess, SIGNAL(error(QProcess::ProcessError)), this, SLOT(MSOPCKerror(QProcess::ProcessError)));
    connect(&MSOPCKprocess, SIGNAL(readyReadStandardOutput()), this, SLOT(MSOPCKreadyReadStandardOutput()));
    connect(&MSOPCKprocess, SIGNAL(readyReadStandardError()), this, SLOT(MSOPCKreadyReadStandardError()));

    connect(&RemoveFileprocess, SIGNAL(finished(int, QProcess::ExitStatus)), this, SLOT(RemoveFilefinished(int, QProcess::ExitStatus)));
    connect(&RemoveFileprocess, SIGNAL(error(QProcess::ProcessError)), this, SLOT(RemoveFileerror(QProcess::ProcessError)));
    connect(&RemoveFileprocess, SIGNAL(readyReadStandardOutput()), this, SLOT(RemoveFilereadyReadStandardOutput()));
    connect(&RemoveFileprocess, SIGNAL(readyReadStandardError()), this, SLOT(RemoveFilereadyReadStandardError()));

    connect(this, SIGNAL(setKernelList_signal(QStringList)), kernelWindow, SLOT(setKernelList_slot(QStringList)));
    connect(ui->GLwidget, SIGNAL(setInstrumentsParameters_signal(QString,QString,QString,QString,QString,QColor)), instAndSCMainWindow, SLOT(setInstrumentsParameters_slot(QString,QString,QString,QString,QString,QColor)));
    connect(ui->GLwidget, SIGNAL(getResolution_signal(QString)), observationDBWindow, SLOT(getResolution_slot(QString)));
    connect(this, SIGNAL(getTargetName_signal(QString)), observationDBWindow, SLOT(getTargetName_slot(QString)));
    connect(observationDBWindow, SIGNAL(visualizationObservedData_signal(QStringList)), ui->GLwidget, SLOT(visualizationObservedData_slot(QStringList)));
    connect(ui->GLwidget, SIGNAL(getPolygonID_signal(QList<GLuint>, QList<GLboolean>)), observationDBWindow, SLOT(getPolygonID_slot(QList<GLuint>, QList<GLboolean>)));
    connect(observationDBWindow, SIGNAL(mapTexture_signal(QString,QString)), ui->GLwidget, SLOT(mapTexture_slot(QString,QString)));

    connect(this, SIGNAL(setSPKParam_signal(QString,QString,QString)), spkSettingFile, SLOT(setSPKParam_slot(QString,QString,QString)));
    connect(this, SIGNAL(setCKParam_signal(QString,SpiceInt)), ckSettingFile, SLOT(setCKParam_slot(QString,SpiceInt)));

    
    connect(kernelWindow, SIGNAL(setLSKFile_signal(QString)), spkSettingFile, SLOT(setLSKFile_slot(QString)));
    connect(kernelWindow, SIGNAL(setLSKFile_signal(QString)), ckSettingFile, SLOT(setLSKFile_slot(QString)));

    connect(kernelWindow, SIGNAL(setSCLKFile_signal(QString)), ckSettingFile, SLOT(setSCLKFile_slot(QString)));

    connect(kernelWindow, SIGNAL(setFKFile_signal(QString)), spkSettingFile, SLOT(setFKFile_slot(QString)));
    connect(kernelWindow, SIGNAL(setFKFile_signal(QString)), ckSettingFile, SLOT(setFKFile_slot(QString)));

    connect(this, SIGNAL(setInputDataFileName_signal(QString)), spkSettingFile, SLOT(setInputDataFileName_slot(QString)));

    
    connect(this, SIGNAL(setSPKParam_signal(QString,QString,QString)), inputMakeSPKWindow, SLOT(setSPKParam_slot(QString,QString,QString)));
    connect(this, SIGNAL(setCKParam_signal(QString,SpiceInt)), inputMakeCKWindow, SLOT(setCKParam_slot(QString,SpiceInt)));

    connect(kernelWindow, SIGNAL(setFKFile_signal(QString)), inputMakeSPKWindow, SLOT(setFKFile_slot(QString)));
    connect(kernelWindow, SIGNAL(setLSKFile_signal(QString)), inputMakeSPKWindow, SLOT(setLSKFile_slot(QString)));

    connect(kernelWindow, SIGNAL(setFKFile_signal(QString)), inputMakeCKWindow, SLOT(setFKFile_slot(QString)));
    connect(kernelWindow, SIGNAL(setLSKFile_signal(QString)), inputMakeCKWindow, SLOT(setLSKFile_slot(QString)));
    connect(kernelWindow, SIGNAL(setSCLKFile_signal(QString)), inputMakeCKWindow, SLOT(setSCLKFile_slot(QString)));

    connect(inputMakeSPKWindow, SIGNAL(getSPKData_signal()), this, SLOT(getSPKData_slot()));
    connect(inputMakeCKWindow, SIGNAL(getCKData_signal()), this, SLOT(getCKData_slot()));
    connect(this, SIGNAL(sendSPKData_signal(SpiceDouble,SpiceDouble,SpiceDouble,SpiceDouble)), inputMakeSPKWindow, SLOT(sendSPKData_slot(SpiceDouble,SpiceDouble,SpiceDouble,SpiceDouble)));
    connect(this, SIGNAL(sendCKData_signal(SpiceDouble,SpiceDouble,SpiceDouble,SpiceDouble)), inputMakeCKWindow, SLOT(sendCKData_slot(SpiceDouble,SpiceDouble,SpiceDouble,SpiceDouble)));


    connect(observationDBWindow, SIGNAL(clearTexture_signal()), ui->GLwidget, SLOT(clearTexture_slot()));

    connect(this, SIGNAL(draw_NIRS_LINE_signal(bool)), ui->GLwidget, SLOT(draw_NIRS_LINE_slot(bool)));
    connect(this, SIGNAL(draw_LIDAR_LINE_signal(bool)), ui->GLwidget, SLOT(draw_LIDAR_LINE_slot(bool)));


    connect(observationDBWindow, SIGNAL(getSCName_signal()), this, SLOT(getSCName_slot()));
    connect(observationDBWindow, SIGNAL(getSCID_singal()), this, SLOT(getSCID_slot()));
    connect(observationDBWindow, SIGNAL(getSCFrame_signal()), this, SLOT(getSCFrame_slot()));
    connect(observationDBWindow, SIGNAL(getTargetName_signal()), this, SLOT(getTargetName_slot()));
    connect(observationDBWindow, SIGNAL(getTargetID_signal()), this, SLOT(getTargetID_slot()));
    connect(observationDBWindow, SIGNAL(getBodyFixed_signal()), this, SLOT(getBodyFixed_slot()));

    connect(this, SIGNAL(setFOVLength_signal(GLfloat)), ui->GLwidget, SLOT(setFOVLength_slot(GLfloat)));

    connect(this, SIGNAL(openDBWindow_signal(QString)), observationDBWindow, SLOT(openDBWindow_slot(QString)));
    connect(this, SIGNAL(sendLoadKernels_signal(QStringList)), observationDBWindow, SLOT(sendLoadKernels_slot(QStringList)));

    connect(observationDBWindow, SIGNAL(getTargetModel_signal()), ui->GLwidget, SLOT(getTargetModel_slot()));

    connect(ui->GLwidget, SIGNAL(setWindowPos_signal(SpiceDouble,SpiceDouble,SpiceDouble)), this, SLOT(setWindowBoresight_slot(SpiceDouble,SpiceDouble,SpiceDouble)));


    timeFormat="YYYY-MM-DDTHR:MN:SC ::UTC";


    
    startUTCtime="2000-01-01T00:00:00";
    QStringList dateTimelist=startUTCtime.split("T");
    QStringList dateList=dateTimelist.at(0).split("-");
    QStringList timeList=dateTimelist.at(1).split(":");
    
    QDate date=QDate(dateList.at(0).toInt(), dateList.at(1).toInt(), dateList.at(2).toInt());
    QTime time=QTime::fromString(dateTimelist.at(1), "hh:mm:ss");
    QDateTime dateTime=QDateTime(date, time, Qt::UTC);
    ui->startUTCdateTimeEdit->setDateTime(dateTime);
    ui->startUTCdateTimeEdit->setDisplayFormat("yyyy-MM-ddThh:mm:ss");
    ui->endUTCdateTimeEdit->setDateTime(dateTime);
    ui->endUTCdateTimeEdit->setDisplayFormat("yyyy-MM-ddThh:mm:ss");
    
}

MainWindow::~MainWindow()
{
    delete ui;
    

    
    
   
}


















void MainWindow::on_action_Quit_triggered()
{
    close();
}


void MainWindow::on_action_About_triggered()
{
    QMessageBox msbox;
    msbox.setStyleSheet("background-image: url(Qt.jpeg)");
    msbox.about(this, tr("About HARMONICS2"),
                             tr("<h2 align=\"center\">HARMONICS2</h2>"
                             "<p>HARMONICS 2.0.1</p>"
                                "<p>(c) 2018 The University of Aizu</p>"
                                "<p>This software is released under the GNU General Public License.</p>"
                                ));
}


void MainWindow::on_actionAbout_Qt_triggered()
{
    QMessageBox::aboutQt(this, "About Qt");
}


void MainWindow::on_action_Read_Kernels_triggered()
{
    SpiceChar arch_name[32], filetype[32];
    QDir d=QDir::current();
    d.cdUp();
    d.cdUp();
    QString dir=d.path();

    if(dir=="SPICE Kernel Set"){
        dir=d.path();
    }
    else{
        dir=QDir::homePath();
    }

    
    QStringList files=QFileDialog::getOpenFileNames(this, tr("Open Kernels or Kernel List Files"), dir  , tr("Spice Kernel Files(*.bds *.bc *.bsp *.tpc *.bpm *.ti *.TF *.tsc *.tls *.tpc *.txt *.obj *.mtl)"));

    

    

    QStringList openKernelfileList;
    GLboolean readed;

    isAddInst=SPICETRUE;
    isAddReference=SPICEFALSE;
    isChangeTimeRange=SPICEFALSE;
    if(files.isEmpty())
        return ;


    
    for(int i=0; i<files.length(); i++){
        if(QFileInfo(files.at(i)).suffix().toLower() == "bds"){

            dasopr_c(files.at(i).toStdString().c_str(), &handle);
            dlabfs_c(handle, &dladsc, &found);

            if(found){
                dskz02_c(handle, &dladsc, &vectorNum, &polygonNum);
                loadKernelList.append(files.at(i));
            }

            files.removeAt(i);
        }
    }


    QFileInfo fileinfo, readfileInfo;
    QString ext, ext2;
    QString str;

    for(int i=0; i<files.length(); i++){
        readed=GL_FALSE;

        fileinfo.setFile(files.at(i));
        ext=fileinfo.suffix();
        ext=ext.toUpper();
        if(ext=="TXT"){
            
            QFile kernelListFile(files.at(i));
            if(!kernelListFile.open(QIODevice::ReadOnly)){
                return ;
            }

            QTextStream in(&kernelListFile);

            while(!kernelListFile.atEnd()){
                str=codec->toUnicode(kernelListFile.readLine());
                readed=GL_FALSE;
                readfileInfo.setFile(str);
                ext2=readfileInfo.suffix();
                ext2=ext2.toUpper();
                if(ext2=="OBJ" || ext2=="STL" || ext2=="TXT"){
                    if(!modelFiles.contains(str)){
                        modelFiles.append(str);
                        
                        
                        continue;
                    }
                }
                if(ext2=="MTL"){
                    if(!mtlFiles.contains(str)){
                        
                        mtlFiles.append(str);
                        
                        continue;
                    }
                }

                
                else{
                    openKernelfileList.append(str);
                }
                    
                
            }

        }
        else{
            str=files.at(i);
            readed=GL_FALSE;
            readfileInfo.setFile(str);
            ext2=fileinfo.suffix();
            ext2=ext2.toUpper();
            if(ext2=="OBJ" || ext2=="STL" || ext2=="TXT"){
                if(!modelFiles.contains(str)){
                    modelFiles.append(str);

                    continue;
                }
            }
            if(ext2=="MTL"){
                if(!mtlFiles.contains(str)){
                    
                    mtlFiles.append(str);
                    
                    continue;
                }
            }

            else{
                openKernelfileList.append(str);
                
            }
        }
    }
    for(int i=0; i<openKernelfileList.length(); i++){
        
        

        getfat_c(openKernelfileList.at(i).toStdString().c_str(), 32, 32, arch_name, filetype);
        
        readed=GL_FALSE;
        if(kernelList.contains(openKernelfileList.at(i))){
            readed=GL_TRUE;
        }

        
        if(readed==GL_FALSE){
            kernelList.append(openKernelfileList.at(i));
            loadKernelList.append(openKernelfileList.at(i));
            
            furnsh_c(openKernelfileList.at(i).toStdString().c_str());
            QString KernelFileType=QString(filetype);
            QRegExp r("de[0-9][0-9][0-9].bsp");
            if(KernelFileType.toUpper()=="SPK" && 0>r.indexIn(openKernelfileList.at(i))){
                SPKKernels.append(openKernelfileList.at(i));
                
            }
            if(KernelFileType.toUpper()=="IK"){
                IKKernels.append(openKernelfileList.at(i));
                
            }

            if(KernelFileType.toUpper()=="PCK"){
                PCKKernels.append(openKernelfileList.at(i));
            }
        }
    }

    for(int i=0; i<SPKKernels.length(); i++){
        getSPKInfo(SPKKernels.at(i));
    }
    for(int i=0; i<IKKernels.length(); i++){
        getIKInfo(IKKernels.at(i));
    }

    if(isChangeTimeRange==SPICETRUE){
        setTimeRange();
    }

    if(isAddReference==SPICETRUE){
        setReferenceFrame();
    }

    
    if(openKernelfileList.length()!=0)
        emit setKernelList_signal(openKernelfileList);
    
    ui->targetlabel->setText(SCAndTargetMap.value("HAYABUSA"));
    ui->framelabel->setText(frame);
    emit setFrame_signal(frame);
    emit setTarget_signal(SCAndTargetMap.value("HAYABUSA"));
    emit setTime_signal(startEttime, endEttime, animationStep);
    ui->UTCtime->setText(startUTCtime);

    if(scNames.length()!=0){
        QString str="Instrument && Target of ("+scNames.at(0)+")";
        ui->InstrumentgroupBox->setTitle(str);
    }

    if(SCAndInst.size()!=0){
        emit setInst_signal(ui->InstcomboBox->itemText(0));
    }


    QString s;
    for(int i=0; i<mtlFiles.length(); i++){
        QStringList mtllist=mtlFiles.at(i).split("/");
        
        QString name=mtllist.at(mtllist.length()-1);

        name=name.toLower();

        for(int j=0; j<scNames.length(); j++){
            
            
            s=scNames.at(j);

            s=s.toLower();
            if(name.contains(s)){
                
                emit setLoadSCMTLFile_signal(mtlFiles.at(i));
                mtlFiles[i]="";
                break;
            }
        }

        for(int j=0; j<targetNames.length(); j++){
            s=targetNames.at(j);
            s=s.toLower();
            if(name.contains(s)){
                emit setLoadTargetMTLFile_signal(mtlFiles.at(i));
                mtlFiles[i]="";
                break;
            }
        }
    }
    for(int i=0; i<modelFiles.length(); i++){
        

        QStringList modellist=modelFiles.at(i).split("/");
        QString name=modellist.at(modellist.length()-1);
        name=name.toLower();

        for(int j=0; j<scNames.length(); j++){
            s=scNames.at(j);
            s=s.toLower();
            if(name.contains(s)){
                emit setLoadSCModelFile_signal(modelFiles.at(i));
                modelFiles[i]="";
                break;
            }
        }

        for(int j=0; j<targetNames.length(); j++){
            s=targetNames.at(j);
            s=s.toLower();
            
            
            if(name.contains(s)){
                emit setLoadTargetModelFile_signal(modelFiles.at(i));
                modelFiles[i]="";
                break;
            }
        }
    }

    for(int i = 0; i < PCKKernels.length(); i++){
        QFileInfo file(PCKKernels.at(i));
        if(file.fileName() == "itokawa_gaskell_n3.tpc"){
            unload_c(PCKKernels.at(i).toStdString().c_str());
            furnsh_c(PCKKernels.at(i).toStdString().c_str());
        }
    }
}

SpiceBoolean MainWindow::getSPKInfo(QString SPKFileName){
    QString timeStr;
    SpiceChar timeChar[64];
    SpiceDouble beginEpoch, endEpoch, et;
    SpiceInt niv, obj;
    SPICEDOUBLE_CELL (cover, spiceDoubleCellSize);
    SPICEINT_CELL (ids, spiceIntCellSize);
    spkobj_c(SPKFileName.toStdString().c_str(), &ids);
    for(int i=0; i<card_c(&ids); i++){
        obj=SPICE_CELL_ELEM_I(&ids, i);
        
        scId=obj;
        if(obj<0){
            SpiceChar body[24];
            SpiceBoolean found;
            bodc2n_c(scId, 24, body, &found);
            if(found){
                QString name=QString(body);
                SpiceBoolean foundBody=SPICEFALSE;
                for(int j=0; j<scNames.length(); j++){
                    if(scNames.at(j)==name){
                        foundBody=SPICETRUE;
                        break;
                    }
                }
                if(foundBody==SPICEFALSE){
                    scNames.append(name);
                    emit setSC_signal(name);
                    
                    isAddReference=SPICETRUE;
                }
            }
        }
        scard_c(0, &cover);
        spkcov_c(SPKFileName.toStdString().c_str(), obj, &cover);
        niv=wncard_c(&cover);

        for(int k=0; k<niv; k++){
            wnfetd_c(&cover, k, &beginEpoch, &endEpoch);
            timout_c(beginEpoch, timeFormat.toStdString().c_str(), 64, timeChar);
            timeStr=QString(timeChar);
            utc2et_c(timeChar, &et);
            if(0<=et && et<SPKCovertMinEt){
                SPKCoverMin=timeStr;
                SPKCovertMinEt=et;
                isChangeTimeRange=SPICETRUE;
            }
            timout_c(endEpoch, timeFormat.toStdString().c_str(), 64, timeChar);
            timeStr=QString(timeChar);
            utc2et_c(timeChar, &et);
            if(et>SPKCovertMaxEt){
                SPKCoverMax=timeStr;
                SPKCovertMaxEt=et;
                isChangeTimeRange=SPICETRUE;
            }
        }
    }
    
    SpiceBoolean returnBool = false;
    return returnBool;
}


SpiceBoolean MainWindow::getIKInfo(QString IKFileName){
    QFile IKFile(IKFileName);
    QString instCode, scNameOfInst, instNameOfSC;
    SpiceBoolean found,isInst;
    found=isInst=SPICEFALSE;

    if(!IKFile.open(QIODevice::ReadOnly)){
        cout<<"can not read IK kernel file"<<endl;
        return SPICEFALSE;
        
    }
    QTextStream IKkernelTextStream(&IKFile);
    IKkernelTextStream.setCodec(codec);
    while(!IKkernelTextStream.atEnd()){
        QString str=IKkernelTextStream.readLine();
        
        if(0<=spacecraftNameReg.indexIn(str)){
            QStringList strList=str.split("=");
            scNameOfInst=strList.at(1);
        }
        if(0<=instIDReg.indexIn(str)){
            str=str.trimmed();
            QStringList strList=str.split("=");
            instCode=strList.at(1);
            
            SpiceChar body[24];
            bodc2n_c(instCode.toInt(), 24, body, &found);
            if(!found){
                cout<<"not found"<<endl;
                
                
            }
            instNameOfSC=QString(body);
            
            isInst=SPICEFALSE;
            for(int j=0; j<instNames.length(); j++){
                if(instNames.at(j)==instNameOfSC){
                    isInst=SPICETRUE;
                    break;
                }
            }
            if(found==SPICETRUE && isInst==SPICEFALSE){
                if(instNameOfSC == "HAYABUSA_AMICA")
                    ui->InstcomboBox->addItem(instNameOfSC);
                
                instNames.append(instNameOfSC);
            }
        }
    }
    if(found==SPICEFALSE && isInst==SPICEFALSE){
        QStringList instList=SCAndInst.value(scNameOfInst);
        instList.append(instNameOfSC);
        SCAndInst[scNameOfInst]=instList;

        QStringList list=SCAndInst.value(scNameOfInst);

        for(int i=0; i<list.length(); i++){
            
        }
    }

    
    SpiceBoolean returnBool = false;
    return returnBool;
}

void MainWindow::on_actionInstrument_Parameters_triggered(){
   
   
   
    instAndSCMainWindow->show();
    
}

void MainWindow::setTimeRange(){
    QStringList dateTimelist=SPKCoverMin.split("T");
    QStringList dateList=dateTimelist.at(0).split("-");
    QDate date=QDate(dateList.at(0).toInt(), dateList.at(1).toInt(), dateList.at(2).toInt());
    QTime time=QTime::fromString(dateTimelist.at(1), "hh:mm:ss");
    startDateTime=QDateTime(date, time, Qt::UTC);
    ui->startUTCdateTimeEdit->setMinimumDateTime(startDateTime);
    ui->endUTCdateTimeEdit->setMinimumDateTime(startDateTime);
    ui->startUTCdateTimeEdit->setDateTime(startDateTime);
    ui->startUTCdateTimeEdit->setDisplayFormat("yyyy-MM-ddThh:mm:ss");
    dateTimelist=SPKCoverMax.split("T");
    dateList=dateTimelist.at(0).split("-");
    date=QDate(dateList.at(0).toInt(), dateList.at(1).toInt(), dateList.at(2).toInt());
    time=QTime::fromString(dateTimelist.at(1), "hh:mm:ss");
    endDateTime=QDateTime(date, time, Qt::UTC);
    ui->startUTCdateTimeEdit->setMaximumDateTime(endDateTime);
    ui->endUTCdateTimeEdit->setMaximumDateTime(endDateTime);
    ui->endUTCdateTimeEdit->setDateTime(endDateTime);
    ui->endUTCdateTimeEdit->setDisplayFormat("yyyy-MM-ddThh:mm:ss");
    ui->startUTCdateTimeEdit->setCurrentSection(QDateTimeEdit::DaySection);
    ui->endUTCdateTimeEdit->setCurrentSection(QDateTimeEdit::DaySection);
    emit setTimeRange_signal(startDateTime, endDateTime, SPKCovertMinEt, SPKCovertMaxEt);
}

void MainWindow::setReferenceFrame(){
    SpiceBoolean frameFound, targetFound;
    SpiceInt frcode;
    SpiceChar frname[64], target[64];
    SpiceInt cent;
    SpiceInt frclss;
    SpiceInt clssId;

    for(int i=0; i<scNames.length(); i++){
        cnmfrm_c(scNames.at(i).toStdString().c_str(), 64, &frcode, frname, &frameFound);

        if(!frameFound){
            
        }
        QString frameName=QString(frname);
        

        QString frame=scNames.at(i);
        frame+="_HP";
        namfrm_c(frame.toStdString().c_str(), &frcode);
        frinfo_c(frcode, &cent, &frclss, &clssId, &frameFound);
        if(frameFound){
            
            targetId=cent;
            bodc2n_c(targetId, 64, target, &targetFound);
            if(targetFound){
                targetName=QString(target);
                
                SCAndTargetMap.insert(scNames.at(i), target);
                targetNames.append(target);
                SpiceBoolean isFrame=SPICEFALSE;
                for(int j=0; j<frameNames.length(); j++){
                    if(frameNames.at(j)==frame){
                        isFrame=SPICETRUE;
                    }
                }
                if(isFrame==SPICEFALSE){
                    
                    frameNames.append(frame);
                    ui->framelabel->setText(frame);
                }
            }
        }
        else{
            cout<<"There is insufficient data for frame:"<<frcode<<endl;
        }
    }

}

void MainWindow::on_startUTCdateTimeEdit_dateTimeChanged()
{
    startUTCtime=ui->startUTCdateTimeEdit->text().trimmed();
    endUTCtime=ui->endUTCdateTimeEdit->text().trimmed();
    animationStep=ui->timeStepspinBox->text().trimmed().toDouble();
    if(startUTCtime.isEmpty()){
        startUTCtime=SPKCoverMin;
    }
    if(endUTCtime.isEmpty()){
        endUTCtime=SPKCoverMin;
    }
    utc2et_c(startUTCtime.toStdString().c_str(), &startEttime);
    utc2et_c(endUTCtime.toStdString().c_str(), &endEttime);

    
    
    if(startEttime<0){
        emit setTime_signal(0, endEttime, animationStep);
    }
    emit setTime_signal(startEttime, endEttime, animationStep);
}

void MainWindow::on_endUTCdateTimeEdit_dateTimeChanged()
{
    startUTCtime=ui->startUTCdateTimeEdit->text().trimmed();
    endUTCtime=ui->endUTCdateTimeEdit->text().trimmed();
    animationStep=ui->timeStepspinBox->text().trimmed().toDouble();
    if(startUTCtime.isEmpty()){
        startUTCtime=SPKCoverMin;
    }
    if(endUTCtime.isEmpty()){
        endUTCtime=SPKCoverMax;
    }
    utc2et_c(startUTCtime.toStdString().c_str(), &startEttime);
    utc2et_c(endUTCtime.toStdString().c_str(), &endEttime);

    if(startEttime>=endEttime){
        cout<<"low"<<endl;
        endUTCtime=startUTCtime;
        endEttime=startEttime;
    }
    

    if(startEttime<0){
        emit setTime_signal(0, endEttime, animationStep);
    }
    emit setTime_signal(startEttime, endEttime, animationStep);
}

void MainWindow::on_timeStepspinBox_valueChanged(const QString &arg1)
{
    animationStep=arg1.toDouble();
    if(arg1.isEmpty()){
        animationStep=60;
    }
    SpiceDouble presentETTime;
    utc2et_c(ui->startUTCdateTimeEdit->text().toStdString().c_str(), &presentETTime);

    if(startEttime<0){
        emit setTime_signal(0, endEttime, animationStep);
    }
    emit setTime_signal(presentETTime, endEttime, animationStep);
}

void MainWindow::on_InstcomboBox_currentIndexChanged(const QString &arg1)
{
    
    QString str="Illuminations ("+arg1+")";
    ui->IlluminaiongroupBox->setTitle(str);
    emit setInst_signal(arg1);
}



void MainWindow::setFootprintsOfinstOnSC_slot(QString scName, QString instName){
    if(scName=="HAYABUSA"){
        if(instName=="HAYABUSA_AMICA"){

        }
        else if(instName=="HAYABUSA_AMICA"){

        }
        else if(instName=="HAYABUSA_AMICA"){

        }
        else if(instName=="HAYABUSA_AMICA"){

        }
        else if(instName=="HAYABUSA_AMICA"){

        }
        else{
            cout<<instName.toStdString()<<"is not instrument on Hayabusa"<<endl;
        }
    }
    else if(scName=="HAYABUSA2"){
        if(instName=="HAYABUSA2_TIR"){

        }
    }
}

void MainWindow::notFoundInst_slot(){
    QMessageBox msbox;

    msbox.warning(this, tr("Not found Instrument"),
                             tr("<h2 align=\"center\">Not found Instrument</h2>"
                             "<p>HARMONICS2 can't the Instrument Information</p>"
                                "<p>Please read I-Kernel</p>"
                                ));
}

void MainWindow::on_HARMONICSModecomboBox_currentIndexChanged(const QString &arg1)
{
    QString mode=ui->HARMONICSModecomboBox->currentText();
    HARMONICS2Mode=arg1;
    emit setMode_signal(arg1);
    if(HARMONICS2Mode=="Swing Instrument(SPICE Kernels)"||HARMONICS2Mode=="Swing Instrument(Target Pointing)"){










    }
    else{










        ui->changeValuesCheckBox->setEnabled(true);
    }
    ui->GLwidget->setFocus();

    if(HARMONICS2Mode=="Target Pointing"||HARMONICS2Mode=="Swing Instrument(Target Pointing)"){
       ui->SCRolldoubleSpinBox->setReadOnly(true);
       ui->SCPitchdoubleSpinBox->setReadOnly(true);
       
    }
}

void MainWindow::on_actionAccess_Data_Base_for_Observation_Data_triggered()
{
    emit getResolutionOfModel_signal();
    emit getTargetName_signal(ui->targetlabel->text());
    observationDBWindow->show();
}

void MainWindow::on_actionStore_the_Observed_area_triggered()
{
    emit sendPolygonID_signal();
}

void MainWindow::setScanTimeRange_slot(QDateTime start, QDateTime end, SpiceInt step){

    utc2et_c(start.toString().toStdString().c_str(), &startEttime);
    utc2et_c(end.toString().toStdString().c_str(), &endEttime);

    if(startEttime<0){
        emit setTime_signal(0, endEttime, step);
    }
    if(SPKCovertMinEt>startEttime){
        startUTCtime=SPKCoverMin;
        startEttime=SPKCovertMinEt;
        ui->startUTCdateTimeEdit->setDateTime(ui->startUTCdateTimeEdit->minimumDateTime());
    }
    else{
        ui->startUTCdateTimeEdit->setDateTime(start);
    }
    if(SPKCovertMaxEt<endEttime){
        endUTCtime=SPKCoverMax;
        endEttime=SPKCovertMaxEt;
        ui->endUTCdateTimeEdit->setDateTime(ui->endUTCdateTimeEdit->maximumDateTime());
    }
    else{
        ui->endUTCdateTimeEdit->setDateTime(end);
    }
    ui->timeStepspinBox->setValue(step);
    
}

void MainWindow::on_changeValuesCheckBox_clicked()
{
   GLboolean ischange=!ui->changeValuesCheckBox->isChecked();
   isChangeVal=!ischange;
   if(HARMONICS2Mode=="Swing Instrument(SPICE Kernels)"||HARMONICS2Mode=="Swing Instrument(Target Pointing)"){
       ui->SCPosXdoubleSpinBox->setReadOnly(ischange);
       ui->SCPosYdoubleSpinBox->setReadOnly(ischange);
       ui->SCPosZdoubleSpinBox->setReadOnly(ischange);
       
       
       
   }
   else{
       ui->SCPosXdoubleSpinBox->setReadOnly(ischange);
       ui->SCPosYdoubleSpinBox->setReadOnly(ischange);
       ui->SCPosZdoubleSpinBox->setReadOnly(ischange);
       ui->SCRolldoubleSpinBox->setReadOnly(ischange);
       ui->SCPitchdoubleSpinBox->setReadOnly(ischange);
       ui->SCYawdoubleSpinBox->setReadOnly(ischange);
   }

   if(HARMONICS2Mode=="Target Pointing"||HARMONICS2Mode=="Swing Instrument(Target Pointing)"){
      ui->SCRolldoubleSpinBox->setReadOnly(true);
      ui->SCPitchdoubleSpinBox->setReadOnly(true);
   }
   emit setIsChangeVal_signal(!ischange);
}


void MainWindow::on_SCPosXdoubleSpinBox_valueChanged()
{
    if(prePos[0]==ui->SCPosXdoubleSpinBox->value()){
        return;
    }

    if(isChangeVal==GL_TRUE&&animation==GL_FALSE){
        emit setInputPosAndAtt_signal(ui->SCPosXdoubleSpinBox->value(), ui->SCPosYdoubleSpinBox->value(), ui->SCPosZdoubleSpinBox->value(), ui->SCRolldoubleSpinBox->value(), ui->SCPitchdoubleSpinBox->value(), ui->SCYawdoubleSpinBox->value());
    }
}

void MainWindow::on_SCPosYdoubleSpinBox_valueChanged()
{
    if(prePos[1]==ui->SCPosYdoubleSpinBox->value())
        return;
    if(isChangeVal==GL_TRUE&&animation==GL_FALSE){
        emit setInputPosAndAtt_signal(ui->SCPosXdoubleSpinBox->value(), ui->SCPosYdoubleSpinBox->value(), ui->SCPosZdoubleSpinBox->value(), ui->SCRolldoubleSpinBox->value(), ui->SCPitchdoubleSpinBox->value(), ui->SCYawdoubleSpinBox->value());
    }
}

void MainWindow::on_SCPosZdoubleSpinBox_valueChanged()
{
    if(prePos[2]==ui->SCPosZdoubleSpinBox->value())
        return;
    if(isChangeVal==GL_TRUE&&animation==GL_FALSE){
        emit setInputPosAndAtt_signal(ui->SCPosXdoubleSpinBox->value(), ui->SCPosYdoubleSpinBox->value(), ui->SCPosZdoubleSpinBox->value(), ui->SCRolldoubleSpinBox->value(), ui->SCPitchdoubleSpinBox->value(), ui->SCYawdoubleSpinBox->value());
    }
}

void MainWindow::on_SCRolldoubleSpinBox_valueChanged()
{
    if(preAtt[0]==ui->SCRolldoubleSpinBox->value())
        return;
    if(isChangeVal==GL_TRUE&&animation==GL_FALSE){
        emit setInputPosAndAtt_signal(ui->SCPosXdoubleSpinBox->value(), ui->SCPosYdoubleSpinBox->value(), ui->SCPosZdoubleSpinBox->value(), ui->SCRolldoubleSpinBox->value(), ui->SCPitchdoubleSpinBox->value(), ui->SCYawdoubleSpinBox->value());
    }
}

void MainWindow::on_SCPitchdoubleSpinBox_valueChanged()
{
    if(preAtt[1]==ui->SCPitchdoubleSpinBox->value())
        return;
    if(isChangeVal==GL_TRUE&&animation==GL_FALSE){
        emit setInputPosAndAtt_signal(ui->SCPosXdoubleSpinBox->value(), ui->SCPosYdoubleSpinBox->value(), ui->SCPosZdoubleSpinBox->value(), ui->SCRolldoubleSpinBox->value(), ui->SCPitchdoubleSpinBox->value(), ui->SCYawdoubleSpinBox->value());
    }
}

void MainWindow::on_SCYawdoubleSpinBox_valueChanged()
{
    if(preAtt[2]==ui->SCYawdoubleSpinBox->value())
        return;
    if(isChangeVal==GL_TRUE&&animation==GL_FALSE){
        emit setInputPosAndAtt_signal(ui->SCYawdoubleSpinBox->value(), ui->SCPosYdoubleSpinBox->value(), ui->SCPosZdoubleSpinBox->value(), ui->SCRolldoubleSpinBox->value(), ui->SCPitchdoubleSpinBox->value(), ui->SCYawdoubleSpinBox->value());
    }
}

void MainWindow::on_cameraButton_clicked()
{
    ui->actionOverlay_Image->setEnabled(true);
    emit viewMode_signal(QString("fovMode"));



    ui->positionButton->setChecked(false);
    ui->cameraButton->toggled(true);
}


void MainWindow::on_positionButton_clicked()
{
    ui->actionOverlay_Image->setEnabled(false);
    emit viewMode_signal(QString("geometryMode"));



    ui->cameraButton->setChecked(false);
    ui->positionButton->toggled(true);
}


void MainWindow::on_actionSave_Image_triggered()
{
    emit saveImage_signal();
}

void MainWindow::on_action_Kernel_triggered()
{
    kernelWindow->show();
    isShowInputPosAtt=GL_TRUE;
}

void MainWindow::on_PlayAnimButton_clicked()
{
    emit setFrame_signal(ui->framelabel->text());
    emit setInst_signal(ui->InstcomboBox->currentText());
    emit setTarget_signal(targetName);
    emit startAnimation_signal();
}

void MainWindow::startAnimation_slot(){
    if(ui->PlayAnimButton->text()==">"){
        ui->PlayAnimButton->setText("||");
        if(HARMONICS2Mode=="Swing Instrument(SPICE Kernels)"||HARMONICS2Mode=="Swing Instrument(Target Pointing)"){

















        }
        emit animationStart();
        animation=GL_TRUE;
    }
    else{
       ui->PlayAnimButton->setText(">");
       emit animationStop();
       
       animation=GL_FALSE;
    }
}

void MainWindow::finishedAnim_slot(){
    ui->PlayAnimButton->setText(">");
    animation=GL_FALSE;

    emit scanStop_signal();
}


void MainWindow::on_stepGoButton_clicked()
{
  
   
    stepChanged_signal(animationStep);
}


void MainWindow::on_stepBackButton_clicked()
{
    stepChanged_signal(-animationStep);
}

void MainWindow::on_drawFootprintpushButton_clicked()
{
    timeOnFootprint=QString(ui->UTCtime->text());
    emit drawFootprintsOnTarget_signal();
}

void MainWindow::setWindowTime_slot(SpiceDouble et){
    SpiceChar utc[100];
    et2utc_c(et, "ISOC", 0, STRLEN, utc);
    ui->UTCtime->setText(utc);
    ET=et;
}

void MainWindow::setWindowPos_slot(SpiceDouble positionX, SpiceDouble positionY, SpiceDouble positionZ){
    ui->SCPosXdoubleSpinBox->setValue(QString::number(positionX, 'f', 3).toDouble());
    ui->SCPosYdoubleSpinBox->setValue(QString::number(positionY, 'f', 3).toDouble());
    ui->SCPosZdoubleSpinBox->setValue(QString::number(positionZ, 'f', 3).toDouble());
}

void MainWindow::setWindowBoresight_slot(SpiceDouble roll, SpiceDouble pitch, SpiceDouble yaw){
    ui->SCRolldoubleSpinBox->setValue(QString::number(roll, 'f', 4).toDouble());
    ui->SCPitchdoubleSpinBox->setValue(QString::number(pitch, 'f', 4).toDouble());
    ui->SCYawdoubleSpinBox->setValue(QString::number(yaw, 'f', 4).toDouble());
}

void MainWindow::setWindowPosAndAtt_slot(SpiceDouble positionX, SpiceDouble positionY, SpiceDouble positionZ, SpiceDouble roll, SpiceDouble pitch, SpiceDouble yaw){
    prePos[0]=positionX;
    prePos[1]=positionY;
    prePos[2]=positionZ;
    preAtt[0]=roll;
    preAtt[1]=pitch;
    preAtt[2]=yaw;


    
    ui->SCPosXdoubleSpinBox->setValue(QString::number(positionX, 'f', 3).toDouble());
    ui->SCPosYdoubleSpinBox->setValue(QString::number(positionY, 'f', 3).toDouble());
    ui->SCPosZdoubleSpinBox->setValue(QString::number(positionZ, 'f', 3).toDouble());
    ui->SCRolldoubleSpinBox->setValue(QString::number(roll, 'f', 4).toDouble());
    ui->SCPitchdoubleSpinBox->setValue(QString::number(pitch, 'f', 4).toDouble());
    ui->SCYawdoubleSpinBox->setValue(QString::number(yaw, 'f', 4).toDouble());

    


    if(isAutoRecordSPKData==GL_TRUE){
        emit sendSPKData_signal(ET, positionX, positionY, positionZ);
    }

    if(isAutoRecordCKData==GL_TRUE){
        emit sendCKData_signal(ET, roll, pitch, yaw);
    }
}

void MainWindow::setWindowDisTargettoSC_slot(SpiceDouble dis){
    ui->TargettoSC->setText(QString::number(dis, 'f', 3));
}

void MainWindow::setWindowDisEarthtoSC_slot(SpiceDouble dis){
    ui->EarthtoSC->setText(QString::number(dis, 'f', 3));
}

void MainWindow::setWindowIll_slot(SpiceDouble phase, SpiceDouble incidence, SpiceDouble emission, SpiceBoolean foundIll){
   if(foundIll){
       ui->phaselabel->setText(QString::number(phase, 'f', 2));
       ui->incidencelabel->setText(QString::number(incidence, 'f', 2));
       ui->emissionlabel->setText(QString::number(emission, 'f', 2));
   }

   else{
       ui->phaselabel->setText("Non");
       ui->incidencelabel->setText("Non");
       ui->emissionlabel->setText("Non");
   }
}

void MainWindow::getSubSCPoint_slot(SpiceInt polygonID){
    
    if(polygonID<0){
        ui->subSCPointPolygonlabel->setText("Non");
    }
    else{
        ui->subSCPointPolygonlabel->setText(QString::number(polygonID));
    }
}

void MainWindow::changeKeyStroke_slot(SpiceDouble x, SpiceDouble y, SpiceDouble z, SpiceDouble roll, SpiceDouble pitch, SpiceDouble yaw){
   emit changeValues_signal(x, y, z, roll, pitch, yaw);
}

void MainWindow::on_actionDraw_Image_triggered()
{
    QString imagefile=QFileDialog::getOpenFileName(this, tr("Open Image"), QDir::homePath(), tr("Spice Kernel Files(*.fits *.fit *.fts *.jpg *.jpeg *.png *.bmp *.tiff)"));
    if(imagefile.isEmpty())
        return ;
    this->setFixedSize(1325, 745);

    ui->drawImageWidget->setVisible(true);
    emit openImage_signal(imagefile);

    if(isOpenImageFile==GL_TRUE){
        emit setReadedfile_signal(imagefile);
    }
    else{
        QMessageBox msbox;

        msbox.warning(this, tr("Can't Load Image File"),
                                 tr("<h2 align=\"center\">Can't Load Image File</h2>"
                                 "<p>HARMONICS2 can't load the Image File</p>"
                                    "<p>The Image File maybe broken. Please check the Image File</p>"
                                    ));
    }
}

void MainWindow::isOpenedImageFile_slot(GLboolean isOpenImageFile){
    this->isOpenImageFile=isOpenImageFile;
}

void MainWindow::on_closeImageButton_clicked()
{
    ui->drawImageWidget->setVisible(false);
    this->setFixedSize(840, 745);
}

void MainWindow::on_actionEarth_Vector_triggered()
{
    if(ui->actionEarth_Vector->isChecked()){
        emit drawEarthVec_signal(GL_TRUE);
    }
    else{
        emit drawEarthVec_signal(GL_FALSE);
    }
}

void MainWindow::on_actionSun_Vector_triggered()
{
    if(ui->actionSun_Vector->isChecked()){
        emit drawSunVec_signal(GL_TRUE);
    }
    else{
        emit drawSunVec_signal(GL_FALSE);
    }
}

void MainWindow::on_actionDraw_Orbit_triggered()
{
    
}

void MainWindow::on_actionDraw_Center_triggered()
{
    if(ui->actionDraw_Center->isChecked()){
    emit drawCenterOfFOV_signal(GL_TRUE);
    }

    else{
        emit drawCenterOfFOV_signal(GL_FALSE);
    }
}

void MainWindow::on_actionOverlay_Image_triggered()
{
    if(ui->actionOverlay_Image->isEnabled()){
        emit drawOverlay_signal(ui->actionOverlay_Image->isChecked());
    }
}

void MainWindow::on_actionSelf_Shadow_triggered()
{
    emit isDrawShadow_signal(ui->actionSelf_Shadow->isChecked());
}

void MainWindow::on_actionDraw_Orbital_triggered()
{

}






void MainWindow::on_actionLog_file_triggered()
{
    
}

void MainWindow::on_action_Area_of_FOV_triggered()
{
    
}









void MainWindow::on_actionInit_Footprints_triggered()
{
    QMessageBox msgBox;
    msgBox.setText(tr("Initial footprints Information?"));
    msgBox.setStandardButtons(QMessageBox::Ok | QMessageBox::Cancel);

    int ret=msgBox.exec();
    if(ret==QMessageBox::Ok){
        emit initializeFootprintsInfo_signal();
    }
}

void MainWindow::on_actionCompute_Subpolygon_triggered()
{
    emit isComputeSubPolygon_signal(ui->actionCompute_Subpolygon->isChecked());
}

void MainWindow::on_actionDraw_Shadow_triggered()
{
    if(ui->actionDraw_Shadow->isEnabled()){
        if(ui->actionDraw_Shadow->isChecked())
            emit isDrawShadow_signal(GL_TRUE);
        else
            emit isDrawShadow_signal(GL_FALSE);
    }
}

void MainWindow::on_actionMake_SPK_triggered()
{
    emit setSPKParam_signal(frame, targetName, scName);
    inputMakeSPKWindow->show();
}

void MainWindow::on_actionMake_CK_triggered()
{
    emit setCKParam_signal(frame, instId);
    inputMakeCKWindow->show();
}

void MainWindow::on_action_Show_SettingFile_triggered()
{
    if(HARMONICS2Mode!="OperationPointingTarget"){
        SPKTextSetting_signal();
        CKTextSetting_signal();
        spkSettingFile->show();
        ckSettingFile->show();
    }
    else{
        SPKTextSetting_signal();
        spkSettingFile->show();
    }
}

void MainWindow::sendDataName_slot(QString spkDataName, QString ckDataName){
    SPKDataName=spkDataName;
    CKDataName=ckDataName;
}

void MainWindow::isAutoRecordSPK_slot(SpiceBoolean isAutoRecordSPKData){
    this->isAutoRecordSPKData=isAutoRecordSPKData;
}

void MainWindow::isAutoRecordCK_slot(SpiceBoolean isAutoRecordCKData){
    this->isAutoRecordCKData=isAutoRecordCKData;
}

void MainWindow::makeSettingFile_slot(){
    
        emit createSPKSettingFile_signal();
        emit createCKSettingFile_signal();
    
    
        emit createSPKSettingFile_signal();
}

void MainWindow::getSPKData_slot(){
    SpiceDouble et, x, y, z;
    utc2et_c(ui->UTCtime->text().toStdString().c_str(), &et);

    x=ui->SCPosXdoubleSpinBox->value();
    y=ui->SCPosYdoubleSpinBox->value();
    z=ui->SCPosZdoubleSpinBox->value();

    emit sendSPKData_signal(et, x, y, z);
}

void MainWindow::sendSPKDataName_slot(QString spkDataName){
    SPKDataName=spkDataName;

    emit setInputDataFileName_signal(SPKDataName);
    emit SPKTextSetting_signal();
    emit createSPKSettingFile_signal();
}

void MainWindow::getCKData_slot(){
    SpiceDouble et, roll, pitch, yaw;
    utc2et_c(ui->UTCtime->text().toStdString().c_str(), &et);

    roll=ui->SCRolldoubleSpinBox->value();
    pitch=ui->SCPitchdoubleSpinBox->value();
    yaw=ui->SCYawdoubleSpinBox->value();
    emit sendCKData_signal(et, roll, pitch, yaw);
}

void MainWindow::sendCKDataName_slot(QString ckDataName){
    CKDataName=ckDataName;
    emit CKTextSetting_signal();
    emit createCKSettingFile_signal();
}

void MainWindow::MKSPKfinished(int exitCode, QProcess::ExitStatus exitStatus)
{   
    qDebug("exitCode=%d, exitStatus=%d", exitCode, exitStatus);
}

void MainWindow::MKSPKerror(QProcess::ProcessError error)
{   
    qDebug("error=%d", error);
}

void MainWindow::MKSPKreadyReadStandardOutput()
{   
    QByteArray ab = MKSPKprocess.readAllStandardOutput();
    QTextBrowser *textbroser= new QTextBrowser;
    textbroser->setGeometry(150, 100, 620, 450);
    textbroser->setFont(QFont("Times", 15, QFont::Bold));
    textbroser->insertPlainText(ab.data());
    textbroser->show();

    
}

void MainWindow::MKSPKreadyReadStandardError()
{   
    QByteArray ab=MKSPKprocess.readAllStandardError();
    
}

void MainWindow::MSOPCKfinished(int exitCode, QProcess::ExitStatus exitStatus)
{   
    qDebug("exitCode=%d, exitStatus=%d", exitCode, exitStatus);
}

void MainWindow::MSOPCKerror(QProcess::ProcessError error)
{   
    qDebug("Breif error=%d", error);
}

void MainWindow::MSOPCKreadyReadStandardOutput()
{   
    QByteArray ab = MSOPCKprocess.readAllStandardOutput();
    QTextBrowser *textbroser= new QTextBrowser;
    textbroser->setGeometry(200, 100, 620, 450);
    textbroser->setFont(QFont("Times", 15, QFont::Bold));
    textbroser->insertPlainText(ab.data());
    textbroser->show();

    
}

void MainWindow::MSOPCKreadyReadStandardError()
{   
    QByteArray ab = MSOPCKprocess.readAllStandardError();
    
}

void MainWindow::RemoveFilefinished(int exitCode, QProcess::ExitStatus exitStatus){
    qDebug("exitCode=%d, exitStatus=%d", exitCode, exitStatus);
}

void MainWindow::RemoveFileerror(QProcess::ProcessError error){
    qDebug("Brief error=%d", error);
}

void MainWindow::RemoveFilereadyReadStandardOutput(){

}

void MainWindow::RemoveFilereadyReadStandardError(){

}

void MainWindow::succeededSPKKernel_slot(SpiceBoolean){

}

void MainWindow::succeededCKKernel_slot(SpiceBoolean){

}

void MainWindow::on_CheckNIRS_clicked(bool checked){
    emit draw_NIRS_LINE_signal(checked);
}

void MainWindow::on_LIDAR_clicked(bool checked) {
    emit draw_LIDAR_LINE_signal(checked);
}

void MainWindow::on_XRS_clicked(bool checked){
        
}


void MainWindow::on_FOVLengthHorizontalSlider_sliderMoved(int position)
{
    emit setFOVLength_signal((float)position/10);
}

QString MainWindow::getSCName_slot(){
    return scName;
}

SpiceInt MainWindow::getSCID_slot(){
    return scId;
}

QString MainWindow::getSCFrame_slot(){
    qDebug() << frame;
    return frame;
}

QString MainWindow::getTargetName_slot(){
    qDebug() << targetName;
    return targetName;
}

SpiceInt MainWindow::getTargetID_slot(){
    qDebug() << targetId;
    return targetId;
}

QString MainWindow::getBodyFixed_slot(){
    QString bodyFixed = targetName+"_FIXED";
    qDebug() << bodyFixed;
    return bodyFixed;
}

void MainWindow::on_SetDBpushButton_clicked(){
    DBPath = QFileDialog::getOpenFileName(this, tr("Open Database"), QDir::homePath(), tr("Spice Kernel Files(*.db)"));

    if(DBPath == "") return;

    ui->DBPathlineEdit->setText(DBPath);
}

void MainWindow::on_OpenDBpushButton_clicked()
{
   
   DBPath = ui->DBPathlineEdit->text();

   sendLoadKernels_signal(loadKernelList);
   openDBWindow_signal(DBPath);
}

