

//mainwindow.h
//(c) 2018 The University of Aizu
//This software is released under the GNU General Public License.


#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QApplication>
#include <QWidget>
#include <QtGui>
#include <QFileDialog>
#include <QMessageBox>

#include "kernelmainwindow.h"
#include "observationdatamanagementdbmainwindow.h"

#include "inputandmakespkkernelwindow.h"
#include "inputandmakeckkernelwindow.h"
#include "instrumentonscmainwindow.h"
#include "spksetfiledialog.h"
#include "cksetfiledialog.h"
#include "SpiceUsr.h"
#include <iostream>
#include <glext.h>


using namespace std;

namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

    SpiceBoolean getSPKInfo(QString);
    SpiceBoolean getIKInfo(QString);
    void setReferenceFrame();
    void setTimeRange();

private:
    Ui::MainWindow *ui;
    instrumentonSCMainWindow *instAndSCMainWindow;
    ObservationDataManagementDBMainWindow *observationDBWindow;
    
    InputAndMakeSPKKernelWindow *inputMakeSPKWindow;
    InputAndMakeCKKernelWindow *inputMakeCKWindow;
    CKSetFileDialog *ckSettingFile;
    SPKSetFileDialog *spkSettingFile;
    bool checklog;
    QString frame, scName, targetName, instName;
    SpiceInt scId, targetId, instId;
    QStringList scNames, instNames, instCodes, targetNames, frameNames;
    QStringList modelFiles, mtlFiles;
    QMap<QString, QString> SCAndTargetMap;
    QMap<QString, QStringList> SCAndInst;
    QString HARMONICS2Mode;
    QStringList SPKKernels, IKKernels, PCKKernels;
    QStringList Reloadfiles;
    QString startUTCtime, endUTCtime;
    QString SPKCoverMax, SPKCoverMin;
    GLdouble posx, posy, posz, prePos[3], preAtt[3];
    GLdouble animationStep, preInterval, preRollUL, preRollLL, preRollVariation, prePitchUL, prePitchLL, prePitchVariation, preYawUL, preYawLL, preYawVariation;
    SpiceDouble startEttime, endEttime, SPKCovertMaxEt, SPKCovertMinEt, ET;
    QStringList readedKernel, kernelList;
    QProcess MKSPKprocess, MSOPCKprocess;
    QString timeFormat;
    QTextCodec* codec;
    QRegExp spacecraftNameReg, instIDReg;
    SpiceBoolean isShowInputPosAtt, isChangeVal;
    QString timeOnFootprint;
    QString SPKDataName, CKDataName;
    SpiceBoolean computeSubPolygon, isAddInst, isChangeTimeRange, isAddReference, animation, isAutoRecordCKData, isAutoRecordSPKData;
    KernelMainWindow *kernelWindow;
    SpiceBoolean isOpenImageFile;
    QDateTime startDateTime, endDateTime;
    
    const QString makeSPKComFormat="mkspk -setup";
    const QString makeCKComFormat="msopck";
    QString makeSPKCommand, makeCKCommand;
    QString ckFileName;

    
    
    QString rmfile="rm -R ./*";
    QProcess RemoveFileprocess;


    QStringList loadKernelList;


    SpiceInt handle, vectorNum, polygonNum;
    SpiceDLADescr dladsc;
    SpiceBoolean found;

    QString DBPath;

private slots:
    void on_actionAbout_Qt_triggered();
    void on_action_About_triggered();
    void on_cameraButton_clicked();
    void on_positionButton_clicked();

    void on_PlayAnimButton_clicked();
    void startAnimation_slot();
    void on_stepBackButton_clicked();
    void on_stepGoButton_clicked();
    void on_actionSave_Image_triggered();
    void on_action_Read_Kernels_triggered();
    void on_action_Kernel_triggered();
    void on_actionDraw_Image_triggered();
    void isOpenedImageFile_slot(GLboolean);
    void on_closeImageButton_clicked();
    void on_actionMake_SPK_triggered();
    void on_actionMake_CK_triggered();
    void finishedAnim_slot();
    void notFoundInst_slot();
    void setWindowTime_slot(SpiceDouble);
    void setWindowPos_slot(SpiceDouble, SpiceDouble, SpiceDouble);
    void setWindowBoresight_slot(SpiceDouble, SpiceDouble, SpiceDouble);
    void setWindowPosAndAtt_slot(SpiceDouble, SpiceDouble, SpiceDouble, SpiceDouble, SpiceDouble, SpiceDouble);
    void setWindowDisTargettoSC_slot(SpiceDouble);
    void setWindowDisEarthtoSC_slot(SpiceDouble);
    void setWindowIll_slot(SpiceDouble, SpiceDouble, SpiceDouble, SpiceBoolean);
    void setFootprintsOfinstOnSC_slot(QString, QString);
    void changeKeyStroke_slot(SpiceDouble, SpiceDouble, SpiceDouble, SpiceDouble, SpiceDouble, SpiceDouble);
    void on_actionLog_file_triggered();
    void isAutoRecordSPK_slot(SpiceBoolean);
    void isAutoRecordCK_slot(SpiceBoolean);

    void MKSPKfinished(int exitCode, QProcess::ExitStatus exitStatus);
    void MKSPKerror(QProcess::ProcessError error);
    void MKSPKreadyReadStandardOutput();
    void MKSPKreadyReadStandardError();
    void succeededSPKKernel_slot(SpiceBoolean);

    void MSOPCKfinished(int exitCode, QProcess::ExitStatus exitStatus);
    void MSOPCKerror(QProcess::ProcessError error);
    void MSOPCKreadyReadStandardOutput();
    void MSOPCKreadyReadStandardError();
    void succeededCKKernel_slot(SpiceBoolean);

    void RemoveFilefinished(int exitCode, QProcess::ExitStatus exitStatus);
    void RemoveFileerror(QProcess::ProcessError error);
    void RemoveFilereadyReadStandardOutput();
    void RemoveFilereadyReadStandardError();

    void on_action_Area_of_FOV_triggered();
    void on_action_Quit_triggered();
    void on_HARMONICSModecomboBox_currentIndexChanged(const QString &arg1);
    void on_actionDraw_Orbit_triggered();
    void on_InstcomboBox_currentIndexChanged(const QString &arg1);
    void on_action_Show_SettingFile_triggered();
    void sendDataName_slot(QString, QString);
    void makeSettingFile_slot();
    void getSPKData_slot();
    void sendSPKDataName_slot(QString);
    void getCKData_slot();
    void sendCKDataName_slot(QString);
    void on_actionSun_Vector_triggered();
    void on_actionEarth_Vector_triggered();
    void on_actionDraw_Orbital_triggered();
    void on_changeValuesCheckBox_clicked();
    void on_SCPosXdoubleSpinBox_valueChanged();
    void on_SCPosYdoubleSpinBox_valueChanged();
    void on_SCPosZdoubleSpinBox_valueChanged();
    void on_SCRolldoubleSpinBox_valueChanged();
    void on_SCPitchdoubleSpinBox_valueChanged();
    void on_SCYawdoubleSpinBox_valueChanged();
    void on_actionDraw_Center_triggered();
    void on_actionInit_Footprints_triggered();
    void on_actionDraw_Shadow_triggered();
    void on_endUTCdateTimeEdit_dateTimeChanged();
    void on_startUTCdateTimeEdit_dateTimeChanged();
    void on_timeStepspinBox_valueChanged(const QString &arg1);
    void on_actionInstrument_Parameters_triggered();
    void on_actionAccess_Data_Base_for_Observation_Data_triggered();
    void setScanTimeRange_slot(QDateTime, QDateTime, SpiceInt);
    void getSubSCPoint_slot(SpiceInt);

    void on_actionCompute_Subpolygon_triggered();
    void on_actionOverlay_Image_triggered();
    void on_actionSelf_Shadow_triggered();
    void on_actionStore_the_Observed_area_triggered();
    void on_drawFootprintpushButton_clicked();
    void on_CheckNIRS_clicked(bool checked);
    void on_LIDAR_clicked(bool checked);
    void on_XRS_clicked(bool checked);

    void on_SetDBpushButton_clicked();

    void on_OpenDBpushButton_clicked();

    
    QString getSCName_slot();
    SpiceInt getSCID_slot();
    QString getSCFrame_slot();
    QString getTargetName_slot();
    SpiceInt getTargetID_slot();
    QString getBodyFixed_slot();

    void on_FOVLengthHorizontalSlider_sliderMoved(int position);

signals:
    void viewMode_signal(QString);
    void animationStart(void);
    void animationStop(void);
    void startAnimation_signal();
    void stepChanged_signal(GLint);
    void scanStop_signal();
    void saveImage_signal();
    void setTimeRange_signal(QDateTime, QDateTime, SpiceDouble, SpiceDouble);
    void setMode_signal(QString);
    void setIsChangeVal_signal(GLboolean);
    void setKernelList_signal(QStringList);
    void setSC_signal(QString);
    void setFrame_signal(QString);
    void setInst_signal(QString);
    void setTarget_signal(QString);
    void setTime_signal(SpiceDouble, SpiceDouble, SpiceDouble);
    void setInputPosAndAtt_signal(SpiceDouble, SpiceDouble, SpiceDouble, SpiceDouble, SpiceDouble, SpiceDouble);
    void changeValues_signal(SpiceDouble, SpiceDouble, SpiceDouble, SpiceDouble, SpiceDouble, SpiceDouble);
    void send_param(QString, QString, QString, SpiceDouble, SpiceDouble, SpiceDouble, SpiceDouble);
    void sendInstruments_signal(QString,QStringList);
    void openImage_signal(QString);
    void drawSunVec_signal(GLboolean);
    void drawEarthVec_signal(GLboolean);
    void drawCenterOfFOV_signal(GLboolean);
    void drawFootprintsOnTarget_signal();
    void getFootprintTime_signal(QString);
    void sendPolygonID_signal();
    void isComputeSubPolygon_signal(GLboolean);
    void setReadedfile_signal(QString);
    void drawAreaOfFOV_signal(GLboolean);
    void drawOrbit_signal(GLboolean);
    void drawOverlay_signal(GLboolean);
    void setLoadSCModelFile_signal(QString);
    void setLoadTargetModelFile_signal(QString);
    void setLoadSCMTLFile_signal(QString);
    void setLoadTargetMTLFile_signal(QString);
    void createLogFile_signal(GLboolean);
    void setFootprintsOfinstOnSC_signal(QString, SpiceBoolean);

    
    void createSPKSettingFile_signal();
    void createCKSettingFile_signal();

    void inputSPK_signal(QString);
    void inputCK_signal(QString);
    void saveSPK_signal();
    void saveCK_signal();
    void sendData_signal(SpiceDouble, SpiceDouble, SpiceDouble, SpiceDouble, SpiceDouble, SpiceDouble, SpiceDouble);
    void sendPositionData_signal(SpiceDouble, SpiceDouble, SpiceDouble);
    void sendAttitudeData_signal(SpiceDouble, SpiceDouble, SpiceDouble);
    void makeSettingFile_signal();
    void isDrawFootprints_signal(GLboolean);
    void initializeFootprintsInfo_signal();
    void isDrawShadow_signal(GLboolean);
    void getResolutionOfModel_signal();
    void getTargetName_signal(QString);

    void setSPKParam_signal(QString, QString, QString);
    void setCKParam_signal(QString, SpiceInt);
    void SPKTextSetting_signal();
    void CKTextSetting_signal();
    void SPKSetFileDialog_signal(QString);
    void setInputDataFileName_signal(QString);
    void setLSKFile_signal(QString);
    void setSCLKFile_signal(QString);
    void setFKFile_signal(QString);

    void getSPKFileName_signal(QString);
    void getCKFileName_signal(QString);

    void sendSPKData_signal(SpiceDouble, SpiceDouble, SpiceDouble, SpiceDouble);
    void sendCKData_signal(SpiceDouble, SpiceDouble, SpiceDouble, SpiceDouble);
    void changedParameter_signal(SpiceDouble, SpiceDouble, SpiceDouble,SpiceDouble, SpiceDouble, SpiceDouble);
    void setSwingParameters_signal(SpiceInt, SpiceDouble,SpiceDouble,SpiceDouble,SpiceDouble,SpiceDouble,SpiceDouble, SpiceDouble, SpiceDouble, SpiceDouble);
    void setAutoDrawFootprintsDuringScan_signal(GLboolean);

    
    void draw_NIRS_LINE_signal(bool);
    void draw_LIDAR_LINE_signal(bool);

    void openDBWindow_signal(QString);
    void setReadFileToDBWindow_signal(QStringList);

    void setFOVLength_signal(GLfloat);
    void sendLoadKernels_signal(QStringList);
};

#endif 
