

//model.h
//(c) 2018 The University of Aizu
//This software is released under the GNU General Public License.


#ifndef MODEL
#define MODEL
#include <QVector4D>
#include <QGLWidget>
#include "material.h"
#include <iostream>
#include "model.h"
#include <QDebug>

using namespace std;
class Model{

public:
    GLuint vboID[3];
    GLuint vboIndex, vboDefaultColor, vbobBackup;
    QVector<Material> materials;
    GLuint vertexNum, faceNum;
    QString MTLFileName, modelFileName, modelFileType;
    QVector<QVector4D> verticesData, colorData, backupColorData, translatedVertex, shadowOnData, shadowOffData;
    QVector<QVector3D> normalData, texVerticesV1, texVerticesV2, texVerticesV3;
    QVector<GLuint> indexVector;
    QVector4D defaultColor;
    GLboolean isOBJColored;
    QVector<QVector2D> texImgV1, texImgV2, texImgV3;
    QStringList faceIDV1, faceIDV2, faceIDV3, observedPLIDs;
    GLuint texture;
    bool isMapping;


    Model(){
        vertexNum=faceNum=0;
        isOBJColored=GL_FALSE;
    }

    ~Model(){
        glDeleteBuffers(3, &vboID[0]);
        glDeleteBuffers(1, &vboIndex);
        glDeleteBuffers(1, &vboDefaultColor);
        verticesData.clear();
        normalData.clear();
        colorData.clear();
        indexVector.clear();
    }

    void createVBO(){
        glGenBuffers(3, &vboID[0]);

        glBindBuffer(GL_ARRAY_BUFFER, vboID[0]);
        glBufferData(GL_ARRAY_BUFFER, verticesData.length()*sizeof(QVector4D), verticesData.constData(), GL_STATIC_DRAW);

        GLint bufferForCheck=0;
        glGetBufferParameteriv(GL_ARRAY_BUFFER, GL_BUFFER_SIZE, &bufferForCheck);
        if(sizeof(QVector4D)*verticesData.length()!=bufferForCheck){
            cout<<"vertices"<<endl;
            exit(0);
        }
        glBindBuffer(GL_ARRAY_BUFFER, vboID[1]);
        glBufferData(GL_ARRAY_BUFFER, normalData.length()*sizeof(QVector3D), normalData.constData(), GL_STATIC_DRAW);
        bufferForCheck=0;
        glGetBufferParameteriv(GL_ARRAY_BUFFER, GL_BUFFER_SIZE, &bufferForCheck);
        if(sizeof(QVector3D)*normalData.length()!=bufferForCheck){
            cout<<"normal"<<endl;
            exit(0);
        }

        glBindBuffer(GL_ARRAY_BUFFER, vboID[2]);
        glBufferData(GL_ARRAY_BUFFER, colorData.length()*sizeof(QVector4D), colorData.constData(), GL_DYNAMIC_DRAW);
        bufferForCheck=0;
        glGetBufferParameteriv(GL_ARRAY_BUFFER, GL_BUFFER_SIZE, &bufferForCheck);
        if(sizeof(QVector4D)*colorData.length()!=bufferForCheck){
            cout<<"color"<<endl;
            exit(0);
        }
    }

   void draw3DModel(){
       glBindBuffer(GL_ARRAY_BUFFER, vboID[0]);
       glVertexPointer(3, GL_FLOAT, sizeof(QVector4D), 0);

       glBindBuffer(GL_ARRAY_BUFFER, vboID[1]);
       glNormalPointer(GL_FLOAT, 0, 0);

       glBindBuffer(GL_ARRAY_BUFFER, vboID[2]);
       glColorPointer(3, GL_FLOAT, sizeof(QVector4D), 0);

       glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, vboIndex);
       glEnableClientState(GL_VERTEX_ARRAY);
       glEnableClientState(GL_NORMAL_ARRAY);
       glEnableClientState(GL_COLOR_ARRAY);

       glBindTexture(GL_TEXTURE_2D, texture);
       glEnable(GL_TEXTURE_2D);

       glEnable(GL_TEXTURE_GEN_S);
       glEnable(GL_TEXTURE_GEN_T);
       glEnable(GL_TEXTURE_GEN_R);
       glEnable(GL_TEXTURE_GEN_Q);

       glDrawArrays(GL_TRIANGLES, 0, verticesData.length());

       glDisable(GL_TEXTURE_GEN_S);
       glDisable(GL_TEXTURE_GEN_T);
       glDisable(GL_TEXTURE_GEN_R);
       glDisable(GL_TEXTURE_GEN_Q);

       glDisable(GL_TEXTURE_2D);
       glBindTexture(GL_TEXTURE_2D, 0);

       glDisableClientState(GL_COLOR_ARRAY);
       glDisableClientState(GL_NORMAL_ARRAY);
       glDisableClientState(GL_VERTEX_ARRAY);
       glBindBuffer(GL_ARRAY_BUFFER, 0);
       
       
   }

   void setDefaultColor(QVector4D defaultColor){
       this->defaultColor=defaultColor;
       this->defaultColor.setW(0.0);
   }
};
#endif 

