

//spksetfiledialog.h
//(c) 2018 The University of Aizu
//This software is released under the GNU General Public License.


#ifndef SPKSETFILEDIALOG_H
#define SPKSETFILEDIALOG_H

#include <QDialog>
#include <QFile>
#include <QTextStream>
#include <iostream>
#include "SpiceUsr.h"

using namespace std;

namespace Ui {
class SPKSetFileDialog;
}

class SPKSetFileDialog : public QDialog
{
    Q_OBJECT

public:
    explicit SPKSetFileDialog(QWidget *parent = 0);
    ~SPKSetFileDialog();

    void setSPKKenrelAndDataName(QString, QString);
    void setLSKFile(QString);
    void setFKFile(QString);

public slots:
     void createSPKSettingFile_slot();
     void setSPKParam_slot(QString frame, QString targetName, QString SCName);
     void setSPKParam(QString, QString, QString);
     void SPKTextSettingFile_slot();
     void setLSKFile_slot(QString);
     
     void setFKFile_slot(QString);
     void setInputDataFileName_slot(QString);

private slots:
     void on_OKButton_clicked();
     void on_CancelButton_clicked();

private:
    Ui::SPKSetFileDialog *ui;
    SpiceBoolean initSetFile;
    SpiceBoolean overWrite;
    const QString plainINPUT_DATA_TYPE="INPUT_DATA_TYPE   = 'STATES'";
    const QString plainOUTPUT_SPK_TYPE="OUTPUT_SPK_TYPE   = 9";
    const QString plainOBJECT_ID="OBJECT_ID         = ";
    const QString plainOBJECT_NAME="OBJECT_NAME       = ";
    const QString plainCENTER_ID="CENTER_ID         = ";
    const QString plainCENTER_NAME="CENTER_NAME       = ";
    const QString plainFRAME_DEF_FILE="FRAME_DEF_FILE    = ";
    const QString plainREF_FRAME_NAME="REF_FRAME_NAME    = ";
    const QString plainPRODUCER_ID="PRODUCER_ID       = 'HARMONICS2'";
    const QString plainDATA_ORDER="DATA_ORDER        = 'EPOCH X Y Z VX VY VZ'";
    const QString plainINPUT_DATA_UNITS="INPUT_DATA_UNITS  = ('ANGLES=DEGREES' 'DISTANCES=km')";
    const QString plainDATA_DELIMITER="DATA_DELIMITER    = ' '";
    const QString plainLINES_PER_RECORD="LINES_PER_RECORD  = 1";
    const QString plainLEAPSECONDS_FILE="LEAPSECONDS_FILE  = ";
    const QString plainIGNORE_FIRST_LINE="IGNORE_FIRST_LINE = 0";
    const QString plainPOLYNOM_DEGREE="POLYNOM_DEGREE    = 2";
    const QString plainSEGMENT_ID="SEGMENT_ID	     = 'SPK_STATES_09'";
    const QString plainINPUT_DATA_FILE="INPUT_DATA_FILE   = ";
    const QString plainOUTPUT_SPK_FILE="OUTPUT_SPK_FILE   = ";

    QString BEGINDATA;
    QString INPUT_DATA_TYPE;
    QString OUTPUT_SPK_TYPE;
    QString OBJECT_ID;
    QString OBJECT_NAME;
    QString CENTER_ID;
    QString CENTER_NAME;
    QString FRAME_DEF_FILE;
    QString REF_FRAME_NAME;
    QString PRODUCER_ID;
    QString DATA_ORDER;
    QString INPUT_DATA_UNITS;
    QString DATA_DELIMITER;
    QString LINES_PER_RECORD;
    QString LEAPSECONDS_FILE;
    QString IGNORE_FIRST_LINE;
    QString POLYNOM_DEGREE;
    QString SEGMENT_ID;
    QString INPUT_DATA_FILE;
    QString OUTPUT_SPK_FILE;
    QString targetName, frame, SCName;
    QString inputDataFileName, outputSPKFileName;
    SpiceInt SCId, targetId;
    QString lskFile, fkFile;
    QString preData;

};

#endif 
