

//drawimagewidget.h
//(c) 2018 The University of Aizu
//This software is released under the GNU General Public License.


#ifndef DRAWIMAGEWIDGET_H
#define DRAWIMAGEWIDGET_H

#include <QGLWidget>
#include <QFileInfo>
#include <cmath>
#include <CCfits/CCfits>
#include <fitsio.h>
#include <iostream>
#include <GLUT/glut.h>

using namespace std;
using namespace CCfits;

const int imageWidth = 1024;
const int imageHeight = 1024;

class DrawImageWidget : public QGLWidget
{
    Q_OBJECT
public:
    explicit DrawImageWidget(QWidget *parent = 0);
    ~DrawImageWidget();
    virtual void initializeGL();

    virtual void paintGL();

signals:
    void loadcontorImage_signal(QImage, QString);
    void isOpenedImageFile_signal(GLboolean);
public slots:
    void openImage_slot(QString);
    void sendReadImageData();

private:
    QImage loadImage, img;
    QString filetype;
    
    GLuint bits[imageWidth][imageHeight];
    QByteArray byteArray;
    GLuint w=imageWidth, h=imageHeight;
    GLshort ax1, ax2;
    GLboolean readImageSuccesse;
};

#endif 
