

//kernelmainwindow.cpp
//(c) 2018 The University of Aizu
//This software is released under the GNU General Public License.


#include "kernelmainwindow.h"
#include "ui_kernelmainwindow.h"


QMap<QString, SpiceBoolean> KernelMainWindow::kernelMap;

KernelMainWindow::KernelMainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::KernelMainWindow)
{
    ui->setupUi(this);
    ui->kerneltableWidget->setEditTriggers(QAbstractItemView::NoEditTriggers);
    ui->kerneltableWidget->setSelectionMode(QAbstractItemView::NoSelection);
    ui->kerneltableWidget->setColumnWidth(0, 320);
    ui->kerneltableWidget->setColumnWidth(1, 50);
    ui->kerneltableWidget->setColumnWidth(2, 40);
    checkBoxMapper=new QSignalMapper(ui->kerneltableWidget);
}

KernelMainWindow::~KernelMainWindow()
{
    delete ui;
}

void KernelMainWindow::setKernelList_slot(QStringList kernellist){
    
    SpiceChar arch_name[32], filetype[32];
    QString type;
    

    int n=loadedKernelList.size();
    ui->kerneltableWidget->setRowCount(kernellist.size()+loadedKernelList.size());
    for(int i=0; i<kernellist.length(); i++){
        loadedKernelList.append(kernellist.at(i));
        getfat_c(kernellist.at(i).toStdString().c_str(), 32, 32, arch_name, filetype);

        QStringList filenamelist=kernellist.at(i).split("/");

        QString ommisionName="..."+filenamelist.at(filenamelist.length()-2)+"/"+filenamelist.at(filenamelist.length()-1);
        item[0]=new QTableWidgetItem(ommisionName);
        item[1]=new QTableWidgetItem(filetype);
        QCheckBox *loadCheckBox=new QCheckBox();
        loadCheckBox->setChecked(true);
        
        
        ui->kerneltableWidget->setItem(n+i, 0, item[0]);
        ui->kerneltableWidget->setItem(n+i, 1, item[1]);
        ui->kerneltableWidget->setCellWidget(n+i, 2, loadCheckBox);

        

        connect(loadCheckBox, SIGNAL(toggled(bool)), checkBoxMapper, SLOT(map()));
        checkBoxMapper->setMapping(loadCheckBox, i);

        type=QString(filetype);
        
        if(type=="IK"){
            
        }

        if(type=="FK"){
            emit setFKFile_signal(kernellist.at(i));
        }

        if(type=="LSK"){
            emit setLSKFile_signal(kernellist.at(i));
        }

        if(type=="SCLK"){
            emit setSCLKFile_signal(kernellist.at(i));
        }

    }
    
    

    connect(checkBoxMapper, SIGNAL(mapped(int)), this, SLOT(kernelLoad(int)));
}






void KernelMainWindow::kernelLoad(int i){
    
    QCheckBox *checkBox=static_cast<QCheckBox *>(ui->kerneltableWidget->cellWidget(i, 2));

    if(checkBox->checkState()==Qt::Checked){
        
         furnsh_c(loadedKernelList[i].toStdString().c_str());
         
    }
    else{
        
       unload_c(loadedKernelList[i].toStdString().c_str());
       
    }
}

void KernelMainWindow::on_CloseButton_clicked()
{

    

    
    

    
        
        
    

    
    close();
}


void KernelMainWindow::on_action_Breif_triggered()
{

}

void KernelMainWindow::on_actionDelete_Kernel_triggered()
{

}
