

//mainwindow.cpp
//(c) 2018 The University of Aizu
//This software is released under the GNU General Public License.


#include "datasetManager.h"


////////////////////////////////////////
// class DataSet

/**
 * @brief DataSet::DataSet
 */
DataSet::DataSet()
{
    reset();
}

/**
 * @brief DataSet::~DataSet
 */
DataSet::~DataSet()
{
    reset();
}

/**
 * @brief DataSet::reset
 */
void DataSet::reset()
{
    mProjectName.clear();
    mFolderName.clear();

    mDataStartTime.clear();
    mDataEndTime.clear();
    mUserStartTime.clear();
    mUserTime.clear();

    QList<InstrumentData*>::iterator it = mInstrumentList.begin();
    while ( it != mInstrumentList.end() )
    {
        delete (*it);
        it++;
    }
    QList<TargetData*>::iterator itt = mTargetList.begin();
    while ( itt != mTargetList.end() )
    {
        delete (*itt);
        itt++;
    }
    mInstrumentList.clear();
    mTargetList.clear();
    mRcFileList.clear();
}


////////////////////////////////////////
// class XmlParser

/**
 * @brief XmlParser::XmlParser
 */
XmlParser::XmlParser()
{
}

/**
 * @brief XmlParser::parse
 * @param device
 * @param pMan
 * @return
 */
bool XmlParser::parse(QIODevice* device, DataSetManager* pMan)
{
    QDomDocument doc;
    QString errorStr;
    int errorLine;
    int errorColumn;

    if (!doc.setContent(device, true, &errorStr, &errorLine, &errorColumn))
    {
        QMessageBox::warning(0, QObject::tr("DOM Parser"),
                                QObject::tr("Parse error at line %1, column %2:\n%3")
                                         .arg(errorLine)
                                         .arg(errorColumn)
                                         .arg(errorStr));
        return false;
    }

    QDomElement root = doc.documentElement();

    if (root.tagName() != "harmonics")
    {
        return false;
    }

    QDomNode node = root.firstChild();
    while (!node.isNull())
    {
        if (node.toElement().tagName() == "dataset")
        {
            DataSet* pData = new DataSet();
            pMan->addDataSetList(pData);

            parsePropertyTag(node.toElement(), pData);
        }
        node = node.nextSibling();
    }

    return true;
}

/**
 * @brief XmlParser::parsePropertyTag
 * @param element
 * @param pData
 * @return
 */
bool XmlParser::parsePropertyTag(const QDomElement& element, DataSet* dataSet)
{
    QString projectName = element.attribute("project");
    QString rootPath = element.attribute("datafolder");
    QString frameName = element.attribute("frame");

    // data set
    dataSet->setProjectName(projectName);
    dataSet->setFolderName(rootPath);
    dataSet->setFrameName(frameName);

    // file list
    QDomNode node = element.firstChild();
    while (!node.isNull())
    {
        QString strTag = node.toElement().tagName();
        if (strTag == "instrument")
        {
            QString frame, label, id, type;
            QDomNode instNode = node.firstChild();
            while (!instNode.isNull())
            {
                QString strTag = instNode.toElement().tagName();
                if (    strTag == "frame"
                    ||  strTag == "label"
                    ||  strTag == "id"
                    ||  strTag == "type"
                   )
                {
                    QDomNode childNode = instNode.firstChild();
                    while (!childNode.isNull())
                    {
                        if (childNode.nodeType() == QDomNode::TextNode)
                        {
                            QString strElement = childNode.toText().data();
                            if (instNode.toElement().tagName() == "frame")
                            {
                                frame = childNode.toText().data();
                            }
                            else if (instNode.toElement().tagName() == "label")
                            {
                                label = childNode.toText().data();
                            }
                            else if (instNode.toElement().tagName() == "id")
                            {
                                id = childNode.toText().data();
                            }
                            else if (instNode.toElement().tagName() == "type")
                            {
                                type = childNode.toText().data();
                            }
                        }
                        childNode = childNode.nextSibling();
                    }
                }
                instNode = instNode.nextSibling();
            }
            InstrumentData* pInstData = new InstrumentData();
            pInstData->mFrameName = frame;
            pInstData->mLabel = label;
            pInstData->mID = id;
            pInstData->mType = type;
            dataSet->addInstrumentList(pInstData);
        }
        else if (strTag == "target")
        {
            QString name, mtl, obj;
            QDomNode tgtNode = node.firstChild();
            while (!tgtNode.isNull())
            {
                QString strTag = tgtNode.toElement().tagName();
                if (    strTag == "name"
                    ||  strTag == "mtl"
                    ||  strTag == "obj"
                   )
                {
                    QDomNode childNode = tgtNode.firstChild();
                    while (!childNode.isNull())
                    {
                        if (childNode.nodeType() == QDomNode::TextNode)
                        {
                            QString strElement = childNode.toText().data();
                            if (tgtNode.toElement().tagName() == "name")
                            {
                                name = childNode.toText().data();
                            }
                            else if (tgtNode.toElement().tagName() == "mtl")
                            {
                                mtl = childNode.toText().data();
                            }
                            else if (tgtNode.toElement().tagName() == "obj")
                            {
                                obj = childNode.toText().data();
                            }
                        }
                        childNode = childNode.nextSibling();
                    }
                }
                tgtNode = tgtNode.nextSibling();
            }
            TargetData* pTragetData = new TargetData();
            pTragetData->mName = name;
            pTragetData->mMtlName= mtl;
            pTragetData->mObjName= obj;
            dataSet->addTargetList(pTragetData);
        }
        else if (    strTag == "file"
            ||  strTag == "start_time"
            ||  strTag == "end_time"
            ||  strTag == "set_start_time"
            ||  strTag == "set_end_time"
           )
        {
            QDomNode childNode = node.firstChild();
            while (!childNode.isNull())
            {
                QDomNode::NodeType nType = childNode.nodeType();
                if (nType == QDomNode::TextNode)
                {
                    QString strElement = childNode.toText().data();
                    if (node.toElement().tagName() == "file")
                    {
                        dataSet->addRcFileList(strElement);
                    }
                    else if (node.toElement().tagName() == "start_time")
                    {
                        dataSet->setDataStartTime(strElement);
                    }
                    else if (node.toElement().tagName() == "end_time")
                    {
                        dataSet->setDataEndTime(strElement);
                    }
                    else if (node.toElement().tagName() == "set_start_time")
                    {
                        dataSet->setUserStartTime(strElement);
                    }
                    else if (node.toElement().tagName() == "set_end_time")
                    {
                        dataSet->setUserEndTime(strElement);
                    }
                    break;
                }
                childNode = childNode.nextSibling();
            }
        }
        node = node.nextSibling();
    }

    return true;
}


////////////////////////////////////////
// class DataSetManager

/**
 * @brief DataSetManager::DataSetManager
 */
DataSetManager::DataSetManager()
{

}

/**
 * @brief DataSetManager::~DataSetManager
 */
DataSetManager::~DataSetManager()
{
    Clear();
}

/**
 * @brief DataSetManager::getResoruceFileAbsPath
 * @param folderName
 * @param fileName
 * @return resource file full path
 */
QString DataSetManager::getResoruceFileAbsPath(QString folderName, QString fileName)
{
    QString strDelimita = QDir::separator();
    return mDataRootPath + strDelimita + folderName + strDelimita + fileName;
}


