

//drawSpacecraftModel.cpp
//(c) 2018 The University of Aizu
//This software is released under the GNU General Public License.


#include "drawSpacecraftModel.h"
#include <iostream>

using namespace std;

DrawSpacecraftModel::DrawSpacecraftModel(QWidget *parent) :
    QGLWidget(parent)
{
}

DrawSpacecraftModel::~DrawSpacecraftModel(){
    vertices.clear();
    colorVector.clear();
    normalVector.clear();
}

void DrawSpacecraftModel::setSCMTLFile(QString MTLFileName){
    SC3DModel.MTLFileName=MTLFileName;
    if(SC3DModel.modelFileName.isEmpty()){
        return ;
    }
    QStringList list=SC3DModel.MTLFileName.split("/");
    QStringList list2=list.at(list.length()-1).split(".");
    QStringList list3=SC3DModel.modelFileName.split("/");
    QStringList list4=list3.at(list3.length()-1).split(".");

    if(list2.at(0)==list4.at(0)){
        readSC3DModel();
        SC3DModel.createVBO();
    }
}

void DrawSpacecraftModel::setSCModelFile(QString modelFileName){
    SC3DModel.modelFileName=modelFileName;
    QFileInfo fileinfo;
    fileinfo.setFile(modelFileName);
    QString ext=fileinfo.suffix();
    SC3DModel.modelFileType=ext.toUpper();
    if(SC3DModel.MTLFileName.isEmpty()){
        return ;
    }
    QStringList list=SC3DModel.MTLFileName.split("/");
    QStringList list2=list.at(list.length()-1).split(".");
    QStringList list3=SC3DModel.modelFileName.split("/");
    QStringList list4=list3.at(list3.length()-1).split(".");

    if(list2.at(0)==list4.at(0)){
        readSC3DModel();
        SC3DModel.createVBO();
    }
}

void DrawSpacecraftModel::readSC3DModel(){
    QTextCodec* codec=QTextCodec::codecForName("ShiftJIS");

    QVector<Material> materials;
    QString str;
    QStringList list;
    Material mtl;
    QString firstMTL="";
    if(!SC3DModel.MTLFileName.isEmpty()){

        QFile MTLFile(SC3DModel.MTLFileName);
        if(!MTLFile.open(QIODevice::ReadOnly)){
            cout<<"can not read mtl file"<<endl;
            exit(2);
        }
        while(!MTLFile.atEnd()){
            str=codec->toUnicode(MTLFile.readLine());
            

            str=str.trimmed();
            str=str.simplified();
            if(str.contains("# ")){
                continue;
            }
            else if(str.contains("newmtl")){
                if(!firstMTL.isEmpty()){
                    SC3DModel.materials.append(mtl);
                }
                list=str.split(" ");
                firstMTL=list.at(1);
                mtl=Material(list.at(1));
            }
            else if(str.contains("Ka ")){
                list=str.split(" ");
                mtl.setKa(QVector4D(list.at(1).toFloat(), list.at(2).toFloat(), list.at(3).toFloat(), 1.0));
            }
            else if(str.contains("Kd ")){
                list=str.split(" ");
                mtl.setKd(QVector4D(list.at(1).toFloat(), list.at(2).toFloat(), list.at(3).toFloat(), 1.0));
            }
            else if(str.contains("Ks ")){
                list=str.split(" ");
                mtl.setKs(QVector4D(list.at(1).toFloat(), list.at(2).toFloat(), list.at(3).toFloat(), 1.0));
            }
        }
        SC3DModel.materials.append(mtl);
        MTLFile.close();
    }

    QFile modelFile(SC3DModel.modelFileName);
    if(!modelFile.open(QIODevice::ReadOnly)){
        cout<<"can not read model file"<<endl;
        exit(2);
    }

    QVector4D colorface;
    QStringList faceList1, faceList2, faceList3;

    if(SC3DModel.modelFileType=="OBJ"){
        while(!modelFile.atEnd()){
            str=codec->toUnicode(modelFile.readLine());

            str=str.trimmed();
            str=str.simplified();

            list=str.split(" ");
            if(str.contains(".mtl")||str.contains(".MTL")){
                SC3DModel.isOBJColored=GL_TRUE;
            }
            if(str.contains("# ")){
                continue;
            }
            else if(str.contains("usemtl ")){

                for(int i=0; i<SC3DModel.materials.length(); i++){
                    if(list.at(1)==SC3DModel.materials.at(i).getMTL()){
                        colorface=SC3DModel.materials.at(i).getKd();
                        break;
                    }
                }
            }
            else if(str.contains("v ")){
                vertices.append(QVector4D(list.at(1).toFloat(), list.at(2).toFloat(), list.at(3).toFloat(), 1.0));
                if(list.length()==7){
                    SC3DModel.isOBJColored=GL_TRUE;
                    colorVector.append(QVector4D(list.at(4).toFloat(), list.at(5).toFloat(), list.at(6).toFloat(), 1.0));
                }
                else{
                    colorVector.append(QVector4D(1.0, 1.0, 1.0, 1.0));
                }
            }
            else if(str.contains("vn ")){
                normalVector.append(QVector3D(list.at(1).toFloat(), list.at(2).toFloat(), list.at(3).toFloat()));
                normalVector[normalVector.length()-1].normalize();
            }
            else if(str.contains("f ")){
                faceList1=list.at(1).split("/");
                faceList2=list.at(2).split("/");
                faceList3=list.at(3).split("/");

                SC3DModel.verticesData.append(vertices.at(faceList1.at(0).toUInt()-1));
                SC3DModel.normalData.append(normalVector.at(faceList1.at(0).toUInt()-1));
                if(SC3DModel.isOBJColored==GL_TRUE){
                    if(colorface.isNull()){
                        SC3DModel.colorData.append(colorVector.at(faceList1.at(0).toUInt()-1));
                    }
                    else{
                        SC3DModel.colorData.append(colorface);
                    }
                }
                else{
                    SC3DModel.colorData.append(QVector4D(1.0, 1.0, 1.0, 1.0));
                }
                SC3DModel.indexVector.append(SC3DModel.verticesData.length()-1);

                SC3DModel.verticesData.append(vertices.at(faceList2.at(0).toUInt()-1));
                SC3DModel.normalData.append(normalVector.at(faceList2.at(0).toUInt()-1));
                if(SC3DModel.isOBJColored==GL_TRUE){
                    if(colorface.isNull()){
                        SC3DModel.colorData.append(colorVector.at(faceList2.at(0).toUInt()-1));
                    }
                    else{
                        SC3DModel.colorData.append(colorface);
                    }
                }
                else{
                    SC3DModel.colorData.append(QVector4D(1.0, 1.0, 1.0, 1.0));
                }
                SC3DModel.indexVector.append(SC3DModel.verticesData.length()-1);

                SC3DModel.verticesData.append(vertices.at(faceList3.at(0).toUInt()-1));
                SC3DModel.normalData.append(normalVector.at(faceList3.at(0).toUInt()-1));
                if(SC3DModel.isOBJColored==GL_TRUE){
                    if(colorface.isNull()){
                        SC3DModel.colorData.append(colorVector.at(faceList3.at(0).toUInt()-1));
                    }
                    else{
                        SC3DModel.colorData.append(colorface);
                    }
                }
                else{
                    SC3DModel.colorData.append(QVector4D(1.0, 1.0, 1.0, 1.0));
                }
                SC3DModel.indexVector.append(SC3DModel.verticesData.length()-1);
            }
        }
    }

    else if(SC3DModel.modelFileType=="STL"){
        while(!modelFile.atEnd()){
            str=codec->toUnicode(modelFile.readLine());

            str=str.trimmed();
            str=str.simplified();

            list=str.split(" ");

            if(list.contains("solid ")){
                qDebug()<<"STL is Test File";
            }
            if(str.contains("# ")){
                continue;
            }
            else if(str.contains("vertex ")){
                SC3DModel.verticesData.append(QVector4D(list.at(1).toFloat(), list.at(2).toFloat(), list.at(3).toFloat(), 1.0));
                SC3DModel.colorData.append(QVector4D(0.5, 0.5, 0.5, 1.0));
            }
            else if(str.contains("facet normal ")){
                SC3DModel.normalData.append(QVector3D(list.at(1).toFloat(), list.at(2).toFloat(), list.at(3).toFloat()));
                SC3DModel.normalData[SC3DModel.normalData.length()-1].normalize();
            }
        }
    }
    modelFile.close();
    
     vertices.clear();
     normalVector.clear();
     colorVector.clear();
}

void DrawSpacecraftModel::draw3DSCModel()
{
    SC3DModel.draw3DModel();
}

void DrawSpacecraftModel::drawName(){
    glPushMatrix();
    glDisable(GL_LIGHTING);
    glRasterPos3d(-0.45, -1.7, 0.5);
    glColor3d(1.0, 1.0, 1.0);
    string str="-130 HAYABUSA";
    int size = (int)str.size();
    for(int i = 0; i < size; ++i){
        char ic = str[i];
        glutBitmapCharacter(GLUT_BITMAP_HELVETICA_18, ic);
    }
    glEnable(GL_LIGHTING);
    glPopMatrix();
}

