

//databasedrawgl.cpp
//(c) 2018 The University of Aizu
//This software is released under the GNU General Public License.


#include "databasedrawgl.h"
#include <QDebug>

DatabaseDrawGL::DatabaseDrawGL(QWidget *parent) : QGLWidget(parent), target(NULL)
{
    rotate[0] = rotate[1] = rotate[2] = 0.0;
    translate[0] = translate[1] = translate[2] = 0.0;
    selectedPolygon.clear();
}

DatabaseDrawGL::~DatabaseDrawGL(){

}

void DatabaseDrawGL::initializeGL(){
    qglClearColor(Qt::black);  
    glClearDepth(1.f);
    glShadeModel(GL_SMOOTH);
    glEnable(GL_RESCALE_NORMAL);
    glColorMaterial(GL_FRONT, GL_AMBIENT_AND_DIFFUSE);
    glEnable(GL_COLOR_MATERIAL);
    glHint(GL_POLYGON_SMOOTH_HINT, GL_FASTEST);
    glHint(GL_POINT_SMOOTH_HINT, GL_FASTEST);
    glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_FASTEST);
    glEnable(GL_CULL_FACE);
    glFrontFace(GL_CCW);
    glCullFace(GL_BACK);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE);


    glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);

    glEnable(GL_LIGHTING);
    glEnable(GL_LIGHT0);
}

void DatabaseDrawGL::resizeGL(int w, int h){
    glViewport(0, 0, w, h);

    glMatrixMode (GL_PROJECTION);
    glLoadIdentity();
    gluPerspective(30.0, (double)w / (double)h, 0.1, 100.0);
    glMatrixMode(GL_MODELVIEW);
    
    gluLookAt(0.0, 0.0, translate[2] + 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
}

void DatabaseDrawGL::paintGL(){
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    
    glLoadIdentity();
    gluLookAt(0.0, 0.0, translate[2] + 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);

    glEnable(GL_DEPTH_TEST);

    glRotated(rotate[0], 1.0, 0.0, 0.0);
    glRotated(rotate[1], 0.0, 1.0, 0.0);

    drawTarget(GL_MODELVIEW);
    glDisable(GL_DEPTH_TEST);

    glutSwapBuffers();
}

void DatabaseDrawGL::sendTargetModel_slot(DrawTargetModel *targetModel){
    target = targetModel;

    setTargetDefaultColor();

    drawTarget(GL_MODELVIEW);

    updateGL();
}

void DatabaseDrawGL::drawTarget(GLenum mode){

    QVector<int> tmp;
    int count = 0;
    if(target != NULL){
        for(int i = 0; i < target->target3DModel.verticesData.length(); i+=3){
            glLoadName(i/3);

            glBegin(GL_TRIANGLES);

            glColor3f(targetColor.at(i/3).x(), targetColor.at(i/3).y(), targetColor.at(i/3).z());

            glNormal3f(target->target3DModel.normalData.at(i).x(), target->target3DModel.normalData.at(i).y(), target->target3DModel.normalData.at(i).z());
            glVertex3f(target->target3DModel.verticesData.at(i).x(), target->target3DModel.verticesData.at(i).y(), target->target3DModel.verticesData.at(i).z());

            glNormal3f(target->target3DModel.normalData.at(i+1).x(), target->target3DModel.normalData.at(i+1).y(), target->target3DModel.normalData.at(i+1).z());
            glVertex3f(target->target3DModel.verticesData.at(i+1).x(), target->target3DModel.verticesData.at(i+1).y(), target->target3DModel.verticesData.at(i+1).z());

            glNormal3f(target->target3DModel.normalData.at(i+2).x(), target->target3DModel.normalData.at(i+2).y(), target->target3DModel.normalData.at(i+2).z());
            glVertex3f(target->target3DModel.verticesData.at(i+2).x(), target->target3DModel.verticesData.at(i+2).y(), target->target3DModel.verticesData.at(i+2).z());

            glEnd();
        }
    }
}


void DatabaseDrawGL::mousePressEvent(QMouseEvent *event){
    lastPos=event->pos();

    float x = event->pos().x();
    float y = event->pos().y();

    if(isSearchRegion)
        mousePicking(x, y, 1.0, 1.0);
}

void DatabaseDrawGL::mouseMoveEvent(QMouseEvent *event){

    GLint x = event->pos().x();
    GLint y = event->pos().y();

    GLfloat lastx = GLfloat(event->x()-lastPos.x());
    GLfloat lasty = GLfloat(event->y()-lastPos.y());

    GLfloat dx=GLfloat(event->x()-lastPos.x())/width();
    GLfloat dy=GLfloat(event->y()-lastPos.y())/height();

    lastPos=event->pos();

    if(!isSearchRegion){
        rotate[0] += 180*dy;
        rotate[1] += 180*dx;
    }

    else if(isSearchRegion){
        
        mousePicking(x, y, 1.0, 1.0);
    }

    updateGL();
}

void DatabaseDrawGL::mousePicking(GLfloat x, GLfloat y, GLfloat w, GLfloat h){
    

    GLint viewport[4];
    glGetIntegerv(GL_VIEWPORT, viewport);

    memset(selectBuf, 0, sizeof(selectBuf));

    glSelectBuffer(BUFSIZE, selectBuf);

    glRenderMode(GL_SELECT);
    glInitNames();
    glPushName(-1);

    glMatrixMode(GL_PROJECTION);
    glPushMatrix();
    glLoadIdentity();

    
    viewport[2] = 420;
    viewport[3] = 420;

    gluPickMatrix(x, height()-y, 1.0, 1.0, viewport);

    gluPerspective( 30.0,(float)viewport[2]/(float)viewport[3] , 0.1, 100.0 );

    glMatrixMode( GL_MODELVIEW );

    
    drawTarget(GL_SELECT);


    glMatrixMode(GL_PROJECTION);
    glPopMatrix();
    glMatrixMode( GL_MODELVIEW );


    GLint hits;
    hits = glRenderMode(GL_RENDER);

    selectHits(hits, selectBuf);

    updateGL();
}

void DatabaseDrawGL::selectHits(int hits, GLuint *buf){

    
    if(hits<=0){
        previousSelectedPolygon = selectedPolygon;
        selectedPolygon.clear();
        selectedPolygon.append(0);
    }


    else{
        int name = buf[3];
        int depth = buf[1];

        for(int loop = 1; loop < hits;loop++)
        {
            if(buf[loop*4+1] < GLuint(depth)) 
            {
                name = buf[loop*4+3];
                depth = buf[loop*4+1];

            }

        }

        

        selectedPolygon.append(name);
        targetColor.replace(name-1, QVector3D(0.0, 0.0, 1.0));
    }

    searchImageFromPolygon(selectedPolygon);
}

void DatabaseDrawGL::searchImageFromPolygon(QVector<int> polygons){
    QMap<int, QString> map = getPLAndImageMap_signal();

    if (map.size() == 0)
    {
        qDebug("D : map.size() == 0 / DatabaseDrawGL::searchImageFromPolygon();");
        return;
    }

    QStringList tmpImages;
    QStringList images;

    images.clear();
    if(polygons.at(0) == 0){

        images.append("none");
        sendResultSearchImage_signal(images);
    }

    for(int i = 0; i < polygons.length(); i++){

        
        QString str = map[polygons.at(i)];
        if(str != "NULL"){
            
            tmpImages = str.split(",");

            
            for(int j = 0; j < tmpImages.length(); j++){
                if(!images.contains(tmpImages.at(j)) && tmpImages.at(j) != "")

                    images.append(tmpImages.at(j));
            }
        }
    }

    emit sendResultSearchImage_signal(images);
}

void DatabaseDrawGL::wheelEvent(QWheelEvent *event){
    if(!isSearchRegion)
        translate[2]+=(double)event->delta()/120;

    updateGL();
}

void DatabaseDrawGL::setSearchRegionMode_slot(bool state){
    isSearchRegion = state;
}

void DatabaseDrawGL::sendObservedAreas_slot(QStringList polygons){
    for(int i = 0; i < polygons.length(); i++){
        targetColor.replace(polygons.at(i).toInt()-1, QVector3D(1.0, 0.0, 0.0));
    }
}


void DatabaseDrawGL::setTargetDefaultColor(){

    targetColor.clear();

    for(int i = 0; i < target->target3DModel.verticesData.length()/3; i++){
        targetColor.append(QVector3D(target->target3DModel.defaultColor.x(), target->target3DModel.defaultColor.y(), target->target3DModel.defaultColor.z()));
    }
}

void DatabaseDrawGL::resetRegion_slot(){
    setTargetDefaultColor();
    selectedPolygon.clear();
    updateGL();
}
