

//mainwindow.h
//(c) 2018 The University of Aizu
//This software is released under the GNU General Public License.


#ifndef DATASETMANAGER_H
#define DATASETMANAGER_H

#include <QMainWindow>
#include <QApplication>
#include <QWidget>
#include <QtGui>
#include <QFileDialog>
#include <QMessageBox>
#include <iostream>

#include <qxml.h>
#include <qdom.h>
#include <QTreeWidget>
#include "harmonics.h"

using namespace std;

//
// xml dataset
//
static const char gszDataSetFolder[] = "data";
static const char gszDataSetFile[] = "harmonics.xml";
static const int DATASET_FOLDERNEST = 5;

/**
 * @brief The InstrumentData class
 */
class InstrumentData
{
public:
    InstrumentData() { }
    virtual ~InstrumentData()
    {
        qDebug("~instrumenData() = %s", qPrintable(mFrameName));
    }

public:
    QString mFrameName; // instrument name
    QString mLabel;     // label == display name
    QString mID;
    QString mType;

};

/**
 * @brief The TargetData class
 */
class TargetData
{
public:
    TargetData() { }
    virtual ~TargetData()
    {
        qDebug("~TargetData() = %s", qPrintable(mName));
    }

public:
    QString mName;      // display name
    QString mMtlName;   // mtl file name
    QString mObjName;   // obj file name
};

/**
 * @brief The DataSet class
 */
class DataSet
{
private:
    QString         mProjectName;
    QString         mFolderName;
    QString         mFrameName;

    QString         mDataStartTime;
    QString         mDataEndTime;
    QString         mUserStartTime;
    QString         mUserTime;

    QList<InstrumentData*> mInstrumentList;
    QList<TargetData*>  mTargetList;
    QList<QString>  mRcFileList;

public:
    DataSet();
    virtual ~DataSet();

    void    reset();

    void    setProjectName(QString str) { mProjectName = str;   }
    QString getProjectName() const      { return mProjectName;  }

    void    setFolderName(QString str)  { mFolderName = str;    }
    QString getFolderName() const       { return mFolderName;   }

    void    setFrameName(QString str)   { mFrameName = str;     }
    QString getFrameName() const        { return mFrameName;    }

    void    setDataStartTime(QString str)   { mDataStartTime = str; }
    QString getDataStartTime() const        { return mDataStartTime;  }
    void    setDataEndTime(QString str)     { mDataEndTime = str; }
    QString getDataEndTime() const          { return mDataEndTime;  }

    void    setUserStartTime(QString str)   { mUserStartTime = str; }
    QString getUserStartTime() const        { return mUserStartTime;  }
    void    setUserEndTime(QString str)     { mDataEndTime = str; }
    QString getUserEndTime() const          { return mDataEndTime;  }

    const QList<InstrumentData*>* getInstrumentList() const { return &mInstrumentList;  }
    void    addInstrumentList(InstrumentData* p)    { mInstrumentList.append(p);        }
    GLint   getInstrumentListSize()                 { return mInstrumentList.size();    }

    const QList<TargetData*>* getTargetList() const  { return &mTargetList;    }
    void    addTargetList(TargetData* item)         { mTargetList.append(item); }
    GLint   getTargetListSize()                     { return mTargetList.size();}

    const QList<QString>* getRcList() const     { return &mRcFileList;    }
    void    addRcFileList(QString item)         { mRcFileList.append(item); }
    GLint   getRcFileListSize()                 { return mRcFileList.size();}

};

/**
 * @brief The DataSetManager class
 */
class DataSetManager
{
private:
    QList<DataSet*> mDataSetList;
    QString         mDataRootPath;  // absolute path

public:
    DataSetManager();
    virtual ~DataSetManager();

    void Clear()
    {
        QList<DataSet*>::iterator it = mDataSetList.begin();
        while ( it != mDataSetList.end() )
        {
            delete (*it);
            it++;
        }
        mDataSetList.clear();
    }

    const QList<DataSet*>* getDataSetList() const    { return &mDataSetList;    }
    void    addDataSetList(DataSet* pItem)           { mDataSetList.append(pItem); }
    GLint   getDataSetListSize()                     { return mDataSetList.size();}

    DataSet*    findDateSet(QString Name)
    {
        QList<DataSet*>::iterator it = mDataSetList.begin();
        while ( it != mDataSetList.end() )
        {
            if ((*it)->getProjectName() == Name)
            {
                return (*it);
            }
            it++;
        }
        return NULL;
    }

    QString getResoruceFileAbsPath(QString folderName, QString fileName);
    void setResoruceFileAbsPath(QString rootPath)
    {
        mDataRootPath = rootPath;
    }
};

/**
 * @brief : XML Perser (DOM)
 */
class XmlParser
{
public:
    XmlParser();
    virtual ~XmlParser() { }

    bool parse(QIODevice* device, DataSetManager* pMan);
    bool parsePropertyTag(const QDomElement& element, DataSet* dataSet);

};


#endif  // DATASETMANAGER_H


