

//drawTargetModel.h
//(c) 2018 The University of Aizu
//This software is released under the GNU General Public License.


#ifndef DRAWITOKAWA_H
#define DRAWITOKAWA_H

#ifdef __APPLE__
#include <GLUT/glut.h>
#else
#include <GL/glut.h>
#endif
#include <QtOpenGL>
#include <QWidget>
#include <QGLWidget>
#include <cmath>
#include <QVector>
#include <QVector3D>
#include <QVector4D>
#include "model.h"

class boundingShpere{

public:
    QVector3D initialCenter, currentCenter, centerOfGravity;
    QVector3D minVertex, maxVertex;
    QVector4D vec4;
    GLfloat r;
    GLboolean inPolygons;

    boundingShpere(){
        initialCenter.setX(0.0);
        initialCenter.setY(0.0);
        initialCenter.setZ(0.0);
        currentCenter.setX(0.0);
        currentCenter.setY(0.0);
        currentCenter.setZ(0.0);
        r=0.0;
        inPolygons=GL_FALSE;
    }

    ~boundingShpere(){

    }

    void setParam(GLdouble x, GLdouble y, GLdouble z, GLdouble r){
        initialCenter.setX(x);
        initialCenter.setY(y);
        initialCenter.setZ(z);
        this->r=r;
    }

    void setCurrentCenter(GLdouble x, GLdouble y, GLdouble z){
        currentCenter.setX(initialCenter.x()+x);
        currentCenter.setY(initialCenter.y()+y);
        currentCenter.setZ(initialCenter.z()+z);
    }

    QVector4D toVector4D(){
        if(inPolygons==GL_FALSE){
            vec4=QVector4D(initialCenter.x(), initialCenter.y(), initialCenter.z(), -1);
        }
        else{
            vec4=QVector4D(initialCenter.x(), initialCenter.y(), initialCenter.z(), r);
        }

        return vec4;
    }

    void setRadius(GLfloat r){
        this->r=r;
    }

    void setIsInPolygons(GLboolean inPolygons){
        this->inPolygons=inPolygons;
    }
};

class DrawTargetModel : public QGLWidget
{
    Q_OBJECT
public:
    DrawTargetModel(QWidget *parent=0);
    ~DrawTargetModel();
    QHash<QString, Model> target3DModels;
    Model target3DModel;
    GLdouble shapescale;
    QString shapeMode;
    QVector<QVector4D> vertex, vertexIndex;
    
    
    QVector<QVector4D> vertices, colorVector;
    QVector<QVector3D> normalVector;
    QVector<GLfloat> listX, listY, listZ;
    GLboolean isOBJColored=GL_FALSE;
    QVector<GLuint> nodeSphereId;
    QVector<QVector4D> spheresCenter;
    boundingShpere rootSphere;
    QVector<boundingShpere> nodeLevel1Spheres, nodeLevel2Spheres, nodeLevel3Spheres;
    QVector<QVector4D> footprintsColor;
    QVector<QVector4D> polygonColor;
    GLdouble r, minX, maxX, minY, maxY, minZ, maxZ, disX, disY, disZ;
    GLboolean isDrawFootprints, isDrawShadow, isInitializeFootprints;

    void readShapeModel();
    void createBoundingSphere();
    void makeBoundingSphereOct();
    void compSphereMember();
    void setTargetMTLFile(QString);
    void setTargetModelFile(QString);
    void drawTarget3DModel();
    void initTargetPolygonColor(QString);
    void drawName();
    int vertexNumber();
    void visualizePolygon(QStringList);
    void backupPolygonColor();
    void recordShadow();
    void restoreShadowData();
    void overwriteShadowOffData();
    void setTexture(GLuint);
    void bindMapImage(QString);

private:
    QString MTLFileName, modelFileName, modelFileType;
    QVector4D lightPosUnit;
    QVector4D targetColor;
    QVector4D lightColor;

    QVector3D calcCenterOfGravity(QVector3D v0, QVector3D v1, QVector3D v2);
    GLuint sphereMemeber(QVector3D vec);
};

#endif 
