

// harmonics.h
// (c) 2018 The University of Aizu
// This software is released under the GNU General Public License.


#ifndef __HARMONICS_H__
#define __HARMONICS_H__

// common
#define SAFE_DELETE(pPtr)   \
{                           \
    if (pPtr)               \
    {                       \
        delete pPtr;        \
        pPtr = NULL;        \
    }                       \
}

#define Q_STR(QSTRING_STR)  QSTRING_STR.toStdString().c_str()

// definition
#define AMICA_FOV           (5.7)
#define XRS_FOV             (3.5)
#define FINDER_LINELENGTH   (0.05)

// _DEV_FOOTPRINT_
#define FOVLENGTH_SLIDER_FIXED_RATE  (66.5)
const double fov_Hayabusa_rate = 6.65;
const double fov_Hayabusa_distance = 8.0;
#define NUMOF_BOUNDARYVECTORS   (4)
#define NUMOF_PYRAMIDSURFACE    (4)

// default setting
static const bool Default_FOVFixed = true;
static const bool Default_FillTarget = true;



#endif  // __HARMONICS_H__



