# How to install HARMONICS Linux (Ubuntu)  
** Verified version: harmonics 2.1.0 **  
---  

## Verified environment
Windows 10 Home  
VirtualBox version 5.2.12 r122591  

## Verified OS on VirtualBox
Ubuntu16.04-LTS  

## Setup

1. Install Ubuntu on VirtualBox  

2. Install Qt  
	2-1. Download  
	https://www1.qt.io/download-open-source/#section-2  
	Target file: qt-opensource-linux-x64-5.10.1.run  

	2-2. Setup  
	Put qt-opensource-linux-x64-5.10.1.run on $HOME/...  
	e.g.) $HOME/tmp/setup/qt  

	2-3. Install  
	Execute following commands via terminal on VirtualBox  
	`$ cd $HOME/tmp/setup/qt`  
	`$ chmod +x qt-opensource-linux-x64-5.10.1.run`  
	`$ sudo ./qt-opensource-linux-x64-5.10.1.run`  

	2-4. Install Direction  
	/opt/Qt5.10.1  

3. Install required packages  
	`$ sudo apt-get install libglib2.0-dev libSM-dev libxrender-dev   libfontconfig1-dev libxext-dev`  
	`$ sudo apt-get install build-essential`  
	`$ sudo apt-get install libfontconfig1`  
	`$ sudo apt-get install mesa-common-dev`  
	`$ sudo apt-get install libglu1-mesa-dev`  

	If you cannot find installation files, select package-installation.  
	/usr/include/GL/glut.h  
	`$ sudo apt-get install freeglut3-dev`  
	/usr/include/opencv/highgui.h  
	`$ sudo apt-get install libhighgui-dev`  

4. Edit preferences of Qt  
	4-1. Target preferences  
	/usr/lib/x86_64-linux-gnu/qt-default/qtchooser/default.conf  

	4-2. Modified part  
	// Before (Default)  
	/usr/lib/x86_64-linux-gnu/qt4/bin <- This line!  
	/usr/lib/x86_64-linux-gnu  

	// After  
	/opt/Qt5.10.1/5.10.1/gcc_64/bin  
	/usr/lib/x86_64-linux-gnu  

5. Set paths for Qt  
	5-1. Editing of .profile  
	※ Please edit this according to your environment  
	export QT_PATH=/opt/Qt5.10.1  
	export PATH=$PATH:$QT_PATH/5.10.1/gcc_64/bin  
	export LD_LIBRARY_PATH=$QT_PATH/5.10.1/gcc_64/lib  
	export QMLSCENE_DEVICE=softwarecontext  

	5-2. Reboot or activation by "$source .profile"  
	How to confirm paths  
	$ echo $PATH  

6. Check Qt environment  
Please run and check sample programs for OpenGL attached in Qt  


### FOR HARMONICS  

7. Install CSPICE  
	7-1. Download  
	https://naif.jpl.nasa.gov/naif/toolkit_C_PC_Linux_GCC_64bit.html  
	// Target files  
	cspice.tar.Z  
	importCSpice.csh  
	// about installation of CSPICE  
	https://naif.jpl.nasa.  gov/pub/naif/toolkit/C/PC_Linux_GCC_64bit/packages/README  
	Set paths after extraction.  

	7-2. Set up downloaded files to suitable place  
	e.g.）$HOME/tmp/setup/cspice  
	// Run followings  
	`$ /bin/sh -f importCSpice.csh`  
	cspice.tar and cspice directory are set up.  

	7-3. Set paths by editing .profile according to your environment  
	// e.g.  
	`# CSPICE`  
	export CSPICE_PATH=$HOME/tmp/setup/cspice/cspice  
	export PATH=$PATH:$CSPICE_PATH/lib:$CSPICE_PATH/include:$CSPICE_PATH/exe  

8. Install CFITSIO  
	8-1. Download  
	https://heasarc.gsfc.nasa.gov/fitsio/fitsio.html  
	Unix .tar file cfitsio3450.tar.gz  
	// Target file  
	cfitsio3450.tar.gz  
	// Set up  
	$HOME/setup/cfitsio  
	// Extraction  
	`$ tar xvf cfitsio3450.tar.gz`  

	8-2. Install log  
	Install cfitsio according to your environment.  
	`$ cd cfitsio/`  
	`$ ./configure --prefix=/usr/local`  
	`$ make`  
	`$ sudo make install`  
	// sudo make install  
	/bin/cp -a libcfitsio.a /usr/local/lib  
	/bin/cp fitsio.h fitsio2.h longnam.h drvrsmem.h /usr/local/include  
	/bin/cp cfitsio.pc /usr/local/lib/pkgconfig  

9. Install CCFITS  
	9-1. Download  
	https://heasarc.gsfc.nasa.gov/docs/software/fitsio/ccfits/  
	CCfits source code, documentation and the html manual for local   
	From the installation link  
	// Target file  
	cfitsio3450.tar.gz  
	// Set up  
	$HOME/setup/ccfits  
	// Extraction  
	tar xvf CCfits-2.5.tar.gz  

	9-2. Install log  
	Install CCfits according to your environment.  
	`$ cd CCfits/`  
	`$ ./configure --with-cfitsio=/usr/local`  
	`$ make`  
	`$ sudo make install`  

10. Run HARMONICS  
Set up harmonics  
Open HARMONICS2_linux.pro  
Build it and confirm execution  

---

## References URL  
// How to install Qt (JPN)  
https://download.qt.io/archive/qt/5.10/5.10.1/  
http://kconcon3.hatenablog.com/entry/2017/12/01/190933  

// How to install CFITSIO (JPN)  
http://hamalabo.sakura.ne.jp/SPIRAL/spiraf_vine/node18.html  



