

//createckdialog.cpp
//(c) 2018 The University of Aizu
//This software is released under the GNU General Public License.


#include "createckdialog.h"
#include "ui_createckdialog.h"

createCKDialog::createCKDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::createCKDialog)
{
    ui->setupUi(this);
}

createCKDialog::~createCKDialog()
{
    delete ui;
}

void createCKDialog::saveData_slot(){

}

void createCKDialog::sendCKData_slot(SpiceDouble et, SpiceDouble roll, SpiceDouble pitch, SpiceDouble yaw){
    QString spkUTC;
    SpiceChar time[LENOUT];
    
    timout_c(et, timeFormat, LENOUT, time);
    char chr[] = "日本語";
    QString qStr = QString(chr);

    et2utc_c(et, "ISOC", 0, LENOUT, time);
    QString timeStr=QString(time);

    QString ckData=timeStr+" "+QString(QString::number(roll))+" "+QString(QString::number(pitch))+" "+QString(QString::number(yaw));
    ui->CKtextEdit->append(ckData);
}

void createCKDialog::on_WriteDateButton_clicked(){
    firstLine=false;
    emit getCKData_signal();
}

void createCKDialog::on_saveCKDataButton_clicked(){
    

    CKDataFileName = QFileDialog::getSaveFileName(this,tr("Save CK data file"),".",tr("Text File(*.txt)"));
    if(CKDataFileName.isEmpty()){
        ckDataFileInput=false;
        return ;
    }

    
        
        QFile ckfile(CKDataFileName);
        ckfile.open(QIODevice::WriteOnly);
        QTextStream saveCKStream(&ckfile);
        

        QString str=ui->CKtextEdit->toPlainText();

        QStringList strList=str.split("\n");

        for(int i=0; i<strList.length(); i++){
            
            

            QStringList segment=strList.at(i).split(" ");
            SpiceDouble roll, pitch, yaw;

            SpiceDouble q[4];
            SpiceDouble Rmatrix[3][3];
            roll=segment.at(1).toDouble()*rpd_c();
            pitch=segment.at(2).toDouble()*rpd_c();
            yaw=segment.at(3).toDouble()*rpd_c();
            eul2m_c(roll, pitch, yaw, 3, 2, 1, Rmatrix);
            m2q_c(Rmatrix, q);
            
            QString ckInputSegment=segment.at(0)+" "+QString::number(q[0])+" "+QString::number(q[1])+" "+QString::number(q[2])+" "+QString::number(q[3]);
            
            ckInputSegment=ckInputSegment.trimmed();
            ckInputSegment=ckInputSegment.simplified();
            saveCKStream<<ckInputSegment<<endl;
        }

        saveCKStream.flush();
        ckfile.close();

        emit sendCKDataName_signal(CKDataFileName);
    
}





void createCKDialog::on_clearButton_clicked(){
    firstLine=false;
}
