

//inputandmakespkkernelwindow.cpp
//(c) 2018 The University of Aizu
//This software is released under the GNU General Public License.


#include "inputandmakespkkernelwindow.h"
#include "ui_inputandmakespkkernelwindow.h"

InputAndMakeSPKKernelWindow::InputAndMakeSPKKernelWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::InputAndMakeSPKKernelWindow)
{
    ui->setupUi(this);
    spkSettingFile=new SPKSetFileDialog();

    connect(this, SIGNAL(setInputDataFileName_signal(QString)), spkSettingFile, SLOT(setInputDataFileName_slot(QString)));
    connect(this, SIGNAL(SPKTextSettingFile_signal()), spkSettingFile, SLOT(SPKTextSettingFile_slot()));
    connect(this, SIGNAL(createSPKSettingFile_signal()), spkSettingFile, SLOT(createSPKSettingFile_slot()));

    connect(&MKSPKprocess, SIGNAL(finished(int, QProcess::ExitStatus)), this, SLOT(MKSPKfinished(int, QProcess::ExitStatus)));
    connect(&MKSPKprocess, SIGNAL(error(QProcess::ProcessError)), this, SLOT(MKSPKError(QProcess::ProcessError)));
    connect(&MKSPKprocess, SIGNAL(readyReadStandardOutput()), this, SLOT(MKSPKreadyReadStandardOutput()));
    connect(&MKSPKprocess, SIGNAL(readyReadStandardError()), this, SLOT(MKSPKreadyReadStandardError()));

    connect(&RemoveFileprocess, SIGNAL(finished(int, QProcess::ExitStatus)), this, SLOT(RemoveFilefinished(int, QProcess::ExitStatus)));
    connect(&RemoveFileprocess, SIGNAL(error(QProcess::ProcessError)), this, SLOT(RemoveFileError(QProcess::ProcessError)));
    connect(&RemoveFileprocess, SIGNAL(readyReadStandardOutput()), this, SLOT(RemoveFilereadyReadStandardOutput()));
    connect(&RemoveFileprocess, SIGNAL(readyReadStandardError()), this, SLOT(RemoveFilereadyReadStandardError()));

}

InputAndMakeSPKKernelWindow::~InputAndMakeSPKKernelWindow()
{
    delete ui;
    if(MKSPKprocess.state()==QProcess::Running){
        MKSPKprocess.kill();
        MKSPKprocess.waitForFinished();
    }
    
}

void InputAndMakeSPKKernelWindow::sendSPKData_slot(SpiceDouble et, SpiceDouble x, SpiceDouble y, SpiceDouble z){
    QString spkUTC;
    SpiceChar time[LENOUT];
    
    timout_c(et, timeFormat, LENOUT, time);

    et2utc_c(et, "ISOC", 0, LENOUT, time);
    QString timeStr=QString(time);
    QString spkData;
    

    spkData=timeStr+" "+QString(QString::number(x))+" "+QString(QString::number(y))+" "+QString(QString::number(z));
    QString str=ui->SPKtextEdit->toPlainText();

    dataHash.clear();
    SpiceDouble dataET;
    QStringList strList=str.split("\n");

    for(int i=0; i<strList.length(); i++){
        QString is=strList.at(i).simplified();
        is=is.trimmed();
        if(is.isEmpty()){
            continue;
        }
        QStringList list=is.split(" ");
        QString s=list.at(0);
        cout<<"s:"<<s.toStdString()<<endl;
        utc2et_c(s.toStdString().c_str(), &dataET);

        dataHash.insert(dataET, strList.at(i));
  }
    dataHash.insert(et, spkData);

    QList<SpiceDouble> dataList=dataHash.keys();
    qSort(dataList);

    ui->SPKtextEdit->clear();
    for(int i=0; i<dataList.length(); i++){
        ui->SPKtextEdit->append(dataHash.value(dataList.at(i)));
    }
}

void InputAndMakeSPKKernelWindow::on_WriteDateButton_clicked(){
    firstLine=false;
    emit getSPKData_signal();
}

void InputAndMakeSPKKernelWindow::on_saveSPKDataButton_clicked(){
    
    SPKFileName = QFileDialog::getSaveFileName(this,tr("Save SPK data file"),".",tr("bsp File(*.bsp)"));

    if(SPKFileName.isEmpty()){
        spkDataFileInput=false;
        return ;
    }

    QStringList spkfileName=SPKFileName.split("/");
    QString SPKDataFileName="./"+spkfileName.at(spkfileName.length()-1);
    

    
    SPKDataFileName.replace(SPKDataFileName.length()-3, 3, "txt");

    
    

    cout<<"spk file name:"<<SPKDataFileName.toStdString()<<endl;

    spkSettingFile->setSPKKenrelAndDataName(SPKFileName, SPKDataFileName);
    
    
    

    emit SPKTextSettingFile_signal();
    emit createSPKSettingFile_signal();

    QFile spkfile(SPKDataFileName);
    spkfile.open(QIODevice::WriteOnly);
    QTextStream saveSPKStream(&spkfile);
    
    

    QString str=ui->SPKtextEdit->toPlainText();

    QStringList strList=str.split("\n");

    for(int i=0; i<strList.length(); i++){
        QString is=strList.at(i).simplified();
        is=is.trimmed();
        if(is.isEmpty()){
            continue;
            
        }
        

        
        
        QStringList segment=strList.at(i).split(" ");
        SpiceDouble x, y, z;
        x=-segment.at(1).toDouble();
        y=-segment.at(2).toDouble();
        z=segment.at(3).toDouble();
        SpiceDouble et;
        SpiceChar time[LENOUT];
        
        utc2et_c(segment.at(0).toStdString().c_str(), &et);
        timout_c(et, timeFormat, LENOUT, time);

        QString spkInputSegment=QString(time)+" "+QString::number(x)+" "+QString::number(y)+" "+QString::number(z)+" 0 0 0";

        spkInputSegment=spkInputSegment.trimmed();
        spkInputSegment=spkInputSegment.simplified();
        saveSPKStream<<spkInputSegment<<endl;
    }

    saveSPKStream.flush();
    spkfile.close();

    

    makeSPKCommand=makeSPKComFormat+" "+SPKSettingFileName+" "+SPKDataFileName;
    MKSPKprocess.start(makeSPKCommand);

    
    
    
    
    
    
}

void InputAndMakeSPKKernelWindow::on_actionShow_Setting_File_triggered()
{
    emit SPKTextSettingFile_signal();
    spkSettingFile->show();
}

void InputAndMakeSPKKernelWindow::setSPKParam_slot(QString frame, QString targetName, QString SCName){
    spkSettingFile->setSPKParam(frame, targetName, SCName);
}

void InputAndMakeSPKKernelWindow::setLSKFile_slot(QString lskName){
    spkSettingFile->setLSKFile(lskName);
}

void InputAndMakeSPKKernelWindow::setFKFile_slot(QString fkName){
    spkSettingFile->setFKFile(fkName);
}

void InputAndMakeSPKKernelWindow::on_actionAuto_Record_positions_from_MainWindow_triggered()
{
    emit isAutoRecordSPK_signal(ui->actionAuto_Record_positions_from_MainWindow->isChecked());
}

void InputAndMakeSPKKernelWindow::MKSPKfinished(int exitCode, QProcess::ExitStatus exitStatus)
{   
    qDebug("MKSPK exitCode=%d, exitStatus=%d", exitCode, exitStatus);
}

void InputAndMakeSPKKernelWindow::MKSPKError(QProcess::ProcessError error)
{   
    qDebug("MKSPK error=%d", error);
    isCreateSPKKernel=error;
}

void InputAndMakeSPKKernelWindow::MKSPKreadyReadStandardOutput()
{   
    QByteArray ab = MKSPKprocess.readAllStandardOutput();
    QTextBrowser *textbroser= new QTextBrowser;
    textbroser->setGeometry(150, 100, 620, 450);
    textbroser->setFont(QFont("Times", 15, QFont::Bold));
    textbroser->insertPlainText(ab.data());
    textbroser->show();

    
}

void InputAndMakeSPKKernelWindow::MKSPKreadyReadStandardError()
{   
    QByteArray ab = MKSPKprocess.readAllStandardError();
    
}

void InputAndMakeSPKKernelWindow::RemoveFilefinished(int exitCode, QProcess::ExitStatus exitStatus){
    qDebug("RemoveFile exitCode=%d, exitStatus=%d", exitCode, exitStatus);
    
}

void InputAndMakeSPKKernelWindow::RemoveFileError(QProcess::ProcessError error){
    qDebug("error=%d", error);
}

void InputAndMakeSPKKernelWindow::RemoveFilereadyReadStandardOutput(){

}

void InputAndMakeSPKKernelWindow::RemoveFilereadyReadStandardError(){

}

void InputAndMakeSPKKernelWindow::on_closeButton_clicked()
{
    this->close();
}
