

//computeelements.h
//(c) 2018 The University of Aizu
//This software is released under the GNU General Public License.



#ifndef COMPUTEELEMENTS_H
#define COMPUTEELEMENTS_H

#include <iostream>
#include <math.h>
#include <cmath>
#include <QString>
#include "SpiceUsr.h"


#include <memory.h>

#define STRLEN 100
#define BCVLEN 5
#define SPEEDOFLIGTH 299792458
#define DegToRad (M_PI/180.0)
#define RadToDeg (180.0/M_PI)

#define SC -130
#define SCINST -130102

#define MAXCLK 30

using namespace std;

class computeElements
{
public:
    computeElements();
    SpiceInt instId=-130102;
    SpiceChar clkch[MAXCLK];
    SpiceDouble cmat[3][3];
    SpiceDouble av[3];
    SpiceDouble clkout;
    SpiceDouble sclkdp;
    SpiceDouble toltik;
    SpiceDouble vinert[3];
    SpiceChar startUTC[STRLEN], endUTC[STRLEN];
    SpiceDouble start_et, end_et, et;
    SpiceDouble lt;
    SpiceChar shape[STRLEN];
    SpiceChar cameraframe[STRLEN];
    SpiceDouble bsight_inst[3];
    SpiceDouble up_inst[3];
    SpiceInt n_bcv;
    SpiceDouble bounds[BCVLEN][3];
    SpiceDouble rotate[3][3];
    SpiceBoolean found;
    static const SpiceDouble initRotate[4][4];
    SpiceDouble obRotate[16];
    SpiceDouble bound[4][3];

    void computePos(const QString, const QString, const SpiceDouble, SpiceDouble[], SpiceDouble[], SpiceDouble[], SpiceDouble[]);
    void computeAttitude(const SpiceInt, const QString, const SpiceDouble, SpiceDouble[], SpiceDouble[], SpiceDouble*, SpiceDouble*, SpiceDouble*);
    void computeIllum(const QString, const SpiceInt, const SpiceDouble, const QString, SpiceDouble*, SpiceDouble*, SpiceDouble*, SpiceBoolean*);
    SpiceDouble computeDistance(SpiceDouble[], SpiceDouble[]);
    void computeRotateX(const SpiceDouble, const SpiceDouble[], const SpiceDouble[], const SpiceDouble[], SpiceDouble[], SpiceDouble[], SpiceDouble[]);
    void computeRotateY(const SpiceDouble, const SpiceDouble[], const SpiceDouble[], const SpiceDouble[], SpiceDouble[], SpiceDouble[], SpiceDouble[]);
    void computeRotateZ(const SpiceDouble, const SpiceDouble[], const SpiceDouble[], const SpiceDouble[], SpiceDouble[], SpiceDouble[], SpiceDouble[]);
    void compTargetRotateMatrix(const QString, const QString, const SpiceDouble, SpiceFloat[]);
    void computeBoresightAndUpInstfromInput(const QString, const SpiceInt, const SpiceDouble, const SpiceDouble, const SpiceDouble, SpiceDouble[], SpiceDouble[], SpiceDouble [4][3]);

    void computeMapElements(const QString, const SpiceInt,  SpiceDouble [], SpiceDouble [], SpiceDouble [4][3], SpiceDouble [], SpiceDouble [], SpiceDouble [], SpiceDouble);
};

#endif 
