

//drawTargetModel.cpp
//(c) 2018 The University of Aizu
//This software is released under the GNU General Public License.


#include "drawTargetModel.h"

#include <iostream>
#include <fstream>
#include <sstream>
#include <QFile>
#include <math.h>

using namespace::std;

DrawTargetModel::DrawTargetModel(QWidget *parent) :
    QGLWidget(parent)
{
    setFormat(QGLFormat(QGL::DoubleBuffer|QGL::DepthBuffer));
    shapeMode="LOWMODEL";
    r=0.33;
    targetColor=QVector4D(0.6, 0.6, 0.6, 1.0);
    lightColor=QVector4D(1.0, 1.0, 1.0, 1.0);
    isInitializeFootprints=isDrawFootprints=GL_FALSE;
    minX=minY=minZ=1000;
    maxX=maxY=maxZ=-1000;

    
}

DrawTargetModel::~DrawTargetModel(){
    vertices.clear();
    colorVector.clear();
    normalVector.clear();
}

void DrawTargetModel::setTargetMTLFile(QString MTLFileName){
    this->MTLFileName=MTLFileName;
    target3DModel.MTLFileName=MTLFileName;
    if(target3DModel.modelFileName.isEmpty()){
        return ;
    }
    QStringList list=target3DModel.MTLFileName.split("/");
    QStringList list2=list.at(list.length()-1).split(".");
    QStringList list3=target3DModel.modelFileName.split("/");
    QStringList list4=list3.at(list3.length()-1).split(".");

    if(list2.at(0)==list4.at(0)){
        readShapeModel();
        target3DModel.createVBO();
    }
}

void DrawTargetModel::setTargetModelFile(QString modelFileName){
    this->modelFileName=modelFileName;
    target3DModel.modelFileName=modelFileName;
    QFileInfo fileinfo;
    fileinfo.setFile(modelFileName);
    QString ext=fileinfo.suffix();
    modelFileType=ext.toUpper();
    target3DModel.modelFileType=ext.toUpper();
    if(target3DModel.modelFileName.isEmpty()){
        return ;
    }
    QStringList list=target3DModel.MTLFileName.split("/");
    QStringList list2=list.at(list.length()-1).split(".");
    QStringList list3=target3DModel.modelFileName.split("/");
    QStringList list4=list3.at(list3.length()-1).split(".");

    if(list2.at(0)==list4.at(0)){

        readShapeModel();
        target3DModel.createVBO();
    }
}

void DrawTargetModel::readShapeModel(){
    QTextCodec* codec=QTextCodec::codecForName("ShiftJIS");
    QVector3D centerOfGravity;
    QString str;
    QStringList list;
    Material mtl;
    QString firstMTL="";

    if(!target3DModel.MTLFileName.isEmpty()){
        QFile MTLFile(target3DModel.MTLFileName);
        if(!MTLFile.open(QIODevice::ReadOnly)){
            cout<<"can not read mtl file"<<endl;
            exit(2);
        }
        while(!MTLFile.atEnd()){
            str=codec->toUnicode(MTLFile.readLine());
            str=str.trimmed();
            str=str.simplified();
            if(str.contains("# ")){
                continue;
            }
            else if(str.contains("newmtl ")){
                if(!firstMTL.isEmpty()){
                    target3DModel.materials.append(mtl);
                }
                list=str.split(" ");
                firstMTL=list.at(1);
                mtl=Material(list.at(1));
            }
            else if(str.contains("Ka ")){
                list=str.split(" ");
                mtl.setKa(QVector4D(list.at(1).toFloat(), list.at(2).toFloat(), list.at(3).toFloat(), 1.0));
            }
            else if(str.contains("Kd ")){
                list=str.split(" ");
                mtl.setKd(QVector4D(list.at(1).toFloat(), list.at(2).toFloat(), list.at(3).toFloat(), 0.0));
            }
            else if(str.contains("Ks ")){
                list=str.split(" ");
                mtl.setKs(QVector4D(list.at(1).toFloat(), list.at(2).toFloat(), list.at(3).toFloat(), 1.0));
            }
        }
        target3DModel.materials.append(mtl);

        MTLFile.close();
    }

    QFile ModelFile(target3DModel.modelFileName);

    if(!ModelFile.open(QIODevice::ReadOnly)){
        cout<<"can not read model file"<<endl;
        exit(2);
    }

    QVector4D colorface;
    QStringList faceList1, faceList2, faceList3;

    if(target3DModel.modelFileType=="OBJ"){
        while(!ModelFile.atEnd()){
            str=codec->toUnicode(ModelFile.readLine());
            str=str.trimmed();
            str=str.simplified();

            list=str.split(" ");
            if(str.contains(".mtl")||str.contains(".MTL")){
                target3DModel.isOBJColored=GL_TRUE;
            }
            if(str.contains("# ")){
                continue;
            }
            else if(str.contains("usemtl ")){
                for(int i=0; i<target3DModel.materials.length(); i++){
                    if(list.at(1)==target3DModel.materials.at(i).getMTL()){
                        colorface=target3DModel.materials.at(i).getKd();
                        break;
                    }
                }
            }
            else if(str.contains("v ")){
                vertices.append(QVector4D(list.at(1).toFloat(), list.at(2).toFloat(), list.at(3).toFloat(), 1.0));
                listX.append(list.at(1).toFloat());
                listY.append(list.at(2).toFloat());
                listZ.append(list.at(3).toFloat());

                if(list.length()==7){
                    target3DModel.isOBJColored=GL_TRUE;
                    colorVector.append(QVector4D(list.at(4).toFloat(), list.at(5).toFloat(), list.at(6).toFloat(), 0.0));
                }
                else{
                    colorVector.append(QVector4D(1.0, 1.0, 1.0, 1.0));
                }
            }
            else if(str.contains("vn ")){
                normalVector.append(QVector3D(list.at(1).toFloat(), list.at(2).toFloat(), list.at(3).toFloat()));
                normalVector[normalVector.length()-1].normalize();
            }
            else if(str.contains("f ")){
                faceList1=list.at(1).split("/");
                faceList2=list.at(2).split("/");
                faceList3=list.at(3).split("/");

                target3DModel.verticesData.append(vertices.at(faceList1.at(0).toUInt()-1));
                target3DModel.normalData.append(normalVector.at(faceList1.at(0).toUInt()-1));
                target3DModel.faceIDV1.append(faceList1.at(0));

                if(target3DModel.isOBJColored==GL_TRUE){
                    if(colorface.isNull()){
                        target3DModel.colorData.append(colorVector.at(faceList1.at(0).toUInt()-1));
                    }
                    else{
                        target3DModel.colorData.append(colorface);
                    }
                }
                else{
                    target3DModel.colorData.append(QVector4D(1.0, 1.0, 1.0, 0.0));
                }

                target3DModel.verticesData.append(vertices.at(faceList2.at(0).toUInt()-1));
                target3DModel.normalData.append(normalVector.at(faceList2.at(0).toUInt()-1));
                target3DModel.faceIDV2.append(faceList2.at(0));

                if(target3DModel.isOBJColored==GL_TRUE){
                    if(colorface.isNull()){
                        target3DModel.colorData.append(colorVector.at(faceList2.at(0).toUInt()-1));
                    }
                    else{
                        target3DModel.colorData.append(colorface);
                    }
                }
                else{
                    target3DModel.colorData.append(QVector4D(1.0, 1.0, 1.0, 1.0));
                }

                target3DModel.verticesData.append(vertices.at(faceList3.at(0).toUInt()-1));
                target3DModel.normalData.append(normalVector.at(faceList3.at(0).toUInt()-1));
                target3DModel.faceIDV3.append(faceList3.at(0));

                if(target3DModel.isOBJColored==GL_TRUE){
                    if(colorface.isNull()){
                        target3DModel.colorData.append(colorVector.at(faceList3.at(0).toUInt()-1));
                    }
                    else{
                        target3DModel.colorData.append(colorface);
                    }
                }
                else{
                    target3DModel.colorData.append(QVector4D(1.0, 1.0, 1.0, 0.0));
                }
            }
        }
    }

    else if(modelFileType=="STL"){
        while(!ModelFile.atEnd()){
            str=codec->toUnicode(ModelFile.readLine());
            str=str.trimmed();
            str=str.simplified();
            list=str.split(" ");

            if(list.contains("solid ")){
                qDebug()<<"STL is Test File";
            }
            if(str.contains("# ")){
                continue;
            }
            else if(str.contains("vertex ")){
                listX.append(list.at(1).toFloat());
                listY.append(list.at(2).toFloat());
                listZ.append(list.at(3).toFloat());

                centerOfGravity=calcCenterOfGravity(vertices.at(faceList1.at(0).toUInt()-1).toVector3D(), vertices.at(faceList2.at(0).toUInt()-1).toVector3D(), vertices.at(faceList3.at(0).toUInt()-1).toVector3D());
                GLuint memeber=sphereMemeber(centerOfGravity);
                nodeSphereId.append(memeber);
                target3DModel.verticesData.append(QVector4D(list.at(1).toFloat(), list.at(2).toFloat(), list.at(3).toFloat(), 1.0));
                target3DModel.colorData.append(QVector4D(0.5, 0.5, 0.5, 0.0));
            }
            else if(str.contains("facet normal ")){
                target3DModel.normalData.append(QVector3D(list.at(1).toFloat(), list.at(2).toFloat(), list.at(3).toFloat()));
                target3DModel.normalData[target3DModel.normalData.length()-1].normalize();
            }
        }
    }
    ModelFile.close();

    qSort(listX.begin(), listX.end());
    qSort(listY.begin(), listY.end());
    qSort(listZ.begin(), listZ.end());

    minX=listX.at(0);
    maxX=listX.at(listX.length()-1);
    minY=listY.at(0);
    maxY=listY.at(listY.length()-1);
    minZ=listZ.at(0);
    maxZ=listZ.at(listZ.length()-1);

    

    disX=abs(maxX-minX);
    disY=abs(maxY-minY);
    disZ=abs(maxZ-minZ);

    GLfloat disMax=disX;
    if(disMax<disY){
        disMax=disY;
    }
    if(disMax<disZ){
        disMax=disZ;
    }

    
    

    target3DModel.vertexNum=target3DModel.verticesData.length();
    target3DModel.faceNum=target3DModel.verticesData.length()/3;

    createBoundingSphere();
    GLuint memeber;
    for(int i=0; i<int(target3DModel.vertexNum); i+=3){
        centerOfGravity=calcCenterOfGravity(target3DModel.verticesData.at(i).toVector3D(), target3DModel.verticesData.at(i+1).toVector3D(), target3DModel.verticesData.at(i+2).toVector3D());
        memeber=sphereMemeber(centerOfGravity);
        nodeSphereId.append(memeber);
        target3DModel.verticesData[i].setW(memeber);
        target3DModel.verticesData[i+1].setW(memeber);
        target3DModel.verticesData[i+2].setW(memeber);
    }

    target3DModel.setDefaultColor(mtl.getKd());
    vertices.clear();
    normalVector.clear();
    colorVector.clear();
}

void DrawTargetModel::createBoundingSphere(){
    GLfloat r=0.30;
    rootSphere.setParam(0.0, 0.0, 0.0, r);
    
    boundingShpere bs;
    bs.setParam(r/2, r/2, r/2, r/2);
    nodeLevel1Spheres.append(bs);
    
    bs.setParam(r/2, -r/2, r/2, r/2);
    nodeLevel1Spheres.append(bs);
    
    bs.setParam(-r/2, -r/2, r/2, r/2);
    nodeLevel1Spheres.append(bs);
    
    bs.setParam(-r/2, r/2, r/2, r/2);
    nodeLevel1Spheres.append(bs);
    
    bs.setParam(r/2, r/2, -r/2, r/2);
    nodeLevel1Spheres.append(bs);
    
    bs.setParam(r/2, -r/2, -r/2, r/2);
    nodeLevel1Spheres.append(bs);
    
    bs.setParam(-r/2, -r/2, -r/2, r/2);
    nodeLevel1Spheres.append(bs);
    
    bs.setParam(-r/2, r/2, -r/2, r/2);
    nodeLevel1Spheres.append(bs);

    for(int i=0; i<nodeLevel1Spheres.length(); i++){
        
        bs.setParam(nodeLevel1Spheres.at(i).initialCenter.x()+nodeLevel1Spheres.at(i).r/2, nodeLevel1Spheres.at(i).initialCenter.y()+nodeLevel1Spheres.at(i).r/2, nodeLevel1Spheres.at(i).initialCenter.z()+nodeLevel1Spheres.at(i).r/2, nodeLevel1Spheres.at(i).r/1.35);
        nodeLevel2Spheres.append(bs);
        
        bs.setParam(nodeLevel1Spheres.at(i).initialCenter.x()+nodeLevel1Spheres.at(i).r/2, nodeLevel1Spheres.at(i).initialCenter.y()-nodeLevel1Spheres.at(i).r/2, nodeLevel1Spheres.at(i).initialCenter.z()+nodeLevel1Spheres.at(i).r/2, nodeLevel1Spheres.at(i).r/1.35);
        nodeLevel2Spheres.append(bs);
        
        bs.setParam(nodeLevel1Spheres.at(i).initialCenter.x()-nodeLevel1Spheres.at(i).r/2, nodeLevel1Spheres.at(i).initialCenter.y()-nodeLevel1Spheres.at(i).r/2, nodeLevel1Spheres.at(i).initialCenter.z()+nodeLevel1Spheres.at(i).r/2, nodeLevel1Spheres.at(i).r/1.35);
        nodeLevel2Spheres.append(bs);
        
        bs.setParam(nodeLevel1Spheres.at(i).initialCenter.x()-nodeLevel1Spheres.at(i).r/2, nodeLevel1Spheres.at(i).initialCenter.y()+nodeLevel1Spheres.at(i).r/2, nodeLevel1Spheres.at(i).initialCenter.z()+nodeLevel1Spheres.at(i).r/2, nodeLevel1Spheres.at(i).r/1.35);
        nodeLevel2Spheres.append(bs);
        
        bs.setParam(nodeLevel1Spheres.at(i).initialCenter.x()+nodeLevel1Spheres.at(i).r/2, nodeLevel1Spheres.at(i).initialCenter.y()+nodeLevel1Spheres.at(i).r/2, nodeLevel1Spheres.at(i).initialCenter.z()-nodeLevel1Spheres.at(i).r/2, nodeLevel1Spheres.at(i).r/1.35);
        nodeLevel2Spheres.append(bs);
        
        bs.setParam(nodeLevel1Spheres.at(i).initialCenter.x()+nodeLevel1Spheres.at(i).r/2, nodeLevel1Spheres.at(i).initialCenter.y()-nodeLevel1Spheres.at(i).r/2, nodeLevel1Spheres.at(i).initialCenter.z()-nodeLevel1Spheres.at(i).r/2, nodeLevel1Spheres.at(i).r/1.35);
        nodeLevel2Spheres.append(bs);
        
        bs.setParam(nodeLevel1Spheres.at(i).initialCenter.x()-nodeLevel1Spheres.at(i).r/2, nodeLevel1Spheres.at(i).initialCenter.y()-nodeLevel1Spheres.at(i).r/2, nodeLevel1Spheres.at(i).initialCenter.z()-nodeLevel1Spheres.at(i).r/2, nodeLevel1Spheres.at(i).r/1.35);
        nodeLevel2Spheres.append(bs);
        
        bs.setParam(nodeLevel1Spheres.at(i).initialCenter.x()-nodeLevel1Spheres.at(i).r/2, nodeLevel1Spheres.at(i).initialCenter.y()+nodeLevel1Spheres.at(i).r/2, nodeLevel1Spheres.at(i).initialCenter.z()-nodeLevel1Spheres.at(i).r/2, nodeLevel1Spheres.at(i).r/1.35);
        nodeLevel2Spheres.append(bs);
    }

    
    for(int i=0; i<nodeLevel2Spheres.length(); i++){
        
        bs.setParam(nodeLevel2Spheres.at(i).initialCenter.x()+nodeLevel2Spheres.at(i).r/2, nodeLevel2Spheres.at(i).initialCenter.y()+nodeLevel2Spheres.at(i).r/2, nodeLevel2Spheres.at(i).initialCenter.z()+nodeLevel2Spheres.at(i).r/2, nodeLevel2Spheres.at(i).r/1.35);
        nodeLevel3Spheres.append(bs);
        
        bs.setParam(nodeLevel2Spheres.at(i).initialCenter.x()+nodeLevel2Spheres.at(i).r/2, nodeLevel2Spheres.at(i).initialCenter.y()-nodeLevel2Spheres.at(i).r/2, nodeLevel2Spheres.at(i).initialCenter.z()+nodeLevel2Spheres.at(i).r/2, nodeLevel2Spheres.at(i).r/1.35);
        nodeLevel3Spheres.append(bs);
        
        bs.setParam(nodeLevel2Spheres.at(i).initialCenter.x()-nodeLevel2Spheres.at(i).r/2, nodeLevel2Spheres.at(i).initialCenter.y()-nodeLevel2Spheres.at(i).r/2, nodeLevel2Spheres.at(i).initialCenter.z()+nodeLevel2Spheres.at(i).r/2, nodeLevel2Spheres.at(i).r/1.35);
        nodeLevel3Spheres.append(bs);
        
        bs.setParam(nodeLevel2Spheres.at(i).initialCenter.x()-nodeLevel2Spheres.at(i).r/2, nodeLevel2Spheres.at(i).initialCenter.y()+nodeLevel2Spheres.at(i).r/2, nodeLevel2Spheres.at(i).initialCenter.z()+nodeLevel2Spheres.at(i).r/2, nodeLevel2Spheres.at(i).r/1.35);
        nodeLevel3Spheres.append(bs);
        
        bs.setParam(nodeLevel2Spheres.at(i).initialCenter.x()+nodeLevel2Spheres.at(i).r/2, nodeLevel2Spheres.at(i).initialCenter.y()+nodeLevel2Spheres.at(i).r/2, nodeLevel2Spheres.at(i).initialCenter.z()-nodeLevel2Spheres.at(i).r/2, nodeLevel2Spheres.at(i).r/1.35);
        nodeLevel3Spheres.append(bs);
        
        bs.setParam(nodeLevel2Spheres.at(i).initialCenter.x()+nodeLevel2Spheres.at(i).r/2, nodeLevel2Spheres.at(i).initialCenter.y()-nodeLevel2Spheres.at(i).r/2, nodeLevel2Spheres.at(i).initialCenter.z()-nodeLevel2Spheres.at(i).r/2, nodeLevel2Spheres.at(i).r/1.35);
        nodeLevel3Spheres.append(bs);
        
        bs.setParam(nodeLevel2Spheres.at(i).initialCenter.x()-nodeLevel2Spheres.at(i).r/2, nodeLevel2Spheres.at(i).initialCenter.y()-nodeLevel2Spheres.at(i).r/2, nodeLevel2Spheres.at(i).initialCenter.z()-nodeLevel2Spheres.at(i).r/2, nodeLevel2Spheres.at(i).r/1.35);
        nodeLevel3Spheres.append(bs);
        
        bs.setParam(nodeLevel2Spheres.at(i).initialCenter.x()-nodeLevel2Spheres.at(i).r/2, nodeLevel2Spheres.at(i).initialCenter.y()+nodeLevel2Spheres.at(i).r/2, nodeLevel2Spheres.at(i).initialCenter.z()-nodeLevel2Spheres.at(i).r/2, nodeLevel2Spheres.at(i).r/1.35);
        nodeLevel3Spheres.append(bs);
    }
}

void DrawTargetModel::compSphereMember(){

}

void DrawTargetModel::initTargetPolygonColor(QString mode){
    
    if(mode=="ALLInit"){
        isInitializeFootprints=GL_TRUE;
        glBindBuffer(GL_ARRAY_BUFFER, target3DModel.vboID[2]);
        glBufferData(GL_ARRAY_BUFFER, target3DModel.colorData.length()*sizeof(QVector4D), target3DModel.colorData.constData(), GL_DYNAMIC_DRAW);
        isInitializeFootprints=GL_FALSE;
    }
    else{
        isInitializeFootprints=GL_TRUE;
        recordShadow();
        isInitializeFootprints=GL_FALSE;
    }
    
    
}

void DrawTargetModel::drawTarget3DModel(){
    target3DModel.draw3DModel();
}

void DrawTargetModel::visualizePolygon(QStringList observedPolygon){
    glBindBuffer(GL_ARRAY_BUFFER, target3DModel.vboID[2]);
    GLfloat *clientPtrColor=(GLfloat*)glMapBuffer(GL_ARRAY_BUFFER, GL_READ_WRITE);

    QString polygonID;
    GLuint faceID;
    for(int i=1; i<observedPolygon.length(); i++){
        polygonID=observedPolygon.at(i);
        faceID=polygonID.toUInt()*4;
        

        clientPtrColor[faceID]=1.0;
        clientPtrColor[faceID+1]=0.0;
        clientPtrColor[faceID+2]=0.0;

        clientPtrColor[faceID+4]=1.0;
        clientPtrColor[faceID+5]=0.0;
        clientPtrColor[faceID+6]=0.0;

        clientPtrColor[faceID+8]=1.0;
        clientPtrColor[faceID+9]=0.0;
        clientPtrColor[faceID+10]=0.0;
    }

    glUnmapBuffer(GL_ARRAY_BUFFER);

    glBindBuffer(GL_ARRAY_BUFFER, 0);
    
}


void DrawTargetModel::backupPolygonColor(){
    target3DModel.backupColorData.clear();
    

    glBindBuffer(GL_ARRAY_BUFFER, target3DModel.vboID[2]);
    GLfloat *clientPtrColor=(GLfloat*)glMapBuffer(GL_ARRAY_BUFFER, GL_READ_ONLY);

    GLuint id=0;
    for(int i=0; i<target3DModel.colorData.length()*4; i+=12){
        id=i/4;
        if(clientPtrColor[i+3]==100.0){
            target3DModel.backupColorData.append(QVector4D(target3DModel.colorData.at(id).x(), target3DModel.colorData.at(id).y(), target3DModel.colorData.at(id).z(), 0.0));
            target3DModel.backupColorData.append(QVector4D(target3DModel.colorData.at(id+1).x(), target3DModel.colorData.at(id+1).y(), target3DModel.colorData.at(id+1).z(), 0.0));
            target3DModel.backupColorData.append(QVector4D(target3DModel.colorData.at(id+2).x(), target3DModel.colorData.at(id+2).y(), target3DModel.colorData.at(id+2).z(), 0.0));
        }
        else{
            target3DModel.backupColorData.append(QVector4D(clientPtrColor[i], clientPtrColor[i+1], clientPtrColor[i+2], clientPtrColor[i+3]));
            target3DModel.backupColorData.append(QVector4D(clientPtrColor[i+4], clientPtrColor[i+5], clientPtrColor[i+6], clientPtrColor[i+7]));
            target3DModel.backupColorData.append(QVector4D(clientPtrColor[i+8], clientPtrColor[i+9], clientPtrColor[i+10], clientPtrColor[i+11]));
        }
    }

    glUnmapBuffer(GL_ARRAY_BUFFER);
    glBindBuffer(GL_ARRAY_BUFFER, 0);
}



void DrawTargetModel::recordShadow(){
    target3DModel.shadowOffData.clear();
    target3DModel.shadowOnData.clear();
    GLuint id=0;

    glBindBuffer(GL_ARRAY_BUFFER, target3DModel.vboID[2]);
    GLfloat *clientPtrColor=(GLfloat*)glMapBuffer(GL_ARRAY_BUFFER, GL_READ_WRITE);

    for(int i=0; i<target3DModel.colorData.length()*4; i+=12){
        id=i/4;
        if((int)clientPtrColor[i+3]==100){
            target3DModel.shadowOnData.append(QVector4D(0.1, 0.1, 0.1, 100.0));
            target3DModel.shadowOnData.append(QVector4D(0.1, 0.1, 0.1, 100.0));
            target3DModel.shadowOnData.append(QVector4D(0.1, 0.1, 0.1, 100.0));
            target3DModel.shadowOffData.append(target3DModel.defaultColor);
            target3DModel.shadowOffData.append(target3DModel.defaultColor);
            target3DModel.shadowOffData.append(target3DModel.defaultColor);
        }
        else if((int)clientPtrColor[i+3]==0){
            target3DModel.shadowOnData.append(target3DModel.defaultColor);
            target3DModel.shadowOnData.append(target3DModel.defaultColor);
            target3DModel.shadowOnData.append(target3DModel.defaultColor);
            target3DModel.shadowOffData.append(target3DModel.defaultColor);
            target3DModel.shadowOffData.append(target3DModel.defaultColor);
            target3DModel.shadowOffData.append(target3DModel.defaultColor);
        }
        
        
            
            
            
            
            
            

        
        
        
        else{
            
            if(100.0<(int)clientPtrColor[i+3]&&(int)clientPtrColor[i+3]<200){
                if(isInitializeFootprints==GL_TRUE){
                    target3DModel.shadowOnData.append(QVector4D(0.1, 0.1, 0.1, 100.0));
                    target3DModel.shadowOnData.append(QVector4D(0.1, 0.1, 0.1, 100.0));
                    target3DModel.shadowOnData.append(QVector4D(0.1, 0.1, 0.1, 100.0));
                    target3DModel.shadowOffData.append(target3DModel.defaultColor);
                    target3DModel.shadowOffData.append(target3DModel.defaultColor);
                    target3DModel.shadowOffData.append(target3DModel.defaultColor);
                }
                else{
                    target3DModel.shadowOnData.append(QVector4D(clientPtrColor[i], clientPtrColor[i+1], clientPtrColor[i+2], clientPtrColor[i+3]-100.0));
                    target3DModel.shadowOnData.append(QVector4D(clientPtrColor[i+4], clientPtrColor[i+5], clientPtrColor[i+6], clientPtrColor[i+7]-100.0));
                    target3DModel.shadowOnData.append(QVector4D(clientPtrColor[i+8], clientPtrColor[i+9], clientPtrColor[i+10], clientPtrColor[i+11]-100.0));
                    target3DModel.shadowOffData.append(QVector4D(clientPtrColor[i], clientPtrColor[i+1], clientPtrColor[i+2], clientPtrColor[i+3]-100.0));
                    target3DModel.shadowOffData.append(QVector4D(clientPtrColor[i+4], clientPtrColor[i+5], clientPtrColor[i+6], clientPtrColor[i+7]-100.0));
                    target3DModel.shadowOffData.append(QVector4D(clientPtrColor[i+8], clientPtrColor[i+9], clientPtrColor[i+10], clientPtrColor[i+11]-100.0));
                }
            }
            else if(200<(int)clientPtrColor[i+3]){
                if(isInitializeFootprints==GL_TRUE){
                    target3DModel.shadowOnData.append(QVector4D(0.1, 0.1, 0.1, 100.0));
                    target3DModel.shadowOnData.append(QVector4D(0.1, 0.1, 0.1, 100.0));
                    target3DModel.shadowOnData.append(QVector4D(0.1, 0.1, 0.1, 100.0));
                    target3DModel.shadowOffData.append(target3DModel.defaultColor);
                    target3DModel.shadowOffData.append(target3DModel.defaultColor);
                    target3DModel.shadowOffData.append(target3DModel.defaultColor);
                }
                else{
                    target3DModel.shadowOnData.append(QVector4D(clientPtrColor[i], clientPtrColor[i+1], clientPtrColor[i+2], clientPtrColor[i+3]-200.0));
                    target3DModel.shadowOnData.append(QVector4D(clientPtrColor[i+4], clientPtrColor[i+5], clientPtrColor[i+6], clientPtrColor[i+7]-200.0));
                    target3DModel.shadowOnData.append(QVector4D(clientPtrColor[i+8], clientPtrColor[i+9], clientPtrColor[i+10], clientPtrColor[i+11]-200.0));
                    target3DModel.shadowOffData.append(QVector4D(clientPtrColor[i], clientPtrColor[i+1], clientPtrColor[i+2], clientPtrColor[i+3]-200.0));
                    target3DModel.shadowOffData.append(QVector4D(clientPtrColor[i+4], clientPtrColor[i+5], clientPtrColor[i+6], clientPtrColor[i+7]-200.0));
                    target3DModel.shadowOffData.append(QVector4D(clientPtrColor[i+8], clientPtrColor[i+9], clientPtrColor[i+10], clientPtrColor[i+11]-200.0));
                }
            }
            else if((int)clientPtrColor[i+3]<-200){
                if(isInitializeFootprints==GL_TRUE){
                    target3DModel.shadowOnData.append(QVector4D(0.1, 0.1, 0.1, 100.0));
                    target3DModel.shadowOnData.append(QVector4D(0.1, 0.1, 0.1, 100.0));
                    target3DModel.shadowOnData.append(QVector4D(0.1, 0.1, 0.1, 100.0));
                    target3DModel.shadowOffData.append(target3DModel.defaultColor);
                    target3DModel.shadowOffData.append(target3DModel.defaultColor);
                    target3DModel.shadowOffData.append(target3DModel.defaultColor);
                }
                else{
                    target3DModel.shadowOnData.append(QVector4D(clientPtrColor[i], clientPtrColor[i+1], clientPtrColor[i+2], clientPtrColor[i+3]+200.0));
                    target3DModel.shadowOnData.append(QVector4D(clientPtrColor[i+4], clientPtrColor[i+5], clientPtrColor[i+6], clientPtrColor[i+7]+200.0));
                    target3DModel.shadowOnData.append(QVector4D(clientPtrColor[i+8], clientPtrColor[i+9], clientPtrColor[i+10], clientPtrColor[i+11]+200.0));
                    target3DModel.shadowOffData.append(QVector4D(clientPtrColor[i], clientPtrColor[i+1], clientPtrColor[i+2], clientPtrColor[i+3]+200.0));
                    target3DModel.shadowOffData.append(QVector4D(clientPtrColor[i+4], clientPtrColor[i+5], clientPtrColor[i+6], clientPtrColor[i+7]+200.0));
                    target3DModel.shadowOffData.append(QVector4D(clientPtrColor[i+8], clientPtrColor[i+9], clientPtrColor[i+10], clientPtrColor[i+11]+200.0));
                }
            }
            else{
                if(isInitializeFootprints==GL_TRUE){
                    target3DModel.shadowOnData.append(target3DModel.defaultColor);
                    target3DModel.shadowOnData.append(target3DModel.defaultColor);
                    target3DModel.shadowOnData.append(target3DModel.defaultColor);
                    target3DModel.shadowOffData.append(target3DModel.defaultColor);
                    target3DModel.shadowOffData.append(target3DModel.defaultColor);
                    target3DModel.shadowOffData.append(target3DModel.defaultColor);
                }
                else{
                    target3DModel.shadowOnData.append(QVector4D(clientPtrColor[i], clientPtrColor[i+1], clientPtrColor[i+2], clientPtrColor[i+3]));
                    target3DModel.shadowOnData.append(QVector4D(clientPtrColor[i+4], clientPtrColor[i+5], clientPtrColor[i+6], clientPtrColor[i+7]));
                    target3DModel.shadowOnData.append(QVector4D(clientPtrColor[i+8], clientPtrColor[i+9], clientPtrColor[i+10], clientPtrColor[i+11]));
                    target3DModel.shadowOffData.append(QVector4D(clientPtrColor[i], clientPtrColor[i+1], clientPtrColor[i+2], clientPtrColor[i+3]));
                    target3DModel.shadowOffData.append(QVector4D(clientPtrColor[i+4], clientPtrColor[i+5], clientPtrColor[i+6], clientPtrColor[i+7]));
                    target3DModel.shadowOffData.append(QVector4D(clientPtrColor[i+8], clientPtrColor[i+9], clientPtrColor[i+10], clientPtrColor[i+11]));
                }
            }
            
            
            
            
        }
    }
    glUnmapBuffer(GL_ARRAY_BUFFER);
    glBindBuffer(GL_ARRAY_BUFFER, 0);
}

void DrawTargetModel::restoreShadowData(){
    
    
    glBindBuffer(GL_ARRAY_BUFFER, target3DModel.vboID[2]);
    glBufferData(GL_ARRAY_BUFFER, target3DModel.shadowOnData.length()*sizeof(QVector4D), target3DModel.shadowOnData.constData(), GL_DYNAMIC_DRAW);
}

void DrawTargetModel::overwriteShadowOffData(){
    glBindBuffer(GL_ARRAY_BUFFER, target3DModel.vboID[2]);
    glBufferData(GL_ARRAY_BUFFER, target3DModel.shadowOffData.length()*sizeof(QVector4D), target3DModel.shadowOffData.constData(), GL_DYNAMIC_DRAW);
}

QVector3D DrawTargetModel::calcCenterOfGravity(QVector3D v0, QVector3D v1, QVector3D v2){
    QVector3D centerOfGravity;
    centerOfGravity.setX((v0.x()+v1.x()+v2.x())/3.0);
    centerOfGravity.setY((v0.y()+v1.y()+v2.y())/3.0);
    centerOfGravity.setZ((v0.z()+v1.z()+v2.z())/3.0);

    return centerOfGravity;
}

GLuint DrawTargetModel::sphereMemeber(QVector3D vec){
    GLuint id=0;
    GLdouble minDistance=10000000;
    GLdouble startToShpereCenterDis;

    for(int i=0; i<nodeLevel3Spheres.length(); i++){
        startToShpereCenterDis=pow(nodeLevel3Spheres[i].initialCenter.x()-vec.x(), 2)+pow(nodeLevel3Spheres[i].initialCenter.y()-vec.y(), 2)+pow(nodeLevel3Spheres[i].initialCenter.z()-vec.z(), 2);
        startToShpereCenterDis=sqrt(startToShpereCenterDis);

        if(minDistance>startToShpereCenterDis){
            minDistance=startToShpereCenterDis;
            id=i;
        }
    }

    if(nodeLevel3Spheres.at(id).inPolygons==GL_FALSE){
        nodeLevel3Spheres[id].setIsInPolygons(GL_TRUE);
    }

    return id;
}

void DrawTargetModel::setTexture(GLuint texture){
    target3DModel.texture = texture;
}

void DrawTargetModel::initDepth(){
    target3DModel.initDepth();


}

void DrawTargetModel::setDepth(){


    initDepth();

    qDebug() << "depth:  " << texture;

    glClear(GL_DEPTH_BUFFER_BIT);
    glViewport(0, 0, 1024, 1024);

    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();

    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();


    float m[16];
    glGetFloatv(GL_MODELVIEW_MATRIX, m);

    float vs[] = { m[0], m[4], m[8],  m[12] };
    float vt[] = { m[1], m[5], m[9],  m[13] };
    float vr[] = { m[2], m[6], m[10], m[14] };
    float vq[] = { m[3], m[7], m[11], m[15] };

    // 合成した変換行列をオブジェクトの頂点に掛ければ画面を覆うようにUVが自動計算される。
    glTexGenfv( GL_S, GL_OBJECT_PLANE, vs );
    glTexGenfv( GL_T, GL_OBJECT_PLANE, vt );
    glTexGenfv( GL_R, GL_OBJECT_PLANE, vr );
    glTexGenfv( GL_Q, GL_OBJECT_PLANE, vq );

    // UVの自動生成を有効化する。
    glEnable( GL_TEXTURE_GEN_S );
    glEnable( GL_TEXTURE_GEN_T );
    glEnable( GL_TEXTURE_GEN_R );
    glEnable( GL_TEXTURE_GEN_Q );

    // 自動生成の計算式にオブジェクト空間の頂点座標を使う。
    glTexGeni( GL_S, GL_TEXTURE_GEN_MODE, GL_OBJECT_LINEAR );
    glTexGeni( GL_T, GL_TEXTURE_GEN_MODE, GL_OBJECT_LINEAR );
    glTexGeni( GL_R, GL_TEXTURE_GEN_MODE, GL_OBJECT_LINEAR );
    glTexGeni( GL_Q, GL_TEXTURE_GEN_MODE, GL_OBJECT_LINEAR );




    glEnable( GL_CULL_FACE );
    glCullFace( GL_FRONT );

    glColorMask(false, false, false, false);


    glEnable(GL_POLYGON_OFFSET_FILL);
    glPolygonOffset(-2, -2);
    glBindTexture( GL_TEXTURE_2D,  0);

    glMatrixMode( GL_PROJECTION );
    glLoadIdentity();
    gluPerspective(5.0, 1.0, 1.0, 2000.0);

    glMatrixMode( GL_MODELVIEW );
    glLoadIdentity();
    //gluLookAt( n, n, n, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);

    target3DModel.draw3DModel();

    glDisable(GL_POLYGON_OFFSET_FILL);

    glBindTexture( GL_TEXTURE_2D,  texture);
    glCopyTexSubImage2D(GL_TEXTURE_2D, 0, 0, 0, 0, 0, 1024, 1024 );

    //qDebug() <<


    glCullFace( GL_BACK );

    // 画面をクリアする。
    glClear( GL_DEPTH_BUFFER_BIT );


    glMatrixMode( GL_MODELVIEW );
         glLoadIdentity();

    target3DModel.draw3DModel();

    glDisable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, 0);


    glColorMask(true, true, true, true);

}

void DrawTargetModel::setMapTexture(QImage image){
    GLuint texture;
    texture = bindTexture(QImage(image), GL_TEXTURE_2D);
    target3DModel.texture = texture;
    target3DModel.initTexture();
}

void DrawTargetModel::setShadow(GLint depth, double bound[4], GLdouble pos[3], GLdouble dir[3], GLdouble up[3], GLfloat modelView[16], double forcalLength){
    target3DModel.setShadow(bound, pos, dir, up, modelView, forcalLength);
}

void DrawTargetModel::mapShadow(GLdouble pos[3], GLdouble dir[3], GLdouble up[3], double rt[16], float geo[3]){
    target3DModel.mapShadow(pos, dir, up, rt, geo);
}

void DrawTargetModel::bindMapImage(QImage image){
//    static double genfunc[][4] = {
//        { 1.0, 0.0, 0.0, 0.0 },
//        { 0.0, 1.0, 0.0, 0.0 },
//        { 0.0, 0.0, 1.0, 0.0 },
//        { 0.0, 0.0, 0.0, 1.0 },
//    };

    target3DModel.texture = 0;

    target3DModel.draw3DModel();

    //glMatrixMode(GL_TEXTURE);
    //glLoadIdentity();

    //setMapTexture(image);

//    GLuint depth;
//    glGenTextures(1, &depth);
//    glBindTexture(GL_TEXTURE_RECTANGLE, depth);
//    glTexImage2D(GL_TEXTURE_RECTANGLE, 0, GL_DEPTH_COMPONENT, fbo_width, fbo_height, 0, GL_DEPTH_COMPONENT, GL_FLOAT, nullptr);
//    glTexParameteri(GL_TEXTURE_RECTANGLE, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
//    glTexParameteri(GL_TEXTURE_RECTANGLE, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
//    glTexParameteri(GL_TEXTURE_RECTANGLE, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_BORDER);
//    glTexParameteri(GL_TEXTURE_RECTANGLE, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_BORDER);




//    glMatrixMode(GL_TEXTURE);
//    glLoadIdentity();

    //gluLookAt(0.404,   -0.096,   4.366,   0.31599,   -0.07672,   3.37007,   0.04614,   0.99498,   -0.08882);

    //gluLookAt(-0.291,   0.068,   4.088,   -0.20147,   0.06116,   3.09204,   -0.02606,   0.99566,   0.08932);

//0.942   -0.075   3.915   0.69785   -0.05625   2.94544   0.03167   0.9691   -0.24465

//    glTranslated(0.5, 0.5, 0);
//    glScaled(0.5, 0.5, 0);
//    glRotated(-90, 0, 0, 1);
//    gluPerspective(5.0, 1.0, 0.1, 1);


//    gluLookAt(0, 0, 2,   0,0,0,   0,1.0,0);

    //glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

    //glBindTexture(GL_TEXTURE_2D, 0);


    //target3DModel.draw3DModel();



}

