

//drawimagewidget.cpp
//(c) 2018 The University of Aizu
//This software is released under the GNU General Public License.


#include "drawimagewidget.h"

DrawImageWidget::DrawImageWidget(QWidget *parent) :
    QGLWidget(parent)
{
    readImageSuccesse=GL_FALSE;
}

DrawImageWidget::~DrawImageWidget(){
    
}

void DrawImageWidget::initializeGL(){
    glClearColor( 0.0f, 0.0f, 0.0f, 1.0f );
    glViewport(0, 0, width(), height());
    glMatrixMode(GL_PROJECTION);
    
    glFrustum(-0.006144, 0.006144, -0.006144, 0.006144, 0.0001204711614, 1000);

    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
}





void DrawImageWidget::paintGL(){

    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    GLint physicalViewport[4];
    glGetIntegerv(GL_VIEWPORT, physicalViewport);
    //img=QImage(this->size()*(physicalViewport[3]/height()), QImage::Format_ARGB32_Premultiplied);
    if(filetype=="FITS"){
        glPixelZoom((GLdouble)width()/ax1*(physicalViewport[2]/width()), (GLdouble)height()/ax1*(physicalViewport[3]/height()));
        
        glDrawPixels(ax1, ax2, GL_BGRA, GL_UNSIGNED_BYTE, bits);

    }

//    glPixelStorei(GL_PACK_ALIGNMENT, 4);
//    glReadPixels(0, 0, this->width()*(physicalViewport[2]/width()), this->height()*(physicalViewport[3]/height()), GL_RGBA, GL_UNSIGNED_BYTE, img.bits());
//    img=img.rgbSwapped();
//    img=img.mirrored();

//    QImage saveImg=grabFrameBuffer(true).copy(0, 0, width()*(physicalViewport[2]/width()), height()*(physicalViewport[3]/height()));
//    QImage scaledSaveImg=saveImg.scaled(1024, 1024, Qt::KeepAspectRatio, Qt::FastTransformation);
    

//    emit loadcontorImage_signal(img, filetype);
}

void DrawImageWidget::sendReadImageData(){
    
}


void DrawImageWidget::openImage_slot(QString filename){
    readImageSuccesse=GL_TRUE;

    QFileInfo fileinfo;
    fileinfo.setFile(filename);
    QString ext=fileinfo.suffix();
    ext=ext.toLower();
    if(ext=="fit"||ext=="fits"||ext=="fts"){
        filetype="FITS";
        valarray<GLuint> contents;
        auto_ptr<FITS> pInfile(0);

        try{
            pInfile.reset(new CCfits::FITS(filename.toStdString().c_str(), CCfits::Read, true));
            PHDU& fitsImage=pInfile->pHDU();
            ax1=fitsImage.axis(0);
            ax2=fitsImage.axis(1);
            fitsImage.read(contents);
            

        }
        catch(FitsException& issue){
            cout<<"Can't open fits file"<<endl;
            readImageSuccesse=GL_FALSE;
        }

        if(readImageSuccesse!=GL_FALSE){
            emit isOpenedImageFile_signal(GL_TRUE);

            for(int i=ax1-1; i>=0; i--){
                for(int j=0; j<ax1; j++){
                    bits[(ax1-1)-j][i]=contents[(ax1-1-i)*ax1+j];
                }
            }
        }
    }

    else{
        filetype="nonFITS";
        loadImage.load(filename);
        emit isOpenedImageFile_signal(GL_TRUE);
    }

    updateGL();
}

