

//kernelmainwindow.h
//(c) 2018 The University of Aizu
//This software is released under the GNU General Public License.


#ifndef KERNELMAINWINDOW_H
#define KERNELMAINWINDOW_H

#include <QMainWindow>
#include <iostream>
#include <QWidget>
#include <QtGui>

#include <QCheckBox>
#include <QTableWidget>
#include <QSignalMapper>
#include "SpiceUsr.h"
#include <string.h>
#include "harmonics.h"

using namespace std;

namespace Ui {
class KernelMainWindow;
}

#define MAX_WIDGETITEM (3)

class KernelMainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit KernelMainWindow(QWidget *parent = 0);
    ~KernelMainWindow();

private:
    Ui::KernelMainWindow *ui;
    QSignalMapper *checkBoxMapper;

    QTableWidgetItem *item[MAX_WIDGETITEM];
    
    QStringList loadedKernelList;
    static QMap<QString, SpiceBoolean> kernelMap; 
    QProcess MKSPKprocess;
    QProcess MSOPCKprocess;
    
    
    
    QString briefCommand;
    QString ckbriefCommand;

signals:
    void setLSKFile_signal(QString);
    void setSCLKFile_signal(QString);
    void setFKFile_signal(QString);

private slots:
    void setKernelList_slot(QStringList);

    

    
    void kernelLoad(int);
    
    void on_CloseButton_clicked();

    void on_action_Breif_triggered();
    void on_actionDelete_Kernel_triggered();

    void clearKernelLoad_slot();
};

#endif 
