

//model.h
//(c) 2018 The University of Aizu
//This software is released under the GNU General Public License.


#ifndef MODEL
#define MODEL
#include <QVector4D>
#include <QGLWidget>
#include "material.h"
#include <iostream>
#include "model.h"
#include <QDebug>
#include "harmonics.h"

using namespace std;
class Model{

public:
    GLuint vboID[3];
    GLuint vboIndex, vboDefaultColor, vbobBackup;
    QVector<Material> materials;
    GLuint vertexNum, faceNum;
    QString MTLFileName, modelFileName, modelFileType;
    QVector<QVector4D> verticesData, colorData, backupColorData, translatedVertex, shadowOnData, shadowOffData;
    QVector<QVector3D> normalData, texVerticesV1, texVerticesV2, texVerticesV3;
    QVector<GLuint> indexVector;
    QVector4D defaultColor;
    GLboolean isOBJColored;
    QVector<QVector2D> texImgV1, texImgV2, texImgV3;
    QStringList faceIDV1, faceIDV2, faceIDV3, observedPLIDs;
    GLuint texture=0, depth=0;
    bool isMapping;
    GLuint TEXSIZE=512;
    GLfloat projection[16];
    GLfloat modelview[16], mapmodelview[16];
    GLint viewport[4];
    QMatrix4x4 affineMatrix;



    Model(){
        vertexNum=faceNum=0;
        isOBJColored=GL_FALSE;
    }

    ~Model(){
        glDeleteBuffers(3, &vboID[0]);
        glDeleteBuffers(1, &vboIndex);
        glDeleteBuffers(1, &vboDefaultColor);
        verticesData.clear();
        normalData.clear();
        colorData.clear();
        indexVector.clear();
    }

    void createVBO(){
        glGenBuffers(3, &vboID[0]);

        glBindBuffer(GL_ARRAY_BUFFER, vboID[0]);
        glBufferData(GL_ARRAY_BUFFER, verticesData.length()*sizeof(QVector4D), verticesData.constData(), GL_STATIC_DRAW);

        GLint bufferForCheck=0;
        glGetBufferParameteriv(GL_ARRAY_BUFFER, GL_BUFFER_SIZE, &bufferForCheck);
        if(sizeof(QVector4D)*verticesData.length()!=bufferForCheck){
            cout<<"vertices"<<endl;
            exit(0);
        }
        glBindBuffer(GL_ARRAY_BUFFER, vboID[1]);
        glBufferData(GL_ARRAY_BUFFER, normalData.length()*sizeof(QVector3D), normalData.constData(), GL_STATIC_DRAW);
        bufferForCheck=0;
        glGetBufferParameteriv(GL_ARRAY_BUFFER, GL_BUFFER_SIZE, &bufferForCheck);
        if(sizeof(QVector3D)*normalData.length()!=bufferForCheck){
            cout<<"normal"<<endl;
            exit(0);
        }

        glBindBuffer(GL_ARRAY_BUFFER, vboID[2]);
        glBufferData(GL_ARRAY_BUFFER, colorData.length()*sizeof(QVector4D), colorData.constData(), GL_DYNAMIC_DRAW);
        bufferForCheck=0;
        glGetBufferParameteriv(GL_ARRAY_BUFFER, GL_BUFFER_SIZE, &bufferForCheck);
        if(sizeof(QVector4D)*colorData.length()!=bufferForCheck){
            cout<<"color"<<endl;
            exit(0);
        }
    }

   void draw3DModel(){
       glBindBuffer(GL_ARRAY_BUFFER, vboID[0]);
       glVertexPointer(3, GL_FLOAT, sizeof(QVector4D), 0);

       glBindBuffer(GL_ARRAY_BUFFER, vboID[1]);
       glNormalPointer(GL_FLOAT, 0, 0);

       glBindBuffer(GL_ARRAY_BUFFER, vboID[2]);
       glColorPointer(3, GL_FLOAT, sizeof(QVector4D), 0);

       glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, vboIndex);
       glEnableClientState(GL_VERTEX_ARRAY);
       glEnableClientState(GL_NORMAL_ARRAY);
       glEnableClientState(GL_COLOR_ARRAY);



       glDrawArrays(GL_TRIANGLES, 0, verticesData.length());


       glDisableClientState(GL_COLOR_ARRAY);
       glDisableClientState(GL_NORMAL_ARRAY);
       glDisableClientState(GL_VERTEX_ARRAY);
       glBindBuffer(GL_ARRAY_BUFFER, 0);
   }

   void setDefaultColor(QVector4D defaultColor){
       this->defaultColor=defaultColor;
       this->defaultColor.setW(0.0);
   }

   //set and map texture
   void initTexture(){
       glBindTexture(GL_TEXTURE_2D, texture);
       const GLfloat borderDepth[] = { 1.0f, 1.0f, 1.0f, 1.0f };
       glTexParameterfv(GL_TEXTURE_2D, GL_TEXTURE_BORDER_COLOR, borderDepth);
       glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_COMPARE_FUNC, GL_LEQUAL);

       glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_COMPARE_MODE, GL_COMPARE_R_TO_TEXTURE);
       glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_COMPARE_FUNC, GL_GREATER);
       glTexParameteri(GL_TEXTURE_2D, GL_DEPTH_TEXTURE_MODE, GL_ALPHA);
       glAlphaFunc(GL_GEQUAL, 0.9f);
       glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
       glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
       glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, GL_OBJECT_LINEAR);
       glTexGeni(GL_T, GL_TEXTURE_GEN_MODE, GL_OBJECT_LINEAR);
       glTexGeni(GL_R, GL_TEXTURE_GEN_MODE, GL_OBJECT_LINEAR);
       glTexGeni(GL_Q, GL_TEXTURE_GEN_MODE, GL_OBJECT_LINEAR);
       glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, GL_OBJECT_LINEAR);
       glTexGeni(GL_T, GL_TEXTURE_GEN_MODE, GL_OBJECT_LINEAR);
       glTexGeni(GL_R, GL_TEXTURE_GEN_MODE, GL_OBJECT_LINEAR);
       glTexGeni(GL_Q, GL_TEXTURE_GEN_MODE, GL_OBJECT_LINEAR);
       double genfunc[][4] = {
           { 1.0, 0.0, 0.0, 0.0 },
           { 0.0, 1.0, 0.0, 0.0 },
           { 0.0, 0.0, 1.0, 0.0 },
           { 0.0, 0.0, 0.0, 1.0 },
       };
       glTexGendv(GL_S, GL_OBJECT_PLANE, genfunc[0]);
       glTexGendv(GL_T, GL_OBJECT_PLANE, genfunc[1]);
       glTexGendv(GL_R, GL_OBJECT_PLANE, genfunc[2]);
       glTexGendv(GL_Q, GL_OBJECT_PLANE, genfunc[3]);

       glEnable(GL_TEXTURE_2D);
       glEnable(GL_TEXTURE_GEN_S);
       glEnable(GL_TEXTURE_GEN_T);
       glEnable(GL_TEXTURE_GEN_R);
       glEnable(GL_TEXTURE_GEN_Q);
       glBindTexture(GL_TEXTURE_2D, texture);
       draw3DModel();
       glBindTexture(GL_TEXTURE_2D, 0);
       glDisable(GL_TEXTURE_GEN_S);
       glDisable(GL_TEXTURE_GEN_T);
       glDisable(GL_TEXTURE_GEN_R);
       glDisable(GL_TEXTURE_GEN_Q);
       glDisable(GL_TEXTURE_2D);
       glDisable(GL_ALPHA_TEST);
       glBindTexture(GL_TEXTURE_2D, 0);
       glMatrixMode(GL_MODELVIEW);
   }

   //compute shadow
   void initDepth(){
       glActiveTexture(GL_TEXTURE1);
       glGenTextures(1, &depth);
       glBindTexture(GL_TEXTURE_2D, depth);

       glTexImage2D(GL_TEXTURE_2D, 0, GL_DEPTH_COMPONENT, TEXSIZE, TEXSIZE, 0, GL_DEPTH_COMPONENT, GL_UNSIGNED_BYTE, NULL);

       glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
       glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
       glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
       glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);

       glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_COMPARE_MODE, GL_COMPARE_R_TO_TEXTURE);
       glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_COMPARE_FUNC, GL_GEQUAL);
       glTexParameteri(GL_TEXTURE_2D, GL_DEPTH_TEXTURE_MODE, GL_INTENSITY);

       glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, GL_EYE_LINEAR);
       glTexGeni(GL_T, GL_TEXTURE_GEN_MODE, GL_EYE_LINEAR);
       glTexGeni(GL_R, GL_TEXTURE_GEN_MODE, GL_EYE_LINEAR);
       glTexGeni(GL_Q, GL_TEXTURE_GEN_MODE, GL_EYE_LINEAR);

       static const GLdouble genfunc[][4] = {
           { 1.0, 0.0, 0.0, 0.0 },
           { 0.0, 1.0, 0.0, 0.0 },
           { 0.0, 0.0, 1.0, 0.0 },
           { 0.0, 0.0, 0.0, 1.0 },
       };
       glTexGendv(GL_S, GL_EYE_PLANE, genfunc[0]);
       glTexGendv(GL_T, GL_EYE_PLANE, genfunc[1]);
       glTexGendv(GL_R, GL_EYE_PLANE, genfunc[2]);
       glTexGendv(GL_Q, GL_EYE_PLANE, genfunc[3]);

       glEnable(GL_DEPTH_TEST);
       glEnable(GL_CULL_FACE);

       glBindTexture(GL_TEXTURE_2D, 0);
   }

   //map shadow
   void setShadow(double bound[4], GLdouble pos[3], GLdouble dir[3], GLdouble up[3], GLfloat modelView[16], double forcalLength){
       glBindTexture(GL_TEXTURE_2D, depth);
       glEnable(GL_TEXTURE_2D);

       glClear(GL_DEPTH_BUFFER_BIT);
       glGetIntegerv(GL_VIEWPORT, viewport);
       glViewport(0, 0, TEXSIZE, TEXSIZE);
       glGetFloatv(GL_PROJECTION_MATRIX, projection);
       glMatrixMode(GL_PROJECTION);
       glLoadIdentity();
       glMatrixMode(GL_MODELVIEW);
       glLoadIdentity();

       glFrustum(bound[0], bound[1], bound[2], bound[3], forcalLength, 1000);
       gluLookAt(-pos[0], -pos[1], pos[2], -dir[0], -dir[1], dir[2], -up[0], -up[1], up[2]);

       glGetFloatv(GL_MODELVIEW_MATRIX, mapmodelview);
       glColorMask(GL_FALSE, GL_FALSE, GL_FALSE, GL_FALSE);
       glDisable(GL_LIGHTING);
       glCullFace(GL_FRONT);

       glEnable(GL_POLYGON_OFFSET_FILL);
       glPolygonOffset(-2, -2);
       glMultMatrixf(affineMatrix.data());

       draw3DModel();

       glDisable(GL_POLYGON_OFFSET_FILL);
       glCopyTexSubImage2D(GL_TEXTURE_2D, 0, 0, 0, 0, 0, TEXSIZE, TEXSIZE);
       glClear(GL_DEPTH_BUFFER_BIT);
       glViewport(viewport[0], viewport[1], viewport[2], viewport[3]);
       glMatrixMode(GL_PROJECTION);
       glLoadMatrixf(projection);
       glMatrixMode(GL_MODELVIEW);
       glLoadMatrixf(modelView);
       glColorMask(GL_TRUE, GL_TRUE, GL_TRUE, GL_TRUE);
       glEnable(GL_LIGHTING);
       glCullFace(GL_BACK);
       glBindTexture(GL_TEXTURE_2D, 0);
       glDisable(GL_TEXTURE_2D);
   }

   void mapShadow(GLdouble pos[3], GLdouble dir[3], GLdouble up[3], double rt[16], float geo[3]){

       glBindTexture(GL_TEXTURE_2D, depth);
       glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

       glMatrixMode(GL_TEXTURE);
       glLoadIdentity();

       glTranslated(0.5, 0.5, 0.5);
       glScaled(0.5, 0.5, 0.5);

       glMultMatrixf(mapmodelview);
       glMultTransposeMatrixd(rt);
       glTranslatef(0, 0.0, geo[2]+10.0);

       glMatrixMode(GL_MODELVIEW);
       glTexImage2D(GL_TEXTURE_2D, 0, GL_DEPTH_COMPONENT, TEXSIZE, TEXSIZE, 0,
         GL_DEPTH_COMPONENT, GL_UNSIGNED_BYTE, 0);
       glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
       glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
       glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
       glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
       glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_COMPARE_MODE, GL_COMPARE_R_TO_TEXTURE);
       glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_COMPARE_FUNC, GL_GEQUAL);
       glTexParameteri(GL_TEXTURE_2D, GL_DEPTH_TEXTURE_MODE, GL_INTENSITY);
       glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, GL_EYE_LINEAR);
       glTexGeni(GL_T, GL_TEXTURE_GEN_MODE, GL_EYE_LINEAR);
       glTexGeni(GL_R, GL_TEXTURE_GEN_MODE, GL_EYE_LINEAR);
       glTexGeni(GL_Q, GL_TEXTURE_GEN_MODE, GL_EYE_LINEAR);
       glDepthFunc(GL_LEQUAL);
       glEnable(GL_TEXTURE_2D);
       glEnable(GL_TEXTURE_GEN_S);
       glEnable(GL_TEXTURE_GEN_T);
       glEnable(GL_TEXTURE_GEN_R);
       glEnable(GL_TEXTURE_GEN_Q);

       glEnable(GL_ALPHA_TEST);
       glAlphaFunc(GL_GEQUAL, 0.9f);
       draw3DModel();
       glDisable(GL_TEXTURE_GEN_S);
       glDisable(GL_TEXTURE_GEN_T);
       glDisable(GL_TEXTURE_GEN_R);
       glDisable(GL_TEXTURE_GEN_Q);
       glDisable(GL_TEXTURE_2D);
       glBindTexture(GL_TEXTURE_2D, 0);
       glDisable(GL_ALPHA_TEST);
       glDepthFunc(GL_LESS);
   }
};
#endif 

