

//AffineTranslate.cl
//(c) 2018 The University of Aizu
//This software is released under the GNU General Public License.

__kernel void AffineTranslate(__global const float4* vertex, __global const float* affineMatrix, __global float4* translatedVertex){
    const unsigned int n=get_global_id(0)*3;

    unsigned int v1=n;
    unsigned int v2=v1+1;
    unsigned int v3=v1+2;

    translatedVertex[v1].x=vertex[v1].x*affineMatrix[0]+vertex[v1].y*affineMatrix[4]+vertex[v1].z*affineMatrix[8];
    translatedVertex[v1].y=vertex[v1].x*affineMatrix[1]+vertex[v1].y*affineMatrix[5]+vertex[v1].z*affineMatrix[9];
    translatedVertex[v1].z=vertex[v1].x*affineMatrix[2]+vertex[v1].y*affineMatrix[6]+vertex[v1].z*affineMatrix[10];
    translatedVertex[v1].w=vertex[v1].w;

    translatedVertex[v2].x=vertex[v2].x*affineMatrix[0]+vertex[v2].y*affineMatrix[4]+vertex[v2].z*affineMatrix[8];
    translatedVertex[v2].y=vertex[v2].x*affineMatrix[1]+vertex[v2].y*affineMatrix[5]+vertex[v2].z*affineMatrix[9];
    translatedVertex[v2].z=vertex[v2].x*affineMatrix[2]+vertex[v2].y*affineMatrix[6]+vertex[v2].z*affineMatrix[10];
    translatedVertex[v2].w=vertex[v2].w;

    translatedVertex[v3].x=vertex[v3].x*affineMatrix[0]+vertex[v3].y*affineMatrix[4]+vertex[v3].z*affineMatrix[8];
    translatedVertex[v3].y=vertex[v3].x*affineMatrix[1]+vertex[v3].y*affineMatrix[5]+vertex[v3].z*affineMatrix[9];
    translatedVertex[v3].z=vertex[v3].x*affineMatrix[2]+vertex[v3].y*affineMatrix[6]+vertex[v3].z*affineMatrix[10];
    translatedVertex[v3].w=vertex[v3].w;
}
