

//databasedrawgl.h
//(c) 2018 The University of Aizu
//This software is released under the GNU General Public License.


#ifndef DATABASEDRAWGL_H
#define DATABASEDRAWGL_H

#include <QtOpenGL>
#include <QGLWidget>
#include <QOpenGLWidget>
#include <glu.h>
#ifdef __APPLE__
#include <GLUT/glut.h>
#include <opencv4/opencv2/opencv.hpp>
#include <opencv4/opencv2/highgui.hpp>
#else
#include <GL/glut.h>
#include <opencv/cv.hpp>
#include <opencv/highgui.h>
#endif
#include <QFileInfo>
#include "drawTargetModel.h"
#include <QMouseEvent>
#include <QVector>
#include "harmonics.h"

class DatabaseDrawGL : public QGLWidget
{
    Q_OBJECT

public:
    explicit DatabaseDrawGL(QWidget *parent = 0);
    ~DatabaseDrawGL();

    QVector<int> selectedPolygon;
    int previousSelectedPolygon = 0;
    QVector<int> coveragePolygons;

private:
    GLfloat rotate[3];
    GLfloat translate[3];

    QPoint lastPos;
    DrawTargetModel *target;
    bool isSearchRegion;
    QVector<QVector3D> targetColor;

    #define BUFSIZE 256
    GLuint selectBuf[BUFSIZE];

    void drawTarget(GLenum);
    void mousePicking(GLfloat, GLfloat, GLfloat, GLfloat);
    void selectHits(int ,GLuint *);
    void searchImageFromPolygon(QVector<int>);
    void setTargetDefaultColor();

protected:
    virtual void initializeGL();
    virtual void resizeGL(int w, int h);
    virtual void paintGL();

    void mousePressEvent(QMouseEvent *event);
    void mouseMoveEvent(QMouseEvent *event);
    void wheelEvent(QWheelEvent *event);

signals:
    
    DrawTargetModel* getTargetModel();
    QMap<int, QString> getPLAndImageMap_signal();
    void sendResultSearchImage_signal(QStringList);

public slots:
    void sendTargetModel_slot(DrawTargetModel *);
    void setSearchRegionMode_slot(bool);
    void sendObservedAreas_slot(QStringList, bool);
    void resetRegion_slot();
    void setTargetDefaultColor_slot();
};

#endif 
