

//drawglwidget.cpp
//(c) 2018 The University of Aizu
//This software is released under the GNU General Public License.


#include "drawglwidget.h"

#define USEALPHA 1

GLfloat lightpos[]={0.0, 0.0, 50.0, 1.0};
static const GLfloat lightamb[] = { 0.2, 0.2, 0.2, 1.0 };
static const GLfloat lightdif[] = { 1.0, 1.0, 1.0, 1.0 };
static const GLfloat lightspe[] = { 1.0, 1.0, 1.0, 1.0 };

GLdouble camerazoom=15.0;
GLdouble cameravec[]={0.0, 0.0, 0.0};

const int imageWidth = 1024;
const int imageHeight = 1024;
const int cannyImageWidth = 128;
const int cannyImageHeight = 128;
const int wandHWidth = 240;
const int wandHHeight = 240;

static double cq[4] = { 1.0, 0.0, 0.0, 0.0 };

static double tq[4];

static double rt[16] = {
  1.0, 0.0, 0.0, 0.0,
  0.0, 1.0, 0.0, 0.0,
  0.0, 0.0, 1.0, 0.0,
  0.0, 0.0, 0.0, 1.0,
};

#define PI 3.1415926535897932384626433832795

extern void plinfo_(SpiceInt*, SpiceInt*, SpiceInt[3], SpiceDouble[3][3], SpiceDouble[3], SpiceDouble[3], SpiceDouble*);


drawGLWidget::drawGLWidget(QWidget *parent) :
    QGLWidget(parent), timer(new QBasicTimer)
    , mFOVLengthFixed(true)
    , mNumerator(fov_Hayabusa_rate)
    , mDenominator(fov_Hayabusa_distance)
    , mIsDisplayParameter(false)
    , mIsFillTarget(false)
    , isXRS(false)
    , mpTargetModel(NULL)
    , mpSpacecraftModel(NULL)
{
    targetFrame="HAYABUSA_HP";
    targetName="ITOKAWA";
    instName="HAYABUSA_AMICA";
    instId=-130102;
    strcpy(utc, "0000-00-00T00:00:00");
    start_et=end_et=et=0.0;
    preET=-1;
    target_pos[0]=target_pos[1]=target_pos[2]=0.0;
    sc_pos[0]=sc_pos[1]=sc_pos[2]=0.0;
    earth_pos[0]=earth_pos[1]=earth_pos[2]=0.0;
    sun_pos[0]=sun_pos[1]=sun_pos[2]=0.0;
    phase=incidence=emission=0.0;
    lt_earth=lt_target=0.0;
    bsight[0]=bsight[1]=bsight[2]=0.0;
    up_inst[0]=up_inst[1]=up_inst[2]=0.0;
    rotateSC[0]=rotateSC[1]=rotateSC[2]=0.0;
    observerRotate[0]=observerRotate[1]=observerRotate[2]=0.0;
    targetRotate[0]=targetRotate[1]=targetRotate[2]=0.0;
    observerTranslate[0]=observerTranslate[1]=observerTranslate[2]=0.0;
    targetTranslate[0]=targetTranslate[1]=targetTranslate[2]=0.0;
    SCPosTranslate[0]=SCPosTranslate[1]=SCPosTranslate[2]=0.0;
    geometryTranslate[0]=geometryTranslate[1]=geometryTranslate[2]=0.0;
    geometryRotate[0]=geometryRotate[1]=geometryRotate[2]=0.0;
    glViewMode="fovMode";
    animation=initializedFootprint=isOnceRestore=isRecordSubPointProjection=GL_FALSE;
    harmonicsMode="Get Data from SPICE Kernels";
    HARMONICSModes.append("Get Data from SPICE Kernels");
    HARMONICSModes.append("Target Pointing");
    HARMONICSModes.append("Swing Instrument(SPICE Kernels)");
    HARMONICSModes.append("Swing Instrument(Target Pointing)");
    drawSunVec=drawEarthVec=isDrawCenterOfFOV=drawOrbit=GL_TRUE;
    isScanning=drawOverlay=inputxyz=isChangeVal=drawFootprints=isDrawShadow=isAutoDrawFootprints=isComputedSubpolygon=drewShadow=GL_FALSE;
    isComputeSubPolygon=GL_TRUE;
    isRestoredShadowData=GL_FALSE;
    defaultBoundaryCorners[0]=-0.006144;
    defaultBoundaryCorners[1]=0.006144;
    defaultBoundaryCorners[2]=-0.006144;
    defaultBoundaryCorners[3]=0.006144;
    defaultBoundaryCorners[4]=0.1204711614;
    rollDir="Up";
    pitchDir="Right";
    yawDir="CCW";
    interval=60;
    rollUL=rollLL=pitchUL=pitchLL=yawUL=yawLL=0.0;
    rollCurrentAngle=pitchCurrentAngle=yawCurrentAngle=0.0;
    rollVariation=pitchVariation=yawVariation=0.0;

    screenWidth=480;
    screenHeight=480;

    codec=QTextCodec::codecForLocale();
    subPolygonID=-1;

    isNIRS = isLIDAR = false;
    FOVLength = 0.0;

    onCreateModels_slot();

    dummyColor.setRgbF(0.0, 0.0, 0.0, 0.0);
    prepareFootprint();
    initCL();
    initDepth();
}

drawGLWidget::~drawGLWidget(){

}

void drawGLWidget::initializeGL(){
    qglClearColor(Qt::black);  
    glClear(1.f);
    glShadeModel(GL_SMOOTH);
    glEnable(GL_RESCALE_NORMAL);
    glColorMaterial(GL_FRONT, GL_AMBIENT_AND_DIFFUSE);
    glEnable(GL_COLOR_MATERIAL);
    glHint(GL_POLYGON_SMOOTH_HINT, GL_FASTEST);
    glHint(GL_POINT_SMOOTH_HINT, GL_FASTEST);
    glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_FASTEST);
    glEnable(GL_CULL_FACE);
    glFrontFace(GL_CCW);
    glCullFace(GL_BACK);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE);
    glLightfv(GL_LIGHT0, GL_AMBIENT, lightamb);
    glLightfv(GL_LIGHT0, GL_DIFFUSE, lightdif);
    glLightfv(GL_LIGHT0, GL_SPECULAR, lightspe);

    glEnable(GL_LIGHTING);
    glEnable(GL_LIGHT0);

    //set shadow states
    mpTargetModel->initDepth();
}

void drawGLWidget::initDepth(){


    glGenTextures(1, &depth);
    glBindTexture(GL_TEXTURE_RECTANGLE, depth);

    //glTexImage2D(GL_TEXTURE_RECTANGLE, 0, GL_DEPTH_COMPONENT, 1024, 1024, 0, GL_DEPTH_COMPONENT, GL_FLOAT, nullptr);

    glTexImage2D(GL_TEXTURE_2D, 0, GL_DEPTH_COMPONENT, 1024, 1024, 0, GL_DEPTH_COMPONENT, GL_UNSIGNED_BYTE, 0);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_COMPARE_MODE, GL_COMPARE_R_TO_TEXTURE);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_COMPARE_FUNC, GL_LEQUAL);
    glTexParameteri(GL_TEXTURE_2D, GL_DEPTH_TEXTURE_MODE, GL_INTENSITY);

    glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, GL_EYE_LINEAR);
    glTexGeni(GL_T, GL_TEXTURE_GEN_MODE, GL_EYE_LINEAR);
    glTexGeni(GL_R, GL_TEXTURE_GEN_MODE, GL_EYE_LINEAR);
    glTexGeni(GL_Q, GL_TEXTURE_GEN_MODE, GL_EYE_LINEAR);

    static double genfunc[][4] = {
        { 1.0, 0.0, 0.0, 0.0 },
        { 0.0, 1.0, 0.0, 0.0 },
        { 0.0, 0.0, 1.0, 0.0 },
        { 0.0, 0.0, 0.0, 1.0 },
    };

    glTexGendv(GL_S, GL_EYE_PLANE, genfunc[0]);
    glTexGendv(GL_T, GL_EYE_PLANE, genfunc[1]);
    glTexGendv(GL_R, GL_EYE_PLANE, genfunc[2]);
    glTexGendv(GL_Q, GL_EYE_PLANE, genfunc[3]);
}

void drawGLWidget::resizeGL(int width, int height){
    
    glViewport(0, 0, width, height);

    glGetIntegerv(GL_VIEWPORT, viewport);
    viewport[2]=screenWidth;
    viewport[3]=screenHeight;

    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();


}

void drawGLWidget::paintGL(){

    if (mpTargetModel == NULL ||  mpSpacecraftModel == NULL)
    {
        return;
    }

    if(isRecordSubPointProjection==GL_FALSE){
        glFrustum(-0.006144, 0.006144, -0.006144, 0.006144, 0.0001204711614, 1000);
        glGetFloatv(GL_PROJECTION_MATRIX, subPointProjection);
        isRecordSubPointProjection=GL_TRUE;
    }
    glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
    glEnable(GL_DEPTH_TEST);

    glLoadIdentity();

    if(SCParameters.length()==0){
        glFrustum(defaultBoundaryCorners[0], defaultBoundaryCorners[1], defaultBoundaryCorners[2], defaultBoundaryCorners[3], defaultBoundaryCorners[4], 1000);
    }
    else{
        SpiceInt id;
        for(int i=0; i<SCParameters.length(); i++){
            if(SCParameters.at(i).SCName==SCName){
                id=i;
            }
        }
        spacecraftParam SCParameter=SCParameters.at(id);
        if(SCParameter.getRegisteredInstNum()==0){
            glFrustum(defaultBoundaryCorners[0], defaultBoundaryCorners[1], defaultBoundaryCorners[2], defaultBoundaryCorners[3], defaultBoundaryCorners[4], 1000);
        }
        else{
            SpiceDouble boundaryCorners[4][3];
            SpiceDouble forcalLength=SCParameter.getForcalLengthAndBoundaryCorners(instName, boundaryCorners);

            glFrustum(boundaryCorners[1][0], boundaryCorners[0][0], boundaryCorners[2][0], boundaryCorners[3][0], forcalLength, 1000);
        }
    }

    SpiceChar action[] = "IGNORE";
    erract_c("SET", STRLEN, action);

    


    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();

    compElements.computePos(SCName, targetName, et, sun_pos, earth_pos, sc_pos, target_pos);
    compElements.computeAttitude(instId, targetFrame, et, bsight, up_inst, &r, &p, &y);
    compElements.compTargetRotateMatrix(targetName, targetFrame, et, targetRot);
    affineMatrix=QMatrix4x4(targetRot);
    affine.setToIdentity();
    affineMatrix=affineMatrix.transposed();
    affine.rotate(180, 0.0, 0.0, 1.0);
    affineMatrix=affine*affineMatrix;


    if((isChangeVal==GL_TRUE&&preET!=et)||(animation==GL_TRUE)){
        inputXpos=sc_pos[0];
        inputYpos=sc_pos[1];
        inputZpos=sc_pos[2];
        inputRoll=r;
        inputPitch=p;
        inputYaw=y;
        preET=et;
        isComputedSubpolygon=GL_FALSE;
    }

    if(preET!=et){
        isComputedSubpolygon=GL_FALSE;
    }

    if(isDrawShadow==GL_TRUE||isAutoDrawFootprints==GL_TRUE||(isComputedSubpolygon==GL_FALSE&&isComputeSubPolygon==GL_TRUE)){
        calculateAffineTranslate();
        compBoundingSphere();
        isComputedSubpolygon=GL_TRUE;
    }

    if(isAutoDrawFootprints==GL_TRUE&&animation==GL_TRUE){
        emit drawFootprints_signal();
    }

    if((isDrawShadow==GL_TRUE&&animation==GL_FALSE&&preET!=et&&drewShadow==GL_FALSE)||(isDrawShadow==GL_TRUE&&initializedFootprint==GL_TRUE)){
        mpTargetModel->backupPolygonColor();
        if(initializedFootprint==GL_TRUE){
            mpTargetModel->restoreShadowData();
            initializedFootprint=GL_FALSE;
            
        }
        else{
            if(drewShadow==GL_FALSE){
                drawShadow();
            }
        }
        drewShadow=GL_TRUE;
    }

    if(drewShadow==GL_TRUE&&isRestoredShadowData==GL_TRUE&&isOnceRestore==GL_FALSE){
        cout<<"restore"<<endl;
        mpTargetModel->restoreShadowData();
        isOnceRestore=GL_TRUE;
    }

    if(glViewMode=="fovMode"){
        draw3Dperspective();
    }
    else if(glViewMode=="geometryMode"){
        glShadeModel(GL_FLAT);
        drawGeo();
        glShadeModel(GL_SMOOTH);

        glMultMatrixd(rt);

    }
    glDisable(GL_DEPTH_TEST);

    emit setWindowTime_signal(et);


    if(animation==GL_TRUE||isChangeVal==GL_FALSE){
        emit setWindowPosAndAtt_signal(posSC[0], posSC[1], posSC[2], r, p, y);
    }


    dis=compElements.computeDistance(posSC, target_pos);
    emit setWindowDisTargettoSC_signal(dis);
    dis=compElements.computeDistance(posSC, earth_pos);
    convrt_c(dis, "KM", "AU", &dis);
    emit setWindowDisEarthtoSC_signal(dis);
    emit setWindowIll_signal(phase, incidence, emission, foundIll);

    
    
    if (mIsDisplayParameter == true)
    {
        qglColor(Qt::white);
        renderText(10,420,"X: "+QString::number(posSC[0], 'f', 3)+"[km]");
        renderText(10,440,"Y: "+QString::number(posSC[1], 'f', 3)+"[km]");
        renderText(10,460,"Z: "+QString::number(posSC[2], 'f', 3)+"[km]");
        renderText(140,420,"Roll : "+QString::number(r, 'f', 3)+"[deg]");
        renderText(140,440,"Pitch: "+QString::number(p, 'f', 3)+"[deg]");
        renderText(140,460,"Yaw : "+QString::number(y, 'f', 3)+"[deg]");
    }

    if (isXRS)
    {
        paintXRS_FOV();
    }

}

void drawGLWidget::draw3Dperspective(){
    if (!mpTargetModel)
        return;

    lightpos[0]=sun_pos[0];
    lightpos[1]=sun_pos[1];
    lightpos[2]=sun_pos[2];
    glLightfv(GL_LIGHT0, GL_POSITION, lightpos);

    if(harmonicsMode==HARMONICSModes.at(0)){
        if(isChangeVal==GL_FALSE){
            posSC[0]=sc_pos[0];
            posSC[1]=sc_pos[1];
            posSC[2]=sc_pos[2];
            bsightDir[0]=posSC[0]+bsight[0];
            bsightDir[1]=posSC[1]+bsight[1];
            bsightDir[2]=posSC[2]+bsight[2];
            upVec[0]=up_inst[0];
            upVec[1]=up_inst[1];
            upVec[2]=up_inst[2];
        }
        else{
            posSC[0]=inputXpos+SCPosTranslate[0];
            posSC[1]=inputYpos+SCPosTranslate[1];
            posSC[2]=inputZpos+SCPosTranslate[2];
            r=inputRoll+cameravec[0];
            p=inputPitch+cameravec[1];
            y=inputYaw+cameravec[2];

            compElements.computeBoresightAndUpInstfromInput(targetFrame, instId, r, p, y, compBoresight, up_instFromInput, bounds);
            bsightDir[0]=posSC[0]+compBoresight[0];
            bsightDir[1]=posSC[1]+compBoresight[1];
            bsightDir[2]=posSC[2]+compBoresight[2];
            upVec[0]=up_instFromInput[0];
            upVec[1]=up_instFromInput[1];
            upVec[2]=up_instFromInput[2];
        }
    }
    if(harmonicsMode==HARMONICSModes.at(1)){
        if(isChangeVal==GL_FALSE){
            posSC[0]=sc_pos[0];
            posSC[1]=sc_pos[1];
            posSC[2]=sc_pos[2];
            y=179.9;
        }
        else{
            posSC[0]=inputXpos+SCPosTranslate[0];
            posSC[1]=inputYpos+SCPosTranslate[1];
            posSC[2]=inputZpos+SCPosTranslate[2];

            if(inputYaw==0.0||inputYaw==180){
                y=179.9+cameravec[2];
            }
            else{
                y=inputYaw+cameravec[2];
            }
        }
        p=atan2(posSC[0]-target_pos[0], posSC[2]-target_pos[2]);
        r=-atan2(posSC[1]-target_pos[1], posSC[2]-target_pos[2]);
        r*=RadToDeg;
        p*=RadToDeg;


        compElements.computeBoresightAndUpInstfromInput(targetFrame, instId, r, p, y, compBoresight, up_instFromInput, bounds);

        p=atan2(posSC[0]-target_pos[0], posSC[2]-target_pos[2]);
        r=-atan2(posSC[1]-target_pos[1], hypot(0.0, posSC[0]-target_pos[0]));

        bsightDir[0]=posSC[0]+compBoresight[0];
        bsightDir[1]=posSC[1]+compBoresight[1];
        bsightDir[2]=posSC[2]+compBoresight[2];
        upVec[0]=up_instFromInput[0];
        upVec[1]=up_instFromInput[1];
        upVec[2]=up_instFromInput[2];
    }
    else if(harmonicsMode==HARMONICSModes.at(2)){
        posSC[0]=sc_pos[0];
        posSC[1]=sc_pos[1];
        posSC[2]=sc_pos[2];

        compSwing();

        compElements.computeBoresightAndUpInstfromInput(targetFrame, instId, r, p, y, compBoresight, up_instFromInput, bounds);

        bsightDir[0]=posSC[0]+bsight[0];
        bsightDir[1]=posSC[1]+bsight[1];
        bsightDir[2]=posSC[2]+bsight[2];
        upVec[0]=up_instFromInput[0];
        upVec[1]=up_instFromInput[1];
        upVec[2]=up_instFromInput[2];
    }
    else if(harmonicsMode==HARMONICSModes.at(3)){
        posSC[0]=sc_pos[0];
        posSC[1]=sc_pos[1];
        posSC[2]=sc_pos[2];
        posSC[0]=0.0;
        posSC[1]=0.0;
        posSC[2]=4.0;

        p=atan2(posSC[0]-target_pos[0], posSC[2]-target_pos[2]);
        r=-atan2(posSC[1]-target_pos[1], posSC[2]-target_pos[2]);
        r*=RadToDeg;
        p*=RadToDeg;
        y=179.9;

        compSwing();
        compElements.computeBoresightAndUpInstfromInput(targetFrame, instId, r, p, y, compBoresight, up_instFromInput, bounds);

        bsightDir[0]=posSC[0]+compBoresight[0];
        bsightDir[1]=posSC[1]+compBoresight[1];
        bsightDir[2]=posSC[2]+compBoresight[2];
        upVec[0]=up_instFromInput[0];
        upVec[1]=up_instFromInput[1];
        upVec[2]=up_instFromInput[2];
    }

    compElements.computeIllum(SCName, instId, et, targetName, &phase, &incidence, &emission, &foundIll);

    gluLookAt(posSC[0], posSC[1], posSC[2], bsightDir[0], bsightDir[1], bsightDir[2], upVec[0], upVec[1], upVec[2]);

    glGetFloatv(GL_MODELVIEW_MATRIX, modelView);
    drawVec(target_pos, earth_pos, sun_pos, drawEarthVec, drawSunVec);

    glEnable(GL_COLOR_MATERIAL);
    glPushMatrix();
      glTranslated(target_pos[0], target_pos[1], target_pos[2]);
      glMultMatrixf(affineMatrix.data());
      mpTargetModel->drawTarget3DModel();
    glPopMatrix();
    glDisable(GL_COLOR_MATERIAL);

    if(isDrawCenterOfFOV==GL_TRUE){
        drawCenterofFOV();
    }

    if(drawOverlay==GL_TRUE){
        drawOverlayImage(readedfilename);
    }
}

void drawGLWidget::drawGeo(){

    lightpos[0]=sun_pos[0];
    lightpos[1]=sun_pos[1];
    lightpos[2]=sun_pos[2];
    glLightfv(GL_LIGHT0, GL_POSITION, lightpos);


    if(harmonicsMode==HARMONICSModes.at(0)){
        if(isChangeVal==false){
            posSC[0]=sc_pos[0];
            posSC[1]=sc_pos[1];
            posSC[2]=sc_pos[2];
            bsightDir[0]=sc_pos[0]+bsight[0];
            bsightDir[1]=sc_pos[1]+bsight[1];
            bsightDir[2]=sc_pos[2]+bsight[2];
            bsightVec.setX(bsight[0]);
            bsightVec.setY(bsight[1]);
            bsightVec.setZ(bsight[2]);
            upVec[0]=up_inst[0];
            upVec[1]=up_inst[1];
            upVec[2]=up_inst[2];

        }
        else{
            r=inputRoll+cameravec[0];
            p=inputPitch+cameravec[1];
            y=inputYaw+cameravec[2];

            compElements.computeBoresightAndUpInstfromInput(targetFrame, instId, r, p, y, compBoresight, up_instFromInput, bounds);
            posSC[0]=inputXpos+SCPosTranslate[0];
            posSC[1]=inputYpos+SCPosTranslate[1];
            posSC[2]=inputZpos+SCPosTranslate[2];
            bsightDir[0]=posSC[0]+compBoresight[0];
            bsightDir[1]=posSC[1]+compBoresight[1];
            bsightDir[2]=posSC[2]+compBoresight[2];
            bsightVec.setX(compBoresight[0]);
            bsightVec.setY(compBoresight[1]);
            bsightVec.setZ(compBoresight[2]);
            upVec[0]=up_instFromInput[0];
            upVec[1]=up_instFromInput[1];
            upVec[2]=up_instFromInput[2];
        }
    }
    if(harmonicsMode==HARMONICSModes.at(1)){
        if(isChangeVal==false){
            posSC[0]=sc_pos[0];
            posSC[1]=sc_pos[1];
            posSC[2]=sc_pos[2];
            y=179.9;
        }
        else{
            posSC[0]=inputXpos+SCPosTranslate[0];
            posSC[1]=inputYpos+SCPosTranslate[1];
            posSC[2]=inputZpos+SCPosTranslate[2];

            if(inputYaw==0.0||inputYaw==180){
                y=179.9+cameravec[2];
            }
            else{
                y=inputYaw+cameravec[2];
            }
        }
        p=atan2(posSC[0]-target_pos[0], posSC[2]-target_pos[2]);
        r=-atan2(posSC[1]-target_pos[1], hypot(0.0, posSC[0]-target_pos[0]));
        r*=RadToDeg;
        p*=RadToDeg;

        compElements.computeBoresightAndUpInstfromInput(targetFrame, instId, r, p, y, compBoresight, up_instFromInput, bounds);

        bsightDir[0]=compBoresight[0];
        bsightDir[1]=compBoresight[1];
        bsightDir[2]=compBoresight[2];
        bsightVec.setX(compBoresight[0]);
        bsightVec.setY(compBoresight[1]);
        bsightVec.setZ(compBoresight[2]);
        upVec[0]=up_instFromInput[0];
        upVec[1]=up_instFromInput[1];
        upVec[2]=up_instFromInput[2];
    }
    else if(harmonicsMode==HARMONICSModes.at(2)){
        posSC[0]=sc_pos[0];
        posSC[1]=sc_pos[1];
        posSC[2]=sc_pos[2];

        compSwing();

        compElements.computeBoresightAndUpInstfromInput(targetFrame, instId, r, p, y, compBoresight, up_instFromInput, bounds);

        bsightDir[0]=posSC[0]+bsight[0];
        bsightDir[1]=posSC[1]+bsight[1];
        bsightDir[2]=posSC[2]+bsight[2];
        bsightVec.setX(compBoresight[0]);
        bsightVec.setY(compBoresight[1]);
        bsightVec.setZ(compBoresight[2]);
        upVec[0]=up_instFromInput[0];
        upVec[1]=up_instFromInput[1];
        upVec[2]=up_instFromInput[2];
    }
    else if(harmonicsMode==HARMONICSModes.at(3)){
        posSC[0]=sc_pos[0];
        posSC[1]=sc_pos[1];
        posSC[2]=sc_pos[2];
        posSC[0]=0.0;
        posSC[1]=0.0;
        posSC[2]=3.0;

        p=atan2(posSC[0]-target_pos[0], posSC[2]-target_pos[2]);
        r=-atan2(posSC[1]-target_pos[1], posSC[2]-target_pos[2]);
        r*=RadToDeg;
        p*=RadToDeg;
        y=179.9;

        compSwing();

        compElements.computeBoresightAndUpInstfromInput(targetFrame, instId, r, p, y, compBoresight, up_instFromInput, bounds);

        bsightDir[0]=posSC[0]+compBoresight[0];
        bsightDir[1]=posSC[1]+compBoresight[1];
        bsightDir[2]=posSC[2]+compBoresight[2];
        bsightVec[0]=compBoresight[0];
        bsightVec[1]=compBoresight[1];
        bsightVec[2]=compBoresight[2];
        upVec[0]=up_instFromInput[0];
        upVec[1]=up_instFromInput[1];
        upVec[2]=up_instFromInput[2];
    }




    glGetFloatv(GL_MODELVIEW_MATRIX, modelView);
    glLoadIdentity();


    glTranslated(0.0, 0.0, -geometryTranslate[2]-10.0);

    glDisable(GL_COLOR_MATERIAL);
    glPushMatrix();

    //rotate
    glMultMatrixd(rt);


      
      glDisable(GL_LIGHTING);
      glEnable(GL_LINE_STIPPLE);
      glLineStipple(1 , 0xE0E0);
      glLineWidth(2.5);

      glPushMatrix();
      glBegin(GL_LINE_STRIP);
      qglColor(Qt::yellow);

      
      SpiceDouble bsightVec_bd[3], originalBound[3];
      bsightVec_bd[0] = bsightVec[0];
      bsightVec_bd[1] = bsightVec[1];
      bsightVec_bd[2] = bsightVec[2];

      glVertex3d(posSC[0], posSC[1], posSC[2]);

      bsightVec_bd[0] *= 10.0;
      bsightVec_bd[1] *= 10.0;
      bsightVec_bd[2] *= 10.0;

      vadd_c(posSC, bsightVec_bd, originalBound);

      
      originalBound[0] -= posSC[0];
      originalBound[1] -= posSC[1];
      originalBound[2] -= posSC[2];

      
      vadd_c(posSC, originalBound, originalBound);

      glVertex3d(originalBound[0], originalBound[1], originalBound[2]);

      glEnd();

      glPopMatrix();

      if(FOVLength > 0){
          glPushMatrix();
          glDisable(GL_LINE_STIPPLE);
          visualizeFrustum();
          glPopMatrix();
          glEnable(GL_LINE_STIPPLE);
      }

      spacecraftParam SCParameter;
      if(isNIRS){
          glPushMatrix();

          compElements.computeBoresightAndUpInstfromInput(targetFrame, -130200, r, p, y, compBoresight, up_instFromInput, bounds);

          glDisable(GL_LIGHTING);
          glBegin(GL_LINES);
          qglColor(Qt::blue);
          glVertex3d(posSC[0], posSC[1], posSC[2]);


          SpiceDouble bsightVec_bd[3], originalBound[3];
          bsightVec_bd[0] = compBoresight[0];
          bsightVec_bd[1] = compBoresight[1];
          bsightVec_bd[2] = compBoresight[2];

          bsightVec_bd[0] *= 10.0;
          bsightVec_bd[1] *= 10.0;
          bsightVec_bd[2] *= 10.0;

          vadd_c(posSC, bsightVec_bd, originalBound);


          originalBound[0] -= posSC[0];
          originalBound[1] -= posSC[1];
          originalBound[2] -= posSC[2];


          vadd_c(posSC, originalBound, originalBound);



          glVertex3d(originalBound[0]*10.0, originalBound[1]*10.0, originalBound[2]*10.0);

          glEnd();


          glPopMatrix();
      }

      if(isLIDAR){
          glPushMatrix();

          compElements.computeBoresightAndUpInstfromInput(targetFrame, -130300, r, p, y, compBoresight, up_instFromInput, bounds);

          glDisable(GL_LIGHTING);
          glBegin(GL_LINES);
          glColor3d(0, 255, 255);
          glVertex3d(posSC[0], posSC[1], posSC[2]);


          SpiceDouble bsightVec_bd[3], originalBound[3];
          bsightVec_bd[0] = compBoresight[0];
          bsightVec_bd[1] = compBoresight[1];
          bsightVec_bd[2] = compBoresight[2];

          bsightVec_bd[0] *= 10.0;
          bsightVec_bd[1] *= 10.0;
          bsightVec_bd[2] *= 10.0;

          vadd_c(posSC, bsightVec_bd, originalBound);


          originalBound[0] -= posSC[0];
          originalBound[1] -= posSC[1];
          originalBound[2] -= posSC[2];


          vadd_c(posSC, originalBound, originalBound);



          glVertex3d(originalBound[0]*10.0, originalBound[1]*10.0, originalBound[2]*10.0);

          glEnd();

          glPopMatrix();
      }

      drawVec(target_pos, earth_pos, sun_pos, drawEarthVec, drawSunVec);

      glDisable(GL_LINE_STIPPLE);
      glEnable(GL_LIGHTING);


      glEnable(GL_COLOR_MATERIAL);

      glPushMatrix();
        glTranslated(posSC[0], posSC[1], posSC[2]);

        SCAffineMatrix.setToIdentity();
        SCAffineMatrix.rotate(r, 1.0, 0.0, 0.0);
        SCAffineMatrix.rotate(p, 0.0, 1.0, 0.0);
        SCAffineMatrix.rotate(y, 0.0, 0.0, 1.0);

        glPushMatrix();
          glMultMatrixf(SCAffineMatrix.data());
          glPushMatrix();
            glScaled(1.5, 1.5, 1.5);
            glRotated(180, 0.0, 0.0, 1.0);
            glRotated(90, 1.0, 0.0, 0.0);
            mpSpacecraftModel->draw3DSCModel();
          glPopMatrix();
        glPopMatrix();
      glPopMatrix();

      glPushMatrix();
      mpTargetModel->target3DModel.affineMatrix = affineMatrix;

      if(isTexture){
          glMatrixMode(GL_MODELVIEW);
          glLoadIdentity();

          glTranslated(0.0, 0.0, -geometryTranslate[2]-10.0);
          glMultMatrixd(rt);
          glGetFloatv(GL_MODELVIEW, modelView);
          mpTargetModel->setShadow(depth, bound, simPos, simDir, simUp, modelView, len);

          glMultMatrixf(affineMatrix.data());
          glEnable(GL_POLYGON_OFFSET_FILL);
          glPolygonOffset(1, 1);
          glMatrixMode(GL_TEXTURE);
          glLoadIdentity();

          glTranslated(0.5, 0.5, 0);
          glScaled(0.5, 0.5, 0);
          glFrustum(bound[0], bound[1], bound[2], bound[3], len, 1000);
          gluLookAt(-pos[0], -pos[1], pos[2], -dir[0], -dir[1], dir[2], -up[0], -up[1], up[2]);
          mpTargetModel->setMapTexture(image);

          mpTargetModel->mapShadow(simPos, simDir, simUp, rt, geometryTranslate);
          glDisable(GL_POLYGON_OFFSET_FILL);
      }
        else {
            glMultMatrixf(affineMatrix.data());

            mpTargetModel->drawTarget3DModel();

        }
      glPopMatrix();

    if (mIsFillTarget == true)
    {
        if (mBound.length() == NUMOF_BOUNDARYVECTORS)
        {
            {
                QVector3D a = mBound.at(0) - mBound.at(1);
                QVector3D b = mBound.at(0) - mBound.at(3);
                QVector3D n = QVector3D::crossProduct(b, a);
                n.normalize();

                float xx = (mBound.at(0).x() + mBound.at(1).x() + mBound.at(2).x() + mBound.at(3).x()) / 4.0;
                float yy = (mBound.at(0).y() + mBound.at(1).y() + mBound.at(2).y() + mBound.at(3).y()) / 4.0;
                float zz = (mBound.at(0).z() + mBound.at(1).z() + mBound.at(2).z() + mBound.at(3).z()) / 4.0;
                QVector3D c = QVector3D(xx, yy, zz);
                float d = QVector3D::dotProduct(c, n);

                glEnable(GL_CLIP_PLANE0);
                GLdouble eq[4] = {n.x(), n.y(), n.z(), -d};
                glClipPlane(GL_CLIP_PLANE0, eq);
            }
            for (int i=0; i < NUMOF_PYRAMIDSURFACE; i++)
            {
                int next = i + 1;
                if (next > 3) next = 0;

                QVector3D a = mBound.at(next) - QVector3D(posSC[0], posSC[1], posSC[2]);
                QVector3D b = mBound.at(i) - QVector3D(posSC[0], posSC[1], posSC[2]);
                QVector3D n = QVector3D::crossProduct(b, a);
                n.normalize();

                float xx = (mBound.at(i).x() + mBound.at(next).x() + posSC[0]) / 3.0;
                float yy = (mBound.at(i).y() + mBound.at(next).y() + posSC[1]) / 3.0;
                float zz = (mBound.at(i).z() + mBound.at(next).z() + posSC[2]) / 3.0;
                QVector3D c = QVector3D(xx, yy, zz);
                float d = QVector3D::dotProduct(c, n);

                glEnable(GL_CLIP_PLANE1 + i);
                GLdouble eq[4] = {n.x(), n.y(), n.z(), -d};
                glClipPlane(GL_CLIP_PLANE1 + i, eq);
            }

            glPushMatrix();
            glMultMatrixf(affineMatrix.data());
            static const GLfloat lightamb2[] = { 0.2, 0.4, 0.2, 1.0 };
            glLightfv(GL_LIGHT0, GL_AMBIENT, lightamb2);
            glEnable(GL_POLYGON_OFFSET_FILL);
            glPolygonOffset(-10, 1);
            //mpTargetModel->drawTarget3DModel();
            glDisable(GL_POLYGON_OFFSET_FILL);
            glDisable(GL_CLIP_PLANE0);
            glDisable(GL_CLIP_PLANE1);
            glDisable(GL_CLIP_PLANE2);
            glDisable(GL_CLIP_PLANE3);
            glDisable(GL_CLIP_PLANE4);
            glLightfv(GL_LIGHT0, GL_AMBIENT, lightamb);
            glPopMatrix();
        }
    }

    glDisable(GL_COLOR_MATERIAL);
    glPopMatrix();
}

void drawGLWidget::compSwing(){
    GLdouble v;
    if(step<interval){
        GLdouble t=step/interval;
        v=rollVariation*t;
        for(int i=0; i<(int)(interval/step); i++){
            if(rollVariation>0){
                if(rollDir=="Up"){
                    rollCurrentAngle+=v;
                }
                if(rollDir=="Down"){
                    rollCurrentAngle=rollCurrentAngle-v;
                    cout<<"Down"<<endl;
                }
                if((rollCurrentAngle)>rollUL){
                    rollCurrentAngle=rollUL;
                    cout<<"To down"<<endl;
                    rollDir="Down";
                }
                else if((rollCurrentAngle)<rollLL){
                    rollCurrentAngle=rollLL;
                    cout<<"To up"<<endl;
                    rollDir="Up";
                }
            }
            else if(rollVariation<0){
                if(rollDir=="Up"){
                    rollCurrentAngle=rollCurrentAngle-v;
                }
                if(rollDir=="Down"){
                    rollCurrentAngle=rollCurrentAngle+v;
                }
                if(rollCurrentAngle>rollUL){
                    rollCurrentAngle=rollUL;
                    rollDir="Down";
                }
                else if(rollCurrentAngle<rollLL){
                    rollCurrentAngle=rollLL;
                    rollDir="Up";
                }
            }

            v=pitchVariation*t;

            if(pitchVariation>0){
                if(pitchDir=="Left"){
                    pitchCurrentAngle+=v;
                }
                if(rollDir=="Right"){
                    pitchCurrentAngle-=v;
                }
                if((pitchCurrentAngle)>pitchUL){
                    pitchCurrentAngle=pitchUL;
                    pitchDir="Left";
                }
                else if((pitchCurrentAngle)<pitchLL){
                    pitchCurrentAngle=pitchLL;
                    pitchDir="Right";
                }
            }
            else if(pitchVariation<0){
                if(pitchDir=="Left"){
                    pitchCurrentAngle-=v;
                }
                if(pitchDir=="Right"){
                    pitchCurrentAngle+=v;
                }
                if(pitchCurrentAngle>pitchUL){
                    pitchCurrentAngle=pitchUL;
                    pitchDir="Right";
                }
                else if(pitchCurrentAngle<pitchLL){
                    pitchCurrentAngle=pitchLL;
                    pitchDir="Left";
                }
            }

            v=yawVariation*t;
            if(yawVariation>0){
                if(yawDir=="CCW"){
                    yawCurrentAngle+=v;
                }
                if(yawDir=="CW"){
                    yawCurrentAngle-=v;
                }
                if((yawCurrentAngle)>yawUL){
                    yawCurrentAngle=yawUL;
                    yawDir="CW";
                }
                else if((yawCurrentAngle)<yawLL){
                    yawCurrentAngle=yawLL;
                    yawDir="CCW";
                }
            }
            else if(yawVariation<0){
                if(yawDir=="Up"){
                    yawCurrentAngle-=v;
                }
                if(yawDir=="Down"){
                    yawCurrentAngle+=v;
                }
                if(yawCurrentAngle>yawUL){
                    yawCurrentAngle=yawUL;
                    yawDir="Down";
                }
                else if(yawCurrentAngle<yawLL){
                    yawCurrentAngle=yawLL;
                    yawDir="Up";
                }
            }

            r+=rollCurrentAngle;
            p+=pitchCurrentAngle;
            y+=yawCurrentAngle;

            if(isAutoDrawFootprints==GL_TRUE&&animation==GL_TRUE){
                compElements.computeBoresightAndUpInstfromInput(targetFrame, instId, r, p, y, compBoresight, up_instFromInput, bounds);
                bsightDir[0]=posSC[0]+bsight[0];
                bsightDir[1]=posSC[1]+bsight[1];
                bsightDir[2]=posSC[2]+bsight[2];
                upVec[0]=up_instFromInput[0];
                upVec[1]=up_instFromInput[1];
                upVec[2]=up_instFromInput[2];
                gluLookAt(posSC[0], posSC[1], posSC[2], bsightDir[0], bsightDir[1], bsightDir[2], upVec[0], upVec[1], upVec[2]);
                glGetFloatv(GL_MODELVIEW_MATRIX, modelView);
                emit drawFootprints_signal();
                glLoadIdentity();
            }
        }
    }
    else if(step>interval){
        GLdouble s=step/interval;
        GLdouble a, rv, pv, yv;

        for(int i=0; i<(int)s; i++){
            if(rollVariation>0){
                if(rollDir=="Up"){
                    rollCurrentAngle+=rollVariation;
                }
                else if(rollDir=="Down"){
                    rollCurrentAngle-=rollVariation;
                }
                if(rollCurrentAngle>rollUL){
                    rollCurrentAngle=rollUL;
                    rollDir="Down";
                }
                else if(rollCurrentAngle<rollLL){
                    rollCurrentAngle=rollLL;
                    rollDir="Up";
                }
            }
            else if(rollVariation<0){
                if(rollDir=="Up"){
                    rollCurrentAngle-=rollVariation;
                }
                else if(rollDir=="Down"){
                    rollCurrentAngle+=rollVariation;
                }

                if(rollCurrentAngle>rollUL){
                    rollCurrentAngle=rollUL;
                    rollDir="Down";
                }
                else if(rollCurrentAngle<rollLL){
                    rollCurrentAngle=rollLL;
                    rollDir="Up";
                }
            }

            if(pitchVariation>0){
                if(pitchDir=="Left"){
                    pitchCurrentAngle+=pitchVariation;
                }
                else if(pitchDir=="Right"){
                    pitchCurrentAngle-=pitchVariation;
                }
                if(pitchCurrentAngle>pitchUL){
                    pitchCurrentAngle=pitchUL;
                    pitchDir="Right";
                }
                else if(pitchCurrentAngle<pitchLL){
                    pitchCurrentAngle=rollLL;
                    pitchDir="Left";
                }
            }
            else if(pitchVariation<0){
                if(pitchDir=="Left"){
                    pitchCurrentAngle-=pitchVariation;
                }
                else if(pitchDir=="Right"){
                    pitchCurrentAngle+=pitchCurrentAngle;
                }
                if(pitchCurrentAngle>pitchUL){
                    pitchCurrentAngle=pitchUL;
                    pitchDir="Right";
                }
                else if(pitchCurrentAngle<pitchLL){
                    pitchCurrentAngle=pitchLL;
                    pitchDir="Left";
                }
            }

            if(yawVariation>0){
                if(yawDir=="CCW"){
                    yawCurrentAngle+=yawVariation;
                }
                else if(yawDir=="CW"){
                    yawCurrentAngle-=yawVariation;
                }
                if(yawCurrentAngle>yawUL){
                    yawCurrentAngle=yawUL;
                    yawDir="CW";
                }
                else if(yawCurrentAngle<yawLL){
                    yawCurrentAngle=yawLL;
                    yawDir="CCW";
                }
            }
            else if(yawVariation<0){
                if(yawDir=="CCW"){
                    yawCurrentAngle-=yawVariation;
                }
                else if(yawDir=="CW"){
                    yawCurrentAngle+=yawVariation;
                }
                if(yawCurrentAngle>yawUL){
                    yawCurrentAngle=yawUL;
                    yawDir="CW";
                }
                else if(yawCurrentAngle<yawLL){
                    yawCurrentAngle=yawLL;
                    yawDir="CCW";
                }
            }
            r+=rollCurrentAngle;
            p+=pitchCurrentAngle;
            y+=yawCurrentAngle;

            if(isAutoDrawFootprints==GL_TRUE&&animation==GL_TRUE){
                compElements.computeBoresightAndUpInstfromInput(targetFrame, instId, r, p, y, compBoresight, up_instFromInput, bounds);
                bsightDir[0]=posSC[0]+bsight[0];
                bsightDir[1]=posSC[1]+bsight[1];
                bsightDir[2]=posSC[2]+bsight[2];
                upVec[0]=up_instFromInput[0];
                upVec[1]=up_instFromInput[1];
                upVec[2]=up_instFromInput[2];
                gluLookAt(posSC[0], posSC[1], posSC[2], bsightDir[0], bsightDir[1], bsightDir[2], upVec[0], upVec[1], upVec[2]);
                glGetFloatv(GL_MODELVIEW_MATRIX, modelView);
                emit drawFootprints_signal();
                glLoadIdentity();
            }


        }

        a=(GLint)s-s;
        if(a!=0.0){
            if(a<0){
                a=(-a);
            }
            rv=rollVariation*a;
            pv=pitchVariation*a;
            yv=yawVariation*a;

            if(rollVariation>0){
                if(rollDir=="Up"){
                    rollCurrentAngle+=rv;
                }
                else if(rollDir=="Down"){
                    rollCurrentAngle-=rv;
                }
                if(rollCurrentAngle>rollUL){
                    rollCurrentAngle=rollUL;
                    rollDir="Down";
                }
                else if(rollCurrentAngle<rollLL){
                    rollCurrentAngle=rollLL;
                    rollDir="Up";
                }
            }
            else if(rollVariation<0){
                if(rollDir=="Up"){
                    rollCurrentAngle-=rv;
                }
                else if(rollDir=="Down"){
                    rollCurrentAngle+=rv;
                }

                if(rollCurrentAngle>rollUL){
                    rollCurrentAngle=rollUL;
                    rollDir="Down";
                }
                else if(rollCurrentAngle<rollLL){
                    rollCurrentAngle=rollLL;
                    rollDir="Up";
                }
            }
            if(pitchVariation>0){
                if(pitchDir=="Left"){
                    pitchCurrentAngle+=pv;
                }
                else if(pitchDir=="Right"){
                    pitchCurrentAngle-=pv;
                }
                if(pitchCurrentAngle>pitchUL){
                    pitchCurrentAngle=pitchUL;
                    pitchDir="Right";
                }
                else if(pitchCurrentAngle<pitchLL){
                    pitchCurrentAngle=rollLL;
                    pitchDir="Left";
                }
            }
            else if(pitchVariation<0){
                if(pitchDir=="Left"){
                    pitchCurrentAngle-=pv;
                }
                else if(pitchDir=="Right"){
                    pitchCurrentAngle+=pv;
                }
                if(pitchCurrentAngle>pitchUL){
                    pitchCurrentAngle=pitchUL;
                    pitchDir="Right";
                }
                else if(pitchCurrentAngle<pitchLL){
                    pitchCurrentAngle=pitchLL;
                    pitchDir="Left";
                }
            }

            if(yawVariation>0){
                if(yawDir=="CCW"){
                    yawCurrentAngle+=yv;
                }
                else if(yawDir=="CW"){
                    yawCurrentAngle-=yv;
                }
                if(yawCurrentAngle>yawUL){
                    yawCurrentAngle=yawUL;
                    yawDir="CW";
                }
                else if(yawCurrentAngle<yawLL){
                    yawCurrentAngle=yawLL;
                    yawDir="CCW";
                }
            }
            else if(yawVariation<0){
                if(yawDir=="CCW"){
                    yawCurrentAngle-=yv;
                }
                else if(yawDir=="CW"){
                    yawCurrentAngle+=yv;
                }
                if(yawCurrentAngle>yawUL){
                    yawCurrentAngle=yawUL;
                    yawDir="CW";
                }
                else if(yawCurrentAngle<yawLL){
                    yawCurrentAngle=yawLL;
                    yawDir="CCW";
                }
            }
        }
        r+=rollCurrentAngle;
        p+=pitchCurrentAngle;
        y+=yawCurrentAngle;
    }
    else if(step==interval){
        if(rollVariation>0){
            if(rollDir=="Up"){
                rollCurrentAngle+=rollVariation;
            }
            else if(rollDir=="Down"){
                rollCurrentAngle-=rollVariation;
            }
            if(rollCurrentAngle>=rollUL){
                rollCurrentAngle=rollUL;
                rollDir="Down";
            }
            else if(rollCurrentAngle<=rollLL){
                rollCurrentAngle=rollLL;
                rollDir="Up";
            }
        }
        else if(rollVariation<0){
            if(rollDir=="Up"){
                rollCurrentAngle-=rollVariation;
            }
            else if(rollDir=="Down"){
                rollCurrentAngle+=rollVariation;
            }
            if(rollCurrentAngle>=rollUL){
                rollCurrentAngle=rollUL;
                rollDir="Down";
            }
            else if(rollCurrentAngle<=rollLL){
                rollCurrentAngle=rollLL;
                rollDir="Up";
            }
        }

        if(pitchVariation>0){
            if(pitchDir=="Left"){
                pitchCurrentAngle+=pitchVariation;
            }
            else if(pitchDir=="Right"){
                pitchCurrentAngle-=pitchVariation;
            }
            if(pitchCurrentAngle>pitchUL){
                pitchCurrentAngle=pitchUL;
                pitchDir="Right";
            }
            else if(pitchCurrentAngle<pitchLL){
                pitchCurrentAngle=rollLL;
                pitchDir="Left";
            }
        }
        else if(pitchVariation<0){
            if(pitchDir=="Left"){
                pitchCurrentAngle-=pitchVariation;
            }
            else if(pitchDir=="Right"){
                pitchCurrentAngle+=pitchCurrentAngle;
            }
            if(pitchCurrentAngle>pitchUL){
                pitchCurrentAngle=pitchUL;
                pitchDir="Right";
            }
            else if(pitchCurrentAngle<pitchLL){
                pitchCurrentAngle=pitchLL;
                pitchDir="Left";
            }
        }

        if(yawVariation>0){
            if(yawDir=="CCW"){
                yawCurrentAngle+=yawVariation;
            }
            else if(yawDir=="CW"){
                yawCurrentAngle-=yawVariation;
            }
            if(yawCurrentAngle>yawUL){
                yawCurrentAngle=yawUL;
                yawDir="CW";
            }
            else if(yawCurrentAngle<yawLL){
                yawCurrentAngle=yawLL;
                yawDir="CCW";
            }
        }
        else if(yawVariation<0){
            if(yawDir=="CCW"){
                yawCurrentAngle-=yawVariation;
            }
            else if(yawDir=="CW"){
                yawCurrentAngle+=yawVariation;
            }
            if(yawCurrentAngle>yawUL){
                yawCurrentAngle=yawUL;
                yawDir="CW";
            }
            else if(yawCurrentAngle<yawLL){
                yawCurrentAngle=yawLL;
                yawDir="CCW";
            }
        }
        r+=rollCurrentAngle;
        p+=pitchCurrentAngle;
        y+=yawCurrentAngle;
    }
}





void drawGLWidget::drawInstName(QString instName){
    glPushMatrix();
    glDisable(GL_LIGHTING);
    glRasterPos3d(-0.45, -1.7, 0.5);
    glColor3d(1.0, 1.0, 1.0);
    string str=instName.toStdString();
    int size=(int)str.size();
    for(int i = 0; i < size; ++i){
        char ic = str[i];
        glutBitmapCharacter(GLUT_BITMAP_HELVETICA_18, ic);
    }
    glEnable(GL_LIGHTING);
    glPopMatrix();
}





void drawGLWidget::setLoadSCModelFile_slot(QString name)
{
    if (mpSpacecraftModel)
    {
        mpSpacecraftModel->setSCModelFile(name);
    }
}

void drawGLWidget::setLoadTargetModelFile_slot(QString name)
{
    if (mCurrentTargetName == name){
        return;
    }

    if (mpTargetModel)
    {
        mpTargetModel->setTargetModelFile(name);
    }
}

void drawGLWidget::setLoadSCMTLFile_slot(QString name)
{
    if (mpSpacecraftModel)
    {
        mpSpacecraftModel->setSCMTLFile(name);
    }
}

void drawGLWidget::setLoadTargetMTLFile_slot(QString name)
{
    if (mpTargetModel)
    {
        mpTargetModel->setTargetMTLFile(name);
    }
}

void drawGLWidget::isComputeSubPolygon_slot(GLboolean isComputeSubPolygon){
    this->isComputeSubPolygon=isComputeSubPolygon;
    emit getSubSCPoint_signal(-1);
    updateGL();
}

void drawGLWidget::getResolutionOfModel_slot(){
    if (mpTargetModel)
    {
        QString res=QString::number(mpTargetModel->target3DModel.faceNum);
        emit getResolution_signal(res);
    }
}

void drawGLWidget::visualizationObservedData_slot(QStringList observedPolygon){
    if (mpTargetModel)
    {
        mpTargetModel->visualizePolygon(observedPolygon);
        updateGL();
    }
}

void drawGLWidget::keyPressEvent(QKeyEvent *event){
    
}

void drawGLWidget::mousePressEvent(QMouseEvent *event){
    lastPos=event->pos();
}

void drawGLWidget::mouseMoveEvent(QMouseEvent *event){
    GLfloat dx=GLfloat(event->x()-lastPos.x())/width();
    GLfloat dy=GLfloat(event->y()-lastPos.y())/height();

    if(event->buttons()&Qt::RightButton){
        if(glViewMode=="observerMode"){
            observerRotate[0]+=180*dy;
            observerRotate[1]+=180*dx;
        }

        else if(glViewMode=="targetMode"){
            targetRotate[0]+=180*dy;
            targetRotate[1]+=180*dx;
        }
        else if(glViewMode=="geometryMode"){
            geometryTranslate[0]+=dy;
            geometryTranslate[1]-=dx;
        }
    }

    if(event->buttons()&Qt::LeftButton){
        if(glViewMode=="observerMode"){
            observerTranslate[0]+=dx;
            observerTranslate[1]-=dy;
        }

        else if(glViewMode=="targetMode"){
            targetTranslate[0]+=dx;
            targetTranslate[1]-=dy;
        }

        else if(glViewMode=="geometryMode"){
            geometryRotate[0]+=180*dy;
            geometryRotate[1]+=180*dx;
            geometryRotate[2]+=90*dy + 90*dx;
        }

    }


    double a;

    /* マウスポインタの位置のドラッグ開始位置からの距離 */
    a = sqrt(dx * dx + dy * dy);

    if (a != 0.0) {
      double ar = a * PI;
      double as = sin(ar) / a;
      double dq[4] = { cos(ar), dy * as, dx * as, 0.0 };

      /* クォータニオンを掛けて回転を合成 */
      qmul(tq, dq, cq);

      /* クォータニオンから回転の変換行列を求める */
      qrot(rt, tq);
    }



    //lastPos=event->pos();



    updateGL();
}

void drawGLWidget::qmul(double r[], const double p[], const double q[]){
    r[0] = p[0] * q[0] - p[1] * q[1] - p[2] * q[2] - p[3] * q[3];
    r[1] = p[0] * q[1] + p[1] * q[0] + p[2] * q[3] - p[3] * q[2];
    r[2] = p[0] * q[2] - p[1] * q[3] + p[2] * q[0] + p[3] * q[1];
    r[3] = p[0] * q[3] + p[1] * q[2] - p[2] * q[1] + p[3] * q[0];
}

void drawGLWidget::qrot(double r[], double q[]){
    double x2 = q[1] * q[1] * 2.0;
    double y2 = q[2] * q[2] * 2.0;
    double z2 = q[3] * q[3] * 2.0;
    double xy = q[1] * q[2] * 2.0;
    double yz = q[2] * q[3] * 2.0;
    double zx = q[3] * q[1] * 2.0;
    double xw = q[1] * q[0] * 2.0;
    double yw = q[2] * q[0] * 2.0;
    double zw = q[3] * q[0] * 2.0;

    r[ 0] = 1.0 - y2 - z2;
    r[ 1] = xy + zw;
    r[ 2] = zx - yw;
    r[ 4] = xy - zw;
    r[ 5] = 1.0 - z2 - x2;
    r[ 6] = yz + xw;
    r[ 8] = zx + yw;
    r[ 9] = yz - xw;
    r[10] = 1.0 - x2 - y2;
    r[ 3] = r[ 7] = r[11] = r[12] = r[13] = r[14] = 0.0;
    r[15] = 1.0;

//    for(int i=0; i<16; i++){
//        rotate[i] = r[i];
//    }
}

void drawGLWidget::viewMode_slot(QString mode){
    if(glViewMode!=mode){
        glViewMode=mode;
        updateGL();
    }
}

void drawGLWidget::setIsChangeVal_slot(GLboolean changeval){
    
    if(preET!=et && changeval==GL_TRUE){
        inputXpos=sc_pos[0];
        inputYpos=sc_pos[1];
        inputZpos=sc_pos[2];
        inputRoll=r;
        inputPitch=p;
        inputYaw=y;
        
    }
    isChangeVal=changeval;
    updateGL();
}

void drawGLWidget::setAutoDrawFootprintsDuringScan_slot(GLboolean isAutoDrawFootprints){
    this->isAutoDrawFootprints=isAutoDrawFootprints;
}

void drawGLWidget::wheelEvent(QWheelEvent *event){
    if(glViewMode=="geometryMode")
        geometryTranslate[2]+=(double)event->delta()/120;

    else if(glViewMode=="fovMode"&&harmonicsMode==HARMONICSModes.at(1))
        SCPosTranslate[2]+=(double)event->delta()/120/1000;

    updateGL();
}

void drawGLWidget::timerEvent(QTimerEvent *event){
    Q_UNUSED(event);
    if(et<end_et&&animation==GL_TRUE){
        et+=step;
        preET=et;
        drewShadow=GL_FALSE;
        isRestoredShadowData=GL_FALSE;
    }
    else if(et>=end_et){
        animation=GL_FALSE;
        emit finishedAnim_signal();
    }

    updateGL();
}

void drawGLWidget::startAnimation(){
    if (mpTargetModel)
    {
        animation=GL_TRUE;
        if(isDrawShadow==GL_TRUE){
            mpTargetModel->initTargetPolygonColor("Record");
        }
        glShadeModel(GL_FLAT);
        timer->start(200, this);
    }
}

void drawGLWidget::stopAnimation(){
    animation=GL_FALSE;
    glShadeModel(GL_SMOOTH);

    if(isDrawShadow==GL_TRUE){
        drawShadow();
        drewShadow=GL_TRUE;
    }
    timer->stop();
}

void drawGLWidget::setSwingParameters_slot(SpiceInt interval, SpiceDouble rollLL, SpiceDouble rollUL, SpiceDouble rollVariation, SpiceDouble pitchLL, SpiceDouble pitchUL, SpiceDouble pitchVariation, SpiceDouble yawLL, SpiceDouble yawUL, SpiceDouble yawVariation){
    this->interval=interval;
    this->rollUL=rollUL;
    this->rollLL=rollLL;
    this->rollVariation=rollVariation;
    this->pitchUL=pitchUL;
    this->pitchLL=pitchLL;
    this->pitchVariation=pitchVariation;
    this->yawUL=yawUL;
    this->yawLL=yawLL;
    this->yawVariation=yawVariation;

    rollmid=(rollUL+rollLL)/2;
    pitchmid=(pitchUL+pitchLL)/2;
    yawmid=(yawUL+yawLL)/2;
    rollCurrentAngle=rollmid;
    pitchCurrentAngle=pitchmid;
    yawCurrentAngle=yawmid;
}


void drawGLWidget::saveImage_slot(){
    savefilename=QFileDialog::getSaveFileName(this, tr("Save Screen Image(JPG JPEG PNG BMP TIFF FITS FIT FTS)"),QDir::homePath(), tr("Image File(*.jpg *.jpeg *.png *.bmp *.tiff *.fits *.fit. *.fts)"));
    if(savefilename.isEmpty())
        return ;

    
    updateGL();

    QFileInfo fileinfo;
    fileinfo.setFile(savefilename);
    QString fileExtension=fileinfo.suffix();
    GLint physicalViewport[4];
    glGetIntegerv(GL_VIEWPORT, physicalViewport);

    QImage saveImg=grabFrameBuffer(true).copy(0, 0, width()*(physicalViewport[2]/width()), height()*(physicalViewport[3]/height()));
    QImage scaledSaveImg=saveImg.scaled(1024, 1024, Qt::KeepAspectRatio, Qt::FastTransformation);
    if(fileExtension=="fit"||fileExtension=="fits"||fileExtension=="fts"){

        SpiceLong naxes[]={imageWidth, imageHeight};
        SpiceLong naxis=2;
        GLuint nelements(1);
        QTransform transformM;

        scaledSaveImg=scaledSaveImg.transformed(transformM.rotate(180, Qt::XAxis), Qt::FastTransformation);
        scaledSaveImg=scaledSaveImg.convertToFormat(QImage::Format_RGB32);

        nelements=accumulate(&naxes[0], &naxes[naxis], 1, multiplies<GLuint>());
        GLuint *bits=(GLuint *)scaledSaveImg.bits();

        cout<<scaledSaveImg.bitPlaneCount()<<endl;
        valarray<int> contents(naxes[0]*naxes[1]);
        SpiceLong  fpixel(1);
        auto_ptr<FITS> saveFitsFile(0);

        try{
            saveFitsFile.reset(new FITS(savefilename.toStdString().c_str(), ULONG_IMG, naxis, naxes));

            for(int i=naxes[0]-1; i>=0; i--){
                for(int j=0; j<naxes[1]; j++){
                    contents[(naxes[1]-1-i)*naxes[1]+j]=bits[(naxes[1]-1-j)*naxes[1]+i];
                }
            }

            QString str;
            SpiceDouble tick;

            et2utc_c(et, "ISOC", 0, STRLEN, utc);
            sce2c_c(SCCode.toInt(), et, &tick);
            saveFitsFile->pHDU().addKey("ax1", imageWidth,"pixel");
            saveFitsFile->pHDU().addKey("ax2", imageHeight,"pixel");

            saveFitsFile->pHDU().addKey("TI_0", tick,"Spacecraft Clock");
            saveFitsFile->pHDU().write(fpixel, nelements, contents);
        }
        catch(FITS::CantCreate){
            cout<<"Can't save fits image file"<<endl;
            return ;
        }
    }
    else{
        scaledSaveImg=scaledSaveImg.convertToFormat(QImage::Format_RGB32);

        scaledSaveImg.save(savefilename, 0, -1);
    }
}

void drawGLWidget::drawVec(SpiceDouble target_pos[3], SpiceDouble earth_pos[3], SpiceDouble sun_pos[3], GLboolean drawEarthVec, GLboolean drawSunVec){
    glPushMatrix();
      
      glDisable(GL_LIGHTING);

      glEnable(GL_LINE_STIPPLE);
      glLineStipple(1 , 0xE0E0);
      glLineWidth(2.5);

      
      if(drawEarthVec==GL_TRUE){
          glBegin(GL_LINES);
          qglColor(Qt::green);
          glVertex3d(earth_pos[0], earth_pos[1], earth_pos[2]);
          glVertex3d(target_pos[0], target_pos[0], target_pos[0]);
          glEnd();
      }

       
       if(drawSunVec==GL_TRUE){
           glBegin(GL_LINES);
           qglColor(Qt::red);
           glVertex3d(sun_pos[0], sun_pos[1], sun_pos[2]);
           glVertex3d(target_pos[0], target_pos[0], target_pos[0]);
           glEnd();
       }

       
       glBegin(GL_LINES);
       qglColor(Qt::white);
       glVertex3d(0.0, -10.0, 0.0);
       glVertex3d(0.0, 10.0, 0.0);

//       qglColor(Qt::red);
//       glVertex3d(0, 0, 0);
//       glVertex3d(10, 0, 0);
//       qglColor(Qt::green);
//       glVertex3d(0, 0, 0);
//       glVertex3d(0, 10, 0);
//       qglColor(Qt::cyan);
//       glVertex3d(0, 0, 0);
//       glVertex3d(0, 0, 10);
       glEnd();

       glLineWidth(1.0);
       glDisable(GL_LINE_STIPPLE);
       glEnable(GL_LIGHTING);
     glPopMatrix();
}

void drawGLWidget::drawCenterofFOV(){
    glDisable(GL_DEPTH_TEST);
    glDisable(GL_LIGHTING);
    glMatrixMode(GL_PROJECTION);
    glPushMatrix();
      glLoadIdentity();
      glMatrixMode(GL_MODELVIEW);
      glPushMatrix();
        glLoadIdentity();
        glPushMatrix();
         glBegin(GL_LINE_STRIP);
         qglColor(Qt::yellow);

         glVertex3d(0.0, 0.04, 1.0);
         glVertex3d(0.04, 0.0, 1.0);
         glVertex3d(0.0, -0.04, 1.0);
         glVertex3d(-0.04, 0.0, 1.0);
         glVertex3d(0.0, 0.04, 1.0);

         glEnd();
        glPopMatrix();
        glMatrixMode(GL_PROJECTION);
       glPopMatrix();
       glMatrixMode(GL_MODELVIEW);
     glPopMatrix();
   glEnable(GL_LIGHTING);
   glEnable(GL_DEPTH_TEST);
}

void drawGLWidget::drawOrbit_slot(GLboolean draworbit){
    drawOrbit=draworbit;
    updateGL();
}

void drawGLWidget::drawOrbital(){
    GLUquadric *qobj=gluNewQuadric();
    gluQuadricDrawStyle(qobj, GLU_FILL);
    gluQuadricNormals(qobj, GLU_SMOOTH);
    gluQuadricTexture(qobj, GL_TRUE);

    glEnable(GL_TEXTURE_2D);
    for(int i=0; i<orbitList.length(); i++){
        QVector3D orbitVec=orbitList.at(i);

        glPushMatrix();
         gluSphere(qobj, 0.5, 24, 24);
        glPopMatrix();
    }
}

void drawGLWidget::drawAreaOfFOV_slot(GLboolean areaOfFOV){
    if (mpTargetModel)
    {
        drawAreaOfFOV=areaOfFOV;
        mpTargetModel->isDrawFootprints=areaOfFOV;
        updateGL();
    }
}







QString drawGLWidget::getfileName(){
    return savefilename;
}

void drawGLWidget::setMode_slot(QString mode){
    harmonicsMode=mode;

    if(harmonicsMode==HARMONICSModes.at(2)||harmonicsMode==HARMONICSModes.at(3)){
        isScanning=GL_TRUE;
    }
    else{
        isScanning=GL_FALSE;
    }
    updateGL();
}

void drawGLWidget::setSC_slot(QString sc){
    SCName=sc;
    SpiceBoolean found;
    SpiceInt code;
    bodn2c_c(SCName.toStdString().c_str(), &code, &found);
    SCCode=QString::number(code);
    SpiceBoolean reg=SPICEFALSE;
    for(int i=0; i<SCParameters.length(); i++){
        if(SCParameters.at(i).SCName==SCName){
            reg=SPICETRUE;
            break;
        }
    }

    if(reg==SPICEFALSE){
        spacecraftParam scparam(sc);
        SCParameters.append(scparam);
    }
}

void drawGLWidget::setFrame_slot(QString frame){
    targetFrame=frame;
    updateGL();
}


void drawGLWidget::setInst_slot(QString instName){
    
    this->instName=instName;
    SpiceBoolean isSCReg, isInstReg, found;
    SpiceInt instID, id;

    
    bodn2c_c(instName.toStdString().c_str(), &instID, &found);

    if(!found){
       printf("Instrument name %s could not be translated to an ID code\n", instName.toStdString().c_str());
    }

    isSCReg=SPICEFALSE;
    for(int i=0; i<SCParameters.length(); i++){
        if(SCParameters.at(i).SCName==SCName){
            id=i;
            isSCReg=SPICETRUE;
            break;
        }
    }

    spacecraftParam SCParameter;
    if(isSCReg==SPICETRUE){
        SCParameter=SCParameters.at(id);
        isInstReg=SCParameter.isInstRegistered(instName);
    }

    if(isSCReg==SPICETRUE && isInstReg==SPICEFALSE){
        SCParameter.setInstParam(instName);
        SCParameters[id]=SCParameter;
        QColor color=SCParameter.getFootprintColorCode(instName);
        QString colorName=SCParameter.getFootprintColorName(instName);
        emit setInstrumentsParameters_signal(instName, QString::number(instID), SCParameter.getInstType(instName), QString::number(SCParameter.getFOVAngle(instName)), colorName, color);
    }

   updateGL();
}




void drawGLWidget::setTarget_slot(QString target){
    targetName=target;
}

void drawGLWidget::setTime_slot(SpiceDouble starttime, SpiceDouble endtime, SpiceDouble Animstep){
    if(step!=Animstep&&start_et==starttime&&end_et==endtime){
        step=Animstep;
        return ;
    }
    else if(start_et!=starttime&&end_et==endtime&&step==Animstep){
        start_et=starttime;
        et=starttime;
    }
    else if(start_et==starttime&&end_et!=endtime&&step==Animstep){
        end_et=endtime;
        return ;
    }
    else{
        start_et=starttime;
        end_et=endtime;
        et=starttime;
        step=Animstep;
    }

    updateGL();
}

void drawGLWidget::setInputPosAndAtt_slot(SpiceDouble posX, SpiceDouble posY, SpiceDouble posZ, SpiceDouble roll, SpiceDouble pitch, SpiceDouble yaw){    
    inputXpos=posX;
    inputYpos=posY;
    inputZpos=posZ;
    inputRoll=roll;
    inputPitch=pitch;
    inputYaw=yaw;

    if(animation==GL_FALSE){
        updateGL();
    }
}

void drawGLWidget::sendInstruments_slot(QString SCName,QStringList instNames){
    SpiceBoolean isSCReg, isInstReg, found;
    SpiceInt instID, id;

    for(int i=0; i<instNames.length(); i++){
        
        bodn2c_c(instNames.at(i).toStdString().c_str(), &instID, &found);

        if(!found){
           printf("Instrument name %s could not be translated to an ID code\n", instName.toStdString().c_str());
        }

        isSCReg=SPICEFALSE;
        for(int i=0; i<SCParameters.length(); i++){
            if(SCParameters.at(i).SCName==SCName){
                id=i;
                isSCReg=SPICETRUE;
                break;
            }
        }

        spacecraftParam SCParameter;
        if(isSCReg==SPICETRUE){
            SCParameter=SCParameters.at(id);
            isInstReg=SCParameter.isInstRegistered(instName);
        }
        if(isSCReg==SPICETRUE && isInstReg==SPICEFALSE){
            SCParameter.setInstParam(instName);
            SCParameters[id]=SCParameter;
            QColor color=SCParameter.getFootprintColorCode(instName);
            QString colorName=SCParameter.getFootprintColorName(instName);
            emit setInstrumentsParameters_signal(instName, QString::number(instID), SCParameter.getInstType(instName), QString::number(SCParameter.getFOVAngle(instName)), colorName, color);
        }
    }
}

SpiceInt drawGLWidget::compSubSCPolygon(){
    subPolygonID=-1;

    // MygluUnProject("SubPoint", modelView, subPointProjection, viewport);
    // crossingDetection("Boresight", dummyColor, GL_TRUE);
    return subPolygonID;
}

void drawGLWidget::stepChanged_slot(GLint stepvalue){
    et=et+stepvalue;
    SCPosTranslate[0]=SCPosTranslate[1]=SCPosTranslate[2]=0.0;
    cameravec[0]=cameravec[1]=cameravec[2]=0.0;
    drewShadow=GL_FALSE;
    isRestoredShadowData=GL_FALSE;
    isOnceRestore=GL_FALSE;

    if(animation==GL_FALSE){
        updateGL();   
    }
}

void drawGLWidget::drawSunVec_slot(GLboolean isDrawVec){
    drawSunVec=isDrawVec;
    updateGL();
}

void drawGLWidget::drawEarthVec_slot(GLboolean isDrawVec){
    drawEarthVec=isDrawVec;
    updateGL();
}

void drawGLWidget::drawCenterOfFOV_slot(GLboolean isDrawCenOfFOV){
    isDrawCenterOfFOV=isDrawCenOfFOV;
    updateGL();
}

void drawGLWidget::isDrawFootprints_slot(GLboolean isDrawFootprints){
    if (mpTargetModel)
    {
        drawFootprints=isDrawFootprints;
        mpTargetModel->isDrawFootprints=isDrawFootprints;
    }
}

void drawGLWidget::initializeFootprintsInfo_slot(){
    if (mpTargetModel)
    {
        if(isDrawShadow==GL_FALSE&&drewShadow==GL_FALSE){
            mpTargetModel->initTargetPolygonColor("ALLInit");
        }
        else{
            mpTargetModel->initTargetPolygonColor("Record");
        }

        initializedFootprint=GL_TRUE;
        updateGL();
    }
}


void drawGLWidget::setReadedfile_slot(QString filename){
    readedfilename=filename;

    SpiceDouble fileEt;

    QFileInfo fileinfo;
    fileinfo.setFile(readedfilename);
    QString ext=fileinfo.suffix();
    ext=ext.toLower();
    if(ext=="fit"||ext=="fits"||ext=="fts"){
        auto_ptr<FITS> pInfile(0);


        try{
            pInfile.reset(new CCfits::FITS(filename.toStdString().c_str(), CCfits::Read, true));
            PHDU& fitsImage=pInfile->pHDU();
            string UTC_0;
            fitsImage.readKey("UTC_0", UTC_0);
            utc2et_c(UTC_0.c_str(), &fileEt);
            et=fileEt;
        }
        catch(FitsException& issue){
            cout<<"Can't open fits file"<<endl;

        }
    }
    else{
        QStringList list=readedfilename.split("_");
        if(list.length()>=2){
            scs2e_c(SCCode.toInt(), list.at(1).toStdString().c_str(), &fileEt);
            if(fileEt!=0)
            et=fileEt;
        }
    }
    updateGL();
}

void drawGLWidget::loadcontorImage_slot(QImage img, QString filetype){
    loadedImageFile=img;
    loadedFiletype=filetype;
}

void drawGLWidget::drawOverlay_slot(GLboolean drawOverlay){
    this->drawOverlay=drawOverlay;
    updateGL();
}

void drawGLWidget::drawOverlayImage(QString filename){
    if(filename.isEmpty()){
        return;
    }

    glEnable(GL_BLEND);

    QImage srcImg=loadedImageFile;
    QRgb color;
    int redcolor;

    for(int i=0; i<srcImg.height(); i++){
        for(int j=0; j<srcImg.width(); j++){
            color=srcImg.pixel(j, i);

            redcolor=qRed(color);
            QColor c;
            c.setRgb(redcolor, 0.0, 0.0, 0);
            srcImg.setPixel(j, i, c.rgb());
        }
    }
    QImage glImage=QGLWidget::convertToGLFormat(srcImg);

    glDisable(GL_DEPTH_TEST);
    glDisable(GL_LIGHTING);
    glMatrixMode(GL_PROJECTION);
    glPushMatrix();
      glLoadIdentity();
      glMatrixMode(GL_MODELVIEW);
      glPushMatrix();
        glLoadIdentity();
        glPushMatrix();
          glDrawPixels(glImage.width(), glImage.height(), GL_RGBA, GL_UNSIGNED_BYTE, glImage.bits());
        glPopMatrix();
        glMatrixMode(GL_PROJECTION);
      glPopMatrix();
      glMatrixMode(GL_MODELVIEW);
    glPopMatrix();
    glEnable(GL_LIGHTING);
    glEnable(GL_DEPTH_TEST);
    glDisable(GL_BLEND);

}

void drawGLWidget::createLogFile_slot(GLboolean create){
    logFileCreate=create;
}

void drawGLWidget::prepareFootprint(){
    GLint w, h;
    QString cw="LeftToRight";
    w=h=0;
    WandH.clear();

    subSCPointPolygonArea.append(QVector4D(screenWidth/2, screenHeight/2, 1, 1));
    while(1){
        if(cw=="LeftToRight"){    
            FOVArea.append(QVector4D(w, screenHeight-h+1, 1, 1));
            w++;
            if(w==(screenWidth-1)){
                cw="TopToBottom";
                
            }
        }

        else if(cw=="TopToBottom"){
            FOVArea.append(QVector4D(w-1, screenHeight-h, 1, 1));
            h++;

            if(h==(screenHeight-1)){
                cw="RightToLeft";
                
            }
        }

        else if(cw=="RightToLeft"){
            FOVArea.append(QVector4D(w, screenHeight-h-1, 1, 1));
            w--;

            if(w==0){
                cw="BottomToTop";
            }
        }

        else if(cw=="BottomToTop"){
            FOVArea.append(QVector4D(w+1, screenHeight-h, 1, 1));
            h--;

            if(h==0){
                cw="STOP";
            }
        }

        else if(cw=="STOP"){
            break;
        }
    }

    scientificInstrumentsPeriod.append(WandH.length());

    
    for(int i=238; i<242; i++){
        for(int j=238; j<242; j++){
            boresightArea.append(QVector4D(i, (screenHeight)-j, 2, 1));
        }
    }
}

void drawGLWidget::compBoundingSphere(){
    if (mpTargetModel)
    {
        mpTargetModel->spheresCenter.clear();


        QVector4D Rootshpere=affineMatrix*mpTargetModel->rootSphere.toVector4D();
        mpTargetModel->spheresCenter.append(Rootshpere);


         QVector4D affineVec;
         for(int i=0; i<mpTargetModel->nodeLevel3Spheres.length(); i++){
             affineVec=affineMatrix*mpTargetModel->nodeLevel3Spheres[i].toVector4D();
             mpTargetModel->spheresCenter.append(affineVec);
         }
    }
}

void drawGLWidget::drawFootprintsOnTarget_slot(){
    calculateAffineTranslate();
    compBoundingSphere();

    rayDirection.clear();
    screenStart.clear();

    spacecraftParam SCParameter;
    for(int i=0; i<SCParameters.length(); i++){
        if(SCParameters.at(i).SCName==SCName){
            SCParameter=SCParameters.at(i);
        }
    }
    for(int i=0; i<SCParameter.getRegisteredInstNum(); i++){
        if(SCParameter.instParamsOnSpacecraft.at(i).getIsDrawFootprint()==GL_TRUE){
            instParam instParameter=SCParameter.instParamsOnSpacecraft.at(i);
            instParameter.getProjection(projection);
            // MygluUnProject(instParameter.getInstrumentType(), modelView, projection, viewport);
            // crossingDetection("Boresight", instParameter.getFootprintColorCode(), GL_FALSE);
        }
    }

    if(isAutoDrawFootprints==GL_FALSE)
        updateGL();
}

void drawGLWidget::setIsDrawFootprint_signal(QString instName, SpiceBoolean isdrawFootprint){
    spacecraftParam SCParameter;
    int i=0;
    for(i=0; i<SCParameters.length(); i++){
        if(SCParameters.at(i).SCName==SCName){
            SCParameter=SCParameters.at(i);
        }
    }
    SCParameter.setIsDrawFootprint(instName, isdrawFootprint);
    SCParameters[i]=SCParameter;
}

void drawGLWidget::sendPolygonID_slot(){
    emit getPolygonID_signal(polygonIDInObservedArea, shadowFlag);
}

void drawGLWidget::isDrawShadow_slot(GLboolean drawShadow){
    if (mpTargetModel)
    {
        isDrawShadow=drawShadow;

        if(isDrawShadow!=GL_TRUE){
            mpTargetModel->recordShadow();
            mpTargetModel->overwriteShadowOffData();
        }

        if(isDrawShadow==GL_TRUE&&drewShadow==GL_TRUE){
            isRestoredShadowData=GL_TRUE;
            isOnceRestore=GL_FALSE;
        }
        updateGL();
    }
}




//GLboolean drawGLWidget::crossingDetection(const QString instType, const QColor colorCode, GLboolean subPoint){
//    // openCL;
//    return true;
//}

void drawGLWidget::drawShadow(){
    // openCL
}

QMatrix4x4 drawGLWidget::calculateMatrixInv(const GLfloat* mat){
    QMatrix4x4 matrix(mat);
    return matrix.transposed().inverted();
}

//GLboolean drawGLWidget::MygluUnProject(const QString instType, const GLfloat* const modelView, const GLfloat* const projection, const GLint* const viewport)
//{
//    // openCL
//    return ture;
//}

void drawGLWidget::calculateAffineTranslate(){
    if (!mpTargetModel)
        return;

//    GLuint vertexNum=mpTargetModel->target3DModel.vertexNum;
//    GLuint faceNum=mpTargetModel->target3DModel.faceNum;
//    translatedVertex.clear();
//    translatedVertex.resize(vertexNum);

//    glBindBuffer(GL_ARRAY_BUFFER, mpTargetModel->target3DModel.vboID[0]);

//    GLint clienPtrSize=0;
//    glGetBufferParameteriv(GL_ARRAY_BUFFER, GL_BUFFER_SIZE, &clienPtrSize);

//    cl::Buffer buffer1(context_AffineTranslate, CL_MEM_READ_ONLY|CL_MEM_COPY_HOST_PTR, sizeof(QVector4D)*vertexNum, mpTargetModel->target3DModel.verticesData.data());
//    cl::Buffer buffer2(context_AffineTranslate, CL_MEM_READ_ONLY|CL_MEM_COPY_HOST_PTR, sizeof(QMatrix4x4), &affineMatrix);
//    cl::Buffer buffer3(context_AffineTranslate, CL_MEM_WRITE_ONLY|CL_MEM_COPY_HOST_PTR, sizeof(QVector4D)*translatedVertex.length(), translatedVertex.data());



//    q_AffineTranslate=cl::CommandQueue(context_AffineTranslate, stdDevice[0]);
//    q_AffineTranslate.enqueueWriteBuffer(buffer1, CL_TRUE, 0, sizeof(QVector4D)*vertexNum,mpTargetModel->target3DModel.verticesData.data());
//    q_AffineTranslate.enqueueWriteBuffer(buffer2, CL_TRUE, 0, sizeof(QMatrix4x4), &affineMatrix);
//    q_AffineTranslate.enqueueWriteBuffer(buffer3, CL_TRUE, 0, sizeof(QVector4D)*translatedVertex.length(), translatedVertex.data());

//    kernel_AffineTranslate=cl::Kernel(program_AffineTranslate, "AffineTranslate");

//    kernel_AffineTranslate.setArg(0, buffer1);
//    kernel_AffineTranslate.setArg(1, buffer2);
//    kernel_AffineTranslate.setArg(2, buffer3);


//    cl::NDRange global(faceNum, 1, 1);
//    q_AffineTranslate.enqueueNDRangeKernel(kernel_AffineTranslate, cl::NullRange, global);

//    q_AffineTranslate.enqueueReadBuffer(buffer3, CL_TRUE, 0, sizeof(QVector4D)*translatedVertex.length(), translatedVertex.data());

//    q_AffineTranslate.finish();
//    q_AffineTranslate.flush();

//    glUnmapBuffer(GL_ARRAY_BUFFER);
//    glBindBuffer(GL_ARRAY_BUFFER, 0);
//    glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, 0);
}

void drawGLWidget::compSphereMember(){
    if (!mpTargetModel)
        return;

//    QVector<QVector4D> spheres;
//    QVector<GLboolean> isInPolygons;
//    spheres.clear();
//    GLuint vertexNum=mpTargetModel->target3DModel.vertexNum;
//    GLuint sphereNum=mpTargetModel->nodeLevel3Spheres.length();

//    isInPolygons.resize(mpTargetModel->nodeLevel3Spheres.length());
//    isInPolygons.fill(GL_FALSE);

//    for(int i=0; i<mpTargetModel->nodeLevel3Spheres.length(); i++){
//        spheres.append(mpTargetModel->nodeLevel3Spheres[i].toVector4D());
//    }
//    glBindBuffer(GL_ARRAY_BUFFER, mpTargetModel->target3DModel.vboID[0]);

//    GLint clienPtrSize=0;
//    glGetBufferParameteriv(GL_ARRAY_BUFFER, GL_BUFFER_SIZE, &clienPtrSize);

//    cl::Buffer buffer1(context_CompShpereMember, CL_MEM_READ_ONLY|CL_MEM_COPY_HOST_PTR, sizeof(QVector4D)*spheres.length(), spheres.data());
//    cl::Buffer buffer2(context_CompShpereMember, CL_MEM_READ_ONLY|CL_MEM_COPY_HOST_PTR, sizeof(GLuint), &sphereNum);
//    cl::Buffer buffer3(context_CompShpereMember, CL_MEM_READ_WRITE|CL_MEM_COPY_HOST_PTR, sizeof(QVector4D)*mpTargetModel->target3DModel.verticesData.length(), mpTargetModel->target3DModel.verticesData.data());
//    cl::Buffer buffer4(context_CompShpereMember, CL_MEM_WRITE_ONLY|CL_MEM_COPY_HOST_PTR, sizeof(GLboolean)*isInPolygons.length(), isInPolygons.data());



//    q_CompShpereMember=cl::CommandQueue(context_CompShpereMember, stdDevice[0]);
//    q_CompShpereMember.enqueueWriteBuffer(buffer1, CL_TRUE, 0, sizeof(QVector4D)*spheres.length(), spheres.data());
//    q_CompShpereMember.enqueueWriteBuffer(buffer2, CL_TRUE, 0, sizeof(GLuint), &sphereNum);
//    q_CompShpereMember.enqueueWriteBuffer(buffer1, CL_TRUE, 0, sizeof(QVector4D)*mpTargetModel->target3DModel.verticesData.length(), mpTargetModel->target3DModel.verticesData.data());

//    kernel_CompShpereMember=cl::Kernel(program_CompShpereMember, "AffineTranslate");

//    kernel_CompShpereMember.setArg(0, buffer1);
//    kernel_CompShpereMember.setArg(1, buffer2);
//    kernel_CompShpereMember.setArg(2, buffer1);
//    kernel_CompShpereMember.setArg(3, buffer2);

//    cl::NDRange global(vertexNum, 1, 1);
//    q_CompShpereMember.enqueueNDRangeKernel(kernel_CompShpereMember, cl::NullRange, global);
//    q_CompShpereMember.enqueueReadBuffer(buffer3, CL_TRUE, 0, sizeof(QVector4D)*mpTargetModel->target3DModel.verticesData.length(), mpTargetModel->target3DModel.verticesData.data());
//    q_CompShpereMember.enqueueReadBuffer(buffer4, CL_TRUE, 0, sizeof(GLboolean)*isInPolygons.length(), isInPolygons.data());

//    q_CompShpereMember.finish();
//    q_CompShpereMember.flush();

//    glUnmapBuffer(GL_ARRAY_BUFFER);
//    glBindBuffer(GL_ARRAY_BUFFER, 0);
//    glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, 0);
}

int drawGLWidget::initCL(){
//    cl_int err=CL_SUCCESS;
    
//    stdPlat=platforms.toStdVector();
//    cl::Platform::get(&stdPlat);
//    platforms=platforms.fromStdVector(stdPlat);
//    if(platforms.size()==0){
//        cout<<"No platform\n"<<endl;
//        return EXIT_FAILURE;
//    }

    

    
   

    
    
//    stdPlat[0].getDevices(CL_DEVICE_TYPE_GPU, &stdDevice);
//    devices=devices.fromStdVector(stdDevice);
//    if(devices.size()==0){
//        cerr << "No device.\n";
//        return EXIT_FAILURE;
//    }

    
    

    
//    context_CompRayDir=cl::Context(stdDevice);
//    QString kernelName=":/compRayDirection.cl";
//    QFile file(kernelName);

//    if(file.open(QIODevice::ReadOnly)){

//    }
//    else{
//        cout<<"Can't open file"<<endl;
//        exit(0);
//    }
//    QString kernelSoure=codec->toUnicode(file.readAll());

    
//    cl::Program::Sources source_CompRayDir(1, make_pair(kernelSoure.toLocal8Bit().constData(), kernelSoure.toLocal8Bit().length()+1));

//    program_CompRayDir=cl::Program(context_CompRayDir, source_CompRayDir);
//    if(program_CompRayDir.build(stdDevice)!=CL_SUCCESS){
//        cout<<" Error building: "<<program_CompRayDir.getBuildInfo<CL_PROGRAM_BUILD_LOG>(stdDevice[0])<<"\n";
//        exit(1);
//    }

//    context_ParallelCollision=cl::Context(stdDevice);

//    kernelName=":/parallelCollisionDetection.cl";
//    QFile file2(kernelName);

//    if(file2.open(QIODevice::ReadOnly)){

//    }
//    else{
//        cout<<"parallelCollisionDetection.cl can't open file"<<endl;
//        exit(0);
//    }

//    QString kernelSoure2=codec->toUnicode(file2.readAll());

//    cl::Program::Sources source_ParallelCollision(1, make_pair(kernelSoure2.toLocal8Bit().constData(), kernelSoure2.toLocal8Bit().length()+1));

//    program_ParallelCollision=cl::Program(context_ParallelCollision, source_ParallelCollision);
    
//    if(program_ParallelCollision.build(stdDevice)!=CL_SUCCESS){
//        cout<<"parallelCollisionDetection.cl Error building: "<<program_ParallelCollision.getBuildInfo<CL_PROGRAM_BUILD_LOG>(stdDevice[0])<<"\n";
//                exit(1);
//    }

//    context_AffineTranslate=cl::Context(stdDevice);

//    kernelName=":/AffineTranslate.cl";
//    QFile file3(kernelName);

//    if(file3.open(QIODevice::ReadOnly)){

//    }
//    else{
//        cout<<"affineTranslate.cl Can't open file"<<endl;
//        exit(0);
//    }
//    QString kernelSoure3=codec->toUnicode(file3.readAll());

//    cl::Program::Sources source_AffineTranslate(1, make_pair(kernelSoure3.toLocal8Bit().constData(), kernelSoure3.toLocal8Bit().length()+1));

//    program_AffineTranslate=cl::Program(context_AffineTranslate, source_AffineTranslate);
//    if(program_AffineTranslate.build(stdDevice)!=CL_SUCCESS){
//        cout<<" affineTranslate.cl Error building: "<<program_AffineTranslate.getBuildInfo<CL_PROGRAM_BUILD_LOG>(stdDevice[0])<<"\n";
//                exit(1);
//    }

//    context_DrawShadows=cl::Context(stdDevice);

//    kernelName=":/compShadowing.cl";
//    QFile file4(kernelName);

//    if(file4.open(QIODevice::ReadOnly)){

//    }
//    else{
//        cout<<"compShadowing.cl Can't open file"<<endl;
//        exit(0);
//    }

//    QString kernelSoure4=codec->toUnicode(file4.readAll());
//    cl::Program::Sources source_DrawShadows(1, make_pair(kernelSoure4.toLocal8Bit().constData(), kernelSoure4.toLocal8Bit().length()+1));

//    program_DrawShadows=cl::Program(context_DrawShadows, source_DrawShadows);
    
//    if(program_DrawShadows.build(stdDevice)!=CL_SUCCESS){
//        cout<<" compShadowing.cl Error building: "<<program_DrawShadows.getBuildInfo<CL_PROGRAM_BUILD_LOG>(stdDevice[0])<<"\n";
//        exit(1);
//    }

//    return err;
    return 0; // (CL_SUCCESS == 0 / cl.h)
}

//in: observed image
//    observed time
//compute shadow
//map image
//map shadow
void drawGLWidget::mapTexture_slot(QImage img, QString observedTime){
    SpiceDouble etTmp;
    QString bodyFixed=targetName+"_FIXED";
    SpiceDouble rotate[3][3];
    image = img;

    int TEXSIZE = 512;

    if (!mpTargetModel)
        return;

    etTmp = et;

    SpiceInt id;
    for(int i=0; i<SCParameters.length(); i++){
        if(SCParameters.at(i).SCName==SCName){
            id=i;
        }
    }
    spacecraftParam SCParameter=SCParameters.at(id);
    SpiceDouble boundaryCorners[4][3];
    SpiceDouble forcalLength=SCParameter.getForcalLengthAndBoundaryCorners(instName, boundaryCorners);

    utc2et_c(observedTime.toStdString().c_str(), &mapEt);
    et=mapEt;
    updateGL();

    simPos[0] = posSC[0];
    simPos[1] = posSC[1];
    simPos[2] = posSC[2];
    simDir[0] = bsightDir[0];
    simDir[1] = bsightDir[1];
    simDir[2] = bsightDir[2];
    simUp[0] = upVec[0];
    simUp[1] = upVec[1];
    simUp[2] = upVec[2];

    //compute positions and attitudes before modelviews
    compElements.computeMapElements(targetName, instId, bsight, upVec, bounds, posSC, bsightDir, upVec, mapEt);
    QString targetFIXED=targetName+"_FIXED";
    SpiceDouble rotateLight[3][3];
    pxform_c("HAYABUSA_HP", targetFIXED.toStdString().c_str(), mapEt, rotateLight);

    bound[0] = boundaryCorners[1][0];
    bound[1] = boundaryCorners[0][0];
    bound[2] = boundaryCorners[2][0];
    bound[3] = boundaryCorners[3][0];

    pos[0] = posSC[0];
    pos[1] = posSC[1];
    pos[2] = posSC[2];
    dir[0] = bsightDir[0];
    dir[1] = bsightDir[1];
    dir[2] = bsightDir[2];
    up[0] = upVec[0];
    up[1] = upVec[1];
    up[2] = upVec[2];
    len = forcalLength;


    isTexture = true;
    updateGL();
}

void drawGLWidget::clearTexture_slot(){
    mpTargetModel->setTexture(0);
    isTexture=0;

    updateGL();
}

void drawGLWidget::draw_NIRS_LINE_slot(bool div){
        isNIRS = div;

        update();
}

void drawGLWidget::draw_LIDAR_LINE_slot(bool div){
        isLIDAR = div;

        update();
}

DrawTargetModel* drawGLWidget::getTargetModel_slot(){
    return mpTargetModel;
}

void drawGLWidget::setFOVLength_slot(GLfloat length){
    FOVLength = length;

    update();
}


void drawGLWidget::visualizeFrustum(){

#define STRLEN 100
#define BCVLEN 5

    QString upInstString="INS"+QString::number(instId)+"_UPVECTOR";
    SpiceChar cameraframe[STRLEN];
    SpiceDouble bounds[BCVLEN][3];
    SpiceInt n_bcv;
    SpiceDouble bsight[3];
    SpiceDouble rotate[3][3];
    QVector<QVector3D> bound;

    getfov_c(instId, BCVLEN, STRLEN, STRLEN, shape, cameraframe, bsight, &n_bcv, bounds);

    glDisable(GL_LIGHTING);

    glBegin(GL_LINES);
    qglColor(Qt::yellow);



    for(int i = 0; i < n_bcv; i++){
        SpiceDouble originalBound[3];

        compElements.computeBoresightAndUpInstfromInput(targetFrame, instId, r, p, y, compBoresight, up_instFromInput, bounds);

        bounds[i][0] *= 10.0;
        bounds[i][1] *= 10.0;
        bounds[i][2] *= 10.0;

        glVertex3d(posSC[0], posSC[1], posSC[2]);

        vadd_c(posSC, bounds[i], originalBound);



        originalBound[0] -= posSC[0];
        originalBound[1] -= posSC[1];
        originalBound[2] -= posSC[2];

        if (mFOVLengthFixed)
        {
            SpiceDouble coefficient = (mNumerator / mDenominator);
            FOVLength = coefficient * compElements.computeDistance(posSC, target_pos);
        }

        vscl_c(FOVLength, originalBound, originalBound);


        vadd_c(posSC, originalBound, originalBound);

        glVertex3d(originalBound[0], originalBound[1], originalBound[2]);



        bound.append(QVector3D(originalBound[0], originalBound[1], originalBound[2]));
    }
    glVertex3d(bound.at(0).x(), bound.at(0).y(), bound.at(0).z());
    glVertex3d(bound.at(1).x(), bound.at(1).y(), bound.at(1).z());

    glVertex3d(bound.at(1).x(), bound.at(1).y(), bound.at(1).z());
    glVertex3d(bound.at(2).x(), bound.at(2).y(), bound.at(2).z());

    glVertex3d(bound.at(2).x(), bound.at(2).y(), bound.at(2).z());
    glVertex3d(bound.at(3).x(), bound.at(3).y(), bound.at(3).z());

    glVertex3d(bound.at(3).x(), bound.at(3).y(), bound.at(3).z());
    glVertex3d(bound.at(0).x(), bound.at(0).y(), bound.at(0).z());

    glEnd();

    glEnable(GL_LIGHTING);

    mBound.clear();
    for (int i = 0; i < bound.length(); i++)
    {
        mBound.append(QVector3D(bound[i].x(), bound[i].y(), bound[i].z()));
    }
}

/**
 * @brief drawGLWidget::paintXRS_FOV
 */
void drawGLWidget::paintXRS_FOV()
{
    qDebug("drawGLWidget::paintXRS_FOV()");

    SpiceDouble fov_rate = AMICA_FOV / XRS_FOV;
    SpiceDouble screen_point = 1.0 / fov_rate;

    glDisable(GL_DEPTH_TEST);
    glDisable(GL_LIGHTING);
    glMatrixMode(GL_PROJECTION);
    glPushMatrix();
      glLoadIdentity();
      glMatrixMode(GL_MODELVIEW);
      glPushMatrix();
        glLoadIdentity();
        glPushMatrix();
         glBegin(GL_LINES);
         qglColor(Qt::gray);

         // LT
         glVertex3d(-screen_point, screen_point, 1.0);
         glVertex3d(-screen_point, -screen_point, 1.0);
         // LB
         glVertex3d(-screen_point, -screen_point, 1.0);
         glVertex3d(screen_point, -screen_point, 1.0);
         // RB
         glVertex3d(screen_point, -screen_point, 1.0);
         glVertex3d(screen_point, screen_point, 1.0);
         // RT
         glVertex3d(screen_point, screen_point, 1.0);
         glVertex3d(-screen_point, screen_point, 1.0);

         glEnd();
        glPopMatrix();
        glMatrixMode(GL_PROJECTION);
       glPopMatrix();
       glMatrixMode(GL_MODELVIEW);
     glPopMatrix();
    glEnable(GL_LIGHTING);
    glEnable(GL_DEPTH_TEST);
}

/**
 * @brief drawGLWidget::draw_XRS_FOV_slot
 * @param flag
 */
void drawGLWidget::draw_XRS_FOV_slot(bool flag)
{
    isXRS = flag;
    update();
}

void drawGLWidget::fixed_FOVLENGTH_slot(bool flag)
{
    mFOVLengthFixed = flag;
    update();
}

void drawGLWidget::setCoefficient_FOVLENGTH_slot(SpiceDouble nume, SpiceDouble deno)
{
    mNumerator      = nume;
    mDenominator    = deno;
}

void drawGLWidget::isDisplayParameter_slot(bool flag)
{
    mIsDisplayParameter = flag;
    update();
}

void drawGLWidget::isFillTarget_slot(bool flag)
{
    mIsFillTarget = flag;
    update();
}

void drawGLWidget::onDestroyModels_slot()
{
    onDestroyTargetModel();
    onDestroyTargetSCModel();
}

void drawGLWidget::onCreateModels_slot()
{
    onDestroyModels_slot();
    onCreateTargetModel();
    onCreateTargetSCModel();
}

void drawGLWidget::onReloadTarget_slot(QString name, QString mtl, QString obj)
{
    if (mCurrentTargetName == name)
    {
        return;
    }
    onDestroyTargetModel();
    onCreateTargetModel();
    setLoadTargetMTLFile_slot(mtl);
    setLoadTargetModelFile_slot(obj);
    mCurrentTargetName= name;
}

void drawGLWidget::onDestroyTargetModel()
{
    SAFE_DELETE(mpTargetModel);
}

void drawGLWidget::onCreateTargetModel()
{
    Q_ASSERT(mpTargetModel == NULL);
    mpTargetModel = new DrawTargetModel;
}

void drawGLWidget::onDestroyTargetSCModel()
{
    SAFE_DELETE(mpSpacecraftModel);
}

void drawGLWidget::onCreateTargetSCModel()
{
    Q_ASSERT(mpSpacecraftModel == NULL);
    mpSpacecraftModel = new DrawSpacecraftModel;
}

/**
 * @brief drawGLWidget::onUpdate_slot
 */
void drawGLWidget::onUpdate_slot()
{
    update();
}

void drawGLWidget::textureMapping(){



}
