

//inputandmakeckkernelwindow.h
//(c) 2018 The University of Aizu
//This software is released under the GNU General Public License.


#ifndef INPUTANDMAKECKKERNELWINDOW_H
#define INPUTANDMAKECKKERNELWINDOW_H

#include <QMainWindow>
#include <QWidget>
#include <QtGui>
#include <iostream>
#include <QFile>
#include <QFileDialog>
#include <QTextStream>
#include <QMessageBox>
#include <QTextBrowser>
#include "SpiceUsr.h"
#include "cksetfiledialog.h"

#define LENOUT 32

using namespace std;

namespace Ui {
class InputAndMakeCKKernelWindow;
}

class InputAndMakeCKKernelWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit InputAndMakeCKKernelWindow(QWidget *parent = 0);
    ~InputAndMakeCKKernelWindow();

private:
    Ui::InputAndMakeCKKernelWindow *ui;
    SpiceBoolean firstLine;
    QString CKDataFileName;
    QString CKFileName;
    QHash<SpiceDouble, QString> dataHash;
    SpiceBoolean ckDataFileInput;
    SpiceChar timeFormat[27]="YYYY Mon DD HR:MN:SC ::UTC";
    QTextStream saveCKTextStream;
    CKSetFileDialog *ckSettingFile;

    
    const QString CKSettingFileName="./CKsetFile.txt";
    QProcess MKSPKprocess;
    QProcess MSOPCKprocess;
    const QString makeCKComFormat="/usr/local/bin/msopck";
    

    QString makeCKCommand;
    QString ckFileName;
    SpiceBoolean isCreateCKKernel;
    const QString rmfile="rm /Users/s1190244/Desktop/";
    QString RemoveSettingfile;
    QString RemoveDataFile;
    QProcess RemoveFileprocess;

signals:
    void getCKData_signal();
    void sendCKDataName_signal(QString);
    void CKTextSettingFile_signal();
    void createCKSettingFile_signal();
    void succeededCKKernel_signal(SpiceBoolean);
    void isAutoRecordCK_signal(SpiceBoolean);

public slots:
    void sendCKData_slot(SpiceDouble, SpiceDouble, SpiceDouble, SpiceDouble);
    void on_WriteDateButton_clicked();
    void on_saveCKDataButton_clicked();
    void setCKParam_slot(QString, SpiceInt);
    void setLSKFile_slot(QString);
    void setSCLKFile_slot(QString);
    void setFKFile_slot(QString);

    void MSOPCKfinished(int exitCode, QProcess::ExitStatus exitStatus);
    void MSOPCKError(QProcess::ProcessError error);
    void MSOPCKreadyReadStandardOutput();
    void MSOPCKreadyReadStandardError();

    void RemoveFilefinished(int exitCode, QProcess::ExitStatus exitStatus);
    void RemoveFileError(QProcess::ProcessError error);
    void RemoveFilereadyReadStandardOutput();
    void RemoveFilereadyReadStandardError();
    void on_actionShow_Setting_FIle_triggered();
    void on_closeButton_clicked();
    void on_actionAuto_Record_attidutes_from_MainWindow_triggered();

};

#endif 
