

//instrumentonscmainwindow.cpp
//(c) 2018 The University of Aizu
//This software is released under the GNU General Public License.


#include "instrumentonscmainwindow.h"
#include "ui_instrumentonscmainwindow.h"
#include <QDebug>

instrumentonSCMainWindow::instrumentonSCMainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::instrumentonSCMainWindow)
{
    ui->setupUi(this);
    ui->instmentTableWidget->setEditTriggers(QAbstractItemView::NoEditTriggers);
    ui->instmentTableWidget->setSelectionMode(QAbstractItemView::NoSelection);
    checkBoxMapper=new QSignalMapper(ui->instmentTableWidget);
    ui->instmentTableWidget->setColumnWidth(0, 170);
    ui->instmentTableWidget->setColumnWidth(1, 90);
    ui->instmentTableWidget->setColumnWidth(2, 95);
    ui->instmentTableWidget->setColumnWidth(3, 70);
    ui->instmentTableWidget->setColumnWidth(4, 95);
    ui->instmentTableWidget->setColumnWidth(5, 90);

    
    
   
}

instrumentonSCMainWindow::~instrumentonSCMainWindow()
{
    delete ui;
}

void instrumentonSCMainWindow::setInstrumentsParameters_slot(QString instName, QString instID, QString instType, QString FOVAngle, QString color, QColor colorCode){
    
    item[0]=new QTableWidgetItem(instName);
    item[1]=new QTableWidgetItem(instID);
    item[2]=new QTableWidgetItem(instType);
    item[3]=new QTableWidgetItem(FOVAngle);
    item[4]=new QTableWidgetItem(color);

    int n=ui->instmentTableWidget->rowCount();
    ui->instmentTableWidget->setRowCount(n+1);

    
    QCheckBox *loadCheckBox=new QCheckBox();
    loadCheckBox->setChecked(true);

    ui->instmentTableWidget->setItem(0, 0, item[0]);
    ui->instmentTableWidget->setItem(0, 1, item[1]);
    ui->instmentTableWidget->setItem(0, 2, item[2]);
    ui->instmentTableWidget->setItem(0, 3, item[3]);
    ui->instmentTableWidget->setItem(0, 4, item[4]);


    

    
    

    ui->instmentTableWidget->setCellWidget(n, 5, loadCheckBox);
    connect(loadCheckBox, SIGNAL(toggled(bool)), checkBoxMapper, SLOT(map()));
    checkBoxMapper->setMapping(loadCheckBox, n);
    connect(checkBoxMapper, SIGNAL(mapped(int)), this, SLOT(drawFootprintCheck_slot(int)));
}

void instrumentonSCMainWindow::drawFootprintCheck_slot(int i){
    QCheckBox *checkBox=static_cast<QCheckBox *>(ui->instmentTableWidget->cellWidget(i, 5));
    
    
    if(checkBox->checkState()==Qt::Checked){
        emit setIsDrawFootprint_signal(ui->instmentTableWidget->item(i, 0)->text(), SPICETRUE);
    }
    else{
        emit setIsDrawFootprint_signal(ui->instmentTableWidget->item(i, 0)->text(), SPICEFALSE);
    }
}

void instrumentonSCMainWindow::on_pushButton_clicked()
{
    this->close();
}
