

//parallelCollisionDetection.cl
//(c) 2018 The University of Aizu
//This software is released under the GNU General Public License.


#define EPSILON 0.000001f
#define DELTA 1/1024
#define M_PI 3.14159f

__kernel void collisionDetection(__global const float4* vertex, __global const int* vertexN, __global float4* start, __global const float4* rayDirection, __global const float4* spheres, __global const float4* polygonColor, __global const bool* isFOV, __global const bool* compSubPolygon,  __global const float4* frustum, __global float4* detectionPolygonColor, __global int* subPolygonID, __global bool* isPolygonIDObserved){
    //printf("collisionDetection\n");
    const unsigned int n=get_global_id(0)*3;
    float t, tmin, det, inv_det, u, v, angle;
    float4 t0, t1, pvec, qvec, tvec, vec0, vec1, vec2, normalVec, rayVec;
    float3 grav, qvec3D, pvec3D;
    bool crossingDec;
    float sphere_sq;
    float4 xc;
    float3 xc3D;
    float xc2;
    float3 rayDirection3D;
    float vxc;
    float distance;
    int hitPolygonID, polygonID, minDisSphere, id;
    bool isHitNodeSphere[512];
    tmin=1000000;
    float distanceLightToHitPolygon, distanceLightToShadowPolygon;
    float nodeSphereR;
    float4 shadowRay;
    float4 shadowStart;
    bool isHitRay=false;
    int i, p, k;
    //float distanceSCToInsidePolygon, distanceSCToOtherPolygon;
    bool inFrustum=true;
    float d;

if(*isFOV){
    vec0=vertex[n];
    vec1=vertex[n+1];
    vec2=vertex[n+2];

    for(p=0; p<6; p++){
        k=0;
        d=frustum[p].x*vec0.x+frustum[p].y*vec0.y+frustum[p].z*vec0.z+frustum[p].w;
        if(d<0){
            //inFrustum=false;
            k++;
            //return;
        }

        d=frustum[p].x*vec1.x+frustum[p].y*vec1.y+frustum[p].z*vec1.z+frustum[p].w;

        if(d<0){
            //inFrustum=false;
            k++;
            //return;
        }

        d=frustum[p].x*vec2.x+frustum[p].y*vec2.y+frustum[p].z*vec2.z+frustum[p].w;

        if(d<0){
            //inFrustum=false;
            k++;
            //return;
        }


        if(k>=2){
            inFrustum=false;
            return;
        }
    }

    t0=vec1-vec0;
    t1=vec2-vec0;
    normalVec.x=t0.y*t1.z-t0.z*t1.y;
    normalVec.y=t0.z*t1.x-t0.x*t1.z;
    normalVec.z=t0.x*t1.y-t0.y*t1.x;

    normalVec=normalize(normalVec);
    normalVec.x=-normalVec.x;
    normalVec.y=-normalVec.y;
    normalVec.z=-normalVec.z;

    angle=((normalVec.x*rayDirection[0].x)+(normalVec.y*rayDirection[0].y)+(normalVec.z*rayDirection[0].z));
    angle=acos(angle)*180.0f/M_PI;

    if(90<=angle){
        inFrustum=false;
        return;
    }

    rayVec.x=((vec0.x+vec1.x+vec2.x)/3.0f)-start[0].x;
    rayVec.y=((vec0.y+vec1.y+vec2.y)/3.0f)-start[0].y;
    rayVec.z=((vec0.z+vec1.z+vec2.z)/3.0f)-start[0].z;
    //rayVec.x=start[0].x-((vec0.x+vec1.x+vec2.x)/3.0f);
    //rayVec.y=start[0].y-((vec0.y+vec1.y+vec2.y)/3.0f);
    //rayVec.z=start[0].z-((vec0.z+vec1.z+vec2.z)/3.0f);

    rayVec=normalize(rayVec);

    pvec3D.x=(rayVec.y*t1.z-rayVec.z*t1.y);
    pvec3D.y=(rayVec.z*t1.x-rayVec.x*t1.z);
    pvec3D.z=(rayVec.x*t1.y-rayVec.y*t1.x);

    det=t0.x*pvec3D.x+t0.y*pvec3D.y+t0.z*pvec3D.z;
    inv_det=1.0f/det;
    tvec=start[0]-vec0;

    qvec3D.x=(tvec.y*t0.z-tvec.z*t0.y);
    qvec3D.y=(tvec.z*t0.x-tvec.x*t0.z);
    qvec3D.z=(tvec.x*t0.y-tvec.y*t0.x);
    t=t1.x*qvec3D.x+t1.y*qvec3D.y+t1.z*qvec3D.z;
    t*=inv_det;
    tmin=t;


    for(i=0; i< *vertexN; i+=3){
        vec0=vertex[i];
        vec1=vertex[i+1];
        vec2=vertex[i+2];

        t0=vec1-vec0;
        t1=vec2-vec0;
        normalVec.x=t0.y*t1.z-t0.z*t1.y;
        normalVec.y=t0.z*t1.x-t0.x*t1.z;
        normalVec.z=t0.x*t1.y-t0.y*t1.x;

        normalVec=normalize(normalVec);
        normalVec.x=-normalVec.x;
        normalVec.y=-normalVec.y;
        normalVec.z=-normalVec.z;

        angle=((normalVec.x*rayVec.x)+(normalVec.y*rayVec.y)+(normalVec.z*rayVec.z));
        angle=acos(angle)*180.0f/M_PI;

        if(90<=angle){
            continue;
        }

        pvec3D.x=(rayVec.y*t1.z-rayVec.z*t1.y);
        pvec3D.y=(rayVec.z*t1.x-rayVec.x*t1.z);
        pvec3D.z=(rayVec.x*t1.y-rayVec.y*t1.x);

        det=t0.x*pvec3D.x+t0.y*pvec3D.y+t0.z*pvec3D.z;

        if(det<EPSILON){
            continue;
        }

        if(det>-EPSILON && det<EPSILON){
            continue;
        }

        inv_det=1.0/det;
        tvec=start[0]-vec0;
        u=tvec.x*pvec3D.x+tvec.y*pvec3D.y+tvec.z*pvec3D.z;
        u*=inv_det;

        if(u<0.0f || u>1.0f){
            continue;
        }

        qvec3D.x=(tvec.y*t0.z-tvec.z*t0.y);
        qvec3D.y=(tvec.z*t0.x-tvec.x*t0.z);
        qvec3D.z=(tvec.x*t0.y-tvec.y*t0.x);

        v=rayVec.x*qvec3D.x+rayVec.y*qvec3D.y+rayVec.z*qvec3D.z;
        v*=inv_det;

        if(v<0.0f || u+v>1.0f){
            continue;
        }

        t=t1.x*qvec3D.x+t1.y*qvec3D.y+t1.z*qvec3D.z;
        t*=inv_det;

        if(0<t && t<tmin){
            inFrustum=false;
            return;
        }
    }

    if(inFrustum){
        isPolygonIDObserved[n/3]=true;
        if(detectionPolygonColor[n].w==(*polygonColor).w){
            return ;
        }

        detectionPolygonColor[n].x=(*polygonColor).x;
        detectionPolygonColor[n].y=(*polygonColor).y;
        detectionPolygonColor[n].z=(*polygonColor).z;

        detectionPolygonColor[n+1].x=(*polygonColor).x;
        detectionPolygonColor[n+1].y=(*polygonColor).y;
        detectionPolygonColor[n+1].z=(*polygonColor).z;

        detectionPolygonColor[n+2].x=(*polygonColor).x;
        detectionPolygonColor[n+2].y=(*polygonColor).y;
        detectionPolygonColor[n+2].z=(*polygonColor).z;


        if(detectionPolygonColor[n].w==0.0){
            detectionPolygonColor[n].w=(*polygonColor).w;
            detectionPolygonColor[n+1].w=(*polygonColor).w;
            detectionPolygonColor[n+2].w=(*polygonColor).w;
        }

        else if(detectionPolygonColor[n].w==100.0){
            detectionPolygonColor[n].w=(*polygonColor).w+100;
            detectionPolygonColor[n+1].w=(*polygonColor).w+100;
            detectionPolygonColor[n+2].w=(*polygonColor).w+100;
        }
    }
    }

    else{
        id=n/3;
        sphere_sq=spheres[0].w*spheres[0].w;
        xc=convert_float4(start[id]-spheres[0]);
        xc3D=float3(xc.x, xc.y, xc.z);
        xc2=xc.x*xc.x+xc.y*xc.y+xc.z*xc.z;
        rayDirection3D=float3(rayDirection[id].x, rayDirection[id].y, rayDirection[id].z);
        vxc=xc.x*rayDirection[id].x+xc.y*rayDirection[id].y+xc.z*rayDirection[id].z;
        distance=vxc*vxc-xc2+sphere_sq;


        if(distance<0.0f){
             //printf("Not hit Root bounding sphere\n");
             return;
         }

        float tn=-vxc-sqrt(distance);
        float tp=-vxc+sqrt(distance);

        if(tn<0.0f && tp<0.0f){
            //printf("ray back\n");
            return;
        }

        else if(tn>0.0f && tp>0.0f){
             //printf("hit root bounding shpere\n");
        }

        for(i=1; i<513; i++){
            if(spheres[i].w>0){
                sphere_sq=spheres[i].w*spheres[i].w;
                break;
            }
        }

        for(i=1; i<513; i++){
            if(spheres[i].w<=0){
                 isHitNodeSphere[i-1]=false;
                 continue;
           }
           xc=convert_float4(start[id]-spheres[i]);
           xc2=xc2=xc.x*xc.x+xc.y*xc.y+xc.z*xc.z;
           vxc=xc.x*rayDirection[id].x+xc.y*rayDirection[id].y+xc.z*rayDirection[id].z;

           distance=vxc*vxc-xc2+sphere_sq;

           if(distance<0.0f){
                //printf("i%d: bounding shpere not hit\n", (i-1));
                isHitNodeSphere[i-1]=false;
                continue;
            }

            tn=-vxc-sqrt(distance);
            tp=-vxc+sqrt(distance);
            //printf("openCL %d: tn: %f tp:%f\n", i, tn, tp);

            if(tn<0.0f && tp<0.0f){
                //printf("ray back\n");
                isHitNodeSphere[i-1]=false;
                continue;
            }

            else if(tn>0.0f && tp>0.0f){
                //printf("OpenCL Number:%d bounding sphere hit\n", (i-1));
                isHitNodeSphere[i-1]=true;
            }
        }

        polygonID=-1;

        unsigned int vertexMemberId;
        for(i=0; i< *vertexN; i+=3){
            vertexMemberId=round(vertex[i].w);

            if(!isHitNodeSphere[vertexMemberId]){
                //printf("i:%d nodesphere:%d not hit\n", i, vertexMemberId);
                continue;
            }

            vec0=vertex[i];
            vec1=vertex[i+1];
            vec2=vertex[i+2];

            t0=vec1-vec0;
            t1=vec2-vec0;
            normalVec.x=t0.y*t1.z-t0.z*t1.y;
            normalVec.y=t0.z*t1.x-t0.x*t1.z;
            normalVec.z=t0.x*t1.y-t0.y*t1.x;

            normalVec=normalize(normalVec);
            normalVec.x=-normalVec.x;
            normalVec.y=-normalVec.y;
            normalVec.z=-normalVec.z;

            angle=((normalVec.x*rayDirection[id].x)+(normalVec.y*rayDirection[id].y)+(normalVec.z*rayDirection[id].z));
            angle=acos(angle)*180.0/M_PI;

            if(90<angle){
                continue;
            }

            pvec3D.x=(rayDirection[id].y*t1.z-rayDirection[id].z*t1.y);
            pvec3D.y=(rayDirection[id].z*t1.x-rayDirection[id].x*t1.z);
            pvec3D.z=(rayDirection[id].x*t1.y-rayDirection[id].y*t1.x);
            det=t0.x*pvec3D.x+t0.y*pvec3D.y+t0.z*pvec3D.z;

            if(det<EPSILON){
                //printf("Culling\n");
                continue;
            }

            if(det>-EPSILON && det<EPSILON){
                //printf("not collision\n");
                continue;
            }

            inv_det=1/det;
            tvec=start[id]-vec0;
            u=tvec.x*pvec3D.x+tvec.y*pvec3D.y+tvec.z*pvec3D.z;
            u*=inv_det;

            if(u<0.0f || u>1.0f){
                //printf("2\n");
                continue;
            }

            qvec3D.x=(tvec.y*t0.z-tvec.z*t0.y);
            qvec3D.y=(tvec.z*t0.x-tvec.x*t0.z);
            qvec3D.z=(tvec.x*t0.y-tvec.y*t0.x);

            v=rayDirection[id].x*qvec3D.x+rayDirection[id].y*qvec3D.y+rayDirection[id].z*qvec3D.z;
            v*=inv_det;
            //printf("OpenCL v:%f\n", v);
            if(v<0.0f || u+v>1.0f){
               //printf("3\n");
               continue;
            }

            t=t1.x*qvec3D.x+t1.y*qvec3D.y+t1.z*qvec3D.z;
            t*=inv_det;
            //printf("t:%f\n", t);
            if(0<t && t<tmin){
               polygonID=i;
               tmin=t;
            }

            //printf("i:%d ray hit\n", i);
        }

        if(polygonID>0){
            if(*compSubPolygon){
                *subPolygonID=polygonID;
                return;
            }

            if(detectionPolygonColor[polygonID].w==(*polygonColor).w){
                return ;
            }

            detectionPolygonColor[polygonID].x=(*polygonColor).x;
            detectionPolygonColor[polygonID].y=(*polygonColor).y;
            detectionPolygonColor[polygonID].z=(*polygonColor).z;

            detectionPolygonColor[polygonID+1].x=(*polygonColor).x;
            detectionPolygonColor[polygonID+1].y=(*polygonColor).y;
            detectionPolygonColor[polygonID+1].z=(*polygonColor).z;

            detectionPolygonColor[polygonID+2].x=(*polygonColor).x;
            detectionPolygonColor[polygonID+2].y=(*polygonColor).y;
            detectionPolygonColor[polygonID+2].z=(*polygonColor).z;


            if(detectionPolygonColor[polygonID].w==0.0){
                detectionPolygonColor[polygonID].w=(*polygonColor).w;
                detectionPolygonColor[polygonID+1].w=(*polygonColor).w;
                detectionPolygonColor[polygonID+2].w=(*polygonColor).w;
                //printf("polygonID:%d w:%f\n", polygonID, detectionPolygonColor[polygonID+2].w);

            }

            else if(detectionPolygonColor[polygonID].w==100.0){
                detectionPolygonColor[polygonID].w=(*polygonColor).w+100;
                detectionPolygonColor[polygonID+1].w=(*polygonColor).w+100;
                detectionPolygonColor[polygonID+2].w=(*polygonColor).w+100;
            }

            else{
                //if(200<detectionPolygonColor[polygonID].w){
                detectionPolygonColor[polygonID].w=(*polygonColor).w+100;
                detectionPolygonColor[polygonID+1].w=(*polygonColor).w+100;
                detectionPolygonColor[polygonID+2].w=(*polygonColor).w+100;

            }
    }
    }
}
