

//spksetfiledialog.cpp
//(c) 2018 The University of Aizu
//This software is released under the GNU General Public License.


#include "spksetfiledialog.h"
#include "ui_spksetfiledialog.h"

SPKSetFileDialog::SPKSetFileDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SPKSetFileDialog)
{
    ui->setupUi(this);
    
    inputDataFileName="";
    BEGINDATA="\\begindata";
    INPUT_DATA_TYPE="INPUT_DATA_TYPE   = 'STATES'";
    OUTPUT_SPK_TYPE="OUTPUT_SPK_TYPE   = 9";
    
    
    
    
    
    
    
    
    
    
    
    PRODUCER_ID="PRODUCER_ID       = 'HARMONICS2'";
    DATA_ORDER="DATA_ORDER        = 'EPOCH X Y Z VX VY VZ'";
    INPUT_DATA_UNITS="INPUT_DATA_UNITS  = ('ANGLES=DEGREES' 'DISTANCES=km')";
    DATA_DELIMITER="DATA_DELIMITER    = ' '";
    LINES_PER_RECORD="LINES_PER_RECORD  = 1";
    
    LEAPSECONDS_FILE="LEAPSECONDS_FILE  = ";
    IGNORE_FIRST_LINE="IGNORE_FIRST_LINE = 0";
    POLYNOM_DEGREE="POLYNOM_DEGREE    = 2";
    SEGMENT_ID="SEGMENT_ID	     = 'SPK_STATES_09'";
    
    
    
    
    initSetFile=false;
    overWrite=false;
}

SPKSetFileDialog::~SPKSetFileDialog()
{
    delete ui;
}

void SPKSetFileDialog::createSPKSettingFile_slot(){
    
    
    QFile spkSetfile("./SPKsetFile.txt");
    cout<<"call create spk setting file"<<endl;
    spkSetfile.open(QIODevice::WriteOnly);
    QTextStream SPKSetStream(&spkSetfile);
    SPKSetStream <<ui->SPKSetTextEdit->toPlainText();
    SPKSetStream.flush();
    spkSetfile.close();
}

void SPKSetFileDialog::setSPKParam_slot(QString frame, QString targetName, QString SCName){
    this->frame=frame;
    this->targetName=targetName;
    this->SCName=SCName;

    SpiceBoolean found;
    bodn2c_c(SCName.toStdString().c_str(), &SCId, &found);
    
    bodn2c_c(targetName.toStdString().c_str(), &targetId, &found);
    
}

void SPKSetFileDialog::setSPKParam(QString frame, QString targetName, QString SCName){
    this->frame=frame;
    this->targetName=targetName;
    this->SCName=SCName;

    SpiceBoolean found;
    bodn2c_c(SCName.toStdString().c_str(), &SCId, &found);
    
    bodn2c_c(targetName.toStdString().c_str(), &targetId, &found);
    
}

void SPKSetFileDialog::setSPKKenrelAndDataName(QString spkName, QString dataName){
    outputSPKFileName=spkName;
    inputDataFileName=dataName;
}

void SPKSetFileDialog::SPKTextSettingFile_slot(){
    QString str;
    if(!outputSPKFileName.isEmpty()){

    
        
        
        
        
        
        
        

        
    }

    QStringList spkfile=inputDataFileName.split("/");
    

    QString datafile="/Users/s1190244/Desktop/"+spkfile.at(spkfile.length()-1);
    

    datafile.replace(datafile.length()-3, 3, "txt");
    cout<<"in set file SPKDataName_slot name: "<<datafile.toStdString()<<endl;

    

    ui->SPKSetTextEdit->clear();
    
        
        OBJECT_ID=plainOBJECT_ID+QString::number(SCId);
        
        OBJECT_NAME=plainOBJECT_NAME+"'"+SCName+"'";
        
        CENTER_ID=plainCENTER_ID+QString::number(targetId);
        CENTER_NAME=plainCENTER_NAME+"'"+targetName+"'";
        FRAME_DEF_FILE=plainFRAME_DEF_FILE+"'"+fkFile+"'";
        REF_FRAME_NAME=plainREF_FRAME_NAME+"'"+frame+"'";
        LEAPSECONDS_FILE=plainLEAPSECONDS_FILE+"'"+lskFile+"'";
        INPUT_DATA_FILE=plainINPUT_DATA_FILE+"'"+inputDataFileName+"'";
        

        OUTPUT_SPK_FILE=plainOUTPUT_SPK_FILE+"'"+outputSPKFileName+"'";

        ui->SPKSetTextEdit->append(BEGINDATA);
        ui->SPKSetTextEdit->append(INPUT_DATA_TYPE);
        ui->SPKSetTextEdit->append(OUTPUT_SPK_TYPE);
        ui->SPKSetTextEdit->append(OBJECT_ID);
        ui->SPKSetTextEdit->append(OBJECT_NAME);
        ui->SPKSetTextEdit->append(CENTER_ID);
        ui->SPKSetTextEdit->append(CENTER_NAME);
        ui->SPKSetTextEdit->append(FRAME_DEF_FILE);
        ui->SPKSetTextEdit->append(REF_FRAME_NAME);
        ui->SPKSetTextEdit->append(PRODUCER_ID);
        ui->SPKSetTextEdit->append(DATA_ORDER);
        ui->SPKSetTextEdit->append(INPUT_DATA_UNITS);
        ui->SPKSetTextEdit->append(DATA_DELIMITER);
        ui->SPKSetTextEdit->append(LINES_PER_RECORD);
        ui->SPKSetTextEdit->append(LEAPSECONDS_FILE);
        ui->SPKSetTextEdit->append(IGNORE_FIRST_LINE);
        ui->SPKSetTextEdit->append(POLYNOM_DEGREE);
        ui->SPKSetTextEdit->append(SEGMENT_ID);
        ui->SPKSetTextEdit->append(INPUT_DATA_FILE);
        ui->SPKSetTextEdit->append(OUTPUT_SPK_FILE);
        ui->SPKSetTextEdit->append("\n");

        
    
}

void SPKSetFileDialog::setLSKFile_slot(QString lsk){
    lskFile=lsk;
}

void SPKSetFileDialog::setFKFile_slot(QString fk){
    fkFile=fk;
}
void SPKSetFileDialog::setLSKFile(QString lsk){
    lskFile=lsk;
}

void SPKSetFileDialog::setFKFile(QString fk){
    fkFile=fk;
}

void SPKSetFileDialog::setInputDataFileName_slot(QString fileName){
    inputDataFileName=fileName;
     cout<<"inputDataName"<<inputDataFileName.toStdString()<<endl;
}

void SPKSetFileDialog::on_OKButton_clicked()
{
    
    accept();
    preData=ui->SPKSetTextEdit->toPlainText();
    
}

void SPKSetFileDialog::on_CancelButton_clicked()
{
    overWrite=false;
    ui->SPKSetTextEdit->clear();
    ui->SPKSetTextEdit->setText(preData);
    reject();
}
