# Linux 環境での harmonics セットアップについて
**対象バージョン : harmonics 2.1.0**

---

## 確認環境
Windows 10 Home  
VirtualBox バージョン 5.2.12 r122591

## VirtualBox 対象 OS
Ubuntu16.04-LTS

## セットアップ
1. VirtualBox に Ubuntu インストール  
特別な変更点はなし  

2. Qt インストール  
	2-1. ダウンロード
	https://www1.qt.io/download-open-source/#section-2  
	ダウンロードファイル名  
	qt-opensource-linux-x64-5.10.1.run  

	2-2. 配置  
	qt-opensource-linux-x64-5.10.1.run を$HOME以下の適当なフォルダに配置  
	例) $HOME/tmp/setup/qt  

	2-3. 実行権限を与え、インストール実行  
	実行は、VirtualBox 内ターミナルで行う  
	`$ cd $HOME/tmp/setup/qt`  
	`$ chmod +x qt-opensource-linux-x64-5.10.1.run`  
	`$ sudo ./qt-opensource-linux-x64-5.10.1.run`  

	2-4. インストール先の例 (今後はこのフォルダの例になります)  
	/opt/Qt5.10.1  

3. 必要なパッケージのインストール  
`$ sudo apt-get install libglib2.0-dev libSM-dev libxrender-dev libfontconfig1-dev libxext-dev`  
`$ sudo apt-get install build-essential`  
`$ sudo apt-get install libfontconfig1`  
`$ sudo apt-get install mesa-common-dev`  
`$ sudo apt-get install libglu1-mesa-dev`  
インストール(ファイル)がなければインストールパッケージ  
/usr/include/GL/glut.h  
`$ sudo apt-get install freeglut3-dev`  
/usr/include/opencv/highgui.h  
`$ sudo apt-get install libhighgui-dev`  

4. Qt 用設定ファイルを編集  
	4-1. 編集するファイル  
	/usr/lib/x86_64-linux-gnu/qt-default/qtchooser/default.conf  

	4-2. 編集について  
	// 編集前(デフォルト)内容  
	/usr/lib/x86_64-linux-gnu/qt4/bin <- この行を編集  
	/usr/lib/x86_64-linux-gnu  
	// 編集後  
	/opt/Qt5.10.1/5.10.1/gcc_64/bin  
	/usr/lib/x86_64-linux-gnu  

5. Qt 用にパスを通す  
	5-1. .profile ファイルの編集  
	※自分のインストール環境に合わせて編集してください  
	export QT_PATH=/opt/Qt5.10.1  
	export PATH=$PATH:$QT_PATH/5.10.1/gcc_64/bin  
	export LD_LIBRARY_PATH=$QT_PATH/5.10.1/gcc_64/lib  
	export QMLSCENE_DEVICE=softwarecontext  

	5-2. 再起動か $source .profile コマンドで設定を有効にする  
	パスの確認方法  
	$ echo $PATH  

6. ここで Qt 環境の確認  
Qt 付属 OpenGL 用サンプルプログラムを実行し、Qt インストール環境を確認  

### 以下、harmonics 実行にむけて  

7. CSPICE インストール  
	7-1. ダウンロード  
	https://naif.jpl.nasa.gov/naif/toolkit_C_PC_Linux_GCC_64bit.html  
	// ダウンロードファイル  
	cspice.tar.Z  
	importCSpice.csh  
	// CSPICE インストールについて  
	https://naif.jpl.nasa.gov/pub/naif/toolkit/C/PC_Linux_GCC_64bit/packages/README  
	展開後、パスを通す方式を採用  

	7-2. ダウンロードファイルを適当なフォルダに配置  
	例）$HOME/tmp/setup/cspice  
	// 次のコマンドを実行  
	`$ /bin/sh -f importCSpice.csh`  
	展開され、cspice.tar ファイルと cspice フォルダができる  

	7-3. 自分の環境に合わせ .profile ファイルの編集しパスを通す  
	// 設定例  
	`# CSPICE`  
	export CSPICE_PATH=$HOME/tmp/setup/cspice/cspice  
	export PATH=$PATH:$CSPICE_PATH/lib:$CSPICE_PATH/include:$CSPICE_PATH/exe  

8. CFITSIO のインストール  
	8-1. ダウンロード  
	https://heasarc.gsfc.nasa.gov/fitsio/fitsio.html  
	Unix .tar file cfitsio3450.tar.gz  
	// ダウンロードファイル  
	cfitsio3450.tar.gz  
	// 配置例  
	$HOME/setup/cfitsio  
	// 展開  
	`$ tar xvf cfitsio3450.tar.gz`   

	8-2. インストール実行ログ  
	自分の配置した環境に合わせて実行してください  
	`$ cd cfitsio/`  
	`$ ./configure --prefix=/usr/local`  
	`$ make`  
	`$ sudo make install`  
	// sudo make install 後のターミナル表示  
	/bin/cp -a libcfitsio.a /usr/local/lib  
	/bin/cp fitsio.h fitsio2.h longnam.h drvrsmem.h /usr/local/include  
	/bin/cp cfitsio.pc /usr/local/lib/pkgconfig  

9. CCFITS のインストール  
	9-1. ダウンロード
	https://heasarc.gsfc.nasa.gov/docs/software/fitsio/ccfits/
	CCfits source code, documentation and the html manual for local installation のリンクより  
	// ダウンロードファイル  
	cfitsio3450.tar.gz  
	// 配置例  
	$HOME/setup/ccfits  
	// 展開  
	tar xvf CCfits-2.5.tar.gz  

	9-2. インストール実行ログ  
	自分の配置した環境に合わせて実行してください  
	`$ cd CCfits/`  
	`$ ./configure --with-cfitsio=/usr/local`  
	`$ make`  
	`$ sudo make install`  

10. harmonics 実行
harmonics を適当なフォルダへ配置  
HARMONICS2_linux.pro を開く  
ビルド、実行を確認する  

---

## 参照 URL  
// Qt インストールについて  
https://download.qt.io/archive/qt/5.10/5.10.1/  
http://kconcon3.hatenablog.com/entry/2017/12/01/190933  

// CFITSIO のインストールについて  
インストール方法参照  
http://hamalabo.sakura.ne.jp/SPIRAL/spiraf_vine/node18.html  


